/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.AlphaComposite;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import sun.awt.SunToolkit;
import sun.awt.image.DataBufferNative;
import sun.awt.image.PixelConverter;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.image.WritableRasterNative;
import sun.awt.windows.WComponentPeer;
import sun.java2d.InvalidPipeException;
import sun.java2d.ScreenUpdateManager;
import sun.java2d.StateTracker;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.d3d.D3DBlitLoops;
import sun.java2d.d3d.D3DContext;
import sun.java2d.d3d.D3DDrawImage;
import sun.java2d.d3d.D3DGraphicsConfig;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DMaskBlit;
import sun.java2d.d3d.D3DMaskFill;
import sun.java2d.d3d.D3DPaints;
import sun.java2d.d3d.D3DRenderQueue;
import sun.java2d.d3d.D3DRenderer;
import sun.java2d.d3d.D3DSurfaceDataProxy;
import sun.java2d.d3d.D3DTextRenderer;
import sun.java2d.d3d.D3DVolatileSurfaceManager;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.PixelToParallelogramConverter;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.ExtendedBufferCapabilities;

public class D3DSurfaceData
extends SurfaceData
implements AccelSurface {
    public static final int D3D_DEVICE_RESOURCE = 100;
    public static final int ST_INT_ARGB = 0;
    public static final int ST_INT_ARGB_PRE = 1;
    public static final int ST_INT_ARGB_BM = 2;
    public static final int ST_INT_RGB = 3;
    public static final int ST_INT_BGR = 4;
    public static final int ST_USHORT_565_RGB = 5;
    public static final int ST_USHORT_555_RGB = 6;
    public static final int ST_BYTE_INDEXED = 7;
    public static final int ST_BYTE_INDEXED_BM = 8;
    public static final int ST_3BYTE_BGR = 9;
    public static final int SWAP_DISCARD = 1;
    public static final int SWAP_FLIP = 2;
    public static final int SWAP_COPY = 3;
    private static final String DESC_D3D_SURFACE = "D3D Surface";
    private static final String DESC_D3D_SURFACE_RTT = "D3D Surface (render-to-texture)";
    private static final String DESC_D3D_TEXTURE = "D3D Texture";
    static final SurfaceType D3DSurface = SurfaceType.Any.deriveSubType("D3D Surface", PixelConverter.ArgbPre.instance);
    static final SurfaceType D3DSurfaceRTT = D3DSurface.deriveSubType("D3D Surface (render-to-texture)");
    static final SurfaceType D3DTexture = SurfaceType.Any.deriveSubType("D3D Texture");
    private int type;
    private int width;
    private int height;
    private int nativeWidth;
    private int nativeHeight;
    protected WComponentPeer peer;
    private Image offscreenImage;
    protected D3DGraphicsDevice graphicsDevice;
    private int swapEffect;
    private ExtendedBufferCapabilities.VSyncType syncType;
    private int backBuffersNum;
    private WritableRasterNative wrn;
    protected static D3DRenderer d3dRenderPipe;
    protected static PixelToParallelogramConverter d3dTxRenderPipe;
    protected static ParallelogramPipe d3dAAPgramPipe;
    protected static D3DTextRenderer d3dTextPipe;
    protected static D3DDrawImage d3dImagePipe;

    private native boolean initTexture(long var1, boolean var3, boolean var4);

    private native boolean initFlipBackbuffer(long var1, long var3, int var5, int var6, int var7);

    private native boolean initRTSurface(long var1, boolean var3);

    private native void initOps(int var1, int var2, int var3);

    protected D3DSurfaceData(WComponentPeer wComponentPeer, D3DGraphicsConfig d3DGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3, int n4, ExtendedBufferCapabilities.VSyncType vSyncType, int n5) {
        super(D3DSurfaceData.getCustomSurfaceType(n5), colorModel);
        this.graphicsDevice = d3DGraphicsConfig.getD3DDevice();
        this.peer = wComponentPeer;
        this.type = n5;
        this.width = n;
        this.height = n2;
        this.offscreenImage = image;
        this.backBuffersNum = n3;
        this.swapEffect = n4;
        this.syncType = vSyncType;
        this.initOps(this.graphicsDevice.getScreen(), n, n2);
        if (n5 == 1) {
            this.setSurfaceLost(true);
        } else {
            this.initSurface();
        }
        this.setBlitProxyKey(d3DGraphicsConfig.getProxyKey());
    }

    @Override
    public SurfaceDataProxy makeProxyFor(SurfaceData surfaceData) {
        return D3DSurfaceDataProxy.createProxy(surfaceData, (D3DGraphicsConfig)this.graphicsDevice.getDefaultConfiguration());
    }

    public static D3DSurfaceData createData(WComponentPeer wComponentPeer, Image image) {
        D3DGraphicsConfig d3DGraphicsConfig = D3DSurfaceData.getGC(wComponentPeer);
        if (d3DGraphicsConfig == null || !wComponentPeer.isAccelCapable()) {
            return null;
        }
        BufferCapabilities bufferCapabilities = wComponentPeer.getBackBufferCaps();
        ExtendedBufferCapabilities.VSyncType vSyncType = ExtendedBufferCapabilities.VSyncType.VSYNC_DEFAULT;
        if (bufferCapabilities instanceof ExtendedBufferCapabilities) {
            vSyncType = ((ExtendedBufferCapabilities)bufferCapabilities).getVSync();
        }
        Rectangle rectangle = wComponentPeer.getBounds();
        BufferCapabilities.FlipContents flipContents = bufferCapabilities.getFlipContents();
        int n = flipContents == BufferCapabilities.FlipContents.COPIED ? 3 : (flipContents == BufferCapabilities.FlipContents.PRIOR ? 2 : 1);
        return new D3DSurfaceData(wComponentPeer, d3DGraphicsConfig, rectangle.width, rectangle.height, image, wComponentPeer.getColorModel(), wComponentPeer.getBackBuffersNum(), n, vSyncType, 4);
    }

    public static D3DSurfaceData createData(WComponentPeer wComponentPeer) {
        D3DGraphicsConfig d3DGraphicsConfig = D3DSurfaceData.getGC(wComponentPeer);
        if (d3DGraphicsConfig == null || !wComponentPeer.isAccelCapable()) {
            return null;
        }
        return new D3DWindowSurfaceData(wComponentPeer, d3DGraphicsConfig);
    }

    public static D3DSurfaceData createData(D3DGraphicsConfig d3DGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, int n3) {
        D3DSurfaceData d3DSurfaceData;
        block4: {
            if (n3 == 5) {
                int n4;
                boolean bl = colorModel.getTransparency() == 1;
                int n5 = n4 = bl ? 8 : 4;
                if (!d3DGraphicsConfig.getD3DDevice().isCapPresent(n4)) {
                    n3 = 2;
                }
            }
            d3DSurfaceData = null;
            try {
                d3DSurfaceData = new D3DSurfaceData(null, d3DGraphicsConfig, n, n2, image, colorModel, 0, 1, ExtendedBufferCapabilities.VSyncType.VSYNC_DEFAULT, n3);
            }
            catch (InvalidPipeException invalidPipeException) {
                if (n3 != 5 || ((SunVolatileImage)image).getForcedAccelSurfaceType() == 5) break block4;
                n3 = 2;
                d3DSurfaceData = new D3DSurfaceData(null, d3DGraphicsConfig, n, n2, image, colorModel, 0, 1, ExtendedBufferCapabilities.VSyncType.VSYNC_DEFAULT, n3);
            }
        }
        return d3DSurfaceData;
    }

    private static SurfaceType getCustomSurfaceType(int n) {
        switch (n) {
            case 3: {
                return D3DTexture;
            }
            case 5: {
                return D3DSurfaceRTT;
            }
        }
        return D3DSurface;
    }

    private boolean initSurfaceNow() {
        boolean bl = this.getTransparency() == 1;
        switch (this.type) {
            case 2: {
                return this.initRTSurface(this.getNativeOps(), bl);
            }
            case 3: {
                return this.initTexture(this.getNativeOps(), false, bl);
            }
            case 5: {
                return this.initTexture(this.getNativeOps(), true, bl);
            }
            case 1: 
            case 4: {
                return this.initFlipBackbuffer(this.getNativeOps(), this.peer.getData(), this.backBuffersNum, this.swapEffect, this.syncType.id());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSurface() {
        Object object = this;
        synchronized (object) {
            this.wrn = null;
        }
        class Status {
            boolean success = false;

            Status() {
            }
        }
        object = new Status();
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            d3DRenderQueue.flushAndInvokeNow(new Runnable((Status)object){
                final /* synthetic */ Status val$status;
                {
                    this.val$status = status;
                }

                @Override
                public void run() {
                    this.val$status.success = D3DSurfaceData.this.initSurfaceNow();
                }
            });
            if (!((Status)object).success) {
                throw new InvalidPipeException("Error creating D3DSurface");
            }
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    @Override
    public final D3DContext getContext() {
        return this.graphicsDevice.getContext();
    }

    @Override
    public final int getType() {
        return this.type;
    }

    private static native int dbGetPixelNative(long var0, int var2, int var3);

    private static native void dbSetPixelNative(long var0, int var2, int var3, int var4);

    @Override
    public synchronized Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.wrn == null) {
            DirectColorModel directColorModel = (DirectColorModel)this.getColorModel();
            int n5 = 0;
            int n6 = this.width;
            n5 = directColorModel.getPixelSize() > 16 ? 3 : 1;
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(n5, this.width, this.height, n6, directColorModel.getMasks());
            D3DDataBufferNative d3DDataBufferNative = new D3DDataBufferNative(this, n5, this.width, this.height);
            this.wrn = WritableRasterNative.createNativeRaster(singlePixelPackedSampleModel, d3DDataBufferNative);
        }
        return this.wrn;
    }

    @Override
    public boolean canRenderLCDText(SunGraphics2D sunGraphics2D) {
        return this.graphicsDevice.isCapPresent(65536) && sunGraphics2D.compositeState <= 0 && sunGraphics2D.paintState <= 0 && sunGraphics2D.surfaceData.getTransparency() == 1;
    }

    void disableAccelerationForSurface() {
        SurfaceManager surfaceManager;
        if (this.offscreenImage != null && (surfaceManager = SurfaceManager.getManager(this.offscreenImage)) instanceof D3DVolatileSurfaceManager) {
            this.setSurfaceLost(true);
            ((D3DVolatileSurfaceManager)surfaceManager).setAccelerationEnabled(false);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void validatePipe(SunGraphics2D var1_1) {
        block23: {
            block22: {
                var3_2 = false;
                if (var1_1.compositeState >= 2) {
                    super.validatePipe(var1_1);
                    var1_1.imagepipe = D3DSurfaceData.d3dImagePipe;
                    this.disableAccelerationForSurface();
                    return;
                }
                if (var1_1.compositeState > 0) break block22;
                if (var1_1.paintState <= 1) ** GOTO lbl-1000
            }
            if (var1_1.compositeState != 1) break block23;
            if (var1_1.paintState <= 1 && ((AlphaComposite)var1_1.composite).getRule() == 3) ** GOTO lbl-1000
        }
        if (var1_1.compositeState == 2) {
            ** if (var1_1.paintState > 1) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 3 sources

        {
            var2_3 /* !! */  = D3DSurfaceData.d3dTextPipe;
            ** GOTO lbl27
        }
lbl-1000:
        // 2 sources

        {
            super.validatePipe(var1_1);
            var2_3 /* !! */  = var1_1.textpipe;
            var3_2 = true;
        }
lbl27:
        // 2 sources

        var4_4 = null;
        var5_5 = null;
        if (var1_1.antialiasHint != 2) {
            if (var1_1.paintState <= 1) {
                if (var1_1.compositeState <= 2) {
                    var4_4 = D3DSurfaceData.d3dTxRenderPipe;
                    var5_5 = D3DSurfaceData.d3dRenderPipe;
                }
            } else if (var1_1.compositeState <= 1 && D3DPaints.isValid(var1_1)) {
                var4_4 = D3DSurfaceData.d3dTxRenderPipe;
                var5_5 = D3DSurfaceData.d3dRenderPipe;
            }
        } else if (var1_1.paintState <= 1) {
            if (this.graphicsDevice.isCapPresent(524288) && (var1_1.imageComp == CompositeType.SrcOverNoEa || var1_1.imageComp == CompositeType.SrcOver)) {
                if (!var3_2) {
                    super.validatePipe(var1_1);
                    var3_2 = true;
                }
                var6_6 = new PixelToParallelogramConverter(var1_1.shapepipe, D3DSurfaceData.d3dAAPgramPipe, 0.125, 0.499, false);
                var1_1.drawpipe = var6_6;
                var1_1.fillpipe = var6_6;
                var1_1.shapepipe = var6_6;
            } else if (var1_1.compositeState == 2) {
                var4_4 = D3DSurfaceData.d3dTxRenderPipe;
                var5_5 = D3DSurfaceData.d3dRenderPipe;
            }
        }
        if (var4_4 != null) {
            if (var1_1.transformState >= 3) {
                var1_1.drawpipe = var4_4;
                var1_1.fillpipe = var4_4;
            } else if (var1_1.strokeState != 0) {
                var1_1.drawpipe = var4_4;
                var1_1.fillpipe = var5_5;
            } else {
                var1_1.drawpipe = var5_5;
                var1_1.fillpipe = var5_5;
            }
            var1_1.shapepipe = var4_4;
        } else if (!var3_2) {
            super.validatePipe(var1_1);
        }
        var1_1.textpipe = var2_3 /* !! */ ;
        var1_1.imagepipe = D3DSurfaceData.d3dImagePipe;
    }

    @Override
    protected MaskFill getMaskFill(SunGraphics2D sunGraphics2D) {
        if (!(sunGraphics2D.paintState <= 1 || D3DPaints.isValid(sunGraphics2D) && this.graphicsDevice.isCapPresent(16))) {
            return null;
        }
        return super.getMaskFill(sunGraphics2D);
    }

    @Override
    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (sunGraphics2D.transformState < 3) {
            if (sunGraphics2D.compositeState < 2) {
                d3dRenderPipe.copyArea(sunGraphics2D, n += sunGraphics2D.transX, n2 += sunGraphics2D.transY, n3, n4, n5, n6);
                return true;
            }
        }
        return false;
    }

    @Override
    public void flush() {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            RenderBuffer renderBuffer = d3DRenderQueue.getBuffer();
            d3DRenderQueue.ensureCapacityAndAlignment(12, 4);
            renderBuffer.putInt(72);
            renderBuffer.putLong(this.getNativeOps());
            d3DRenderQueue.flushNow();
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose(long l) {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            RenderBuffer renderBuffer = d3DRenderQueue.getBuffer();
            d3DRenderQueue.ensureCapacityAndAlignment(12, 4);
            renderBuffer.putInt(73);
            renderBuffer.putLong(l);
            d3DRenderQueue.flushNow();
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void swapBuffers(D3DSurfaceData d3DSurfaceData, final int n, final int n2, final int n3, final int n4) {
        long l = d3DSurfaceData.getNativeOps();
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        if (d3DRenderQueue.isRenderQueueThread()) {
            if (!d3DRenderQueue.tryLock()) {
                final Component component = (Component)d3DSurfaceData.getPeer().getTarget();
                SunToolkit.executeOnEventHandlerThread(component, new Runnable(){

                    @Override
                    public void run() {
                        component.repaint(n, n2, n3, n4);
                    }
                });
                return;
            }
        } else {
            d3DRenderQueue.lock();
        }
        try {
            RenderBuffer renderBuffer = d3DRenderQueue.getBuffer();
            d3DRenderQueue.ensureCapacityAndAlignment(28, 4);
            renderBuffer.putInt(80);
            renderBuffer.putLong(l);
            renderBuffer.putInt(n);
            renderBuffer.putInt(n2);
            renderBuffer.putInt(n3);
            renderBuffer.putInt(n4);
            d3DRenderQueue.flushNow();
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    @Override
    public Object getDestination() {
        return this.offscreenImage;
    }

    @Override
    public Rectangle getBounds() {
        if (this.type == 4 || this.type == 1) {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }
        return new Rectangle(this.width, this.height);
    }

    @Override
    public Rectangle getNativeBounds() {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            Rectangle rectangle = new Rectangle(this.nativeWidth, this.nativeHeight);
            return rectangle;
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsDevice.getDefaultConfiguration();
    }

    @Override
    public SurfaceData getReplacement() {
        return D3DSurfaceData.restoreContents(this.offscreenImage);
    }

    private static D3DGraphicsConfig getGC(WComponentPeer wComponentPeer) {
        GraphicsConfiguration graphicsConfiguration;
        if (wComponentPeer != null) {
            graphicsConfiguration = wComponentPeer.getGraphicsConfiguration();
        } else {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        }
        return graphicsConfiguration instanceof D3DGraphicsConfig ? (D3DGraphicsConfig)graphicsConfiguration : null;
    }

    void restoreSurface() {
        this.initSurface();
    }

    WComponentPeer getPeer() {
        return this.peer;
    }

    @Override
    public void setSurfaceLost(boolean bl) {
        super.setSurfaceLost(bl);
        if (bl && this.offscreenImage != null) {
            SurfaceManager surfaceManager = SurfaceManager.getManager(this.offscreenImage);
            surfaceManager.acceleratedSurfaceLost();
        }
    }

    private static native long getNativeResourceNative(long var0, int var2);

    @Override
    public long getNativeResource(int n) {
        return D3DSurfaceData.getNativeResourceNative(this.getNativeOps(), n);
    }

    public static native boolean updateWindowAccelImpl(long var0, long var2, int var4, int var5);

    static {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3dImagePipe = new D3DDrawImage();
        d3dTextPipe = new D3DTextRenderer(d3DRenderQueue);
        d3dRenderPipe = new D3DRenderer(d3DRenderQueue);
        if (GraphicsPrimitive.tracingEnabled()) {
            d3dTextPipe = d3dTextPipe.traceWrap();
            d3dRenderPipe = d3dRenderPipe.traceWrap();
        }
        d3dAAPgramPipe = d3dRenderPipe.getAAParallelogramPipe();
        d3dTxRenderPipe = new PixelToParallelogramConverter(d3dRenderPipe, d3dRenderPipe, 1.0, 0.25, true);
        D3DBlitLoops.register();
        D3DMaskFill.register();
        D3DMaskBlit.register();
    }

    public static class D3DWindowSurfaceData
    extends D3DSurfaceData {
        StateTracker dirtyTracker = this.getStateTracker();

        public D3DWindowSurfaceData(WComponentPeer wComponentPeer, D3DGraphicsConfig d3DGraphicsConfig) {
            super(wComponentPeer, d3DGraphicsConfig, wComponentPeer.getBounds().width, wComponentPeer.getBounds().height, null, wComponentPeer.getColorModel(), 1, 3, ExtendedBufferCapabilities.VSyncType.VSYNC_DEFAULT, 1);
        }

        @Override
        public SurfaceData getReplacement() {
            ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
            return screenUpdateManager.getReplacementScreenSurface(this.peer, this);
        }

        @Override
        public Object getDestination() {
            return this.peer.getTarget();
        }

        @Override
        void disableAccelerationForSurface() {
            this.setSurfaceLost(true);
            this.invalidate();
            this.flush();
            this.peer.disableAcceleration();
            ScreenUpdateManager.getInstance().dropScreenSurface(this);
        }

        @Override
        void restoreSurface() {
            if (!this.peer.isAccelCapable()) {
                throw new InvalidPipeException("Onscreen acceleration disabled for this surface");
            }
            Window window = this.graphicsDevice.getFullScreenWindow();
            if (window != null && window != this.peer.getTarget()) {
                throw new InvalidPipeException("Can't restore onscreen surface when in full-screen mode");
            }
            super.restoreSurface();
            this.setSurfaceLost(false);
            D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
            d3DRenderQueue.lock();
            try {
                this.getContext().invalidateContext();
            }
            finally {
                d3DRenderQueue.unlock();
            }
        }

        public boolean isDirty() {
            return !this.dirtyTracker.isCurrent();
        }

        public void markClean() {
            this.dirtyTracker = this.getStateTracker();
        }
    }

    static class D3DDataBufferNative
    extends DataBufferNative {
        int pixel;

        protected D3DDataBufferNative(SurfaceData surfaceData, int n, int n2, int n3) {
            super(surfaceData, n, n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int getElem(final int n, final int n2, final SurfaceData surfaceData) {
            int n3;
            if (surfaceData.isSurfaceLost()) {
                return 0;
            }
            D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
            d3DRenderQueue.lock();
            try {
                d3DRenderQueue.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        pixel = D3DSurfaceData.dbGetPixelNative(surfaceData.getNativeOps(), n, n2);
                    }
                });
            }
            finally {
                n3 = this.pixel;
                d3DRenderQueue.unlock();
            }
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setElem(final int n, final int n2, final int n3, final SurfaceData surfaceData) {
            if (surfaceData.isSurfaceLost()) {
                return;
            }
            D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
            d3DRenderQueue.lock();
            try {
                d3DRenderQueue.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        D3DSurfaceData.dbSetPixelNative(surfaceData.getNativeOps(), n, n2, n3);
                    }
                });
                surfaceData.markDirty();
            }
            finally {
                d3DRenderQueue.unlock();
            }
        }
    }
}

