/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.ar;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ar extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "\u062f.\u0625.\u200f" },
            { "BHD", "\u062f.\u0628.\u200f" },
            { "BRL", "\u0631.\u0628.\u200f" },
            { "CNY", "\u064a.\u0635" },
            { "DZD", "\u062f.\u062c.\u200f" },
            { "EGP", "\u062c.\u0645.\u200f" },
            { "INR", "\u0631.\u0647.\u200f" },
            { "IQD", "\u062f.\u0639.\u200f" },
            { "JOD", "\u062f.\u0623.\u200f" },
            { "KMF", "\u0641.\u062c.\u0642.\u200f" },
            { "KWD", "\u062f.\u0643.\u200f" },
            { "LBP", "\u0644.\u0644.\u200f" },
            { "LYD", "\u062f.\u0644.\u200f" },
            { "MAD", "\u062f.\u0645.\u200f" },
            { "MRO", "\u0623.\u0645.\u200f" },
            { "OMR", "\u0631.\u0639.\u200f" },
            { "QAR", "\u0631.\u0642.\u200f" },
            { "RUB", "\u0631.\u0631.\u200f" },
            { "SAR", "\u0631.\u0633.\u200f" },
            { "SDD", "\u062f.\u0633.\u200f" },
            { "SDP", "\u062c.\u0633.\u200f" },
            { "SYP", "\u0644.\u0633.\u200f" },
            { "TND", "\u062f.\u062a.\u200f" },
            { "XAF", "\u0641.\u0627.\u200f" },
            { "XXX", "***" },
            { "YER", "\u0631.\u064a.\u200f" },
            { "adp", "\u0628\u064a\u0633\u062a\u0627 \u0623\u0646\u062f\u0648\u0631\u064a" },
            { "aed", "\u062f\u0631\u0647\u0645 \u0625\u0645\u0627\u0631\u0627\u062a\u064a" },
            { "afa", "\u0623\u0641\u063a\u0627\u0646\u064a - 1927-2002" },
            { "afn", "\u0623\u0641\u063a\u0627\u0646\u064a" },
            { "all", "\u0644\u064a\u0643 \u0623\u0644\u0628\u0627\u0646\u064a" },
            { "amd", "\u062f\u0631\u0627\u0645 \u0623\u0631\u0645\u064a\u0646\u064a" },
            { "ang", "\u063a\u064a\u0644\u062f\u0631 \u0647\u0648\u0644\u0646\u062f\u064a \u0623\u0646\u062a\u064a\u0644\u064a" },
            { "aoa", "\u0643\u0648\u0627\u0646\u0632\u0627 \u0623\u0646\u062c\u0648\u0644\u064a" },
            { "aok", "\u0643\u0648\u0627\u0646\u0632\u0627 \u0623\u0646\u062c\u0648\u0644\u064a - 1977-1990" },
            { "aon", "\u0643\u0648\u0627\u0646\u0632\u0627 \u0623\u0646\u062c\u0648\u0644\u064a \u062c\u062f\u064a\u062f\u0629 - 1990-2000" },
            { "aor", "\u0643\u0648\u0627\u0646\u0632\u0627 \u0623\u0646\u062c\u0648\u0644\u064a \u0645\u0639\u062f\u0644\u0629 - 1995 - 1999" },
            { "ara", "\u0627\u0633\u062a\u0631\u0627\u0644 \u0623\u0631\u062c\u0646\u062a\u064a\u0646\u064a" },
            { "arp", "\u0628\u064a\u0632\u0648 \u0623\u0631\u062c\u0646\u062a\u064a\u0646\u064a - 1983-1985" },
            { "ars", "\u0628\u064a\u0632\u0648 \u0623\u0631\u062c\u0646\u062a\u064a\u0646\u064a" },
            { "ats", "\u0634\u0644\u0646 \u0646\u0645\u0633\u0627\u0648\u064a" },
            { "aud", "\u062f\u0648\u0644\u0627\u0631 \u0623\u0633\u062a\u0631\u0627\u0644\u064a" },
            { "awg", "\u062c\u0644\u062f\u0631 \u0623\u0631\u0648\u0628\u064a" },
            { "azm", "\u0645\u0627\u0646\u0627\u062a \u0623\u0630\u0631\u064a\u0628\u062c\u0627\u0646\u064a" },
            { "azn", "\u0645\u0627\u0646\u0627\u062a \u0623\u0630\u0631\u0628\u064a\u062c\u0627\u0646" },
            { "bad", "\u062f\u064a\u0646\u0627\u0631 \u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643" },
            { "bam", "\u0645\u0627\u0631\u0643 \u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643 \u0642\u0627\u0628\u0644 \u0644\u0644\u062a\u062d\u0648\u064a\u0644" },
            { "bbd", "\u062f\u0648\u0644\u0627\u0631 \u0628\u0631\u0628\u0627\u062f\u0648\u0633\u064a" },
            { "bdt", "\u062a\u0627\u0643\u0627 \u0628\u0646\u062c\u0644\u0627\u062f\u064a\u0634\u064a" },
            { "bec", "\u0641\u0631\u0646\u0643 \u0628\u0644\u062c\u064a\u0643\u064a \u0642\u0627\u0628\u0644 \u0644\u0644\u062a\u062d\u0648\u064a\u0644" },
            { "bef", "\u0641\u0631\u0646\u0643 \u0628\u0644\u062c\u064a\u0643\u064a" },
            { "bel", "\u0641\u0631\u0646\u0643 \u0628\u0644\u062c\u064a\u0643\u064a \u0645\u0627\u0644\u064a" },
            { "bgl", "\u0644\u064a\u0641 \u0628\u0644\u063a\u0627\u0631\u064a" },
            { "bgn", "\u0644\u064a\u0641 \u0628\u0644\u063a\u0627\u0631\u064a \u062c\u062f\u064a\u062f" },
            { "bhd", "\u062f\u064a\u0646\u0627\u0631 \u0628\u062d\u0631\u064a\u0646\u064a" },
            { "bif", "\u0641\u0631\u0646\u0643 \u0628\u0631\u0648\u0646\u062f\u064a" },
            { "bmd", "\u062f\u0648\u0644\u0627\u0631 \u0628\u0631\u0645\u0648\u062f\u064a" },
            { "bnd", "\u062f\u0648\u0644\u0627\u0631 \u0628\u0631\u0648\u0646\u0627\u064a" },
            { "bob", "\u0628\u0648\u0644\u064a\u0641\u064a\u0627\u0646\u0648 \u0628\u0648\u0644\u064a\u0641\u064a" },
            { "bop", "\u0628\u064a\u0632\u0648 \u0628\u0648\u0644\u064a\u0641\u064a" },
            { "bov", "\u0645\u0641\u062f\u0648\u0644 \u0628\u0648\u0644\u064a\u0641\u064a" },
            { "brb", "\u0646\u0648\u0641\u0648 \u0643\u0631\u0648\u0632\u0627\u064a\u0631\u0648 \u0628\u0631\u0627\u0632\u064a\u0644\u064a - 1967-1986" },
            { "brc", "\u0643\u0631\u0648\u0632\u0627\u062f\u0648 \u0628\u0631\u0627\u0632\u064a\u0644\u064a" },
            { "bre", "\u0643\u0631\u0648\u0632\u0627\u064a\u0631\u0648 \u0628\u0631\u0627\u0632\u064a\u0644\u064a - 1990-1993" },
            { "brl", "\u0631\u064a\u0627\u0644 \u0628\u0631\u0627\u0632\u064a\u0644\u064a" },
            { "bsd", "\u062f\u0648\u0644\u0627\u0631 \u0628\u0627\u0647\u0627\u0645\u064a" },
            { "btn", "\u0646\u0648\u0644\u062a\u0648\u0645 \u0628\u0648\u062a\u0627\u0646\u064a" },
            { "buk", "\u0643\u064a\u0627\u062a \u0628\u0648\u0631\u0645\u064a" },
            { "bwp", "\u0628\u0648\u0644\u0627 \u0628\u062a\u0633\u0648\u0627\u0646\u064a" },
            { "byb", "\u0631\u0648\u0628\u0644 \u0628\u064a\u0644\u0627\u0631\u0648\u0633\u064a \u062c\u062f\u064a\u062f - 1994-1999" },
            { "byr", "\u0631\u0648\u0628\u0644 \u0628\u064a\u0644\u0627\u0631\u0648\u0633\u064a" },
            { "bzd", "\u062f\u0648\u0644\u0627\u0631 \u0628\u0644\u064a\u0632\u064a" },
            { "cad", "\u062f\u0648\u0644\u0627\u0631 \u0643\u0646\u062f\u064a" },
            { "cdf", "\u0641\u0646\u0643 \u0643\u0648\u0646\u063a\u0648\u0644\u064a" },
            { "chf", "\u0641\u0631\u0646\u0643 \u0633\u0648\u064a\u0633\u0631\u064a" },
            { "clp", "\u0628\u064a\u0632\u0648 \u0634\u064a\u0644\u064a" },
            { "cny", "\u064a\u0648\u0627\u0646 \u0635\u064a\u0646\u064a" },
            { "cop", "\u0628\u064a\u0632\u0648 \u0643\u0648\u0644\u0648\u0645\u0628\u064a" },
            { "crc", "\u0643\u0648\u0644\u0646 \u0643\u0648\u0633\u062a\u0627 \u0631\u064a\u0643\u064a" },
            { "csd", "\u062f\u064a\u0646\u0627\u0631 \u0635\u0631\u0628\u064a \u0642\u062f\u064a\u0645" },
            { "csk", "\u0643\u0631\u0648\u0646\u0629 \u062a\u0634\u064a\u0643\u0648\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0627" },
            { "cuc", "\u0628\u064a\u0632\u0648 \u0643\u0648\u0628\u064a \u0642\u0627\u0628\u0644 \u0644\u0644\u062a\u062d\u0648\u064a\u0644" },
            { "cup", "\u0628\u064a\u0632\u0648 \u0643\u0648\u0628\u064a" },
            { "cve", "\u0627\u0633\u0643\u0648\u062f\u0648 \u0627\u0644\u0631\u0623\u0633 \u0627\u0644\u062e\u0636\u0631\u0627\u0621" },
            { "cyp", "\u062c\u0646\u064a\u0647 \u0642\u0628\u0631\u0635\u064a" },
            { "czk", "\u0643\u0631\u0648\u0646\u0629 \u062a\u0634\u064a\u0643\u064a\u0629" },
            { "ddm", "\u0623\u0648\u0633\u062a\u0645\u0627\u0631\u0643 \u0623\u0644\u0645\u0627\u0646\u064a \u0634\u0631\u0642\u064a" },
            { "dem", "\u0645\u0627\u0631\u0643 \u0623\u0644\u0645\u0627\u0646\u064a" },
            { "djf", "\u0641\u0631\u0646\u0643 \u062c\u064a\u0628\u0648\u062a\u064a" },
            { "dkk", "\u0643\u0631\u0648\u0646\u0629 \u062f\u0627\u0646\u0645\u0627\u0631\u0643\u064a" },
            { "dop", "\u0628\u064a\u0632\u0648 \u0627\u0644\u062f\u0648\u0645\u0646\u064a\u0643\u0627\u0646" },
            { "dzd", "\u062f\u064a\u0646\u0627\u0631 \u062c\u0632\u0627\u0626\u0631\u064a" },
            { "eek", "\u0643\u0631\u0648\u0646\u0629 \u0627\u0633\u062a\u0648\u0646\u064a\u0629" },
            { "egp", "\u062c\u0646\u064a\u0647 \u0645\u0635\u0631\u064a" },
            { "ern", "\u0646\u0627\u0643\u0641\u0627 \u0623\u0631\u064a\u062a\u0631\u064a" },
            { "esp", "\u0628\u064a\u0632\u064a\u062a\u0627 \u0625\u0633\u0628\u0627\u0646\u064a" },
            { "etb", "\u0628\u064a\u0631 \u0623\u062b\u064a\u0648\u0628\u064a" },
            { "eur", "\u064a\u0648\u0631\u0648" },
            { "fim", "\u0645\u0627\u0631\u0643\u0627 \u0641\u0646\u0644\u0646\u062f\u064a" },
            { "fjd", "\u062f\u0648\u0644\u0627\u0631 \u0641\u064a\u062c\u064a" },
            { "fkp", "\u062c\u0646\u064a\u0647 \u062c\u0632\u0631 \u0641\u0648\u0643\u0644\u0627\u0646\u062f" },
            { "frf", "\u0641\u0631\u0646\u0643 \u0641\u0631\u0646\u0633\u064a" },
            { "gbp", "\u062c\u0646\u064a\u0647 \u0625\u0633\u062a\u0631\u0644\u064a\u0646\u064a" },
            { "gel", "\u0644\u0627\u0631\u0649 \u062c\u0648\u0631\u062c\u064a" },
            { "ghc", "\u0633\u064a\u062f\u064a \u063a\u0627\u0646\u064a" },
            { "ghs", "\u0633\u064a\u062f\u064a \u063a\u0627\u0646\u0627" },
            { "gip", "\u062c\u0646\u064a\u0647 \u062c\u0628\u0644 \u0637\u0627\u0631\u0642" },
            { "gmd", "\u062f\u0644\u0627\u0633\u064a \u062c\u0627\u0645\u0628\u064a" },
            { "gnf", "\u0641\u0631\u0646\u0643 \u063a\u064a\u0646\u064a\u0627" },
            { "gns", "\u0633\u064a\u0644\u064a \u063a\u064a\u0646\u064a\u0627" },
            { "gqe", "\u0627\u0643\u0648\u064a\u0644 \u062c\u0648\u0646\u064a\u0646\u0627 \u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u0627\u0633\u062a\u0648\u0627\u0626\u064a\u0651\u0629" },
            { "grd", "\u062f\u0631\u0627\u062e\u0645\u0627 \u064a\u0648\u0646\u0627\u0646\u064a" },
            { "gtq", "\u0643\u0648\u062a\u0632\u0627\u0644 \u062c\u0648\u0627\u062a\u064a\u0645\u0627\u0644\u0627" },
            { "gwe", "\u0627\u0633\u0643\u0648\u062f \u0628\u0631\u062a\u063a\u0627\u0644\u064a \u063a\u064a\u0646\u064a\u0627" },
            { "gwp", "\u0628\u064a\u0632\u0648 \u063a\u064a\u0646\u064a\u0627 \u0628\u064a\u0633\u0627\u0648" },
            { "gyd", "\u062f\u0648\u0644\u0627\u0631 \u063a\u064a\u0627\u0646\u0627" },
            { "hkd", "\u062f\u0648\u0644\u0627\u0631 \u0647\u0648\u0646\u062c \u0643\u0648\u0646\u062c" },
            { "hnl", "\u0644\u064a\u0645\u0628\u064a\u0631\u0627 \u0647\u0646\u062f\u0627\u0631\u0648\u0633" },
            { "hrd", "\u062f\u064a\u0646\u0627\u0631 \u0643\u0631\u0648\u0627\u062a\u064a" },
            { "hrk", "\u0643\u0648\u0646\u0627 \u0643\u0631\u0648\u0627\u062a\u064a" },
            { "htg", "\u062c\u0648\u0631\u062f\u0649 \u0647\u0627\u064a\u062a\u064a" },
            { "huf", "\u0641\u0648\u0631\u064a\u0646\u062a \u0645\u062c\u0631\u064a" },
            { "idr", "\u0631\u0648\u0628\u064a\u0629 \u0625\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0629" },
            { "iep", "\u062c\u0646\u064a\u0647 \u0625\u064a\u0631\u0644\u0646\u062f\u064a" },
            { "ilp", "\u062c\u0646\u064a\u0647 \u0625\u0633\u0631\u0627\u0626\u064a\u0644\u064a" },
            { "ils", "\u0634\u064a\u0643\u0644 \u0625\u0633\u0631\u0627\u0626\u064a\u0644\u064a \u062c\u062f\u064a\u062f" },
            { "inr", "\u0631\u0648\u0628\u064a\u0647 \u0647\u0646\u062f\u064a" },
            { "iqd", "\u062f\u064a\u0646\u0627\u0631 \u0639\u0631\u0627\u0642\u064a" },
            { "irr", "\u0631\u064a\u0627\u0644 \u0625\u064a\u0631\u0627\u0646\u064a" },
            { "isk", "\u0643\u0631\u0648\u0646\u0647 \u0623\u064a\u0633\u0644\u0646\u062f\u064a" },
            { "itl", "\u0644\u064a\u0631\u0629 \u0625\u064a\u0637\u0627\u0644\u064a\u0629" },
            { "jmd", "\u062f\u0648\u0644\u0627\u0631 \u062c\u0627\u0645\u0627\u064a\u0643\u064a" },
            { "jod", "\u062f\u064a\u0646\u0627\u0631 \u0623\u0631\u062f\u0646\u064a" },
            { "jpy", "\u064a\u0646 \u064a\u0627\u0628\u0627\u0646\u064a" },
            { "kes", "\u0634\u0644\u0646 \u0643\u064a\u0646\u064a\u064a" },
            { "kgs", "\u0633\u0648\u0645 \u0642\u064a\u0631\u063a\u0633\u062a\u0627\u0646\u064a" },
            { "khr", "\u0631\u064a\u064a\u0627\u0644 \u0643\u0645\u0628\u0648\u062f\u064a" },
            { "kmf", "\u0641\u0631\u0646\u0643 \u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631" },
            { "kpw", "\u0648\u0648\u0646 \u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "krw", "\u0648\u0648\u0646 \u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "kwd", "\u062f\u064a\u0646\u0627\u0631 \u0643\u0648\u064a\u062a\u064a" },
            { "kyd", "\u062f\u0648\u0644\u0627\u0631 \u062c\u0632\u0631 \u0643\u064a\u0645\u0646" },
            { "kzt", "\u062a\u064a\u0646\u063a \u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646\u064a" },
            { "lak", "\u0643\u064a\u0628 \u0644\u0627\u0648\u0633\u064a" },
            { "lbp", "\u062c\u0646\u064a\u0629 \u0644\u0628\u0646\u0627\u0646\u064a" },
            { "lkr", "\u0631\u0648\u0628\u064a\u0629 \u0633\u0631\u064a\u0644\u0627\u0646\u0643\u064a\u0629" },
            { "lrd", "\u062f\u0648\u0644\u0627\u0631 \u0644\u064a\u0628\u064a\u0631\u064a" },
            { "lsl", "\u0644\u0648\u062a\u064a \u0644\u064a\u0633\u0648\u062a\u0648" },
            { "ltl", "\u0627\u0644\u0644\u064a\u062a\u0627 \u0627\u0644\u0644\u064a\u062a\u0648\u0627\u0646\u064a\u0629" },
            { "ltt", "\u062a\u0627\u0644\u0648\u0646\u0627\u0633 \u0644\u064a\u062a\u0648\u0627\u0646\u064a" },
            { "luc", "\u0641\u0631\u0646\u0643 \u0644\u0648\u0643\u0633\u0645\u0628\u0631\u062c \u0642\u0627\u0628\u0644 \u0644\u0644\u062a\u062d\u0648\u064a\u0644" },
            { "luf", "\u0641\u0631\u0646\u0643 \u0644\u0648\u0643\u0633\u0645\u0628\u0631\u062c" },
            { "lul", "\u0641\u0631\u0646\u0643 \u0644\u0648\u0643\u0633\u0645\u0628\u0631\u062c \u0627\u0644\u0645\u0627\u0644\u064a" },
            { "lvl", "\u0644\u0627\u062a\u0633 \u0644\u0627\u062a\u0641\u064a\u0627" },
            { "lvr", "\u0631\u0648\u0628\u0644 \u0644\u0627\u062a\u0641\u064a\u0627" },
            { "lyd", "\u062f\u064a\u0646\u0627\u0631 \u0644\u064a\u0628\u064a" },
            { "mad", "\u062f\u0631\u0647\u0645 \u0645\u063a\u0631\u0628\u064a" },
            { "maf", "\u0641\u0631\u0646\u0643 \u0645\u063a\u0631\u0628\u064a" },
            { "mdl", "\u0644\u0627\u0648 \u0645\u0648\u0644\u062f\u0648\u0641\u064a" },
            { "mga", "\u0623\u0631\u064a\u0627\u0631\u064a \u0645\u062f\u063a\u0634\u0642\u0631" },
            { "mgf", "\u0641\u0631\u0646\u0643 \u0645\u062f\u063a\u0634\u0642\u0631" },
            { "mkd", "\u062f\u064a\u0646\u0627\u0631 \u0645\u0642\u062f\u0648\u0646\u064a" },
            { "mlf", "\u0641\u0631\u0646\u0643 \u0645\u0627\u0644\u064a" },
            { "mmk", "\u0643\u064a\u0627\u062a \u0645\u064a\u0627\u0646\u0645\u0627\u0631" },
            { "mnt", "\u062a\u0648\u063a\u0631\u0648\u063a \u0645\u0646\u063a\u0648\u0644\u064a" },
            { "mop", "\u0628\u0627\u062a\u0627\u0643\u0627 \u0645\u0627\u0643\u0627\u0648\u064a" },
            { "mro", "\u0623\u0648\u0642\u064a\u0629 \u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0629" },
            { "mtl", "\u0644\u064a\u0631\u0629 \u0645\u0627\u0644\u0637\u064a\u0629" },
            { "mtp", "\u062c\u0646\u064a\u0647 \u0645\u0627\u0644\u0637\u064a" },
            { "mur", "\u0631\u0648\u0628\u064a\u0629 \u0645\u0648\u0631\u064a\u0634\u064a\u0648\u0633\u064a\u0629" },
            { "mvr", "\u0631\u0648\u0641\u064a\u0647 \u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0644\u062f\u064a\u0641" },
            { "mwk", "\u0643\u0648\u0627\u0634\u0627 \u0645\u0627\u0644\u0627\u0648\u064a" },
            { "mxn", "\u0628\u064a\u0632\u0648 \u0645\u0643\u0633\u064a\u0643\u064a" },
            { "mxp", "\u0628\u064a\u0632\u0648 \u0641\u0636\u064a \u0645\u0643\u0633\u064a\u0643\u064a - 1861-1992" },
            { "myr", "\u0631\u064a\u0646\u063a\u064a\u062a \u0645\u0627\u0644\u064a\u0632\u064a" },
            { "mze", "\u0627\u0633\u0643\u0648\u062f \u0645\u0648\u0632\u0645\u0628\u064a\u0642\u064a" },
            { "nad", "\u062f\u0648\u0644\u0627\u0631 \u0646\u0627\u0645\u064a\u0628\u064a" },
            { "ngn", "\u0646\u0627\u064a\u0631\u0627 \u0646\u064a\u062c\u064a\u0631\u064a" },
            { "nic", "\u0643\u0648\u0631\u062f\u0648\u0628\u0629 \u0646\u064a\u0643\u0627\u0631\u0627\u062c\u0648\u0627" },
            { "nio", "\u0642\u0631\u0637\u0628\u0629 \u0646\u064a\u0643\u0627\u0631\u0627\u063a\u0648\u0627" },
            { "nlg", "\u062c\u0644\u062f\u0631 \u0647\u0648\u0644\u0646\u062f\u064a" },
            { "nok", "\u0643\u0631\u0648\u0646\u0629 \u0646\u0631\u0648\u064a\u062c\u064a\u0629" },
            { "npr", "\u0631\u0648\u0628\u064a\u0629 \u0646\u064a\u0628\u0627\u0644\u064a" },
            { "nzd", "\u062f\u0648\u0644\u0627\u0631 \u0646\u064a\u0648\u0632\u064a\u0644\u0646\u062f\u064a" },
            { "omr", "\u0631\u064a\u0627\u0644 \u0639\u0645\u0627\u0646\u064a" },
            { "pab", "\u0628\u0627\u0644\u0628\u0648\u0627 \u0628\u0646\u0645\u064a" },
            { "pen", "\u0633\u0648\u0644 \u062c\u062f\u064a\u062f \u0627\u0644\u0628\u064a\u0631\u0648" },
            { "pgk", "\u0643\u064a\u0646\u0627 \u0628\u0627\u0628\u0648\u0627 \u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629" },
            { "php", "\u0628\u064a\u0632\u0648 \u0641\u0644\u0628\u064a\u0646\u064a" },
            { "pkr", "\u0631\u0648\u0628\u064a\u0629 \u0628\u0627\u0643\u0633\u062a\u0627\u0646\u064a" },
            { "pln", "\u0632\u0644\u0648\u062a\u064a \u0628\u0648\u0644\u0646\u062f\u064a" },
            { "plz", "\u0632\u0644\u0648\u062a\u064a \u0628\u0648\u0644\u0646\u062f\u064a - 1950-1995" },
            { "pte", "\u0627\u0633\u0643\u0648\u062f \u0628\u0631\u062a\u063a\u0627\u0644\u064a" },
            { "pyg", "\u062c\u0648\u0627\u0631\u0627\u0646\u064a \u0628\u0627\u0631\u0627\u062c\u0648\u0627\u064a" },
            { "qar", "\u0631\u064a\u0627\u0644 \u0642\u0637\u0631\u064a" },
            { "rhd", "\u062f\u0648\u0644\u0627\u0631 \u0631\u0648\u062f\u064a\u0633\u064a" },
            { "rol", "\u0644\u064a\u0648 \u0631\u0648\u0645\u0627\u0646\u064a \u0642\u062f\u064a\u0645" },
            { "rsd", "\u062f\u064a\u0646\u0627\u0631 \u0635\u0631\u0628\u064a" },
            { "rub", "\u0631\u0648\u0628\u0644 \u0631\u0648\u0633\u064a" },
            { "rur", "\u0631\u0648\u0628\u0644 \u0631\u0648\u0633\u064a - 1991-1998" },
            { "rwf", "\u0641\u0631\u0646\u0643 \u0631\u0648\u0627\u0646\u062f\u064a" },
            { "sar", "\u0631\u064a\u0627\u0644 \u0633\u0639\u0648\u062f\u064a" },
            { "sbd", "\u062f\u0648\u0644\u0627\u0631 \u062c\u0632\u0631 \u0633\u0644\u064a\u0645\u0627\u0646" },
            { "scr", "\u0631\u0648\u0628\u064a\u0629 \u0633\u064a\u0634\u064a\u0644\u064a\u0629" },
            { "sdd", "\u062f\u064a\u0646\u0627\u0631 \u0633\u0648\u062f\u0627\u0646\u064a" },
            { "sdg", "\u062c\u0646\u064a\u0647 \u0633\u0648\u062f\u0627\u0646\u064a" },
            { "sdp", "\u062c\u0646\u064a\u0647 \u0633\u0648\u062f\u0627\u0646\u064a \u0642\u062f\u064a\u0645" },
            { "sek", "\u0643\u0631\u0648\u0646\u0629 \u0633\u0648\u064a\u062f\u064a\u0629" },
            { "sgd", "\u062f\u0648\u0644\u0627\u0631 \u0633\u0646\u063a\u0627\u0641\u0648\u0631\u064a" },
            { "shp", "\u062c\u0646\u064a\u0647 \u0633\u0627\u0646\u062a \u0647\u064a\u0644\u064a\u0646" },
            { "sit", "\u062a\u0648\u0644\u0627\u0631 \u0633\u0644\u0648\u0641\u064a\u0646\u064a" },
            { "skk", "\u0643\u0631\u0648\u0646\u0629 \u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0629" },
            { "sll", "\u0644\u064a\u0648\u0646 \u0633\u064a\u0631\u0627\u0644\u064a\u0648\u0646\u064a" },
            { "sos", "\u0634\u0644\u0646 \u0635\u0648\u0645\u0627\u0644\u064a" },
            { "srd", "\u062f\u0648\u0644\u0627\u0631 \u0633\u0648\u0631\u064a\u0646\u0627\u0645\u064a" },
            { "srg", "\u062c\u0644\u062f\u0631 \u0633\u0648\u0631\u064a\u0646\u0627\u0645\u064a" },
            { "std", "\u062f\u0648\u0628\u0631\u0627 \u0633\u0627\u0648 \u062a\u0648\u0645\u064a \u0648\u0628\u0631\u064a\u0646\u0633\u064a\u0628\u064a" },
            { "sur", "\u0631\u0648\u0628\u0644 \u0633\u0648\u0641\u064a\u062a\u064a" },
            { "svc", "\u0643\u0648\u0644\u0648\u0646 \u0633\u0644\u0641\u0627\u062f\u0648\u0631\u064a" },
            { "syp", "\u0644\u064a\u0631\u0629 \u0633\u0648\u0631\u064a\u0629" },
            { "szl", "\u0644\u064a\u0644\u0627\u0646\u062c\u064a\u0646\u064a \u0633\u0648\u0627\u0632\u064a\u0644\u0646\u062f\u064a" },
            { "thb", "\u0628\u0627\u062e\u062a \u062a\u0627\u064a\u0644\u0627\u0646\u062f\u064a" },
            { "tjr", "\u0631\u0648\u0628\u0644 \u0637\u0627\u062c\u064a\u0643\u0633\u062a\u0627\u0646\u064a" },
            { "tjs", "\u0633\u0648\u0645\u0648\u0646\u064a \u0637\u0627\u062c\u064a\u0643\u0633\u062a\u0627\u0646\u064a" },
            { "tmm", "\u0645\u0627\u0646\u0627\u062a \u062a\u0631\u0643\u0645\u0646\u0633\u062a\u0627\u0646\u064a" },
            { "tmt", "\u0645\u0627\u0646\u0627\u062a \u062a\u0631\u0643\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "tnd", "\u062f\u064a\u0646\u0627\u0631\u062a\u0648\u0646\u0633\u064a" },
            { "top", "\u0628\u0627\u0646\u063a\u0627 \u062a\u0648\u0646\u063a\u0627" },
            { "tpe", "\u0627\u0633\u0643\u0648\u062f \u062a\u064a\u0645\u0648\u0631\u064a" },
            { "trl", "\u0644\u064a\u0631\u0629 \u062a\u0631\u0643\u064a" },
            { "try", "\u0644\u064a\u0631\u0629 \u062a\u0631\u0643\u064a\u0629" },
            { "ttd", "\u062f\u0648\u0644\u0627\u0631 \u062a\u0631\u064a\u0646\u062f\u0627\u062f \u0648\u062a\u0648\u0628\u0627\u062c\u0648" },
            { "twd", "\u062f\u0648\u0644\u0627\u0631 \u062a\u0627\u064a\u0648\u0627\u0646\u064a" },
            { "tzs", "\u0634\u0644\u0646 \u062a\u0646\u0632\u0627\u0646\u064a" },
            { "uah", "\u0647\u0631\u064a\u0641\u0646\u064a\u0627 \u0623\u0648\u0643\u0631\u0627\u0646\u064a" },
            { "ugs", "\u0634\u0644\u0646 \u0623\u0648\u063a\u0646\u062f\u064a - 1966-1987" },
            { "ugx", "\u0634\u0644\u0646 \u0623\u0648\u063a\u0646\u062f\u064a" },
            { "usd", "\u062f\u0648\u0644\u0627\u0631 \u0623\u0645\u0631\u064a\u0643\u064a" },
            { "usn", "\u062f\u0648\u0644\u0627\u0631 \u0623\u0645\u0631\u064a\u0643\u064a (\u0627\u0644\u064a\u0648\u0645 \u0627\u0644\u062a\u0627\u0644\u064a)\u200f" },
            { "uss", "\u062f\u0648\u0644\u0627\u0631 \u0623\u0645\u0631\u064a\u0643\u064a (\u0646\u0641\u0633 \u0627\u0644\u064a\u0648\u0645)\u200f" },
            { "uyp", "\u0628\u064a\u0632\u0648 \u0623\u0648\u0631\u0648\u062c\u0648\u0627\u064a - 1975-1993" },
            { "uyu", "\u0628\u064a\u0632\u0648 \u0627\u0648\u0631\u0648\u063a\u0648\u0627\u064a" },
            { "uzs", "\u0633\u0648\u0645 \u0623\u0648\u0632\u0628\u0643\u0633\u062a\u0627\u0646\u064a" },
            { "veb", "\u0628\u0648\u0644\u064a\u0641\u0627\u0631 \u0641\u0646\u0632\u0648\u064a\u0644\u064a - 1871-2008\u00a0" },
            { "vef", "\u0628\u0648\u0644\u064a\u0641\u0627\u0631 \u0641\u0646\u0632\u0648\u064a\u0644\u064a" },
            { "vnd", "\u062f\u0648\u0646\u062c \u0641\u064a\u062a\u0646\u0627\u0645\u064a" },
            { "vuv", "\u0641\u0627\u062a\u0648 \u0641\u0627\u0646\u0648\u0627\u062a\u0648" },
            { "wst", "\u062a\u0627\u0644\u0627 \u0633\u0627\u0645\u0648\u0627" },
            { "xaf", "\u0641\u0631\u0646\u0643 \u0623\u0641\u0631\u064a\u0642\u064a" },
            { "xag", "\u0641\u0636\u0629" },
            { "xau", "\u0630\u0647\u0628" },
            { "xba", "\u0627\u0644\u0648\u062d\u062f\u0629 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629 \u0627\u0644\u0645\u0631\u0643\u0628\u0629" },
            { "xbb", "\u0627\u0644\u0648\u062d\u062f\u0629 \u0627\u0644\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "xbc", "\u0627\u0644\u0648\u062d\u062f\u0629 \u0627\u0644\u062d\u0633\u0627\u0628\u064a\u0629 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "xbd", "(XBD)\u0648\u062d\u062f\u0629 \u0627\u0644\u062d\u0633\u0627\u0628 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "xcd", "\u062f\u0648\u0644\u0627\u0631 \u0634\u0631\u0642 \u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a" },
            { "xdr", "\u062d\u0642\u0648\u0642 \u0627\u0644\u0633\u062d\u0628 \u0627\u0644\u062e\u0627\u0635\u0629" },
            { "xeu", "\u0648\u062d\u062f\u0629 \u0627\u0644\u0646\u0642\u062f \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "xfo", "\u0641\u0631\u0646\u0643 \u0641\u0631\u0646\u0633\u064a \u0630\u0647\u0628\u064a" },
            { "xfu", "(UIC)\u0641\u0631\u0646\u0643 \u0641\u0631\u0646\u0633\u064a" },
            { "xof", "\u0641\u0631\u0646\u0643 \u0633\u064a \u0625\u0641 \u0625\u064a\u0647 \u063a\u0631\u0628 \u0625\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "xpd", "\u0628\u0627\u0644\u0627\u062f\u064a\u0648\u0645" },
            { "xpf", "\u0641\u0631\u0646\u0643 \u0633\u064a \u0625\u0641 \u0628\u064a" },
            { "xpt", "\u0627\u0644\u0628\u0644\u0627\u062a\u064a\u0646" },
            { "xts", "\u0643\u0648\u062f \u0627\u062e\u062a\u0628\u0627\u0631 \u0627\u0644\u0639\u0645\u0644\u0629" },
            { "xxx", "\u0639\u0645\u0644\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641\u0629" },
            { "ydd", "\u062f\u064a\u0646\u0627\u0631 \u064a\u0645\u0646\u064a" },
            { "yer", "\u0631\u064a\u0627\u0644 \u064a\u0645\u0646\u064a" },
            { "yud", "\u062f\u064a\u0646\u0627\u0631 \u064a\u0648\u063a\u0633\u0644\u0627\u0641\u064a" },
            { "yun", "\u062f\u064a\u0646\u0627\u0631 \u064a\u0648\u063a\u0633\u0644\u0627\u0641\u064a \u0642\u0627\u0628\u0644 \u0644\u0644\u062a\u062d\u0648\u064a\u0644" },
            { "zal", "\u0631\u0627\u0646\u062f \u062c\u0646\u0648\u0628 \u0623\u0641\u0631\u064a\u0642\u064a\u0627 -\u0645\u0627\u0644\u064a" },
            { "zar", "\u0631\u0627\u0646\u062f \u062c\u0646\u0648\u0628 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "zmk", "\u0643\u0648\u0627\u0634\u0627 \u0632\u0627\u0645\u0628\u064a" },
            { "zrn", "\u0632\u0627\u0626\u064a\u0631 \u0632\u0627\u0626\u064a\u0631\u064a \u062c\u062f\u064a\u062f" },
            { "zrz", "\u0632\u0627\u0626\u064a\u0631 \u0632\u0627\u0626\u064a\u0631\u064a" },
            { "zwd", "\u062f\u0648\u0644\u0627\u0631 \u0632\u0645\u0628\u0627\u0628\u0648\u064a" },
            { "zwl", "\u062f\u0648\u0644\u0627\u0631 \u0632\u0645\u0628\u0627\u0628\u0648\u064a 2009" },
        };
        return data;
    }
}
