/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import com.sun.imageio.plugins.common.LZWCompressor;
import com.sun.imageio.plugins.common.PaletteBuilder;
import com.sun.imageio.plugins.gif.GIFImageWriteParam;
import com.sun.imageio.plugins.gif.GIFImageWriterSpi;
import com.sun.imageio.plugins.gif.GIFWritableImageMetadata;
import com.sun.imageio.plugins.gif.GIFWritableStreamMetadata;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.awt.image.ByteComponentRaster;

public class GIFImageWriter
extends ImageWriter {
    private static final boolean DEBUG = false;
    static final String STANDARD_METADATA_NAME = "javax_imageio_1.0";
    static final String STREAM_METADATA_NAME = "javax_imageio_gif_stream_1.0";
    static final String IMAGE_METADATA_NAME = "javax_imageio_gif_image_1.0";
    private ImageOutputStream stream = null;
    private boolean isWritingSequence = false;
    private boolean wroteSequenceHeader = false;
    private GIFWritableStreamMetadata theStreamMetadata = null;
    private int imageIndex = 0;

    private static int getNumBits(int n) throws IOException {
        int n2;
        switch (n) {
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 4;
                break;
            }
            case 32: {
                n2 = 5;
                break;
            }
            case 64: {
                n2 = 6;
                break;
            }
            case 128: {
                n2 = 7;
                break;
            }
            case 256: {
                n2 = 8;
                break;
            }
            default: {
                throw new IOException("Bad palette length: " + n + "!");
            }
        }
        return n2;
    }

    private static void computeRegions(Rectangle rectangle, Dimension dimension, ImageWriteParam imageWriteParam) {
        int n = 1;
        int n2 = 1;
        if (imageWriteParam != null) {
            int[] nArray = imageWriteParam.getSourceBands();
            if (nArray != null && (nArray.length != 1 || nArray[0] != 0)) {
                throw new IllegalArgumentException("Cannot sub-band image!");
            }
            Rectangle rectangle2 = imageWriteParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle2 = rectangle2.intersection(rectangle);
                rectangle.setBounds(rectangle2);
            }
            int n3 = imageWriteParam.getSubsamplingXOffset();
            int n4 = imageWriteParam.getSubsamplingYOffset();
            rectangle.x += n3;
            rectangle.y += n4;
            rectangle.width -= n3;
            rectangle.height -= n4;
            n = imageWriteParam.getSourceXSubsampling();
            n2 = imageWriteParam.getSourceYSubsampling();
        }
        dimension.setSize((rectangle.width + n - 1) / n, (rectangle.height + n2 - 1) / n2);
        if (dimension.width <= 0 || dimension.height <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
    }

    private static byte[] createColorTable(ColorModel colorModel, SampleModel sampleModel) {
        byte[] byArray;
        if (colorModel instanceof IndexColorModel) {
            int n;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n2 = indexColorModel.getMapSize();
            int n3 = GIFImageWriter.getGifPaletteSize(n2);
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n3];
            byte[] byArray4 = new byte[n3];
            indexColorModel.getReds(byArray2);
            indexColorModel.getGreens(byArray3);
            indexColorModel.getBlues(byArray4);
            for (n = n2; n < n3; ++n) {
                byArray2[n] = byArray2[0];
                byArray3[n] = byArray3[0];
                byArray4[n] = byArray4[0];
            }
            byArray = new byte[3 * n3];
            n = 0;
            for (int i = 0; i < n3; ++i) {
                byArray[n++] = byArray2[i];
                byArray[n++] = byArray3[i];
                byArray[n++] = byArray4[i];
            }
        } else if (sampleModel.getNumBands() == 1) {
            int n = sampleModel.getSampleSize()[0];
            if (n > 8) {
                n = 8;
            }
            int n4 = 3 * (1 << n);
            byArray = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                byArray[i] = (byte)(i / 3);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    private static int getGifPaletteSize(int n) {
        if (n <= 2) {
            return 2;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public GIFImageWriter(GIFImageWriterSpi gIFImageWriterSpi) {
        super(gIFImageWriterSpi);
    }

    @Override
    public boolean canWriteSequence() {
        return true;
    }

    private void convertMetadata(String string, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        Object object;
        String string2 = null;
        String string3 = iIOMetadata.getNativeMetadataFormatName();
        if (string3 != null && string3.equals(string)) {
            string2 = string;
        } else {
            object = iIOMetadata.getExtraMetadataFormatNames();
            if (object != null) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (!object[i].equals(string)) continue;
                    string2 = string;
                    break;
                }
            }
        }
        if (string2 == null && iIOMetadata.isStandardMetadataFormatSupported()) {
            string2 = STANDARD_METADATA_NAME;
        }
        if (string2 != null) {
            try {
                object = iIOMetadata.getAsTree(string2);
                iIOMetadata2.mergeTree(string2, (Node)object);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                // empty catch block
            }
        }
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        IIOMetadata iIOMetadata2 = this.getDefaultStreamMetadata(imageWriteParam);
        this.convertMetadata(STREAM_METADATA_NAME, iIOMetadata, iIOMetadata2);
        return iIOMetadata2;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        GIFWritableImageMetadata gIFWritableImageMetadata = (GIFWritableImageMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        boolean bl = gIFWritableImageMetadata.interlaceFlag;
        this.convertMetadata(IMAGE_METADATA_NAME, iIOMetadata, gIFWritableImageMetadata);
        if (imageWriteParam != null && imageWriteParam.canWriteProgressive()) {
            if (imageWriteParam.getProgressiveMode() != 3) {
                gIFWritableImageMetadata.interlaceFlag = bl;
            }
        }
        return gIFWritableImageMetadata;
    }

    @Override
    public void endWriteSequence() throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() was not invoked!");
        }
        this.writeTrailer();
        this.resetLocal();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        int n;
        GIFWritableImageMetadata gIFWritableImageMetadata = new GIFWritableImageMetadata();
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        Rectangle rectangle = new Rectangle(sampleModel.getWidth(), sampleModel.getHeight());
        Dimension dimension = new Dimension();
        GIFImageWriter.computeRegions(rectangle, dimension, imageWriteParam);
        gIFWritableImageMetadata.imageWidth = dimension.width;
        gIFWritableImageMetadata.imageHeight = dimension.height;
        gIFWritableImageMetadata.interlaceFlag = imageWriteParam == null || !imageWriteParam.canWriteProgressive() || imageWriteParam.getProgressiveMode() != 0;
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        gIFWritableImageMetadata.localColorTable = GIFImageWriter.createColorTable(colorModel, sampleModel);
        if (colorModel instanceof IndexColorModel && (n = ((IndexColorModel)colorModel).getTransparentPixel()) != -1) {
            gIFWritableImageMetadata.transparentColorFlag = true;
            gIFWritableImageMetadata.transparentColorIndex = n;
        }
        return gIFWritableImageMetadata;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        GIFWritableStreamMetadata gIFWritableStreamMetadata = new GIFWritableStreamMetadata();
        gIFWritableStreamMetadata.version = "89a";
        return gIFWritableStreamMetadata;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(this.getLocale());
    }

    @Override
    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output is not set.");
        }
        this.resetLocal();
        if (iIOMetadata == null) {
            this.theStreamMetadata = (GIFWritableStreamMetadata)this.getDefaultStreamMetadata(null);
        } else {
            this.theStreamMetadata = new GIFWritableStreamMetadata();
            this.convertMetadata(STREAM_METADATA_NAME, iIOMetadata, this.theStreamMetadata);
        }
        this.isWritingSequence = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetLocal();
    }

    private void resetLocal() {
        this.isWritingSequence = false;
        this.wroteSequenceHeader = false;
        this.theStreamMetadata = null;
        this.imageIndex = 0;
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output is not an ImageOutputStream");
            }
            this.stream = (ImageOutputStream)object;
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream = null;
        }
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("iioimage == null!");
        }
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("canWriteRasters() == false!");
        }
        this.resetLocal();
        GIFWritableStreamMetadata gIFWritableStreamMetadata = iIOMetadata == null ? (GIFWritableStreamMetadata)this.getDefaultStreamMetadata(imageWriteParam) : (GIFWritableStreamMetadata)this.convertStreamMetadata(iIOMetadata, imageWriteParam);
        this.write(true, true, gIFWritableStreamMetadata, iIOImage, imageWriteParam);
    }

    @Override
    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("canWriteRasters() == false!");
        }
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() was not invoked!");
        }
        this.write(!this.wroteSequenceHeader, false, this.theStreamMetadata, iIOImage, imageWriteParam);
        if (!this.wroteSequenceHeader) {
            this.wroteSequenceHeader = true;
        }
        ++this.imageIndex;
    }

    private boolean needToCreateIndex(RenderedImage renderedImage) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        return sampleModel.getNumBands() != 1 || sampleModel.getSampleSize()[0] > 8 || colorModel.getComponentSize()[0] > 8;
    }

    private void write(boolean bl, boolean bl2, IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        Object object;
        this.clearAbortRequest();
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        if (this.needToCreateIndex(renderedImage)) {
            renderedImage = PaletteBuilder.createIndexedImage(renderedImage);
            iIOImage.setRenderedImage(renderedImage);
        }
        ColorModel colorModel = renderedImage.getColorModel();
        SampleModel sampleModel = renderedImage.getSampleModel();
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Dimension dimension = new Dimension();
        GIFImageWriter.computeRegions(rectangle, dimension, imageWriteParam);
        GIFWritableImageMetadata gIFWritableImageMetadata = null;
        if (iIOImage.getMetadata() != null) {
            gIFWritableImageMetadata = new GIFWritableImageMetadata();
            this.convertMetadata(IMAGE_METADATA_NAME, iIOImage.getMetadata(), gIFWritableImageMetadata);
            if (gIFWritableImageMetadata.localColorTable == null) {
                gIFWritableImageMetadata.localColorTable = GIFImageWriter.createColorTable(colorModel, sampleModel);
                if (colorModel instanceof IndexColorModel) {
                    object = (IndexColorModel)colorModel;
                    int n = object.getTransparentPixel();
                    boolean bl3 = gIFWritableImageMetadata.transparentColorFlag = n != -1;
                    if (gIFWritableImageMetadata.transparentColorFlag) {
                        gIFWritableImageMetadata.transparentColorIndex = n;
                    }
                }
            }
        }
        object = null;
        if (bl) {
            if (iIOMetadata == null) {
                throw new IllegalArgumentException("Cannot write null header!");
            }
            GIFWritableStreamMetadata gIFWritableStreamMetadata = (GIFWritableStreamMetadata)iIOMetadata;
            if (gIFWritableStreamMetadata.version == null) {
                gIFWritableStreamMetadata.version = "89a";
            }
            if (gIFWritableStreamMetadata.logicalScreenWidth == -1) {
                gIFWritableStreamMetadata.logicalScreenWidth = dimension.width;
            }
            if (gIFWritableStreamMetadata.logicalScreenHeight == -1) {
                gIFWritableStreamMetadata.logicalScreenHeight = dimension.height;
            }
            if (gIFWritableStreamMetadata.colorResolution == -1) {
                int n = gIFWritableStreamMetadata.colorResolution = colorModel != null ? colorModel.getComponentSize()[0] : sampleModel.getSampleSize()[0];
            }
            if (gIFWritableStreamMetadata.globalColorTable == null) {
                if (this.isWritingSequence && gIFWritableImageMetadata != null && gIFWritableImageMetadata.localColorTable != null) {
                    gIFWritableStreamMetadata.globalColorTable = gIFWritableImageMetadata.localColorTable;
                } else if (gIFWritableImageMetadata == null || gIFWritableImageMetadata.localColorTable == null) {
                    gIFWritableStreamMetadata.globalColorTable = GIFImageWriter.createColorTable(colorModel, sampleModel);
                }
            }
            int n = (object = (Object)gIFWritableStreamMetadata.globalColorTable) != null ? GIFImageWriter.getNumBits(((byte[])object).length / 3) : (gIFWritableImageMetadata != null && gIFWritableImageMetadata.localColorTable != null ? GIFImageWriter.getNumBits(gIFWritableImageMetadata.localColorTable.length / 3) : sampleModel.getSampleSize(0));
            this.writeHeader(gIFWritableStreamMetadata, n);
        } else if (this.isWritingSequence) {
            object = this.theStreamMetadata.globalColorTable;
        } else {
            throw new IllegalArgumentException("Must write header for single image!");
        }
        this.writeImage(iIOImage.getRenderedImage(), gIFWritableImageMetadata, imageWriteParam, (byte[])object, rectangle, dimension);
        if (bl2) {
            this.writeTrailer();
        }
    }

    private void writeImage(RenderedImage renderedImage, GIFWritableImageMetadata gIFWritableImageMetadata, ImageWriteParam imageWriteParam, byte[] byArray, Rectangle rectangle, Dimension dimension) throws IOException {
        boolean bl;
        ColorModel colorModel = renderedImage.getColorModel();
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (gIFWritableImageMetadata == null) {
            gIFWritableImageMetadata = (GIFWritableImageMetadata)this.getDefaultImageMetadata(new ImageTypeSpecifier(renderedImage), imageWriteParam);
            bl = gIFWritableImageMetadata.transparentColorFlag;
        } else {
            NodeList nodeList = null;
            try {
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)gIFWritableImageMetadata.getAsTree(IMAGE_METADATA_NAME);
                nodeList = iIOMetadataNode.getElementsByTagName("GraphicControlExtension");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            boolean bl2 = bl = nodeList != null && nodeList.getLength() > 0;
            if (imageWriteParam != null && imageWriteParam.canWriteProgressive()) {
                if (imageWriteParam.getProgressiveMode() == 0) {
                    gIFWritableImageMetadata.interlaceFlag = false;
                } else if (imageWriteParam.getProgressiveMode() == 1) {
                    gIFWritableImageMetadata.interlaceFlag = true;
                }
            }
        }
        if (Arrays.equals(byArray, gIFWritableImageMetadata.localColorTable)) {
            gIFWritableImageMetadata.localColorTable = null;
        }
        gIFWritableImageMetadata.imageWidth = dimension.width;
        gIFWritableImageMetadata.imageHeight = dimension.height;
        if (bl) {
            this.writeGraphicControlExtension(gIFWritableImageMetadata);
        }
        this.writePlainTextExtension(gIFWritableImageMetadata);
        this.writeApplicationExtension(gIFWritableImageMetadata);
        this.writeCommentExtension(gIFWritableImageMetadata);
        int n = GIFImageWriter.getNumBits(gIFWritableImageMetadata.localColorTable == null ? (byArray == null ? sampleModel.getSampleSize(0) : byArray.length / 3) : gIFWritableImageMetadata.localColorTable.length / 3);
        this.writeImageDescriptor(gIFWritableImageMetadata, n);
        this.writeRasterData(renderedImage, rectangle, dimension, imageWriteParam, gIFWritableImageMetadata.interlaceFlag);
    }

    private void writeRows(RenderedImage renderedImage, LZWCompressor lZWCompressor, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) throws IOException {
        int[] nArray = new int[n5];
        byte[] byArray = new byte[n8];
        Raster raster = renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1 ? renderedImage.getTile(0, 0) : renderedImage.getData();
        for (int i = n6; i < n9; i += n7) {
            if (n10 % n11 == 0) {
                if (this.abortRequested()) {
                    this.processWriteAborted();
                    return;
                }
                this.processImageProgress((float)n10 * 100.0f / (float)n9);
            }
            raster.getSamples(n, n3, n5, 1, 0, nArray);
            int n12 = 0;
            int n13 = 0;
            while (n12 < n8) {
                byArray[n12] = (byte)nArray[n13];
                ++n12;
                n13 += n2;
            }
            lZWCompressor.compress(byArray, 0, n8);
            ++n10;
            n3 += n4;
        }
    }

    private void writeRowsOpt(byte[] byArray, int n, int n2, LZWCompressor lZWCompressor, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        n += n3 * n2;
        n2 *= n4;
        for (int i = n3; i < n6; i += n4) {
            if (n7 % n8 == 0) {
                if (this.abortRequested()) {
                    this.processWriteAborted();
                    return;
                }
                this.processImageProgress((float)n7 * 100.0f / (float)n6);
            }
            lZWCompressor.compress(byArray, n, n5);
            ++n7;
            n += n2;
        }
    }

    private void writeRasterData(RenderedImage renderedImage, Rectangle rectangle, Dimension dimension, ImageWriteParam imageWriteParam, boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = dimension.width;
        int n9 = dimension.height;
        if (imageWriteParam == null) {
            n3 = 1;
            n2 = 1;
        } else {
            n3 = imageWriteParam.getSourceXSubsampling();
            n2 = imageWriteParam.getSourceYSubsampling();
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n10 = n = sampleModel.getSampleSize()[0];
        if (n10 == 1) {
            ++n10;
        }
        this.stream.write(n10);
        LZWCompressor lZWCompressor = new LZWCompressor(this.stream, n10, false);
        boolean bl2 = n3 == 1 && n2 == 1 && renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1 && sampleModel instanceof ComponentSampleModel && renderedImage.getTile(0, 0) instanceof ByteComponentRaster && renderedImage.getTile(0, 0).getDataBuffer() instanceof DataBufferByte;
        int n11 = 0;
        int n12 = Math.max(n9 / 20, 1);
        this.processImageStarted(this.imageIndex);
        if (bl) {
            if (bl2) {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)renderedImage.getTile(0, 0);
                byte[] byArray = ((DataBufferByte)byteComponentRaster.getDataBuffer()).getData();
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)byteComponentRaster.getSampleModel();
                int n13 = componentSampleModel.getOffset(n4, n5, 0);
                int n14 = componentSampleModel.getScanlineStride();
                this.writeRowsOpt(byArray, n13 += byteComponentRaster.getDataOffset(0), n14, lZWCompressor, 0, 8, n8, n9, n11, n12);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRowsOpt(byArray, n13, n14, lZWCompressor, 4, 8, n8, n9, n11 += n9 / 8, n12);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRowsOpt(byArray, n13, n14, lZWCompressor, 2, 4, n8, n9, n11 += (n9 - 4) / 8, n12);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRowsOpt(byArray, n13, n14, lZWCompressor, 1, 2, n8, n9, n11 += (n9 - 2) / 4, n12);
            } else {
                this.writeRows(renderedImage, lZWCompressor, n4, n3, n5, 8 * n2, n6, 0, 8, n8, n9, n11, n12);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRows(renderedImage, lZWCompressor, n4, n3, n5 + 4 * n2, 8 * n2, n6, 4, 8, n8, n9, n11 += n9 / 8, n12);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRows(renderedImage, lZWCompressor, n4, n3, n5 + 2 * n2, 4 * n2, n6, 2, 4, n8, n9, n11 += (n9 - 4) / 8, n12);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRows(renderedImage, lZWCompressor, n4, n3, n5 + n2, 2 * n2, n6, 1, 2, n8, n9, n11 += (n9 - 2) / 4, n12);
            }
        } else if (bl2) {
            Raster raster = renderedImage.getTile(0, 0);
            byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
            int n15 = componentSampleModel.getOffset(n4, n5, 0);
            int n16 = componentSampleModel.getScanlineStride();
            this.writeRowsOpt(byArray, n15, n16, lZWCompressor, 0, 1, n8, n9, n11, n12);
        } else {
            this.writeRows(renderedImage, lZWCompressor, n4, n3, n5, n2, n6, 0, 1, n8, n9, n11, n12);
        }
        if (this.abortRequested()) {
            return;
        }
        this.processImageProgress(100.0f);
        lZWCompressor.flush();
        this.stream.write(0);
        this.processImageComplete();
    }

    private void writeHeader(String string, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, byte[] byArray) throws IOException {
        try {
            this.stream.writeBytes("GIF" + string);
            this.stream.writeShort((short)n);
            this.stream.writeShort((short)n2);
            int n7 = byArray != null ? 128 : 0;
            n7 |= (n3 - 1 & 7) << 4;
            if (bl) {
                n7 |= 8;
            }
            this.stream.write(n7 |= n6 - 1);
            this.stream.write(n5);
            this.stream.write(n4);
            if (byArray != null) {
                this.stream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error writing header!", iOException);
        }
    }

    private void writeHeader(IIOMetadata iIOMetadata, int n) throws IOException {
        GIFWritableStreamMetadata gIFWritableStreamMetadata;
        if (iIOMetadata instanceof GIFWritableStreamMetadata) {
            gIFWritableStreamMetadata = (GIFWritableStreamMetadata)iIOMetadata;
        } else {
            gIFWritableStreamMetadata = new GIFWritableStreamMetadata();
            Node node = iIOMetadata.getAsTree(STREAM_METADATA_NAME);
            gIFWritableStreamMetadata.setFromTree(STREAM_METADATA_NAME, node);
        }
        this.writeHeader(gIFWritableStreamMetadata.version, gIFWritableStreamMetadata.logicalScreenWidth, gIFWritableStreamMetadata.logicalScreenHeight, gIFWritableStreamMetadata.colorResolution, gIFWritableStreamMetadata.pixelAspectRatio, gIFWritableStreamMetadata.backgroundColorIndex, gIFWritableStreamMetadata.sortFlag, n, gIFWritableStreamMetadata.globalColorTable);
    }

    private void writeGraphicControlExtension(int n, boolean bl, boolean bl2, int n2, int n3) throws IOException {
        try {
            this.stream.write(33);
            this.stream.write(249);
            this.stream.write(4);
            int n4 = (n & 3) << 2;
            if (bl) {
                n4 |= 2;
            }
            if (bl2) {
                n4 |= 1;
            }
            this.stream.write(n4);
            this.stream.writeShort((short)n2);
            this.stream.write(n3);
            this.stream.write(0);
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error writing Graphic Control Extension!", iOException);
        }
    }

    private void writeGraphicControlExtension(GIFWritableImageMetadata gIFWritableImageMetadata) throws IOException {
        this.writeGraphicControlExtension(gIFWritableImageMetadata.disposalMethod, gIFWritableImageMetadata.userInputFlag, gIFWritableImageMetadata.transparentColorFlag, gIFWritableImageMetadata.delayTime, gIFWritableImageMetadata.transparentColorIndex);
    }

    private void writeBlocks(byte[] byArray) throws IOException {
        if (byArray != null && byArray.length > 0) {
            int n;
            for (int i = 0; i < byArray.length; i += n) {
                n = Math.min(byArray.length - i, 255);
                this.stream.write(n);
                this.stream.write(byArray, i, n);
            }
        }
    }

    private void writePlainTextExtension(GIFWritableImageMetadata gIFWritableImageMetadata) throws IOException {
        if (gIFWritableImageMetadata.hasPlainTextExtension) {
            try {
                this.stream.write(33);
                this.stream.write(1);
                this.stream.write(12);
                this.stream.writeShort(gIFWritableImageMetadata.textGridLeft);
                this.stream.writeShort(gIFWritableImageMetadata.textGridTop);
                this.stream.writeShort(gIFWritableImageMetadata.textGridWidth);
                this.stream.writeShort(gIFWritableImageMetadata.textGridHeight);
                this.stream.write(gIFWritableImageMetadata.characterCellWidth);
                this.stream.write(gIFWritableImageMetadata.characterCellHeight);
                this.stream.write(gIFWritableImageMetadata.textForegroundColor);
                this.stream.write(gIFWritableImageMetadata.textBackgroundColor);
                this.writeBlocks(gIFWritableImageMetadata.text);
                this.stream.write(0);
            }
            catch (IOException iOException) {
                throw new IIOException("I/O error writing Plain Text Extension!", iOException);
            }
        }
    }

    private void writeApplicationExtension(GIFWritableImageMetadata gIFWritableImageMetadata) throws IOException {
        if (gIFWritableImageMetadata.applicationIDs != null) {
            Iterator iterator = gIFWritableImageMetadata.applicationIDs.iterator();
            Iterator iterator2 = gIFWritableImageMetadata.authenticationCodes.iterator();
            Iterator iterator3 = gIFWritableImageMetadata.applicationData.iterator();
            while (iterator.hasNext()) {
                try {
                    this.stream.write(33);
                    this.stream.write(255);
                    this.stream.write(11);
                    this.stream.write((byte[])iterator.next(), 0, 8);
                    this.stream.write((byte[])iterator2.next(), 0, 3);
                    this.writeBlocks((byte[])iterator3.next());
                    this.stream.write(0);
                }
                catch (IOException iOException) {
                    throw new IIOException("I/O error writing Application Extension!", iOException);
                }
            }
        }
    }

    private void writeCommentExtension(GIFWritableImageMetadata gIFWritableImageMetadata) throws IOException {
        if (gIFWritableImageMetadata.comments != null) {
            try {
                Iterator iterator = gIFWritableImageMetadata.comments.iterator();
                while (iterator.hasNext()) {
                    this.stream.write(33);
                    this.stream.write(254);
                    this.writeBlocks((byte[])iterator.next());
                    this.stream.write(0);
                }
            }
            catch (IOException iOException) {
                throw new IIOException("I/O error writing Comment Extension!", iOException);
            }
        }
    }

    private void writeImageDescriptor(int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, byte[] byArray) throws IOException {
        try {
            int n6;
            this.stream.write(44);
            this.stream.writeShort((short)n);
            this.stream.writeShort((short)n2);
            this.stream.writeShort((short)n3);
            this.stream.writeShort((short)n4);
            int n7 = n6 = byArray != null ? 128 : 0;
            if (bl) {
                n6 |= 0x40;
            }
            if (bl2) {
                n6 |= 8;
            }
            this.stream.write(n6 |= n5 - 1);
            if (byArray != null) {
                this.stream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error writing Image Descriptor!", iOException);
        }
    }

    private void writeImageDescriptor(GIFWritableImageMetadata gIFWritableImageMetadata, int n) throws IOException {
        this.writeImageDescriptor(gIFWritableImageMetadata.imageLeftPosition, gIFWritableImageMetadata.imageTopPosition, gIFWritableImageMetadata.imageWidth, gIFWritableImageMetadata.imageHeight, gIFWritableImageMetadata.interlaceFlag, gIFWritableImageMetadata.sortFlag, n, gIFWritableImageMetadata.localColorTable);
    }

    private void writeTrailer() throws IOException {
        this.stream.write(59);
    }
}

