/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.math.BigInteger;

public final class Long
extends Number
implements Comparable<Long> {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    private static final long serialVersionUID = 4290774380558885855L;

    public static String toString(long l, int n) {
        boolean bl;
        if (n < 2 || n > 36) {
            n = 10;
        }
        if (n == 10) {
            return Long.toString(l);
        }
        char[] cArray = new char[65];
        int n2 = 64;
        boolean bl2 = bl = l < 0L;
        if (!bl) {
            l = -l;
        }
        while (l <= (long)(-n)) {
            cArray[n2--] = Integer.digits[(int)(-(l % (long)n))];
            l /= (long)n;
        }
        cArray[n2] = Integer.digits[(int)(-l)];
        if (bl) {
            cArray[--n2] = 45;
        }
        return new String(cArray, n2, 65 - n2);
    }

    public static String toUnsignedString(long l, int n) {
        if (l >= 0L) {
            return Long.toString(l, n);
        }
        switch (n) {
            case 2: {
                return Long.toBinaryString(l);
            }
            case 4: {
                return Long.toUnsignedString0(l, 2);
            }
            case 8: {
                return Long.toOctalString(l);
            }
            case 10: {
                long l2 = (l >>> 1) / 5L;
                long l3 = l - l2 * 10L;
                return Long.toString(l2) + l3;
            }
            case 16: {
                return Long.toHexString(l);
            }
            case 32: {
                return Long.toUnsignedString0(l, 5);
            }
        }
        return Long.toUnsignedBigInteger(l).toString(n);
    }

    private static BigInteger toUnsignedBigInteger(long l) {
        if (l >= 0L) {
            return BigInteger.valueOf(l);
        }
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        return BigInteger.valueOf(Integer.toUnsignedLong(n)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(n2)));
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString0(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString0(l, 3);
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString0(l, 1);
    }

    static String toUnsignedString0(long l, int n) {
        int n2 = 64 - Long.numberOfLeadingZeros(l);
        int n3 = Math.max((n2 + (n - 1)) / n, 1);
        char[] cArray = new char[n3];
        Long.formatUnsignedLong(l, n, cArray, 0, n3);
        return new String(cArray, true);
    }

    static int formatUnsignedLong(long l, int n, char[] cArray, int n2, int n3) {
        int n4 = n3;
        int n5 = 1 << n;
        int n6 = n5 - 1;
        do {
            cArray[n2 + --n4] = Integer.digits[(int)l & n6];
        } while ((l >>>= n) != 0L && n4 > 0);
        return n4;
    }

    public static String toString(long l) {
        if (l == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        int n = l < 0L ? Long.stringSize(-l) + 1 : Long.stringSize(l);
        char[] cArray = new char[n];
        Long.getChars(l, n, cArray);
        return new String(cArray, true);
    }

    public static String toUnsignedString(long l) {
        return Long.toUnsignedString(l, 10);
    }

    static void getChars(long l, int n, char[] cArray) {
        int n2;
        int n3;
        int n4 = n;
        int n5 = 0;
        if (l < 0L) {
            n5 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n3 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            cArray[--n4] = Integer.DigitOnes[n3];
            cArray[--n4] = Integer.DigitTens[n3];
        }
        int n6 = (int)l;
        while (n6 >= 65536) {
            n2 = n6 / 100;
            n3 = n6 - ((n2 << 6) + (n2 << 5) + (n2 << 2));
            n6 = n2;
            cArray[--n4] = Integer.DigitOnes[n3];
            cArray[--n4] = Integer.DigitTens[n3];
        }
        do {
            n2 = n6 * 52429 >>> 19;
            n3 = n6 - ((n2 << 3) + (n2 << 1));
            cArray[--n4] = Integer.digits[n3];
        } while ((n6 = n2) != 0);
        if (n5 != 0) {
            cArray[--n4] = n5;
        }
    }

    static int stringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    public static long parseLong(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n < 2) {
            throw new NumberFormatException("radix " + n + " less than Character.MIN_RADIX");
        }
        if (n > 36) {
            throw new NumberFormatException("radix " + n + " greater than Character.MAX_RADIX");
        }
        long l = 0L;
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        long l2 = -9223372036854775807L;
        if (n3 > 0) {
            char c = string.charAt(0);
            if (c < '0') {
                if (c == '-') {
                    bl = true;
                    l2 = Long.MIN_VALUE;
                } else if (c != '+') {
                    throw NumberFormatException.forInputString(string);
                }
                if (n3 == 1) {
                    throw NumberFormatException.forInputString(string);
                }
                ++n2;
            }
            long l3 = l2 / (long)n;
            while (n2 < n3) {
                int n4;
                if ((n4 = Character.digit(string.charAt(n2++), n)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                if (l < l3) {
                    throw NumberFormatException.forInputString(string);
                }
                if ((l *= (long)n) < l2 + (long)n4) {
                    throw NumberFormatException.forInputString(string);
                }
                l -= (long)n4;
            }
        } else {
            throw NumberFormatException.forInputString(string);
        }
        return bl ? l : -l;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static long parseUnsignedLong(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n2 = string.length();
        if (n2 > 0) {
            char c = string.charAt(0);
            if (c == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", string));
            }
            if (n2 <= 12 || n == 10 && n2 <= 18) {
                return Long.parseLong(string, n);
            }
            long l = Long.parseLong(string.substring(0, n2 - 1), n);
            int n3 = Character.digit(string.charAt(n2 - 1), n);
            if (n3 < 0) {
                throw new NumberFormatException("Bad digit at end of " + string);
            }
            long l2 = l * (long)n + (long)n3;
            if (Long.compareUnsigned(l2, l) < 0) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", string));
            }
            return l2;
        }
        throw NumberFormatException.forInputString(string);
    }

    public static long parseUnsignedLong(String string) throws NumberFormatException {
        return Long.parseUnsignedLong(string, 10);
    }

    public static Long valueOf(String string, int n) throws NumberFormatException {
        return Long.parseLong(string, n);
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static Long valueOf(long l) {
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Long decode(String string) throws NumberFormatException {
        Long l;
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        char c = string.charAt(0);
        if (c == '-') {
            bl = true;
            ++n2;
        } else if (c == '+') {
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > 1 + n2) {
            ++n2;
            n = 8;
        }
        if (string.startsWith("-", n2) || string.startsWith("+", n2)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            l = Long.valueOf(string.substring(n2), n);
            l = bl ? Long.valueOf(-l.longValue()) : l;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? "-" + string.substring(n2) : string.substring(n2);
            l = Long.valueOf(string2, n);
        }
        return l;
    }

    public Long(long l) {
        this.value = l;
    }

    public Long(String string) throws NumberFormatException {
        this.value = Long.parseLong(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            return this.value == (Long)object;
        }
        return false;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, long l) {
        Long l2 = Long.getLong(string, null);
        return l2 == null ? Long.valueOf(l) : l2;
    }

    public static Long getLong(String string, Long l) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Long.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    @Override
    public int compareTo(Long l) {
        return Long.compare(this.value, l.value);
    }

    public static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public static int compareUnsigned(long l, long l2) {
        return Long.compare(l + Long.MIN_VALUE, l2 + Long.MIN_VALUE);
    }

    public static long divideUnsigned(long l, long l2) {
        if (l2 < 0L) {
            return Long.compareUnsigned(l, l2) < 0 ? 0L : 1L;
        }
        if (l > 0L) {
            return l / l2;
        }
        return Long.toUnsignedBigInteger(l).divide(Long.toUnsignedBigInteger(l2)).longValue();
    }

    public static long remainderUnsigned(long l, long l2) {
        if (l > 0L && l2 > 0L) {
            return l % l2;
        }
        if (Long.compareUnsigned(l, l2) < 0) {
            return l;
        }
        return Long.toUnsignedBigInteger(l).remainder(Long.toUnsignedBigInteger(l2)).longValue();
    }

    public static long highestOneBit(long l) {
        l |= l >> 1;
        l |= l >> 2;
        l |= l >> 4;
        l |= l >> 8;
        l |= l >> 16;
        l |= l >> 32;
        return l - (l >>> 1);
    }

    public static long lowestOneBit(long l) {
        return l & -l;
    }

    public static int numberOfLeadingZeros(long l) {
        if (l == 0L) {
            return 64;
        }
        int n = 1;
        int n2 = (int)(l >>> 32);
        if (n2 == 0) {
            n += 32;
            n2 = (int)l;
        }
        if (n2 >>> 16 == 0) {
            n += 16;
            n2 <<= 16;
        }
        if (n2 >>> 24 == 0) {
            n += 8;
            n2 <<= 8;
        }
        if (n2 >>> 28 == 0) {
            n += 4;
            n2 <<= 4;
        }
        if (n2 >>> 30 == 0) {
            n += 2;
            n2 <<= 2;
        }
        return n -= n2 >>> 31;
    }

    public static int numberOfTrailingZeros(long l) {
        int n;
        if (l == 0L) {
            return 64;
        }
        int n2 = 63;
        int n3 = (int)l;
        if (n3 != 0) {
            n2 -= 32;
            n = n3;
        } else {
            n = (int)(l >>> 32);
        }
        n3 = n << 16;
        if (n3 != 0) {
            n2 -= 16;
            n = n3;
        }
        if ((n3 = n << 8) != 0) {
            n2 -= 8;
            n = n3;
        }
        if ((n3 = n << 4) != 0) {
            n2 -= 4;
            n = n3;
        }
        if ((n3 = n << 2) != 0) {
            n2 -= 2;
            n = n3;
        }
        return n2 - (n << 1 >>> 31);
    }

    public static int bitCount(long l) {
        l -= l >>> 1 & 0x5555555555555555L;
        l = (l & 0x3333333333333333L) + (l >>> 2 & 0x3333333333333333L);
        l = l + (l >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        l += l >>> 32;
        return (int)l & 0x7F;
    }

    public static long rotateLeft(long l, int n) {
        return l << n | l >>> -n;
    }

    public static long rotateRight(long l, int n) {
        return l >>> n | l << -n;
    }

    public static long reverse(long l) {
        l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
        l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
        l = (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
        l = (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
        l = l << 48 | (l & 0xFFFF0000L) << 16 | l >>> 16 & 0xFFFF0000L | l >>> 48;
        return l;
    }

    public static int signum(long l) {
        return (int)(l >> 63 | -l >>> 63);
    }

    public static long reverseBytes(long l) {
        l = (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
        return l << 48 | (l & 0xFFFF0000L) << 16 | l >>> 16 & 0xFFFF0000L | l >>> 48;
    }

    public static long sum(long l, long l2) {
        return l + l2;
    }

    public static long max(long l, long l2) {
        return Math.max(l, l2);
    }

    public static long min(long l, long l2) {
        return Math.min(l, l2);
    }

    private static class LongCache {
        static final Long[] cache = new Long[256];

        private LongCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                LongCache.cache[i] = new Long(i - 128);
            }
        }
    }
}

