/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodRef;
import java.beans.NameGenerator;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.lang.ref.Reference;
import java.lang.reflect.Method;

public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Reference<? extends Class<?>> indexedPropertyTypeRef;
    private final MethodRef indexedReadMethodRef = new MethodRef();
    private final MethodRef indexedWriteMethodRef = new MethodRef();
    private String indexedReadMethodName;
    private String indexedWriteMethodName;

    public IndexedPropertyDescriptor(String string, Class<?> clazz) throws IntrospectionException {
        this(string, clazz, "get" + NameGenerator.capitalize(string), "set" + NameGenerator.capitalize(string), "get" + NameGenerator.capitalize(string), "set" + NameGenerator.capitalize(string));
    }

    public IndexedPropertyDescriptor(String string, Class<?> clazz, String string2, String string3, String string4, String string5) throws IntrospectionException {
        super(string, clazz, string2, string3);
        this.indexedReadMethodName = string4;
        if (string4 != null && this.getIndexedReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + string4);
        }
        this.indexedWriteMethodName = string5;
        if (string5 != null && this.getIndexedWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + string5);
        }
        this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
    }

    public IndexedPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(string, method, method2);
        this.setIndexedReadMethod0(method3);
        this.setIndexedWriteMethod0(method4);
        this.setIndexedPropertyType(this.findIndexedPropertyType(method3, method4));
    }

    IndexedPropertyDescriptor(Class<?> clazz, String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(clazz, string, method, method2);
        this.setIndexedReadMethod0(method3);
        this.setIndexedWriteMethod0(method4);
        this.setIndexedPropertyType(this.findIndexedPropertyType(method3, method4));
    }

    public synchronized Method getIndexedReadMethod() {
        Method method = this.indexedReadMethodRef.get();
        if (method == null) {
            Class[] classArray;
            Class<?> clazz = this.getClass0();
            if (clazz == null || this.indexedReadMethodName == null && !this.indexedReadMethodRef.isSet()) {
                return null;
            }
            String string = "get" + this.getBaseName();
            if (this.indexedReadMethodName == null) {
                classArray = this.getIndexedPropertyType0();
                this.indexedReadMethodName = classArray == Boolean.TYPE || classArray == null ? "is" + this.getBaseName() : string;
            }
            if ((method = Introspector.findMethod(clazz, this.indexedReadMethodName, 1, classArray = new Class[]{Integer.TYPE})) == null && !this.indexedReadMethodName.equals(string)) {
                this.indexedReadMethodName = string;
                method = Introspector.findMethod(clazz, this.indexedReadMethodName, 1, classArray);
            }
            this.setIndexedReadMethod0(method);
        }
        return method;
    }

    public synchronized void setIndexedReadMethod(Method method) throws IntrospectionException {
        this.setIndexedPropertyType(this.findIndexedPropertyType(method, this.indexedWriteMethodRef.get()));
        this.setIndexedReadMethod0(method);
    }

    private void setIndexedReadMethod0(Method method) {
        this.indexedReadMethodRef.set(method);
        if (method == null) {
            this.indexedReadMethodName = null;
            return;
        }
        this.setClass0(method.getDeclaringClass());
        this.indexedReadMethodName = method.getName();
        this.setTransient(method.getAnnotation(Transient.class));
    }

    public synchronized Method getIndexedWriteMethod() {
        Method method = this.indexedWriteMethodRef.get();
        if (method == null) {
            Class[] classArray;
            Class<?> clazz;
            Class<?> clazz2;
            block9: {
                clazz2 = this.getClass0();
                if (clazz2 == null || this.indexedWriteMethodName == null && !this.indexedWriteMethodRef.isSet()) {
                    return null;
                }
                clazz = this.getIndexedPropertyType0();
                if (clazz == null) {
                    try {
                        clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), null);
                        this.setIndexedPropertyType(clazz);
                    }
                    catch (IntrospectionException introspectionException) {
                        Class<?> clazz3 = this.getPropertyType();
                        if (!clazz3.isArray()) break block9;
                        clazz = clazz3.getComponentType();
                    }
                }
            }
            if (this.indexedWriteMethodName == null) {
                this.indexedWriteMethodName = "set" + this.getBaseName();
            }
            if (clazz == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[2];
                classArray2[0] = Integer.TYPE;
                classArray = classArray2;
                classArray2[1] = clazz;
            }
            Class[] classArray3 = classArray;
            method = Introspector.findMethod(clazz2, this.indexedWriteMethodName, 2, classArray3);
            if (method != null && !method.getReturnType().equals(Void.TYPE)) {
                method = null;
            }
            this.setIndexedWriteMethod0(method);
        }
        return method;
    }

    public synchronized void setIndexedWriteMethod(Method method) throws IntrospectionException {
        Class<?> clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), method);
        this.setIndexedPropertyType(clazz);
        this.setIndexedWriteMethod0(method);
    }

    private void setIndexedWriteMethod0(Method method) {
        this.indexedWriteMethodRef.set(method);
        if (method == null) {
            this.indexedWriteMethodName = null;
            return;
        }
        this.setClass0(method.getDeclaringClass());
        this.indexedWriteMethodName = method.getName();
        this.setTransient(method.getAnnotation(Transient.class));
    }

    public synchronized Class<?> getIndexedPropertyType() {
        Class<?> clazz = this.getIndexedPropertyType0();
        if (clazz == null) {
            try {
                clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
                this.setIndexedPropertyType(clazz);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private void setIndexedPropertyType(Class<?> clazz) {
        this.indexedPropertyTypeRef = IndexedPropertyDescriptor.getWeakReference(clazz);
    }

    private Class<?> getIndexedPropertyType0() {
        return this.indexedPropertyTypeRef != null ? this.indexedPropertyTypeRef.get() : null;
    }

    private Class<?> findIndexedPropertyType(Method method, Method method2) throws IntrospectionException {
        Object object;
        Class<?> clazz = null;
        if (method != null) {
            object = IndexedPropertyDescriptor.getParameterTypes(this.getClass0(), method);
            if (((Class<?>[])object).length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed read method");
            }
            clazz = IndexedPropertyDescriptor.getReturnType(this.getClass0(), method);
            if (clazz == Void.TYPE) {
                throw new IntrospectionException("indexed read method returns void");
            }
        }
        if (method2 != null) {
            object = IndexedPropertyDescriptor.getParameterTypes(this.getClass0(), method2);
            if (((Class<?>[])object).length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (clazz == null || ((Class)object[1]).isAssignableFrom(clazz)) {
                clazz = object[1];
            } else if (!clazz.isAssignableFrom((Class<?>)object[1])) {
                throw new IntrospectionException("type mismatch between indexed read and indexed write methods: " + this.getName());
            }
        }
        if (!((object = this.getPropertyType()) == null || ((Class)object).isArray() && ((Class)object).getComponentType() == clazz)) {
            throw new IntrospectionException("type mismatch between indexed and non-indexed methods: " + this.getName());
        }
        return clazz;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)object;
            Method method = indexedPropertyDescriptor.getIndexedReadMethod();
            Method method2 = indexedPropertyDescriptor.getIndexedWriteMethod();
            if (!this.compareMethods(this.getIndexedReadMethod(), method)) {
                return false;
            }
            if (!this.compareMethods(this.getIndexedWriteMethod(), method2)) {
                return false;
            }
            if (this.getIndexedPropertyType() != indexedPropertyDescriptor.getIndexedPropertyType()) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    IndexedPropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        super(propertyDescriptor, propertyDescriptor2);
        IndexedPropertyDescriptor indexedPropertyDescriptor;
        Method method = null;
        Method method2 = null;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            method = indexedPropertyDescriptor.getIndexedReadMethod();
            method2 = indexedPropertyDescriptor.getIndexedWriteMethod();
        }
        if (propertyDescriptor2 instanceof IndexedPropertyDescriptor) {
            Method method3;
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor2;
            Method method4 = indexedPropertyDescriptor.getIndexedReadMethod();
            if (this.isAssignable(method, method4)) {
                method = method4;
            }
            if (this.isAssignable(method2, method3 = indexedPropertyDescriptor.getIndexedWriteMethod())) {
                method2 = method3;
            }
        }
        try {
            if (method != null) {
                this.setIndexedReadMethod(method);
            }
            if (method2 != null) {
                this.setIndexedWriteMethod(method2);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new AssertionError((Object)introspectionException);
        }
    }

    IndexedPropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor) {
        super(indexedPropertyDescriptor);
        this.indexedReadMethodRef.set(indexedPropertyDescriptor.indexedReadMethodRef.get());
        this.indexedWriteMethodRef.set(indexedPropertyDescriptor.indexedWriteMethodRef.get());
        this.indexedPropertyTypeRef = indexedPropertyDescriptor.indexedPropertyTypeRef;
        this.indexedWriteMethodName = indexedPropertyDescriptor.indexedWriteMethodName;
        this.indexedReadMethodName = indexedPropertyDescriptor.indexedReadMethodName;
    }

    @Override
    void updateGenericsFor(Class<?> clazz) {
        super.updateGenericsFor(clazz);
        try {
            this.setIndexedPropertyType(this.findIndexedPropertyType(this.indexedReadMethodRef.get(), this.indexedWriteMethodRef.get()));
        }
        catch (IntrospectionException introspectionException) {
            this.setIndexedPropertyType(null);
        }
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + (this.indexedWriteMethodName == null ? 0 : this.indexedWriteMethodName.hashCode());
        n = 37 * n + (this.indexedReadMethodName == null ? 0 : this.indexedReadMethodName.hashCode());
        n = 37 * n + (this.getIndexedPropertyType() == null ? 0 : this.getIndexedPropertyType().hashCode());
        return n;
    }

    @Override
    void appendTo(StringBuilder stringBuilder) {
        super.appendTo(stringBuilder);
        IndexedPropertyDescriptor.appendTo(stringBuilder, "indexedPropertyType", this.indexedPropertyTypeRef);
        IndexedPropertyDescriptor.appendTo(stringBuilder, "indexedReadMethod", this.indexedReadMethodRef.get());
        IndexedPropertyDescriptor.appendTo(stringBuilder, "indexedWriteMethod", this.indexedWriteMethodRef.get());
    }
}

