/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class ChangeSignatureHandler {
    public static String CHANGE_SIGNATURE_ANNOTATION_ID = "java.refactor.ChangeSignature";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Refactoring getChangeSignatureRefactoring(CodeActionParams params, IMethod method, boolean isDelegate, String methodName, String modifier, String returnType, List<MethodParameter> parameters, List<MethodException> exceptions) {
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (cu == null) {
            return null;
        }
        IType primaryType = cu.findPrimaryType();
        if (primaryType == null) {
            return null;
        }
        try {
            ChangeSignatureProcessor processor = new ChangeSignatureProcessor(method);
            processor.setNewMethodName(methodName);
            processor.setVisibility(JdtFlags.getVisibilityCode((String)modifier));
            processor.setNewReturnTypeName(returnType);
            processor.setDelegateUpdating(isDelegate);
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            if (status.hasFatalError() && status.hasFatalError()) {
                ChangeSignatureHandler.logFatalError(status);
                return null;
            }
            List parameterInfos = processor.getParameterInfos();
            ArrayList<ParameterInfo> newParameterInfos = new ArrayList<ParameterInfo>();
            for (MethodParameter param : parameters) {
                if (param.originalIndex != -1 && param.originalIndex < parameterInfos.size()) {
                    ParameterInfo info = (ParameterInfo)parameterInfos.get(param.originalIndex);
                    info.setNewTypeName(param.type);
                    info.setNewName(param.name);
                    newParameterInfos.add(info);
                    continue;
                }
                newParameterInfos.add(ParameterInfo.createInfoForAddedParameter((String)param.type, (String)param.name, (String)param.defaultValue));
            }
            parameterInfos.removeIf(p -> newParameterInfos.contains(p));
            parameterInfos.forEach(p -> p.markAsDeleted());
            parameterInfos.addAll(newParameterInfos);
            List exceptionInfos = processor.getExceptionInfos();
            ArrayList<ExceptionInfo> newExceptionInfos = new ArrayList<ExceptionInfo>();
            int index = 0;
            for (MethodException exception : exceptions) {
                if (exception.typeHandleIdentifier != null && (index >= exceptionInfos.size() || ((ExceptionInfo)exceptionInfos.get(index)).getFullyQualifiedName().equals(exception.type))) {
                    IJavaElement element = JavaCore.create((String)exception.typeHandleIdentifier);
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IType) {
                        void type;
                        IType cfr_ignored_0 = (IType)iJavaElement;
                        IType cfr_ignored_1 = (IType)iJavaElement;
                        newExceptionInfos.add(ExceptionInfo.createInfoForAddedException((IType)type));
                    }
                } else {
                    IType type = null;
                    if (exception.type.equals("Exception")) {
                        type = cu.getJavaProject().findType("java.lang.Exception");
                    }
                    if (type == null) {
                        type = cu.getJavaProject().findType(exception.type);
                    }
                    if (type == null) {
                        IImportDeclaration[] iImportDeclarationArray = cu.getImports();
                        int n = iImportDeclarationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String typeName;
                            IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
                            String importName = importDeclaration.getElementName();
                            int dotIndex = importName.lastIndexOf(".");
                            if (dotIndex != -1 && dotIndex < importName.length() - 1 && (typeName = importName.substring(dotIndex + 1)).equals(exception.type)) {
                                type = cu.getJavaProject().findType(importName);
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (type == null) {
                        SearchEngine engine = new SearchEngine();
                        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{cu.getJavaProject()}, (boolean)true);
                        int qualIndex = exception.type.lastIndexOf(46);
                        if (qualIndex == -1) {
                            final ArrayList foundTypes = new ArrayList();
                            engine.searchAllTypeNames(null, 64, exception.type.toCharArray(), 64, 0, scope, new TypeNameMatchRequestor(){

                                public void acceptTypeNameMatch(TypeNameMatch match) {
                                    IType type = match.getType();
                                    try {
                                        if (type.exists() && JdtFlags.isPublic((IMember)type)) {
                                            foundTypes.add(type);
                                        }
                                    }
                                    catch (JavaModelException e) {
                                        JavaLanguageServerPlugin.log((CoreException)((Object)e));
                                    }
                                }
                            }, 3, (IProgressMonitor)new NullProgressMonitor());
                            if (foundTypes.size() != 1) {
                                JavaLanguageServerPlugin.getProjectsManager().getConnection().showMessage(new MessageParams(MessageType.Error, "Ambigious exception types are found for " + exception.type + ", please use fully qualified name instead."));
                                return null;
                            }
                            type = (IType)foundTypes.get(0);
                        }
                    }
                    if (type != null) {
                        newExceptionInfos.add(ExceptionInfo.createInfoForAddedException((IType)type));
                    }
                }
                ++index;
            }
            exceptionInfos.stream().forEach(oldException -> {
                if (newExceptionInfos.stream().filter(newException -> newException.getFullyQualifiedName().equals(oldException.getFullyQualifiedName())).collect(Collectors.toList()).isEmpty()) {
                    oldException.markAsDeleted();
                }
            });
            newExceptionInfos.stream().forEach(newException -> {
                if (exceptionInfos.stream().filter(oldException -> oldException.getFullyQualifiedName().equals(newException.getFullyQualifiedName())).collect(Collectors.toList()).isEmpty()) {
                    exceptionInfos.add(newException);
                }
            });
            ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            status = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
            if (status.hasFatalError()) {
                ChangeSignatureHandler.logFatalError(status);
                return null;
            }
            return refactoring;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e);
            return null;
        }
    }

    private static void logFatalError(RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        if (message == null) {
            message = status.getMessageMatchingSeverity(3);
        }
        JavaLanguageServerPlugin.getProjectsManager().getConnection().showMessage(new MessageParams(MessageType.Error, message));
        JavaLanguageServerPlugin.logError(status.toString());
    }

    public static class MethodException {
        public String type;
        public String typeHandleIdentifier;

        public MethodException(String type, String typeHandleIdentifier) {
            this.type = type;
            this.typeHandleIdentifier = typeHandleIdentifier;
        }
    }

    public static class MethodParameter {
        public String type;
        public String name;
        public String defaultValue;
        public int originalIndex;

        public MethodParameter(String type, String name, String defaultValue, int originalIndex) {
            this.type = type;
            this.name = name;
            this.defaultValue = defaultValue;
            this.originalIndex = originalIndex;
        }
    }
}

