/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.ls.core.internal.DecompilerResult;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class DocumentSymbolHandler {
    private static Range DEFAULT_RANGE = new Range(new Position(0, 0), new Position(0, 0));
    private PreferenceManager preferenceManager;
    private static IScanner fScanner;

    public DocumentSymbolHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<Either<SymbolInformation, DocumentSymbol>> documentSymbol(DocumentSymbolParams params, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (unit == null || !unit.exists()) {
            return Collections.emptyList();
        }
        if (this.preferenceManager.getClientPreferences().isHierarchicalDocumentSymbolSupported()) {
            List<DocumentSymbol> symbols = this.getHierarchicalOutline(unit, monitor);
            return symbols.stream().map(Either::forRight).collect(Collectors.toList());
        }
        SymbolInformation[] elements = this.getOutline(unit, monitor);
        return Arrays.asList(elements).stream().map(Either::forLeft).collect(Collectors.toList());
    }

    private SymbolInformation[] getOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            IJavaElement[] elements = unit.getChildren();
            ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>(elements.length);
            this.collectChildren(unit, elements, symbols, monitor);
            return symbols.toArray(new SymbolInformation[symbols.size()]);
        }
        catch (JavaModelException e) {
            if (!unit.exists()) {
                JavaLanguageServerPlugin.logError("Problem getting outline for " + unit.getElementName() + ": File not found.");
            } else {
                JavaLanguageServerPlugin.logException("Problem getting outline for " + unit.getElementName(), e);
            }
            return new SymbolInformation[0];
        }
    }

    /*
     * WARNING - void declaration
     */
    private void collectChildren(ITypeRoot unit, IJavaElement[] elements, ArrayList<SymbolInformation> symbols, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Location location;
                IJavaElement element;
                block13: {
                    void method;
                    int type;
                    element = iJavaElementArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IParent) {
                        void parent;
                        IParent cfr_ignored_0 = (IParent)iJavaElement;
                        IParent cfr_ignored_1 = (IParent)iJavaElement;
                        this.collectChildren(unit, this.filter(parent.getChildren()), symbols, monitor);
                    }
                    if ((type = element.getElementType()) != 7 && type != 8 && type != 9) break block12;
                    IJavaElement iJavaElement2 = element;
                    if (!(iJavaElement2 instanceof SourceMethod)) break block13;
                    SourceMethod cfr_ignored_2 = (SourceMethod)iJavaElement2;
                    SourceMethod cfr_ignored_3 = (SourceMethod)iJavaElement2;
                    if (JDTUtils.isGenerated((IMember)method)) break block12;
                }
                if ((location = JDTUtils.toLocation(element)) != null) {
                    SymbolInformation si = new SymbolInformation();
                    String name = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)0x200009L);
                    si.setName(name == null ? element.getElementName() : name);
                    si.setKind(DocumentSymbolHandler.mapKind(element));
                    if (JDTUtils.isDeprecated(element)) {
                        if (this.preferenceManager.getClientPreferences().isSymbolTagSupported()) {
                            si.setTags(List.of(SymbolTag.Deprecated));
                        } else {
                            si.setDeprecated(Boolean.valueOf(true));
                        }
                    }
                    if (element.getParent() != null) {
                        si.setContainerName(element.getParent().getElementName());
                    }
                    location.setUri(ResourceUtils.toClientUri(location.getUri()));
                    si.setLocation(location);
                    if (!symbols.contains(si)) {
                        symbols.add(si);
                    }
                }
            }
            ++n2;
        }
    }

    private List<DocumentSymbol> getHierarchicalOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            if (unit instanceof IClassFile && unit.getSourceRange() == null) {
                return this.getHierarchicalOutlineFromDecompiledSource(unit, monitor);
            }
            IJavaElement[] children = unit.getChildren();
            Stream<IJavaElement> childrenStream = Stream.of(this.filter(children));
            if (unit instanceof IClassFile) {
                childrenStream = Stream.concat(Stream.of(unit.getParent()), childrenStream);
                ISourceRange sourceRange = unit.getSourceRange();
                if (sourceRange != null) {
                    int shift = sourceRange.getOffset();
                    IScanner scanner = DocumentSymbolHandler.getScanner();
                    scanner.setSource(unit.getSource().toCharArray());
                    scanner.resetTo(shift, shift + sourceRange.getLength());
                }
            }
            return childrenStream.map(child -> this.toDocumentSymbol((IJavaElement)child, unit, monitor)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (OperationCanceledException e) {
            JavaLanguageServerPlugin.logInfo("User abort while collecting the document symbols.");
        }
        catch (JavaModelException e) {
            if (!unit.exists()) {
                JavaLanguageServerPlugin.logError("Problem getting outline for " + unit.getElementName() + ": File not found.");
            }
            JavaLanguageServerPlugin.logException("Problem getting outline for " + unit.getElementName(), e);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private DocumentSymbol toDocumentSymbol(IJavaElement unit, ITypeRoot root, IProgressMonitor monitor) {
        int type = unit.getElementType();
        if (type != 7 && type != 8 && type != 9 && type != 11 && type != 5 && type != 4) {
            return null;
        }
        IJavaElement iJavaElement = unit;
        if (iJavaElement instanceof SourceMethod) {
            void method;
            SourceMethod sourceMethod = (SourceMethod)iJavaElement;
            SourceMethod cfr_ignored_0 = (SourceMethod)iJavaElement;
            if (JDTUtils.isGenerated((IMember)method)) {
                return null;
            }
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("User abort");
        }
        DocumentSymbol symbol = new DocumentSymbol();
        try {
            IScanner scanner;
            String name = this.getName(unit);
            symbol.setName(name);
            if (type == 4) {
                scanner = DocumentSymbolHandler.getScanner();
                int token = 0;
                int packageStart = -1;
                int packageEnd = -1;
                while (token != 158) {
                    switch (token) {
                        case 214: {
                            packageStart = scanner.getCurrentTokenStartPosition();
                            packageEnd = scanner.getCurrentTokenEndPosition();
                        }
                    }
                    token = this.getNextToken(scanner);
                }
                Range packageRange = JDTUtils.toRange((IOpenable)root, packageStart, packageEnd);
                symbol.setRange(packageRange);
                symbol.setSelectionRange(packageRange);
            } else {
                symbol.setRange(this.getRange(unit));
                symbol.setSelectionRange(this.getSelectionRange(unit));
            }
            symbol.setKind(DocumentSymbolHandler.mapKind(unit));
            if (JDTUtils.isDeprecated(unit)) {
                if (this.preferenceManager.getClientPreferences().isSymbolTagSupported()) {
                    symbol.setTags(List.of(SymbolTag.Deprecated));
                } else {
                    symbol.setDeprecated(Boolean.valueOf(true));
                }
            }
            symbol.setDetail(this.getDetail(unit, name));
            IJavaElement iJavaElement2 = unit;
            if (iJavaElement2 instanceof IParent) {
                void parent;
                scanner = (IParent)iJavaElement2;
                IParent cfr_ignored_1 = (IParent)iJavaElement2;
                IJavaElement[] children = this.filter(parent.getChildren());
                symbol.setChildren(Stream.of(children).map(child -> this.toDocumentSymbol((IJavaElement)child, null, monitor)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        catch (JavaModelException e) {
            Exceptions.sneakyThrow((Throwable)e);
        }
        return symbol;
    }

    private String getName(IJavaElement element) {
        String name = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)0x200009L);
        return name == null ? element.getElementName() : name;
    }

    private Range getRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element, JDTUtils.LocationType.FULL_RANGE);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    private Range getSelectionRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    private String getDetail(IJavaElement element, String name) {
        String nameWithDetails = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)1099513724969L);
        if (nameWithDetails != null && nameWithDetails.startsWith(name)) {
            return nameWithDetails.substring(name.length());
        }
        return "";
    }

    private IJavaElement[] filter(IJavaElement[] elements) {
        return (IJavaElement[])Stream.of(elements).filter(e -> !this.isInitializer((IJavaElement)e) && !this.isSyntheticElement((IJavaElement)e)).toArray(IJavaElement[]::new);
    }

    private boolean isInitializer(IJavaElement element) {
        String name;
        return element.getElementType() == 9 && (name = element.getElementName()) != null && name.indexOf(60) >= 0;
    }

    private boolean isSyntheticElement(IJavaElement element) {
        if (!(element instanceof IMember)) {
            return false;
        }
        IMember member = (IMember)element;
        if (!member.isBinary()) {
            return false;
        }
        try {
            return Flags.isSynthetic((int)member.getFlags());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SymbolKind mapKind(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                try {
                    IType type = (IType)element;
                    if (type.isInterface()) {
                        return SymbolKind.Interface;
                    }
                    if (type.isEnum()) {
                        return SymbolKind.Enum;
                    }
                }
                catch (JavaModelException type) {
                    // empty catch block
                }
                return SymbolKind.Class;
            }
            case 16: {
                return SymbolKind.Property;
            }
            case 5: 
            case 6: {
                return SymbolKind.File;
            }
            case 8: {
                IField field = (IField)element;
                try {
                    if (field.isEnumConstant()) {
                        return SymbolKind.EnumMember;
                    }
                    int flags = field.getFlags();
                    if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                        return SymbolKind.Constant;
                    }
                }
                catch (JavaModelException flags) {
                    // empty catch block
                }
                return SymbolKind.Field;
            }
            case 12: 
            case 13: 
            case 17: {
                return SymbolKind.Module;
            }
            case 10: {
                return SymbolKind.Constructor;
            }
            case 14: {
                return SymbolKind.Variable;
            }
            case 15: {
                return SymbolKind.TypeParameter;
            }
            case 9: {
                try {
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IMethod) {
                        void method;
                        IMethod flags = (IMethod)iJavaElement;
                        IMethod cfr_ignored_0 = (IMethod)iJavaElement;
                        if (method.isConstructor()) {
                            return SymbolKind.Constructor;
                        }
                    }
                    return SymbolKind.Method;
                }
                catch (JavaModelException e) {
                    return SymbolKind.Method;
                }
            }
            case 4: 
            case 11: {
                return SymbolKind.Package;
            }
        }
        return SymbolKind.String;
    }

    private static IScanner getScanner() {
        if (fScanner == null) {
            fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)true);
        }
        return fScanner;
    }

    private int getNextToken(IScanner scanner) {
        int token = 0;
        while (token == 0) {
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        return token;
    }

    private List<DocumentSymbol> getHierarchicalOutlineFromDecompiledSource(ITypeRoot unit, IProgressMonitor monitor) {
        DecompilerResult decompileResult;
        ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
        try {
            decompileResult = contentProvider.getSourceResult((IClassFile)unit, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return Collections.emptyList();
        }
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyList();
        }
        String contents = decompileResult.getContent();
        if (contents == null || contents.isBlank()) {
            return Collections.emptyList();
        }
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setResolveBindings(false);
        parser.setKind(8);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(false);
        parser.setIgnoreMethodBodies(true);
        parser.setEnvironment(new String[0], new String[0], null, true);
        Hashtable javaOptions = JavaCore.getOptions();
        javaOptions.put("org.eclipse.jdt.core.compiler.source", JavaCore.latestSupportedJavaVersion());
        javaOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", JavaCore.latestSupportedJavaVersion());
        javaOptions.put("org.eclipse.jdt.core.compiler.compliance", JavaCore.latestSupportedJavaVersion());
        javaOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        parser.setCompilerOptions((Map)javaOptions);
        parser.setUnitName(unit.getElementName());
        parser.setSource(contents.toCharArray());
        CompilationUnit astUnit = (CompilationUnit)parser.createAST(monitor);
        DocumentSymbolVisitor visitor = new DocumentSymbolVisitor(astUnit);
        astUnit.accept((ASTVisitor)visitor);
        return visitor.getSymbols();
    }

    private static class DocumentSymbolVisitor
    extends ASTVisitor {
        private CompilationUnit astUnit = null;
        private List<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        private Map<ASTNode, DocumentSymbol> typeMappings = new HashMap<ASTNode, DocumentSymbol>();

        public DocumentSymbolVisitor(CompilationUnit astUnit) {
            this.astUnit = astUnit;
        }

        public List<DocumentSymbol> getSymbols() {
            return this.symbols;
        }

        public boolean visit(PackageDeclaration node) {
            DocumentSymbol symbol = this.getDocumentSymbol(node.getName().getFullyQualifiedName(), (ASTNode)node, (ASTNode)node.getName());
            this.symbols.add(symbol);
            return super.visit(node);
        }

        public boolean visit(TypeDeclaration node) {
            this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            return super.visit(node);
        }

        public boolean visit(EnumDeclaration node) {
            this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            return super.visit(node);
        }

        /*
         * WARNING - void declaration
         */
        public boolean visit(RecordDeclaration node) {
            DocumentSymbol typeSymbol = this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            typeSymbol.setChildren(new ArrayList());
            List recordComponents = node.recordComponents();
            for (Object recordComponent : recordComponents) {
                void svd;
                Object e = recordComponent;
                if (!(e instanceof SingleVariableDeclaration)) continue;
                SingleVariableDeclaration cfr_ignored_0 = (SingleVariableDeclaration)e;
                SingleVariableDeclaration cfr_ignored_1 = (SingleVariableDeclaration)e;
                DocumentSymbol component = this.getDocumentSymbol(svd.getName().toString(), (ASTNode)svd, (ASTNode)svd.getName());
                component.setKind(SymbolKind.Field);
                typeSymbol.getChildren().add(component);
            }
            return super.visit(node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            return super.visit(node);
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            String memberName = node.getName().getIdentifier() + "()";
            String typeName = node.getType().toString();
            DocumentSymbol symbol = this.getDocumentSymbol(memberName, (ASTNode)node, (ASTNode)node.getName());
            symbol.setDetail(" : " + typeName);
            this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            return super.visit(node);
        }

        public boolean visit(EnumConstantDeclaration node) {
            DocumentSymbol symbol = this.getDocumentSymbol(node.getName().toString(), (ASTNode)node, (ASTNode)node.getName());
            this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            return super.visit(node);
        }

        /*
         * WARNING - void declaration
         */
        public boolean visit(FieldDeclaration node) {
            List fragments = node.fragments();
            for (Object fragment : fragments) {
                void df;
                Object e = fragment;
                if (!(e instanceof VariableDeclarationFragment)) continue;
                VariableDeclarationFragment cfr_ignored_0 = (VariableDeclarationFragment)e;
                VariableDeclarationFragment cfr_ignored_1 = (VariableDeclarationFragment)e;
                DocumentSymbol symbol = this.getDocumentSymbol(df.getName().toString(), (ASTNode)node, (ASTNode)df.getName());
                this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            }
            return super.visit(node);
        }

        /*
         * WARNING - void declaration
         */
        public boolean visit(MethodDeclaration node) {
            StringBuilder name = new StringBuilder(node.getName().getIdentifier());
            name.append("(");
            List parameters = node.parameters();
            if (parameters != null) {
                ArrayList<Object> params = new ArrayList<Object>();
                for (Object parameter : parameters) {
                    Object e = parameter;
                    if (e instanceof SingleVariableDeclaration) {
                        void vd;
                        SingleVariableDeclaration cfr_ignored_0 = (SingleVariableDeclaration)e;
                        SingleVariableDeclaration cfr_ignored_1 = (SingleVariableDeclaration)e;
                        String typeName = vd.getType().toString() + (vd.isVarargs() ? "..." : "");
                        params.add(typeName);
                        continue;
                    }
                    params.add("Object");
                }
                name.append(String.join((CharSequence)", ", params));
            }
            name.append(")");
            String returnType = null;
            returnType = node.getReturnType2() != null ? node.getReturnType2().toString() : (node.isConstructor() ? null : "void");
            DocumentSymbol symbol = this.getDocumentSymbol(name.toString(), (ASTNode)node, (ASTNode)node.getName());
            symbol.setDetail((String)(returnType == null ? "" : " : " + returnType));
            this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            return super.visit(node);
        }

        private DocumentSymbol addAsTypeDocumentSymbol(AbstractTypeDeclaration node) {
            DocumentSymbol symbol = this.getDocumentSymbol(node.getName().getIdentifier(), (ASTNode)node, (ASTNode)node.getName());
            this.symbols.add(symbol);
            this.typeMappings.put((ASTNode)node, symbol);
            return symbol;
        }

        private void addAsChildDocumentSymbol(ASTNode currentNode, DocumentSymbol symbol) {
            ASTNode parent = currentNode.getParent();
            if (parent == null) {
                return;
            }
            DocumentSymbol parentSymbol = this.typeMappings.get(parent);
            if (parentSymbol == null) {
                return;
            }
            if (parentSymbol.getChildren() == null) {
                parentSymbol.setChildren(new ArrayList());
            }
            parentSymbol.getChildren().add(symbol);
        }

        /*
         * WARNING - void declaration
         */
        private DocumentSymbol getDocumentSymbol(String name, ASTNode node, ASTNode nameNode) {
            DocumentSymbol symbol = new DocumentSymbol();
            symbol.setName(name);
            symbol.setKind(this.getKind(node));
            symbol.setRange(this.getRange(node));
            symbol.setSelectionRange(this.getRange(nameNode));
            symbol.setDetail("");
            ASTNode aSTNode = node;
            if (aSTNode instanceof BodyDeclaration) {
                void bd;
                BodyDeclaration bodyDeclaration = (BodyDeclaration)aSTNode;
                BodyDeclaration cfr_ignored_0 = (BodyDeclaration)aSTNode;
                if (this.containsModifier(bd.modifiers(), "@Deprecated")) {
                    symbol.setTags(List.of(SymbolTag.Deprecated));
                }
            }
            return symbol;
        }

        private Range getRange(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            Position startPosition = new Position(this.astUnit.getLineNumber(start) - 1, this.astUnit.getColumnNumber(start));
            Position endPosition = new Position(this.astUnit.getLineNumber(end) - 1, this.astUnit.getColumnNumber(end));
            return new Range(startPosition, endPosition);
        }

        private SymbolKind getKind(ASTNode node) {
            switch (node.getNodeType()) {
                case 35: {
                    return SymbolKind.Package;
                }
                case 55: {
                    return ((TypeDeclaration)node).isInterface() ? SymbolKind.Interface : SymbolKind.Class;
                }
                case 71: {
                    return SymbolKind.Enum;
                }
                case 103: {
                    return SymbolKind.Class;
                }
                case 81: {
                    return SymbolKind.Property;
                }
                case 23: {
                    List modifiers = ((FieldDeclaration)node).modifiers();
                    if (this.containsModifier(modifiers, "static") && this.containsModifier(modifiers, "final")) {
                        return SymbolKind.Constant;
                    }
                    return SymbolKind.Field;
                }
                case 72: {
                    return SymbolKind.EnumMember;
                }
                case 31: {
                    return ((MethodDeclaration)node).isConstructor() ? SymbolKind.Constructor : SymbolKind.Method;
                }
                case 82: {
                    return SymbolKind.Method;
                }
            }
            return SymbolKind.String;
        }

        private boolean containsModifier(List<?> modifiers, String target) {
            if (modifiers == null || modifiers.isEmpty()) {
                return false;
            }
            for (Object modifier : modifiers) {
                if (!Objects.equals(modifier.toString(), target)) continue;
                return true;
            }
            return false;
        }
    }
}

