/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentSymbolHandler;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;

public class TypeHierarchyHandler {
    public List<TypeHierarchyItem> prepareTypeHierarchy(TypeHierarchyPrepareParams params, IProgressMonitor monitor) {
        if (params == null) {
            return Collections.emptyList();
        }
        TextDocumentIdentifier textDocument = params.getTextDocument();
        if (textDocument == null) {
            return Collections.emptyList();
        }
        Position position = params.getPosition();
        String uri = textDocument.getUri();
        return this.getTypeHierarchyItems(uri, position, monitor);
    }

    private List<TypeHierarchyItem> getTypeHierarchyItems(String uri, Position position, IProgressMonitor monitor) {
        if (uri == null || position == null) {
            return Collections.emptyList();
        }
        try {
            TypeHierarchyItem item;
            IMember member = this.getMember(uri, position, monitor);
            IMethod targetMethod = null;
            if (member instanceof IMethod) {
                targetMethod = (IMethod)member;
            }
            TypeHierarchyItem typeHierarchyItem = item = targetMethod == null ? TypeHierarchyHandler.toTypeHierarchyItem(member) : TypeHierarchyHandler.toTypeHierarchyItem(member, false, targetMethod);
            if (item == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(item);
        }
        catch (JavaModelException e) {
            return Collections.emptyList();
        }
    }

    public List<TypeHierarchyItem> getSupertypeItems(TypeHierarchySupertypesParams params, IProgressMonitor monitor) {
        return this.getTypeHierarchyItems(params.getItem(), TypeHierarchyDirection.Supertype, monitor);
    }

    public List<TypeHierarchyItem> getSubtypeItems(TypeHierarchySubtypesParams params, IProgressMonitor monitor) {
        return this.getTypeHierarchyItems(params.getItem(), TypeHierarchyDirection.Subtype, monitor);
    }

    /*
     * WARNING - void declaration
     */
    private List<TypeHierarchyItem> getTypeHierarchyItems(TypeHierarchyItem item, TypeHierarchyDirection direction, IProgressMonitor monitor) {
        TypeHierarchyItemData data = TypeHierarchyItemData.getTypeHierarchyItemData(item.getData());
        if (data == null) {
            return Collections.emptyList();
        }
        IJavaElement element = JavaCore.create((String)data.handleIdentifier);
        IMember member = null;
        IMethod targetMethod = null;
        if (data.methodIdentifier != null) {
            targetMethod = (IMethod)JavaCore.create((String)data.methodIdentifier);
        }
        if (element instanceof IType || element instanceof IMethod) {
            member = (IMember)element;
        } else {
            IJavaElement iJavaElement = element;
            if (iJavaElement instanceof IOrdinaryClassFile) {
                void classFile;
                IOrdinaryClassFile iOrdinaryClassFile = (IOrdinaryClassFile)iJavaElement;
                IOrdinaryClassFile cfr_ignored_0 = (IOrdinaryClassFile)iJavaElement;
                member = classFile.getType();
            } else {
                return Collections.emptyList();
            }
        }
        return this.resolveTypeHierarchyItems(member, targetMethod, direction, monitor);
    }

    private List<TypeHierarchyItem> resolveTypeHierarchyItems(IMember member, IMethod targetMethod, TypeHierarchyDirection direction, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        IType type = null;
        type = member instanceof IType ? (IType)member : member.getDeclaringType();
        try {
            ITypeHierarchy typeHierarchy = null;
            ArrayList<TypeHierarchyItem> items = new ArrayList<TypeHierarchyItem>();
            IType[] hierarchyTypes = null;
            if (direction == TypeHierarchyDirection.Supertype) {
                typeHierarchy = type.newSupertypeHierarchy((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, monitor);
                hierarchyTypes = typeHierarchy.getSupertypes(type);
            } else {
                ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, true);
                typeHierarchy = type.newTypeHierarchy(workingCopies, monitor);
                hierarchyTypes = typeHierarchy.getSubtypes(type);
            }
            IType[] iTypeArray = hierarchyTypes;
            int n = hierarchyTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType hierarchyType = iTypeArray[n2];
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                TypeHierarchyItem item = null;
                if (targetMethod != null) {
                    boolean excludeMember;
                    IMethod[] matches = hierarchyType.findMethods(targetMethod);
                    boolean bl = excludeMember = matches == null || matches.length == 0;
                    if (!excludeMember || !"java.lang.Object".equals(hierarchyType.getFullyQualifiedName())) {
                        item = TypeHierarchyHandler.toTypeHierarchyItem((IMember)(excludeMember ? hierarchyType : matches[0]), excludeMember, targetMethod);
                    }
                } else {
                    item = TypeHierarchyHandler.toTypeHierarchyItem((IMember)hierarchyType);
                }
                if (item != null) {
                    items.add(item);
                }
                ++n2;
            }
            return items;
        }
        catch (JavaModelException e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private IMember getMember(String uri, Position position, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement typeElement = TypeHierarchyHandler.findTypeElement(JDTUtils.resolveTypeRoot(uri), position, monitor);
        IJavaElement iJavaElement = typeElement;
        if (iJavaElement instanceof IType) {
            void type;
            IType iType = (IType)iJavaElement;
            IType cfr_ignored_0 = (IType)iJavaElement;
            return type;
        }
        IJavaElement iJavaElement2 = typeElement;
        if (iJavaElement2 instanceof IMethod) {
            void method;
            IMethod iMethod = (IMethod)iJavaElement2;
            IMethod cfr_ignored_1 = (IMethod)iJavaElement2;
            return method;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static IJavaElement findTypeElement(ITypeRoot unit, Position position, IProgressMonitor monitor) throws JavaModelException {
        if (unit == null) {
            return null;
        }
        IJavaElement element = JDTUtils.findElementAtSelection(unit, position.getLine(), position.getCharacter(), JavaLanguageServerPlugin.getPreferencesManager(), monitor);
        if (element == null) {
            ITypeRoot iTypeRoot = unit;
            if (iTypeRoot instanceof IOrdinaryClassFile) {
                void classFile;
                IOrdinaryClassFile iOrdinaryClassFile = (IOrdinaryClassFile)iTypeRoot;
                IOrdinaryClassFile cfr_ignored_0 = (IOrdinaryClassFile)iTypeRoot;
                element = classFile.getType();
            } else if (unit instanceof ICompilationUnit) {
                element = unit.findPrimaryType();
            }
        }
        return element;
    }

    private static TypeHierarchyItem toTypeHierarchyItem(IMember member) throws JavaModelException {
        return TypeHierarchyHandler.toTypeHierarchyItem(member, false, null);
    }

    private static TypeHierarchyItem toTypeHierarchyItem(IMember member, boolean excludeMember, IMethod targetMethod) throws JavaModelException {
        if (member == null) {
            return null;
        }
        Location location = TypeHierarchyHandler.getLocation(member, JDTUtils.LocationType.FULL_RANGE);
        Location selectLocation = TypeHierarchyHandler.getLocation(member, JDTUtils.LocationType.NAME_RANGE);
        if (location == null || selectLocation == null) {
            return null;
        }
        Range range = location.getRange();
        String uri = location.getUri();
        Range selectionRange = selectLocation.getRange();
        IType type = null;
        type = member instanceof IType ? (IType)member : member.getDeclaringType();
        String name = null;
        String detail = null;
        String fullyQualifiedName = type.getFullyQualifiedName();
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index >= 1 && index < fullyQualifiedName.length() - 1 && !type.isAnonymous()) {
            name = fullyQualifiedName.substring(index + 1);
            detail = fullyQualifiedName.substring(0, index);
        } else {
            name = JDTUtils.getName((IJavaElement)type);
            IPackageFragment packageFragment = type.getPackageFragment();
            if (packageFragment != null) {
                detail = packageFragment.getElementName();
            }
        }
        SymbolKind kind = excludeMember ? SymbolKind.Null : DocumentSymbolHandler.mapKind((IJavaElement)type);
        ArrayList<SymbolTag> tags = new ArrayList<SymbolTag>();
        if (JDTUtils.isDeprecated((IJavaElement)member)) {
            tags.add(SymbolTag.Deprecated);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("element", member.getHandleIdentifier());
        if (targetMethod != null) {
            data.put("method", targetMethod.getHandleIdentifier());
            data.put("method_name", targetMethod.getElementName());
        } else if (member instanceof IMethod) {
            data.put("method", member.getHandleIdentifier());
            data.put("method_name", member.getElementName());
        }
        TypeHierarchyItem item = new TypeHierarchyItem(name, kind, uri, range, selectionRange, detail);
        item.setTags(tags);
        item.setData(data);
        return item;
    }

    private static Location getLocation(IMember member, JDTUtils.LocationType locationType) throws JavaModelException {
        Location location = locationType.toLocation((IJavaElement)member);
        if (location == null && member.getClassFile() != null) {
            location = JDTUtils.toLocation(member.getClassFile());
        }
        return location;
    }

    public static enum TypeHierarchyDirection {
        Subtype,
        Supertype;

    }

    private static class TypeHierarchyItemData {
        private String handleIdentifier;
        private String methodIdentifier;
        private String methodName;

        public TypeHierarchyItemData(String handleIdentifier, String methodIdentifier, String methodName) {
            this.handleIdentifier = handleIdentifier;
            this.methodIdentifier = methodIdentifier;
            this.methodName = methodName;
        }

        private static TypeHierarchyItemData getTypeHierarchyItemData(Object data) {
            if (data == null) {
                return null;
            }
            Map map = JSONUtility.toModel(data, Map.class);
            String handleIdentifier = (String)map.get("element");
            String methodIdentifier = (String)map.get("method");
            String methodName = (String)map.get("method_name");
            return new TypeHierarchyItemData(handleIdentifier, methodIdentifier, methodName);
        }
    }
}

