/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class CodeActionUtility {
    public static ASTNode findASTNode(List<ASTNode> coveredNodes, ASTNode coveringNode, Class<?> nodeType) {
        if (!ASTNode.class.isAssignableFrom(nodeType)) {
            return null;
        }
        if (coveredNodes.size() > 0) {
            for (ASTNode node : coveredNodes) {
                if (nodeType.isInstance(node)) {
                    return node;
                }
                ASTNode inferredNode = CodeActionUtility.inferASTNode(node, nodeType);
                if (inferredNode == null) continue;
                return inferredNode;
            }
        } else if (coveringNode != null) {
            return CodeActionUtility.inferASTNode(coveringNode, nodeType);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static ASTNode inferASTNode(ASTNode node, Class<?> nodeType) {
        if (node != null && ASTNode.class.isAssignableFrom(nodeType)) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParent();
lbl4:
            // 2 sources

            ** while (node != null && !nodeType.isInstance((Object)node) && !(node instanceof Statement) && !(node instanceof BodyDeclaration))
        }
lbl5:
        // 1 sources

        return nodeType.isInstance(node) != false ? node : null;
    }

    public static List<String> getFieldNames(List<ASTNode> coveredNodes, ASTNode coveringNode) {
        if (coveredNodes.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (ASTNode node : coveredNodes) {
                names.addAll(CodeActionUtility.getFieldNamesFromASTNode(node));
            }
            return names;
        }
        if (coveringNode != null) {
            return CodeActionUtility.getFieldNamesFromASTNode(coveringNode);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getFieldNamesFromASTNode(ASTNode node) {
        ASTNode fieldDecl;
        if (node instanceof SimpleName) {
            ASTNode parent = node.getParent();
            if (parent instanceof VariableDeclarationFragment) {
                return CodeActionUtility.getFieldNamesFromASTNode(parent);
            }
        } else {
            ASTNode aSTNode = node;
            if (aSTNode instanceof VariableDeclarationFragment) {
                void varibleDecl;
                VariableDeclarationFragment parent = (VariableDeclarationFragment)aSTNode;
                VariableDeclarationFragment cfr_ignored_0 = (VariableDeclarationFragment)aSTNode;
                SimpleName name = varibleDecl.getName();
                if (name != null) {
                    return Arrays.asList(name.getIdentifier());
                }
            } else {
                ASTNode aSTNode2 = node;
                if (aSTNode2 instanceof FieldDeclaration) {
                    void fieldDecl2;
                    FieldDeclaration name = (FieldDeclaration)aSTNode2;
                    FieldDeclaration cfr_ignored_1 = (FieldDeclaration)aSTNode2;
                    ArrayList<String> names = new ArrayList<String>();
                    List fragments = fieldDecl2.fragments();
                    for (VariableDeclarationFragment fragment : fragments) {
                        names.addAll(CodeActionUtility.getFieldNamesFromASTNode((ASTNode)fragment));
                    }
                    return names;
                }
            }
        }
        if (JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isJavaQuickFixShowAtLine() && (fieldDecl = ASTNodes.getParent((ASTNode)node, FieldDeclaration.class)) != null) {
            return CodeActionUtility.getFieldNamesFromASTNode(fieldDecl);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getVariableNamesFromASTNode(ASTNode node) {
        if (node instanceof VariableDeclaration) {
            SimpleName name = ((VariableDeclaration)node).getName();
            if (name != null) {
                return Arrays.asList(name.getIdentifier());
            }
        } else {
            ASTNode aSTNode = node;
            if (aSTNode instanceof VariableDeclarationStatement) {
                void variableDecl;
                VariableDeclarationStatement name = (VariableDeclarationStatement)aSTNode;
                VariableDeclarationStatement cfr_ignored_0 = (VariableDeclarationStatement)aSTNode;
                ArrayList<String> names = new ArrayList<String>();
                List fragments = variableDecl.fragments();
                for (VariableDeclarationFragment fragment : fragments) {
                    names.addAll(CodeActionUtility.getFieldNamesFromASTNode((ASTNode)fragment));
                }
                return names;
            }
        }
        return Collections.emptyList();
    }

    public static String getTypeName(AbstractTypeDeclaration node) {
        SimpleName name = node.getName();
        if (name != null) {
            return name.getIdentifier();
        }
        return null;
    }

    public static boolean hasMethod(IType type, String methodName, Class ... parameterTypes) {
        if (type == null) {
            return false;
        }
        try {
            return Stream.of(type.getMethods()).anyMatch(method -> {
                if (!method.getElementName().equals(methodName)) {
                    return false;
                }
                if (method.getParameterTypes().length != parameterTypes.length) {
                    return false;
                }
                String[] parameterTypeNames = method.getParameterTypes();
                if (parameterTypes.length != parameterTypeNames.length) {
                    return false;
                }
                int i = 0;
                while (i < parameterTypeNames.length) {
                    if (parameterTypes[i].getName().equals(parameterTypeNames[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            });
        }
        catch (JavaModelException e) {
            return false;
        }
    }
}

