/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.google.gson.JsonSyntaxException;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.plugin.internal.LogUtils;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public final class DebugSettingUtils {
    private static final Logger logger = Logger.getLogger("java-debug");

    public static Object configDebugSettings(List<Object> arguments) {
        if (arguments != null && arguments.size() > 0) {
            arguments.forEach(arg -> {
                if (arg instanceof String) {
                    String jsonStr = (String)arg;
                    try {
                        DebugSettings.getCurrent().updateSettings(jsonStr);
                        DebugSettings.getCurrent().logLevel = LogUtils.configLogLevel(DebugSettings.getCurrent().logLevel);
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        logger.severe(String.format("Parameters for userSettings must be a valid json: %s", String.valueOf(arg)));
                    }
                } else {
                    logger.severe(String.format("Parameters for userSettings must be json string: %s", String.valueOf(arg)));
                }
            });
        } else {
            logger.severe(String.format("Invalid parameters for debugSettings: %s", StringUtils.join((Object[])arguments.toArray(), (char)',')));
        }
        return JsonUtils.toJson((Object)DebugSettings.getCurrent());
    }

    private DebugSettingUtils() {
    }
}

