/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Stack;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class M2EUtils {
    public static void createFolder(IContainer container, boolean derived, IProgressMonitor monitor) throws CoreException {
        block7: {
            if (!(container instanceof IFolder var3_4)) {
                return;
            }
            if (!folder.exists()) {
                IContainer parent = folder.getParent();
                if (parent != null && !parent.exists()) {
                    M2EUtils.createFolder(parent, false, monitor);
                }
                try {
                    if (!folder.exists()) {
                        folder.create(true, true, monitor);
                    }
                }
                catch (CoreException ex) {
                    if (folder.exists()) break block7;
                    throw ex;
                }
            }
        }
        if (folder.isAccessible() && derived && !folder.isDerived()) {
            folder.setDerived(true, monitor);
        }
    }

    public static String getRootCauseMessage(Throwable t) {
        Throwable root = M2EUtils.getRootCause(t);
        if (t == null) {
            return null;
        }
        return root.getMessage();
    }

    public static Throwable getRootCause(Throwable ex) {
        if (ex == null) {
            return null;
        }
        Throwable rootCause = ex;
        Throwable cause = rootCause.getCause();
        while (cause != null && cause != rootCause) {
            rootCause = cause;
            cause = cause.getCause();
        }
        return cause == null ? rootCause : cause;
    }

    public static IFile getPomFile(MavenProject project) {
        if (project == null || project.getFile() == null) {
            return null;
        }
        File file = new File(project.getFile().toURI());
        IPath path = IPath.fromOSString((String)file.getAbsolutePath());
        Stack<Object> stack = new Stack<Object>();
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (ifile != null) {
            stack.push(ifile);
        }
        while (path.segmentCount() > 1) {
            IResource ires = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (ires instanceof IFile var6_6) {
                stack.push(f);
            }
            path = path.removeFirstSegments(1);
        }
        return stack.empty() ? null : (IFile)stack.pop();
    }

    public static Collection<MavenProject> getDefiningProjects(MojoExecutionKey key, Collection<MavenProject> projects) {
        HashSet<MavenProject> sourceProjects = new HashSet<MavenProject>();
        block0: for (MavenProject project : projects) {
            if (M2EUtils.definesPlugin(project, key)) {
                sourceProjects.add(project);
                continue;
            }
            MavenProject parent = project.getParent();
            while (parent != null) {
                if (M2EUtils.definesPlugin(parent, key)) {
                    sourceProjects.add(parent);
                    continue block0;
                }
                parent = parent.getParent();
            }
        }
        return sourceProjects;
    }

    public static boolean definesPlugin(MavenProject project, MojoExecutionKey key) {
        if (project.getOriginalModel().getBuild() == null) {
            return false;
        }
        for (Plugin p : project.getOriginalModel().getBuild().getPlugins()) {
            if (!p.getGroupId().equals(key.groupId()) || !p.getArtifactId().equals(key.artifactId())) continue;
            return true;
        }
        return false;
    }

    public static void copyProperties(Properties to, Properties from) {
        for (String key : from.stringPropertyNames()) {
            String value = from.getProperty(key);
            if (value == null) continue;
            to.put(key, value);
        }
    }
}

