/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.ActionMessageProblemInfo;
import org.eclipse.m2e.core.internal.lifecyclemapping.AnnotationMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.DefaultPluginExecutionMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateExecutionMappingSourceProblem;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateMappingException;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateMappingSourceProblem;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicatePluginExecutionMetadataException;
import org.eclipse.m2e.core.internal.lifecyclemapping.FailedMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.InvalidLifecycleMapping;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingConfigurationException;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.MissingConfiguratorProblemInfo;
import org.eclipse.m2e.core.internal.lifecyclemapping.MissingLifecycleExtensionPoint;
import org.eclipse.m2e.core.internal.lifecyclemapping.MojoExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.NotCoveredMojoExecution;
import org.eclipse.m2e.core.internal.lifecyclemapping.PackagingTypeFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.ProjectConfigurationElementSorter;
import org.eclipse.m2e.core.internal.lifecyclemapping.SimpleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3.LifecycleMappingMetadataSourceXpp3Reader;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3.LifecycleMappingMetadataSourceXpp3Writer;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.internal.project.registry.EclipseWorkspaceArtifactRepository;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractCustomizableLifecycleMapping;
import org.eclipse.m2e.core.project.configurator.AbstractLifecycleMapping;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMappingFactory {
    private static final Logger log = LoggerFactory.getLogger(LifecycleMappingFactory.class);
    public static final String LIFECYCLE_MAPPING_PLUGIN_GROUPID = "org.eclipse.m2e";
    public static final String LIFECYCLE_MAPPING_PLUGIN_ARTIFACTID = "lifecycle-mapping";
    public static final String LIFECYCLE_MAPPING_PLUGIN_VERSION = "1.0.0";
    private static final String LIFECYCLE_MAPPING_PLUGIN_KEY = "org.eclipse.m2e:lifecycle-mapping";
    public static final String LIFECYCLE_MAPPING_METADATA_SOURCE_NAME = "lifecycle-mapping-metadata.xml";
    private static final String LIFECYCLE_MAPPING_METADATA_SOURCE_PATH = "/lifecycle-mapping-metadata.xml";
    private static final String LIFECYCLE_MAPPING_METADATA_EMBEDDED_SOURCE_PATH = "META-INF/m2e/lifecycle-mapping-metadata.xml";
    public static final String EXTENSION_LIFECYCLE_MAPPINGS = "org.eclipse.m2e.core.lifecycleMappings";
    public static final String EXTENSION_PROJECT_CONFIGURATORS = "org.eclipse.m2e.core.projectConfigurators";
    public static final String EXTENSION_LIFECYCLE_MAPPING_METADATA_SOURCE = "org.eclipse.m2e.core.lifecycleMappingMetadataSource";
    private static final String ELEMENT_LIFECYCLE_MAPPING_METADATA = "lifecycleMappingMetadata";
    private static final String ELEMENT_LIFECYCLE_MAPPING = "lifecycleMapping";
    private static final String ELEMENT_SOURCES = "sources";
    private static final String ELEMENT_SOURCE = "source";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ELEMENT_CONFIGURATOR = "configurator";
    private static final String ELEMENT_MESSAGE = "message";
    static final String ELEMENT_RUN_ON_INCREMENTAL = "runOnIncremental";
    static final String ELEMENT_RUN_ON_CONFIGURATION = "runOnConfiguration";
    private static final String ATTR_GROUPID = "groupId";
    private static final String ATTR_ARTIFACTID = "artifactId";
    private static final String ATTR_VERSION = "version";
    private static final String LIFECYCLE_MAPPING_METADATA_CLASSIFIER = "lifecycle-mapping-metadata";
    private static List<LifecycleMappingMetadataSource> bundleMetadataSources = null;
    private static LifecycleMappingMetadataSource workspaceMetadataSource;
    private static LifecycleMappingMetadataSource defaultLifecycleMappingMetadataSource;
    private static boolean useDefaultLifecycleMappingMetadataSource;
    private static final Set<String> INTERESTING_PHASES;

    static {
        useDefaultLifecycleMappingMetadataSource = true;
        INTERESTING_PHASES = Set.of("validate", "initialize", "generate-sources", "process-sources", "generate-resources", "process-resources", "compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes");
    }

    private LifecycleMappingFactory() {
    }

    public static LifecycleMappingResult calculateLifecycleMapping(MavenProject mavenProject, List<MojoExecution> mojoExecutions, String lifecycleMappingId, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        log.debug("Loading lifecycle mapping for {}.", (Object)mavenProject);
        LifecycleMappingResult result = new LifecycleMappingResult();
        try {
            try {
                if (lifecycleMappingId != null) {
                    LifecycleMappingFactory.instantiateLifecycleMapping(result, mavenProject, lifecycleMappingId);
                }
                LifecycleMappingFactory.calculateEffectiveLifecycleMappingMetadata(result, mavenProject, mojoExecutions, monitor);
                if (result.getLifecycleMapping() == null) {
                    lifecycleMappingId = result.getLifecycleMappingId();
                    LifecycleMappingFactory.instantiateLifecycleMapping(result, mavenProject, lifecycleMappingId);
                }
                if (result.getLifecycleMapping() instanceof AbstractCustomizableLifecycleMapping) {
                    LifecycleMappingFactory.instantiateProjectConfigurators(mavenProject, result, result.getMojoExecutionMapping());
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                result.addProblem(new MavenProblemInfo(1, (Throwable)ex));
                log.info("Using {} lifecycle mapping for {}.", (Object)result.getLifecycleMappingId(), (Object)mavenProject);
                log.debug("Loaded lifecycle mapping in {} ms for {}.", (Object)(System.currentTimeMillis() - start), (Object)mavenProject);
            }
        }
        finally {
            log.info("Using {} lifecycle mapping for {}.", (Object)result.getLifecycleMappingId(), (Object)mavenProject);
            log.debug("Loaded lifecycle mapping in {} ms for {}.", (Object)(System.currentTimeMillis() - start), (Object)mavenProject);
        }
        return result;
    }

    private static void calculateEffectiveLifecycleMappingMetadata(LifecycleMappingResult result, MavenProject mavenProject, List<MojoExecution> mojoExecutions, IProgressMonitor monitor) throws CoreException {
        String packagingType = mavenProject.getPackaging();
        if ("pom".equals(packagingType)) {
            log.debug("Using NoopLifecycleMapping lifecycle mapping for {}.", (Object)mavenProject);
            LifecycleMappingMetadata lifecycleMappingMetadata = new LifecycleMappingMetadata();
            lifecycleMappingMetadata.setLifecycleMappingId("NULL");
            result.setLifecycleMappingMetadata(lifecycleMappingMetadata);
            LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>> executionMapping = new LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>>();
            result.setMojoExecutionMapping(executionMapping);
        } else if (result.getLifecycleMapping() != null && !(result.getLifecycleMapping() instanceof AbstractCustomizableLifecycleMapping)) {
            String lifecycleMappingId = result.getLifecycleMapping().getId();
            log.debug("Using non-customizable lifecycle mapping {} for {}.", (Object)lifecycleMappingId, (Object)mavenProject);
            LifecycleMappingMetadata lifecycleMappingMetadata = new LifecycleMappingMetadata();
            lifecycleMappingMetadata.setLifecycleMappingId(lifecycleMappingId);
            result.setLifecycleMappingMetadata(lifecycleMappingMetadata);
            LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>> executionMapping = new LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>>();
            result.setMojoExecutionMapping(executionMapping);
        } else {
            try {
                Map<String, List<MappingMetadataSource>> projectSources = LifecycleMappingFactory.getProjectMetadataSourcesMap(mavenProject, LifecycleMappingFactory.getBundleMetadataSources(), mojoExecutions, true, monitor);
                LifecycleMappingFactory.calculateEffectiveLifecycleMappingMetadata(result, LifecycleMappingFactory.asList(projectSources), mavenProject, mojoExecutions, true, monitor);
            }
            catch (LifecycleMappingConfigurationException e) {
                result.addProblem(new MavenProblemInfo(mavenProject, e));
            }
        }
    }

    public static Map<String, List<MappingMetadataSource>> getProjectMetadataSourcesMap(MavenProject mavenProject, List<LifecycleMappingMetadataSource> bundleMetadataSources, List<MojoExecution> mojoExecutions, boolean includeDefault, IProgressMonitor monitor) throws CoreException, LifecycleMappingConfigurationException {
        LifecycleMappingMetadataSource defaultSource;
        HashMap<String, List<MappingMetadataSource>> metadataSourcesMap = new HashMap<String, List<MappingMetadataSource>>();
        metadataSourcesMap.put("pomMappingMetadataSources", LifecycleMappingFactory.getPomMappingMetadataSources(mavenProject, monitor));
        metadataSourcesMap.put("workspaceMetadataSources", List.of(new SimpleMappingMetadataSource(LifecycleMappingFactory.getWorkspaceMetadata(false))));
        if (bundleMetadataSources != null) {
            metadataSourcesMap.put("bundleMetadataSources", Collections.singletonList(new SimpleMappingMetadataSource(bundleMetadataSources)));
        }
        ArrayList<SimpleMappingMetadataSource> metadataSources = new ArrayList<SimpleMappingMetadataSource>();
        for (LifecycleMappingMetadataSource source : LifecycleMappingFactory.getMavenPluginEmbeddedMetadataSources(mojoExecutions, mavenProject.getPluginArtifactRepositories(), monitor)) {
            metadataSources.add(new SimpleMappingMetadataSource(source));
        }
        metadataSourcesMap.put("mavenPluginEmbeddedMetadataSources", metadataSources);
        if (includeDefault && (defaultSource = LifecycleMappingFactory.getDefaultLifecycleMappingMetadataSource()) != null) {
            metadataSourcesMap.put("defaultLifecycleMappingMetadataSource", Collections.singletonList(new SimpleMappingMetadataSource(defaultSource)));
        }
        return metadataSourcesMap;
    }

    public static void addLifecyclePluginExecution(LifecycleMappingMetadataSource mapping, String groupId, String artifactId, String version, List<String> goals, PluginExecutionAction action) {
        PluginExecutionMetadata execution = LifecycleMappingFactory.getPluginExecutionMetadata(mapping, groupId, artifactId, version, action);
        if (execution == null) {
            execution = new PluginExecutionMetadata();
            execution.setSource(mapping);
            execution.setFilter(new PluginExecutionFilter(groupId, artifactId, version, new HashSet<String>()));
            Xpp3Dom actionDom = new Xpp3Dom("action");
            actionDom.addChild(new Xpp3Dom(action.toString()));
            execution.setActionDom(actionDom);
            mapping.addPluginExecution(execution);
        }
        for (String goal : goals) {
            execution.getFilter().addGoal(goal);
        }
    }

    public static void addLifecycleMappingPackagingFilter(LifecycleMappingMetadataSource mapping, String bsn, String version, String packaging) {
        LifecycleMappingFilter filter = LifecycleMappingFactory.getLifecycleMappingFilter(bsn, version, mapping);
        filter.getPackagingTypes().add(packaging);
    }

    public static void addLifecycleMappingExecutionFilter(LifecycleMappingMetadataSource mapping, String bsn, String bundleVersion, String executionGroupId, String executionArtifactId, String executionVersion, String goal) {
        LifecycleMappingFilter filter = LifecycleMappingFactory.getLifecycleMappingFilter(bsn, bundleVersion, mapping);
        PluginExecutionFilter executionFilter = LifecycleMappingFactory.getPluginExecutionFilter(executionGroupId, executionArtifactId, executionVersion, filter);
        executionFilter.getGoals().add(goal);
    }

    private static PluginExecutionFilter getPluginExecutionFilter(String executionGroupId, String executionArtifactId, String executionVersion, LifecycleMappingFilter filter) {
        PluginExecutionFilter executionFilter2;
        for (PluginExecutionFilter executionFilter2 : filter.getPluginExecutions()) {
            if (!Objects.equals(executionFilter2.getGroupId(), executionGroupId) || !Objects.equals(executionFilter2.getArtifactId(), executionArtifactId)) continue;
            try {
                VersionRange filterRange = VersionRange.createFromVersionSpec((String)executionFilter2.getVersionRange());
                if (!filterRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(executionVersion))) continue;
                return executionFilter2;
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
        executionFilter2 = new PluginExecutionFilter(executionGroupId, executionArtifactId, "[" + executionVersion + ",)", new LinkedHashSet<String>());
        filter.getPluginExecutions().add(executionFilter2);
        return executionFilter2;
    }

    private static LifecycleMappingFilter getLifecycleMappingFilter(String bsn, String version, LifecycleMappingMetadataSource mapping) {
        LifecycleMappingFilter filter2;
        for (LifecycleMappingFilter filter2 : mapping.getLifecycleMappingFilters()) {
            if (!Objects.equals(bsn, filter2.getSymbolicName())) continue;
            try {
                VersionRange filterRange = VersionRange.createFromVersionSpec((String)filter2.getVersionRange());
                if (!filterRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(version))) continue;
                return filter2;
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
        filter2 = new LifecycleMappingFilter();
        filter2.setSymbolicName(bsn);
        filter2.setVersionRange("[" + version + ",)");
        mapping.addLifecycleMappingFilter(filter2);
        return filter2;
    }

    private static PluginExecutionMetadata getPluginExecutionMetadata(LifecycleMappingMetadataSource mapping, String groupId, String artifactId, String version, PluginExecutionAction action) {
        for (PluginExecutionMetadata execution : mapping.getPluginExecutions()) {
            PluginExecutionFilter filter = execution.getFilter();
            if (!Objects.equals(groupId, filter.getGroupId()) || !Objects.equals(artifactId, filter.getArtifactId()) || !Objects.equals(version, filter.getVersionRange()) || action != execution.getAction()) continue;
            return execution;
        }
        return null;
    }

    public static List<MappingMetadataSource> asList(Map<String, List<MappingMetadataSource>> map) {
        return Stream.of("pomMappingMetadataSources", "workspaceMetadataSources", "bundleMetadataSources", "mavenPluginEmbeddedMetadataSources", "defaultLifecycleMappingMetadataSource").map(map::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<LifecycleMappingMetadataSource> getMavenPluginEmbeddedMetadataSources(List<MojoExecution> mojoExecutions, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) {
        if (mojoExecutions == null || mojoExecutions.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<File, LifecycleMappingMetadataSource> result = new LinkedHashMap<File, LifecycleMappingMetadataSource>();
        MavenImpl maven = (MavenImpl)MavenPlugin.getMaven();
        for (MojoExecution execution : mojoExecutions) {
            LifecycleMappingMetadataSource metadata;
            Artifact artifact;
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (EclipseWorkspaceArtifactRepository.Disabled d = EclipseWorkspaceArtifactRepository.setDisabled();){
                    artifact = maven.resolvePluginArtifact(execution.getPlugin(), remoteRepositories, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                continue;
            }
            File file = artifact.getFile();
            if (file == null || result.containsKey(file) || !file.canRead() || (metadata = LifecycleMappingFactory.readMavenPluginEmbeddedMetadata(artifact)) == null) continue;
            for (LifecycleMappingMetadata lifecycleMetadta : metadata.getLifecycleMappings()) {
                LifecycleMappingFactory.enforcePluginMapping(artifact, lifecycleMetadta.getPluginExecutions());
            }
            LifecycleMappingFactory.enforcePluginMapping(artifact, metadata.getPluginExecutions());
            result.put(file, metadata);
        }
        return new ArrayList<LifecycleMappingMetadataSource>(result.values());
    }

    private static void enforcePluginMapping(Artifact artifact, List<PluginExecutionMetadata> executions) {
        if (executions == null) {
            return;
        }
        ListIterator<PluginExecutionMetadata> iter = executions.listIterator();
        while (iter.hasNext()) {
            PluginExecutionMetadata execution = iter.next();
            PluginExecutionFilter filter = execution.getFilter();
            if (!(LifecycleMappingFactory.isNullOrEqual(artifact.getGroupId(), filter.getGroupId()) && LifecycleMappingFactory.isNullOrEqual(artifact.getArtifactId(), filter.getArtifactId()) && LifecycleMappingFactory.isNullOrEqual(artifact.getBaseVersion(), filter.getVersionRange()))) {
                String mappingGAV = String.valueOf(filter.getGroupId()) + ":" + filter.getArtifactId() + ":" + filter.getVersionRange();
                String pluginGAV = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
                log.warn("Ignoring plugin execution mapping {} defined in maven plugin {} because it matches other plugins and/or plugin versions", (Object)mappingGAV, (Object)pluginGAV);
                iter.remove();
                continue;
            }
            filter.setGroupId(artifact.getGroupId());
            filter.setArtifactId(artifact.getArtifactId());
            filter.setVersionRange(artifact.getBaseVersion());
        }
    }

    private static boolean isNullOrEqual(String expected, String actual) {
        return actual == null || actual.equals(expected);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LifecycleMappingMetadataSource readMavenPluginEmbeddedMetadata(Artifact artifact) {
        LifecycleMappingMetadataSource metadata;
        block19: {
            File file = artifact.getFile();
            metadata = null;
            try {
                if (file.isFile()) {
                    Throwable throwable = null;
                    Object var4_8 = null;
                    try (JarFile jar = new JarFile(file);){
                        ZipEntry entry = jar.getEntry(LIFECYCLE_MAPPING_METADATA_EMBEDDED_SOURCE_PATH);
                        if (entry == null) {
                            return null;
                        }
                        InputStream is = jar.getInputStream(entry);
                        metadata = LifecycleMappingFactory.createLifecycleMappingMetadataSource(is);
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                if (!file.isDirectory() || !(file = new File(file, LIFECYCLE_MAPPING_METADATA_EMBEDDED_SOURCE_PATH)).isFile()) break block19;
                Throwable throwable = null;
                Object var4_10 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    metadata = LifecycleMappingFactory.createLifecycleMappingMetadataSource(is);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException | XmlPullParserException e) {
                throw new LifecycleMappingConfigurationException("Cannot read lifecycle mapping metadata for artifact " + artifact, e);
            }
        }
        if (metadata == null) return metadata;
        metadata.setSource(artifact);
        return metadata;
    }

    private static File getWorkspaceMetadataFile() {
        return new File(MavenPlugin.getMavenConfiguration().getWorkspaceLifecycleMappingMetadataFile());
    }

    public static synchronized LifecycleMappingMetadataSource getWorkspaceMetadata(boolean reload) {
        if (workspaceMetadataSource == null || reload) {
            File mappingFile = LifecycleMappingFactory.getWorkspaceMetadataFile();
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileInputStream is = new FileInputStream(mappingFile);){
                    workspaceMetadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException | XmlPullParserException ex) {
                log.error(ex.getMessage(), ex);
            }
            if (workspaceMetadataSource == null) {
                workspaceMetadataSource = new LifecycleMappingMetadataSource();
            }
            workspaceMetadataSource.setSource("workspace");
        }
        return workspaceMetadataSource;
    }

    public static synchronized void writeWorkspaceMetadata(LifecycleMappingMetadataSource metadata) {
        LifecycleMappingMetadataSourceXpp3Writer writer = new LifecycleMappingMetadataSourceXpp3Writer();
        File mappingFile = LifecycleMappingFactory.getWorkspaceMetadataFile();
        mappingFile.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mappingFile));){
                writer.write(os, metadata);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        workspaceMetadataSource = metadata;
    }

    public static void calculateEffectiveLifecycleMappingMetadata(LifecycleMappingResult result, List<MappingMetadataSource> metadataSources, MavenProject mavenProject, List<MojoExecution> mojoExecutions, boolean applyDefaultStrategy, IProgressMonitor monitor) {
        LifecycleMappingMetadata lifecycleMappingMetadata = null;
        String packaging = mavenProject.getPackaging();
        PackagingTypeFilter packagingTypeFilter = new PackagingTypeFilter(metadataSources, packaging);
        int i = 0;
        while (i < metadataSources.size()) {
            block26: {
                MappingMetadataSource source = metadataSources.get(i);
                try {
                    lifecycleMappingMetadata = source.getLifecycleMappingMetadata(packaging, packagingTypeFilter);
                    if (lifecycleMappingMetadata != null) {
                        metadataSources.add(i, new SimpleMappingMetadataSource(lifecycleMappingMetadata));
                    }
                    break block26;
                }
                catch (DuplicateMappingException e) {
                    SourceLocation location = SourceLocationHelper.findPackagingLocation(mavenProject);
                    log.error("Duplicate lifecycle mapping metadata for {}.", (Object)mavenProject, (Object)e);
                    result.addProblem(new DuplicateMappingSourceProblem(location, NLS.bind((String)Messages.LifecycleDuplicate, (Object)packaging, (Object)e.getMessage()), "packaging", packaging, e));
                    metadataSources.add(i, new FailedMappingMetadataSource(source, e));
                }
                break;
            }
            ++i;
        }
        if (lifecycleMappingMetadata == null && applyDefaultStrategy) {
            lifecycleMappingMetadata = new LifecycleMappingMetadata();
            lifecycleMappingMetadata.setLifecycleMappingId("DEFAULT");
            lifecycleMappingMetadata.setPackagingType(packaging);
        }
        result.setLifecycleMappingMetadata(lifecycleMappingMetadata);
        PluginExecutionAction defaultMojoExecutionAction = MavenPlugin.getMavenConfiguration().getDefaultMojoExecutionAction();
        LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>> executionMapping = new LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>>();
        if (mojoExecutions != null && !mojoExecutions.isEmpty()) {
            Map<String, IConfigurationElement> elements = LifecycleMappingFactory.getProjectConfiguratorExtensions();
            for (MojoExecution execution : mojoExecutions) {
                Object location;
                MojoExecutionKey executionKey = new MojoExecutionKey(execution);
                MojoExecutionFilter goalFilter = new MojoExecutionFilter(metadataSources, executionKey);
                HashMap<String, PluginExecutionMetadata> configuratorMetadataMap = new HashMap<String, PluginExecutionMetadata>();
                LinkedHashMap<MappingMetadataSource, List<PluginExecutionMetadata>> metadatasPerSource = new LinkedHashMap<MappingMetadataSource, List<PluginExecutionMetadata>>();
                for (MappingMetadataSource source : metadataSources) {
                    try {
                        List<PluginExecutionMetadata> list = LifecycleMappingFactory.applyParametersFilter(source.getPluginExecutionMetadata(executionKey), mavenProject, execution, monitor);
                        metadatasPerSource.put(source, list);
                        for (PluginExecutionMetadata executionMetadata : list) {
                            if (!LifecycleMappingFactory.isConfigurator(executionMetadata)) continue;
                            String string = LifecycleMappingFactory.getProjectConfiguratorId(executionMetadata);
                            configuratorMetadataMap.put(string, executionMetadata);
                        }
                    }
                    catch (CoreException coreException) {
                        location = SourceLocationHelper.findLocation(mavenProject, executionKey);
                        result.addProblem(new MavenProblemInfo((SourceLocation)location, (Throwable)coreException));
                        metadatasPerSource.put(source, Collections.emptyList());
                    }
                }
                ProjectConfigurationElementSorter sorter = null;
                try {
                    sorter = new ProjectConfigurationElementSorter(configuratorMetadataMap.keySet(), elements);
                }
                catch (CycleDetectedException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    result.addProblem(new MavenProblemInfo(1, NLS.bind((String)"Cyclic dependency detected between project configurators for {0}", (Object)mavenProject), (Throwable)ex));
                    return;
                }
                PluginExecutionMetadata primaryMetadata = null;
                try {
                    for (Map.Entry entry : metadatasPerSource.entrySet()) {
                        for (PluginExecutionMetadata executionMetadata : (List)entry.getValue()) {
                            if (goalFilter.test(executionMetadata) || !LifecycleMappingFactory.isPrimaryMapping(executionMetadata, sorter)) continue;
                            if (primaryMetadata != null) {
                                throw new DuplicatePluginExecutionMetadataException(List.of(primaryMetadata, executionMetadata));
                            }
                            primaryMetadata = executionMetadata;
                        }
                        if (primaryMetadata == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (DuplicatePluginExecutionMetadataException duplicatePluginExecutionMetadataException) {
                    primaryMetadata = null;
                    location = SourceLocationHelper.findLocation(mavenProject, executionKey);
                    log.debug("Duplicate plugin execution mapping metadata for {}.", (Object)executionKey, (Object)duplicatePluginExecutionMetadataException);
                    result.addProblem(new DuplicateExecutionMappingSourceProblem((SourceLocation)location, NLS.bind((String)Messages.PluginExecutionMappingDuplicate, (Object)executionKey, (Object)duplicatePluginExecutionMetadataException.getMessage()), executionKey, duplicatePluginExecutionMetadataException));
                }
                if (primaryMetadata != null && !LifecycleMappingFactory.isValidPluginExecutionMetadata(primaryMetadata)) {
                    log.debug("Invalid plugin execution mapping metadata for {}.", (Object)executionKey);
                    result.addProblem(new MavenProblemInfo(1, NLS.bind((String)Messages.PluginExecutionMappingInvalid, (Object)executionKey), null));
                    primaryMetadata = null;
                }
                ArrayList<IPluginExecutionMetadata> arrayList = new ArrayList<IPluginExecutionMetadata>();
                if (primaryMetadata != null) {
                    arrayList.add(primaryMetadata);
                    if (LifecycleMappingFactory.isConfigurator(primaryMetadata)) {
                        String primaryConfiguratorId = LifecycleMappingFactory.getProjectConfiguratorId(primaryMetadata);
                        List<String> secondaryConfiguratorIds = sorter.getSecondaryConfigurators(primaryConfiguratorId);
                        for (String string : secondaryConfiguratorIds) {
                            IPluginExecutionMetadata metadata = (IPluginExecutionMetadata)configuratorMetadataMap.get(string);
                            if (metadata == null) {
                                log.debug("Invalid secondary lifecycle mapping metadata {} for {}.", (Object)string, (Object)executionKey);
                                continue;
                            }
                            arrayList.add(metadata);
                        }
                    }
                }
                if (defaultMojoExecutionAction != PluginExecutionAction.warn && arrayList.isEmpty() && LifecycleMappingFactory.isInterestingPhase(execution.getLifecyclePhase())) {
                    arrayList.add(new DefaultPluginExecutionMetadata(execution, defaultMojoExecutionAction));
                }
                executionMapping.put(executionKey, arrayList);
            }
        } else {
            log.debug("Execution plan is null, could not calculate mojo execution mapping for {}.", (Object)mavenProject);
        }
        result.setMojoExecutionMapping(executionMapping);
    }

    private static List<PluginExecutionMetadata> applyParametersFilter(List<PluginExecutionMetadata> metadatas, MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        ArrayList<PluginExecutionMetadata> result = new ArrayList<PluginExecutionMetadata>();
        for (PluginExecutionMetadata metadata : metadatas) {
            if (!LifecycleMappingFactory.hasMatchingParameterValue(mavenProject, execution, metadata, maven, monitor)) continue;
            result.add(metadata);
        }
        return result;
    }

    private static boolean hasMatchingParameterValue(MavenProject mavenProject, MojoExecution execution, PluginExecutionMetadata metadata, IMaven maven, IProgressMonitor monitor) throws CoreException {
        Map parameters = metadata.getFilter().getParameters();
        for (Map.Entry entry : parameters.entrySet()) {
            MojoExecution setupExecution = maven.setupMojoExecution(mavenProject, execution, monitor);
            String value = maven.getMojoParameterValue(mavenProject, setupExecution, (String)entry.getKey(), String.class, monitor);
            if (Objects.equals(entry.getValue(), value)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPluginExecutionMetadata(PluginExecutionMetadata metadata) {
        return switch (metadata.getAction()) {
            case PluginExecutionAction.ignore, PluginExecutionAction.execute, PluginExecutionAction.error, PluginExecutionAction.warn -> true;
            case PluginExecutionAction.configurator -> LifecycleMappingFactory.isConfigurator(metadata);
            default -> false;
        };
    }

    private static boolean isConfigurator(PluginExecutionMetadata metadata) {
        if (PluginExecutionAction.configurator == metadata.getAction()) {
            try {
                LifecycleMappingFactory.getProjectConfiguratorId(metadata);
                return true;
            }
            catch (LifecycleMappingConfigurationException lifecycleMappingConfigurationException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void instantiateLifecycleMapping(LifecycleMappingResult result, MavenProject mavenProject, String lifecycleMappingId) {
        AbstractLifecycleMapping lifecycleMapping = null;
        if (lifecycleMappingId != null && (lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(lifecycleMappingId)) == null) {
            SourceLocation markerLocation = SourceLocationHelper.findPackagingLocation(mavenProject);
            result.addProblem(new MissingLifecycleExtensionPoint(lifecycleMappingId, markerLocation));
        }
        result.setLifecycleMapping(lifecycleMapping);
    }

    private static void instantiateProjectConfigurators(MavenProject mavenProject, LifecycleMappingResult result, Map<MojoExecutionKey, List<IPluginExecutionMetadata>> map) {
        if (map == null) {
            Map<String, AbstractProjectConfigurator> configurators = Collections.emptyMap();
            result.setProjectConfigurators(configurators);
            return;
        }
        ProblemSeverity notCoveredMojoExecutionSeverity = ProblemSeverity.get(MavenPlugin.getMavenConfiguration().getNotCoveredMojoExecutionSeverity());
        boolean reportNotCoveredMojoExecutionProblems = !ProblemSeverity.ignore.equals((Object)notCoveredMojoExecutionSeverity);
        LinkedHashMap<String, AbstractProjectConfigurator> configurators = new LinkedHashMap<String, AbstractProjectConfigurator>();
        for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : map.entrySet()) {
            MojoExecutionKey executionKey = entry.getKey();
            List<IPluginExecutionMetadata> executionMetadatas = entry.getValue();
            if (executionMetadatas == null || executionMetadatas.isEmpty()) {
                if (!reportNotCoveredMojoExecutionProblems || !LifecycleMappingFactory.isInterestingPhase(executionKey.lifecyclePhase())) continue;
                SourceLocation markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                result.addProblem(new NotCoveredMojoExecution(executionKey, notCoveredMojoExecutionSeverity.getSeverity(), markerLocation));
                continue;
            }
            for (IPluginExecutionMetadata metadata : executionMetadatas) {
                SourceLocation markerLocation;
                String message = LifecycleMappingFactory.getActionMessage(metadata);
                switch (metadata.getAction()) {
                    case error: {
                        if (message == null) {
                            message = NLS.bind((String)Messages.LifecycleConfigurationPluginExecutionErrorMessage, (Object)executionKey);
                        }
                        markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                        result.addProblem(new ActionMessageProblemInfo(message, 2, executionKey, markerLocation, LifecycleMappingFactory.isPomMapping(metadata)));
                        break;
                    }
                    case execute: {
                        if (message == null) break;
                        markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                        result.addProblem(new ActionMessageProblemInfo(message, 1, executionKey, markerLocation, LifecycleMappingFactory.isPomMapping(metadata)));
                        break;
                    }
                    case configurator: {
                        String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(metadata);
                        try {
                            if (configurators.containsKey(configuratorId)) break;
                            configurators.put(configuratorId, LifecycleMappingFactory.createProjectConfigurator(metadata));
                        }
                        catch (LifecycleMappingConfigurationException e) {
                            log.debug("Could not instantiate project configurator {}.", (Object)configuratorId, (Object)e);
                            if (!reportNotCoveredMojoExecutionProblems) break;
                            SourceLocation markerLocation2 = SourceLocationHelper.findLocation(mavenProject, executionKey);
                            result.addProblem(new MissingConfiguratorProblemInfo(configuratorId, executionKey, notCoveredMojoExecutionSeverity.getSeverity(), markerLocation2));
                        }
                        break;
                    }
                    case ignore: {
                        if (message == null) break;
                        SourceLocation markerLocation3 = SourceLocationHelper.findLocation(mavenProject, executionKey);
                        result.addProblem(new ActionMessageProblemInfo(message, 1, executionKey, markerLocation3, LifecycleMappingFactory.isPomMapping(metadata)));
                    }
                }
                if (!(metadata instanceof DefaultPluginExecutionMetadata)) continue;
                markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                result.addProblem(new NotCoveredMojoExecution(executionKey, 0, markerLocation));
            }
        }
        result.setProjectConfigurators(configurators);
    }

    private static boolean isPomMapping(IPluginExecutionMetadata metadata) {
        if (metadata instanceof PluginExecutionMetadata var1_2) {
            LifecycleMappingMetadataSource source = executionMetadata.getSource();
            return source != null && source.getSource() instanceof MavenProject;
        }
        return false;
    }

    public static List<MappingMetadataSource> getPomMappingMetadataSources(MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        ArrayList<MappingMetadataSource> sources = new ArrayList<MappingMetadataSource>();
        LinkedHashSet<String> referenced = new LinkedHashSet<String>();
        MavenProject project = mavenProject;
        while (!monitor.isCanceled()) {
            LifecycleMappingMetadataSource embeddedSource;
            AnnotationMappingMetadataSource annSource = AnnotationMappingMetadataSource.get(project);
            if (annSource != null) {
                sources.add(annSource);
            }
            if ((embeddedSource = LifecycleMappingFactory.getEmbeddedMetadataSource(project)) != null) {
                embeddedSource.setSource(project);
                sources.add(new SimpleMappingMetadataSource(embeddedSource));
            }
            for (LifecycleMappingMetadataSource referencedSource : LifecycleMappingFactory.getReferencedMetadataSources(referenced, project, monitor)) {
                sources.add(new SimpleMappingMetadataSource(referencedSource));
            }
            if ((project = project.getParent()) != null) continue;
        }
        return sources;
    }

    public static AbstractProjectConfigurator createProjectConfigurator(IPluginExecutionMetadata metadata) {
        PluginExecutionAction pluginExecutionAction = metadata.getAction();
        if (pluginExecutionAction != PluginExecutionAction.configurator) {
            throw new IllegalArgumentException();
        }
        String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(metadata);
        AbstractProjectConfigurator projectConfigurator = LifecycleMappingFactory.createProjectConfigurator(configuratorId);
        if (projectConfigurator == null) {
            String message = NLS.bind((String)Messages.ProjectConfiguratorNotAvailable, (Object)configuratorId);
            throw new LifecycleMappingConfigurationException(message);
        }
        return projectConfigurator;
    }

    public static String getProjectConfiguratorId(IPluginExecutionMetadata metadata) {
        Xpp3Dom child;
        Xpp3Dom configuration = ((PluginExecutionMetadata)metadata).getConfiguration();
        Xpp3Dom xpp3Dom = child = configuration == null ? null : configuration.getChild(ATTR_ID);
        if (child == null || child.getValue().trim().length() == 0) {
            throw new LifecycleMappingConfigurationException("A configurator id must be specified");
        }
        return child.getValue();
    }

    private static String getActionMessage(IPluginExecutionMetadata metadata) {
        if (metadata instanceof PluginExecutionMetadata var1_2) {
            Xpp3Dom configuration = executionMetadata.getConfiguration();
            Xpp3Dom xpp3Dom = child = configuration == null ? null : configuration.getChild(ELEMENT_MESSAGE);
            if (child == null || child.getValue().isBlank()) {
                return null;
            }
            return child.getValue();
        }
        return null;
    }

    public static LifecycleMappingMetadataSource createLifecycleMappingMetadataSource(InputStream is) throws IOException, XmlPullParserException {
        return LifecycleMappingFactory.createLifecycleMappingMetadataSource(new InputStreamReader(is));
    }

    private static LifecycleMappingMetadataSource createLifecycleMappingMetadataSource(Reader reader) throws IOException, XmlPullParserException {
        LifecycleMappingMetadataSource metadataSource = new LifecycleMappingMetadataSourceXpp3Reader().read(reader);
        for (LifecycleMappingMetadata lifecycleMappingMetadata : metadataSource.getLifecycleMappings()) {
            lifecycleMappingMetadata.setSource(metadataSource);
            for (PluginExecutionMetadata executionMetadata : lifecycleMappingMetadata.getPluginExecutions()) {
                executionMetadata.setSource(metadataSource);
            }
        }
        for (PluginExecutionMetadata executionMetadata : metadataSource.getPluginExecutions()) {
            executionMetadata.setSource(metadataSource);
        }
        return metadataSource;
    }

    private static AbstractLifecycleMapping createLifecycleMapping(IConfigurationElement element) {
        String mappingId = null;
        try {
            AbstractLifecycleMapping mapping = (AbstractLifecycleMapping)element.createExecutableExtension(ATTR_CLASS);
            mappingId = element.getAttribute(ATTR_ID);
            mapping.setId(mappingId);
            mapping.setName(element.getAttribute(ATTR_NAME));
            return mapping;
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static MojoExecutionBuildParticipant createMojoExecutionBuildParicipant(MojoExecution mojoExecution, IPluginExecutionMetadata executionMetadata) {
        boolean runOnIncremental = false;
        boolean runOnConfiguration = false;
        if (executionMetadata instanceof PluginExecutionMetadata) {
            Xpp3Dom child = ((PluginExecutionMetadata)executionMetadata).getConfiguration().getChild(ELEMENT_RUN_ON_INCREMENTAL);
            if (child != null) {
                runOnIncremental = Boolean.parseBoolean(child.getValue());
            }
            if ((child = ((PluginExecutionMetadata)executionMetadata).getConfiguration().getChild(ELEMENT_RUN_ON_CONFIGURATION)) != null) {
                runOnConfiguration = Boolean.parseBoolean(child.getValue());
            }
        } else {
            runOnIncremental = true;
        }
        return new MojoExecutionBuildParticipant(mojoExecution, runOnIncremental, runOnConfiguration);
    }

    public static Map<String, IConfigurationElement> getLifecycleMappingExtensions() {
        HashMap<String, IConfigurationElement> mappings = new HashMap<String, IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint configuratorsExtensionPoint = registry.getExtensionPoint(EXTENSION_LIFECYCLE_MAPPINGS);
        if (configuratorsExtensionPoint != null) {
            IExtension[] iExtensionArray = configuratorsExtensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (ELEMENT_LIFECYCLE_MAPPING.equals(element.getName())) {
                        mappings.put(element.getAttribute(ATTR_ID), element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return mappings;
    }

    private static AbstractLifecycleMapping getLifecycleMapping(String mappingId) {
        IConfigurationElement element = LifecycleMappingFactory.getLifecycleMappingExtensions().get(mappingId);
        if (element != null && ELEMENT_LIFECYCLE_MAPPING.equals(element.getName()) && mappingId.equals(element.getAttribute(ATTR_ID))) {
            return LifecycleMappingFactory.createLifecycleMapping(element);
        }
        return null;
    }

    private static AbstractProjectConfigurator createProjectConfigurator(String configuratorId) {
        IConfigurationElement element = LifecycleMappingFactory.getProjectConfiguratorExtension(configuratorId);
        if (element != null) {
            try {
                AbstractProjectConfigurator configurator = (AbstractProjectConfigurator)element.createExecutableExtension(ATTR_CLASS);
                configurator.setProjectManager(MavenPlugin.getMavenProjectRegistry());
                configurator.setMavenConfiguration(MavenPlugin.getMavenConfiguration());
                configurator.setMarkerManager(MavenPluginActivator.getDefault().getMavenMarkerManager());
                return configurator;
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public static Map<String, IConfigurationElement> getProjectConfiguratorExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return LifecycleMappingFactory.getProjectConfiguratorExtensions(registry);
    }

    public static Map<String, IConfigurationElement> getProjectConfiguratorExtensions(IExtensionRegistry registry) {
        HashMap<String, IConfigurationElement> extensions = new HashMap<String, IConfigurationElement>();
        IExtensionPoint configuratorsExtensionPoint = registry.getExtensionPoint(EXTENSION_PROJECT_CONFIGURATORS);
        if (configuratorsExtensionPoint != null) {
            IExtension[] configuratorExtensions;
            IExtension[] iExtensionArray = configuratorExtensions = configuratorsExtensionPoint.getExtensions();
            int n = configuratorExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (ELEMENT_CONFIGURATOR.equals(element.getName())) {
                        extensions.put(element.getAttribute(ATTR_ID), element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return extensions;
    }

    private static IConfigurationElement getProjectConfiguratorExtension(String configuratorId, Map<String, IConfigurationElement> elements) {
        if (elements == null) {
            return null;
        }
        IConfigurationElement element = elements.get(configuratorId);
        if (element != null && ELEMENT_CONFIGURATOR.equals(element.getName()) && configuratorId.equals(element.getAttribute(ATTR_ID))) {
            return element;
        }
        return null;
    }

    private static IConfigurationElement getProjectConfiguratorExtension(String configuratorId) {
        return LifecycleMappingFactory.getProjectConfiguratorExtension(configuratorId, LifecycleMappingFactory.getProjectConfiguratorExtensions());
    }

    private static void checkCompatibleVersion(Plugin metadataPlugin) {
        String v = metadataPlugin.getVersion();
        if (v == null) {
            return;
        }
        ComparableVersion version = new ComparableVersion(v);
        if (!version.equals((Object)new ComparableVersion(LIFECYCLE_MAPPING_PLUGIN_VERSION))) {
            SourceLocation location = SourceLocationHelper.findLocation(metadataPlugin, ATTR_VERSION);
            throw new LifecycleMappingConfigurationException(NLS.bind((String)Messages.LifecycleMappingPluginVersionIncompatible, (Object)metadataPlugin.getVersion()), location);
        }
    }

    private static LifecycleMappingMetadataSource getEmbeddedMetadataSource(MavenProject mavenProject) throws CoreException {
        PluginManagement pluginManagement = LifecycleMappingFactory.getPluginManagement(mavenProject);
        if (pluginManagement == null) {
            return null;
        }
        Plugin metadataPlugin = (Plugin)pluginManagement.getPluginsAsMap().get(LIFECYCLE_MAPPING_PLUGIN_KEY);
        if (metadataPlugin != null) {
            Xpp3Dom lifecycleMappingDom;
            LifecycleMappingFactory.checkCompatibleVersion(metadataPlugin);
            Xpp3Dom configurationDom = (Xpp3Dom)metadataPlugin.getConfiguration();
            if (configurationDom != null && (lifecycleMappingDom = configurationDom.getChild(ELEMENT_LIFECYCLE_MAPPING_METADATA)) != null) {
                try {
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (StringReader reader = new StringReader(lifecycleMappingDom.toString());){
                        LifecycleMappingMetadataSource metadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource(reader);
                        String packagingType = mavenProject.getPackaging();
                        if (!"pom".equals(packagingType)) {
                            for (LifecycleMappingMetadata lifecycleMappingMetadata : metadataSource.getLifecycleMappings()) {
                                if (packagingType.equals(lifecycleMappingMetadata.getPackagingType())) continue;
                                SourceLocation location = SourceLocationHelper.findLocation(metadataPlugin, "configuration");
                                throw new LifecycleMappingConfigurationException(NLS.bind((String)Messages.LifecycleMappingPackagingMismatch, (Object)lifecycleMappingMetadata.getPackagingType(), (Object)packagingType), location);
                            }
                        }
                        return metadataSource;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new LifecycleMappingConfigurationException("Cannot read lifecycle mapping metadata for maven project " + mavenProject, e);
                }
                catch (XmlPullParserException e) {
                    throw new LifecycleMappingConfigurationException("Cannot parse lifecycle mapping metadata for maven project " + mavenProject, e);
                }
                catch (LifecycleMappingConfigurationException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new LifecycleMappingConfigurationException("Cannot load lifecycle mapping metadata for maven project " + mavenProject, e);
                }
            }
        }
        return null;
    }

    private static List<LifecycleMappingMetadataSource> getReferencedMetadataSources(Set<String> referenced, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        ArrayList<LifecycleMappingMetadataSource> metadataSources = new ArrayList<LifecycleMappingMetadataSource>();
        PluginManagement pluginManagement = LifecycleMappingFactory.getPluginManagement(mavenProject);
        for (Plugin plugin : pluginManagement.getPlugins()) {
            Xpp3Dom configuration;
            if (!LIFECYCLE_MAPPING_PLUGIN_KEY.equals(plugin.getKey()) || (configuration = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
            LifecycleMappingFactory.checkCompatibleVersion(plugin);
            Xpp3Dom sources = configuration.getChild(ELEMENT_SOURCES);
            if (sources == null) continue;
            Xpp3Dom[] xpp3DomArray = sources.getChildren(ELEMENT_SOURCE);
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom source = xpp3DomArray[n2];
                String groupId = null;
                Xpp3Dom child = source.getChild(ATTR_GROUPID);
                if (child != null) {
                    groupId = child.getValue();
                }
                String artifactId = null;
                child = source.getChild(ATTR_ARTIFACTID);
                if (child != null) {
                    artifactId = child.getValue();
                }
                String version = null;
                child = source.getChild(ATTR_VERSION);
                if (child != null) {
                    version = child.getValue();
                }
                if (referenced.add(String.valueOf(groupId) + ":" + artifactId)) {
                    try {
                        LifecycleMappingMetadataSource lifecycleMappingMetadataSource = LifecycleMappingFactory.getLifecycleMappingMetadataSource(groupId, artifactId, version, mavenProject.getRemoteArtifactRepositories(), monitor);
                        metadataSources.add(lifecycleMappingMetadataSource);
                    }
                    catch (LifecycleMappingConfigurationException e) {
                        e.setLocation(SourceLocationHelper.findLocation(plugin, "configuration"));
                        throw e;
                    }
                }
                ++n2;
            }
        }
        return metadataSources;
    }

    private static PluginManagement getPluginManagement(MavenProject mavenProject) throws CoreException {
        Model model = new Model();
        Build build = new Build();
        model.setBuild(build);
        PluginManagement result = new PluginManagement();
        build.setPluginManagement(result);
        if (mavenProject == null) {
            return null;
        }
        LifecycleMappingFactory.addBuild(result, (BuildBase)mavenProject.getOriginalModel().getBuild());
        for (Profile profile : mavenProject.getActiveProfiles()) {
            LifecycleMappingFactory.addBuild(result, profile.getBuild());
        }
        ((MavenImpl)MavenPlugin.getMaven()).interpolateModel(mavenProject, model);
        return result;
    }

    private static void addBuild(PluginManagement result, BuildBase build) {
        PluginManagement pluginManagement;
        if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                result.addPlugin(plugin.clone());
            }
        }
    }

    public static LifecycleMappingMetadataSource getDefaultLifecycleMappingMetadataSource() {
        if (!useDefaultLifecycleMappingMetadataSource) {
            return null;
        }
        if (defaultLifecycleMappingMetadataSource == null) {
            Bundle bundle = FrameworkUtil.getBundle(LifecycleMappingFactory.class);
            defaultLifecycleMappingMetadataSource = LifecycleMappingFactory.getMetadataSource(bundle);
            if (defaultLifecycleMappingMetadataSource == null) {
                defaultLifecycleMappingMetadataSource = new LifecycleMappingMetadataSource();
            }
            defaultLifecycleMappingMetadataSource.setSource("default");
        }
        return defaultLifecycleMappingMetadataSource;
    }

    public static void setDefaultLifecycleMappingMetadataSource(LifecycleMappingMetadataSource defaultLifecycleMappingMetadataSource) {
        LifecycleMappingFactory.defaultLifecycleMappingMetadataSource = defaultLifecycleMappingMetadataSource;
        useDefaultLifecycleMappingMetadataSource = true;
    }

    public static void setUseDefaultLifecycleMappingMetadataSource(boolean use) {
        useDefaultLifecycleMappingMetadataSource = use;
        if (!use) {
            defaultLifecycleMappingMetadataSource = null;
        }
    }

    private static LifecycleMappingMetadataSource getLifecycleMappingMetadataSource(String groupId, String artifactId, String version, List<ArtifactRepository> repositories, IProgressMonitor monitor) {
        Artifact artifact;
        try {
            artifact = MavenPlugin.getMaven().resolve(groupId, artifactId, version, "xml", LIFECYCLE_MAPPING_METADATA_CLASSIFIER, repositories, monitor);
        }
        catch (CoreException ex) {
            throw new LifecycleMappingConfigurationException(ex);
        }
        File file = artifact.getFile();
        if (file == null || !file.exists() || !file.canRead()) {
            throw new LifecycleMappingConfigurationException("Cannot find file for artifact " + artifact);
        }
        try {
            LifecycleMappingMetadataSource source = LifecycleMappingFactory.createLifecycleMappingMetadataSource(groupId, artifactId, version, file);
            source.setSource(artifact);
            return source;
        }
        catch (IOException e) {
            throw new LifecycleMappingConfigurationException("Cannot read lifecycle mapping metadata for " + artifact, e);
        }
        catch (XmlPullParserException e) {
            throw new LifecycleMappingConfigurationException("Cannot parse lifecycle mapping metadata for " + artifact, e);
        }
        catch (RuntimeException e) {
            throw new LifecycleMappingConfigurationException("Cannot load lifecycle mapping metadata for " + artifact, e);
        }
    }

    private static LifecycleMappingMetadataSource createLifecycleMappingMetadataSource(String groupId, String artifactId, String version, File configuration) throws IOException, XmlPullParserException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream in = new FileInputStream(configuration);){
            LifecycleMappingMetadataSource lifecycleMappingMetadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource(in);
            lifecycleMappingMetadataSource.setGroupId(groupId);
            lifecycleMappingMetadataSource.setArtifactId(artifactId);
            lifecycleMappingMetadataSource.setVersion(version);
            return lifecycleMappingMetadataSource;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static synchronized List<LifecycleMappingMetadataSource> getBundleMetadataSources() {
        if (bundleMetadataSources == null) {
            bundleMetadataSources = new ArrayList<LifecycleMappingMetadataSource>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint configuratorsExtensionPoint = registry.getExtensionPoint(EXTENSION_LIFECYCLE_MAPPING_METADATA_SOURCE);
            if (configuratorsExtensionPoint != null) {
                IExtension[] configuratorExtensions;
                IExtension[] iExtensionArray = configuratorExtensions = configuratorsExtensionPoint.getExtensions();
                int n = configuratorExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    RegistryContributor contributor = (RegistryContributor)extension.getContributor();
                    Bundle bundle = Platform.getBundle((String)contributor.getActualName());
                    LifecycleMappingMetadataSource source = LifecycleMappingFactory.getMetadataSource(bundle);
                    if (source != null) {
                        bundleMetadataSources.add(source);
                    }
                    ++n2;
                }
            }
        }
        return bundleMetadataSources;
    }

    private static LifecycleMappingMetadataSource getMetadataSource(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        URL url = bundle.getEntry(LIFECYCLE_MAPPING_METADATA_SOURCE_PATH);
        if (url != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream in = url.openStream();){
                    LifecycleMappingMetadataSource metadata = LifecycleMappingFactory.createLifecycleMappingMetadataSource(in);
                    metadata.setSource(bundle);
                    return metadata;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | XmlPullParserException e) {
                log.warn("Could not read lifecycle-mapping-metadata.xml for bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
            }
        }
        return null;
    }

    static boolean isPrimaryMapping(PluginExecutionMetadata executionMetadata, ProjectConfigurationElementSorter sorter) {
        if (executionMetadata == null) {
            return false;
        }
        if (LifecycleMappingFactory.isConfigurator(executionMetadata)) {
            String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(executionMetadata);
            return sorter.isRootConfigurator(configuratorId);
        }
        return true;
    }

    public static ILifecycleMapping getLifecycleMapping(IMavenProjectFacade facade) {
        ILifecycleMapping lifecycleMapping = (ILifecycleMapping)facade.getSessionProperty(MavenProjectFacade.PROP_LIFECYCLE_MAPPING);
        if (lifecycleMapping == null) {
            String lifecycleMappingId = facade.getLifecycleMappingId();
            if (lifecycleMappingId != null) {
                lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(lifecycleMappingId);
            }
            if (lifecycleMapping == null) {
                lifecycleMapping = new InvalidLifecycleMapping();
            }
            facade.setSessionProperty(MavenProjectFacade.PROP_LIFECYCLE_MAPPING, lifecycleMapping);
        }
        return lifecycleMapping;
    }

    public static Map<String, AbstractProjectConfigurator> getProjectConfigurators(IMavenProjectFacade facade) {
        Map<String, AbstractProjectConfigurator> configurators = (Map<String, AbstractProjectConfigurator>)facade.getSessionProperty(MavenProjectFacade.PROP_CONFIGURATORS);
        if (configurators == null) {
            LifecycleMappingResult result = new LifecycleMappingResult();
            LifecycleMappingFactory.instantiateProjectConfigurators(facade.getMavenProject(), result, facade.getMojoExecutionMapping());
            configurators = LifecycleMappingFactory.setProjectConfigurators(facade, result);
            if (result.hasProblems()) {
                IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
                for (MavenProblemInfo problem : result.getProblems()) {
                    markerManager.addErrorMarker((IResource)facade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping", problem);
                }
            }
        }
        return configurators;
    }

    public static Map<String, AbstractProjectConfigurator> setProjectConfigurators(IMavenProjectFacade facade, LifecycleMappingResult mappingResult) {
        Map<String, AbstractProjectConfigurator> unsorted = mappingResult.getProjectConfigurators();
        if (unsorted == null || unsorted.isEmpty()) {
            facade.setSessionProperty(MavenProjectFacade.PROP_CONFIGURATORS, unsorted);
            return unsorted;
        }
        LinkedHashMap<String, AbstractProjectConfigurator> configurators = new LinkedHashMap<String, AbstractProjectConfigurator>(unsorted.size());
        Map<String, IConfigurationElement> elements = LifecycleMappingFactory.getProjectConfiguratorExtensions();
        try {
            ProjectConfigurationElementSorter sorter = new ProjectConfigurationElementSorter(unsorted.keySet(), elements);
            List<String> sortedConfigurators = sorter.getSortedConfigurators();
            log.debug("{} is configured by :", (Object)facade.getProject().getName());
            for (String id : sortedConfigurators) {
                AbstractProjectConfigurator configurator = unsorted.get(id);
                if (configurator == null) continue;
                log.debug("\t- {}", (Object)id);
                configurators.put(id, configurator);
            }
        }
        catch (CycleDetectedException e) {
            log.error("Cycle detecting while sorting configurators", (Throwable)e);
            SourceLocation location = SourceLocationHelper.findPackagingLocation(facade.getMavenProject());
            mappingResult.addProblem(new MavenProblemInfo(location, (Throwable)e));
        }
        facade.setSessionProperty(MavenProjectFacade.PROP_CONFIGURATORS, configurators);
        return configurators;
    }

    public static boolean isLifecycleMappingChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldConfiguration, IProgressMonitor monitor) {
        if (oldConfiguration == null || newFacade == null) {
            return false;
        }
        String lifecycleMappingId = newFacade.getLifecycleMappingId();
        if (lifecycleMappingId == null || newFacade.getMojoExecutionMapping() == null) {
            return false;
        }
        if (!Objects.equals(lifecycleMappingId, oldConfiguration.getLifecycleMappingId())) {
            return true;
        }
        AbstractLifecycleMapping lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(lifecycleMappingId);
        if (lifecycleMapping == null) {
            return false;
        }
        return lifecycleMapping.hasLifecycleMappingChanged(newFacade, oldConfiguration, monitor);
    }

    public static boolean isInterestingPhase(String phase) {
        return INTERESTING_PHASES.contains(phase);
    }

    public static synchronized void setBundleMetadataSources(List<LifecycleMappingMetadataSource> bundleMetadataSources) {
        LifecycleMappingFactory.bundleMetadataSources = bundleMetadataSources;
    }
}

