/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import com.microsoft.jdtls.ext.core.PackageCommand;
import com.microsoft.jdtls.ext.core.model.PackageNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.jarpackager.JarPackageUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;

public final class ProjectCommand {
    private static String COMMAND_EXPORT_JAR_REPORT = "java.view.package.exportJarReport";
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();

    public static List<PackageNode> listProjects(List<Object> arguments, IProgressMonitor monitor) {
        String workspaceUri = (String)arguments.get(0);
        IPath workspaceFolderPath = ResourceUtils.canonicalFilePathFromURI((String)workspaceUri);
        IJavaProject[] javaProjects = ProjectUtils.getJavaProjects();
        ArrayList<PackageNode> children = new ArrayList<PackageNode>();
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                PackageNode projectNode;
                block6: {
                    IJavaProject javaProject = iJavaProjectArray[n2];
                    IProject project = javaProject.getProject();
                    if (!project.isAccessible() || project.getLocation() == null || Objects.equals(project.getName(), "jdt.ls-java-project")) break block5;
                    projectNode = PackageNode.createNodeForProject((IJavaElement)JavaCore.create((IProject)project));
                    if (workspaceFolderPath.isPrefixOf(project.getLocation())) break block6;
                    LinkedFolderVisitor visitor = new LinkedFolderVisitor(workspaceFolderPath);
                    try {
                        project.accept((IResourceVisitor)visitor, 1, false);
                    }
                    catch (CoreException e) {
                        JdtlsExtActivator.log(e);
                        break block5;
                    }
                    if (!visitor.isBelongsToWorkspace()) break block5;
                    projectNode.setDisplayName(workspaceFolderPath.lastSegment());
                }
                children.add(projectNode);
            }
            ++n2;
        }
        return children;
    }

    public static boolean refreshLibraries(List<Object> arguments, IProgressMonitor monitor) {
        String workspaceUri = (String)arguments.get(0);
        IPath workspacePath = ResourceUtils.canonicalFilePathFromURI((String)workspaceUri);
        String projectName = ProjectUtils.getWorkspaceInvisibleProjectName((IPath)workspacePath);
        IProject project = ProjectCommand.getWorkspaceRoot().getProject(projectName);
        try {
            Preferences.ReferencedLibraries libraries = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getReferencedLibraries();
            UpdateClasspathJob.getInstance().updateClasspath(JavaCore.create((IProject)project), libraries);
            return true;
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException((String)"Exception occurred during waiting for classpath to be updated", (Throwable)e);
            return false;
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static boolean exportJar(List<Object> arguments, IProgressMonitor monitor) {
        if (arguments.size() < 4) {
            return false;
        }
        String mainClass = (String)gson.fromJson(gson.toJson(arguments.get(0)), String.class);
        Classpath[] classpaths = (Classpath[])gson.fromJson(gson.toJson(arguments.get(1)), Classpath[].class);
        String destination = (String)gson.fromJson(gson.toJson(arguments.get(2)), String.class);
        String terminalId = (String)gson.fromJson(gson.toJson(arguments.get(3)), String.class);
        try {
            return ProjectCommand.exportJarExecution(mainClass, classpaths, destination, terminalId, monitor);
        }
        catch (OperationCanceledException e) {
            File jarFile = new File(destination);
            if (jarFile.exists()) {
                jarFile.delete();
            }
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean exportJarExecution(String mainClass, Classpath[] classpaths, String destination, String terminalId, IProgressMonitor monitor) throws OperationCanceledException {
        manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (mainClass.length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
        }
        try {
            var6_6 = null;
            var7_9 = null;
            try {
                target = new JarOutputStream((OutputStream)new FileOutputStream(destination), manifest);
                try {
                    directories = new HashSet<String>();
                    var13_13 = classpaths;
                    var12_14 = classpaths.length;
                    var11_15 = 0;
                    while (true) {
                        block17: {
                            block15: {
                                block18: {
                                    block16: {
                                        classpath = var13_13[var11_15];
                                        if (monitor.isCanceled()) {
                                            return false;
                                        }
                                        if (!classpath.isArtifact) break block15;
                                        resultStatus = JarPackageUtil.writeArchive(new ZipFile(classpath.source), true, true, target, directories, monitor);
                                        severity = resultStatus.getSeverity();
                                        if (severity != 0) break block16;
                                        path = Paths.get(classpath.source, new String[0]);
                                        ProjectCommand.reportExportJarMessage(terminalId, 0, "Successfully extracted the file to the exported jar: " + path.getFileName().toString());
                                        break block17;
                                    }
                                    if (!resultStatus.isMultiStatus()) break block18;
                                    var19_23 = resultStatus.getChildren();
                                    var18_22 = var19_23.length;
                                    var17_21 = 0;
                                    if (true) ** GOTO lbl50
                                }
                                ProjectCommand.reportExportJarMessage(terminalId, severity, resultStatus.getMessage());
                                break block17;
                            }
                            try {
                                JarPackageUtil.writeFile(new File(classpath.source), (IPath)new Path(classpath.destination), true, true, target, directories);
                                ProjectCommand.reportExportJarMessage(terminalId, 0, "Successfully added the file to the exported jar: " + classpath.destination);
                            }
                            catch (CoreException e) {
                                ProjectCommand.reportExportJarMessage(terminalId, 4, e.getMessage());
                            }
                            break block17;
                            do {
                                childStatus = var19_23[var17_21];
                                ProjectCommand.reportExportJarMessage(terminalId, severity, childStatus.getMessage());
                                ++var17_21;
lbl50:
                                // 2 sources

                            } while (var17_21 < var18_22);
                        }
                        ++var11_15;
                        return (boolean)var11_15;
                    }
                }
                finally {
                    if (var11_15 < var12_14) ** continue;
                    return true;
                }
            }
            catch (Throwable var7_10) {
                if (var6_6 == null) {
                    var6_6 = var7_10;
                    throw var6_6;
                }
                if (var6_6 == var7_10) throw var6_6;
                var6_6.addSuppressed(var7_10);
                throw var6_6;
            }
        }
        catch (IOException e) {
            ProjectCommand.reportExportJarMessage(terminalId, 4, e.getMessage());
            return false;
        }
    }

    public static List<MainClassInfo> getMainClasses(List<Object> arguments, IProgressMonitor monitor) throws Exception {
        List<PackageNode> projectList = ProjectCommand.listProjects(arguments, monitor);
        final ArrayList<MainClassInfo> res = new ArrayList<MainClassInfo>();
        ArrayList<IPackageFragmentRoot> searchRoots = new ArrayList<IPackageFragmentRoot>();
        if (projectList.size() == 0) {
            return res;
        }
        for (PackageNode project : projectList) {
            IJavaProject javaProject = PackageCommand.getJavaProject(project.getUri());
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                if (!packageFragmentRoot.isArchive()) {
                    searchRoots.add(packageFragmentRoot);
                }
                ++n2;
            }
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])searchRoots.toArray(new IJavaElement[0]));
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                Object element = match.getElement();
                if (!(element instanceof IMethod)) {
                    return;
                }
                IMethod method = (IMethod)element;
                try {
                    if (!method.isMainMethod() || method.getResource() == null || method.getJavaProject() == null) {
                        return;
                    }
                    String mainClass = method.getDeclaringType().getFullyQualifiedName();
                    String filePath = "";
                    if (match.getResource() instanceof IFile) {
                        filePath = match.getResource().getLocation().toOSString();
                    }
                    res.add(new MainClassInfo(mainClass, filePath));
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return res;
    }

    public static String getModuleName(IJavaProject project) {
        if (project == null || !JavaRuntime.isModularProject((IJavaProject)project)) {
            return null;
        }
        try {
            IModuleDescription module = project.getModuleDescription();
            return module == null ? null : module.getElementName();
        }
        catch (CoreException e) {
            return null;
        }
    }

    private static void reportExportJarMessage(String terminalId, int severity, String message) {
        if (StringUtils.isNotBlank((CharSequence)message) && StringUtils.isNotBlank((CharSequence)terminalId)) {
            String readableSeverity = ProjectCommand.getSeverityString(severity);
            JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(COMMAND_EXPORT_JAR_REPORT, new Object[]{terminalId, "[" + readableSeverity + "] " + message});
        }
    }

    private static String getSeverityString(int severity) {
        switch (severity) {
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
            case 0: {
                return "OK";
            }
        }
        return "UNKNOWN STATUS";
    }

    private static class Classpath {
        public String source;
        public String destination;
        public boolean isArtifact;

        private Classpath() {
        }
    }

    private static final class LinkedFolderVisitor
    implements IResourceVisitor {
        private boolean belongsToWorkspace = false;
        private IPath workspaceFolderPath;

        public LinkedFolderVisitor(IPath workspaceFolderPath) {
            this.workspaceFolderPath = workspaceFolderPath;
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath realPath;
            if (this.belongsToWorkspace) {
                return false;
            }
            if (!resource.exists()) {
                return false;
            }
            if (resource.isLinked() && this.workspaceFolderPath.isPrefixOf(realPath = resource.getLocation())) {
                this.belongsToWorkspace = true;
            }
            return true;
        }

        public boolean isBelongsToWorkspace() {
            return this.belongsToWorkspace;
        }
    }

    private static class MainClassInfo {
        public String name;
        public String path;

        public MainClassInfo(String name, String path) {
            this.name = name;
            this.path = path;
        }
    }
}

