/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.util.HashMap;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocAccessImpl;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocContentAccessUtility;
import org.eclipse.jdt.core.manipulation.internal.javadoc.IJavadocContentFactory;
import org.eclipse.jdt.core.manipulation.internal.javadoc.InheritDocVisitor;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;

public class JavadocLookup {
    public static final IJavadocContentFactory DEFAULT_FACTORY = new IJavadocContentFactory(){

        @Override
        public IJavadocContentFactory.IJavadocAccess createJavadocAccess(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
            if (lookup == null) {
                return new CoreJavadocAccessImpl(element, javadoc, source);
            }
            return new CoreJavadocAccessImpl(element, javadoc, source, lookup);
        }
    };
    static final JavadocLookup NONE = new JavadocLookup(null, DEFAULT_FACTORY){

        @Override
        public CharSequence getInheritedMainDescription(IMethod method) {
            return null;
        }

        @Override
        public CharSequence getInheritedParamDescription(IMethod method, int i) {
            return null;
        }

        @Override
        public CharSequence getInheritedReturnDescription(IMethod method) {
            return null;
        }

        @Override
        public CharSequence getInheritedExceptionDescription(IMethod method, String name) {
            return null;
        }
    };
    private final IType fStartingType;
    private final HashMap<IMethod, IJavadocContentFactory.IJavadocAccess> fContentAccesses;
    private ITypeHierarchy fTypeHierarchy;
    private MethodOverrideTester fOverrideTester;
    private IJavadocContentFactory fAccessFactory;

    public JavadocLookup(IType startingType, IJavadocContentFactory accessFactory) {
        this.fStartingType = startingType;
        this.fContentAccesses = new HashMap();
        this.fAccessFactory = accessFactory != null ? accessFactory : DEFAULT_FACTORY;
    }

    public CharSequence getInheritedMainDescription(IMethod method) {
        return this.getInheritedDescription(method, contentAccess -> contentAccess.getMainDescription());
    }

    public CharSequence getInheritedTypeParamDescription(IMethod method, int typeParamIndex) {
        return this.getInheritedDescription(method, contentAccess -> contentAccess.getInheritedTypeParamDescription(typeParamIndex));
    }

    public CharSequence getInheritedParamDescription(IMethod method, int paramIndex) {
        return this.getInheritedDescription(method, contentAccess -> contentAccess.getInheritedParamDescription(paramIndex));
    }

    public CharSequence getInheritedReturnDescription(IMethod method) {
        return this.getInheritedDescription(method, contentAccess -> contentAccess.getReturnDescription());
    }

    public CharSequence getInheritedExceptionDescription(IMethod method, String simpleName) {
        return this.getInheritedDescription(method, contentAccess -> contentAccess.getExceptionDescription(simpleName));
    }

    private CharSequence getInheritedDescription(final IMethod method, final DescriptionGetter descriptionGetter) {
        try {
            return (CharSequence)new InheritDocVisitor(){

                @Override
                public Object visit(IType currType) throws JavaModelException {
                    IMethod overridden = JavadocLookup.this.getOverrideTester().findOverriddenMethodInType(currType, method);
                    if (overridden == null) {
                        return InheritDocVisitor.CONTINUE;
                    }
                    IJavadocContentFactory.IJavadocAccess contentAccess = JavadocLookup.this.getJavadocContentAccess(overridden);
                    if (contentAccess == null) {
                        if (overridden.getOpenable().getBuffer() == null) {
                            return InheritDocVisitor.STOP_BRANCH;
                        }
                        return InheritDocVisitor.CONTINUE;
                    }
                    CharSequence overriddenDescription = descriptionGetter.getDescription(contentAccess);
                    if (overriddenDescription != null) {
                        return overriddenDescription;
                    }
                    return InheritDocVisitor.CONTINUE;
                }
            }.visitInheritDoc(method.getDeclaringType(), this.getTypeHierarchy());
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
            return null;
        }
    }

    private IJavadocContentFactory.IJavadocAccess getJavadocContentAccess(IMethod method) throws JavaModelException {
        IJavadocContentFactory.IJavadocAccess cached = this.fContentAccesses.get(method);
        if (cached != null) {
            return cached;
        }
        if (this.fContentAccesses.containsKey(method)) {
            return null;
        }
        IBuffer buf = method.getOpenable().getBuffer();
        if (buf == null) {
            this.fContentAccesses.put(method, null);
            return null;
        }
        ISourceRange javadocRange = method.getJavadocRange();
        if (javadocRange == null) {
            this.fContentAccesses.put(method, null);
            return null;
        }
        String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
        Javadoc javadoc = CoreJavadocContentAccessUtility.getJavadocNode((IJavaElement)method, rawJavadoc);
        if (javadoc == null) {
            this.fContentAccesses.put(method, null);
            return null;
        }
        IJavadocContentFactory.IJavadocAccess contentAccess = this.fAccessFactory.createJavadocAccess((IJavaElement)method, javadoc, rawJavadoc, this);
        this.fContentAccesses.put(method, contentAccess);
        return contentAccess;
    }

    private ITypeHierarchy getTypeHierarchy() throws JavaModelException {
        if (this.fTypeHierarchy == null) {
            this.fTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy(this.fStartingType);
        }
        return this.fTypeHierarchy;
    }

    private MethodOverrideTester getOverrideTester() throws JavaModelException {
        if (this.fOverrideTester == null) {
            this.fOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(this.fStartingType);
        }
        return this.fOverrideTester;
    }

    private static interface DescriptionGetter {
        public CharSequence getDescription(IJavadocContentFactory.IJavadocAccess var1) throws JavaModelException;
    }
}

