/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.GradleUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.internal.gradle.checksums.ValidationResult;
import org.eclipse.jdt.ls.internal.gradle.checksums.WrapperValidator;

public class GradlePreferenceChangeListener
implements IPreferencesChangeListener {
    @Override
    public void preferencesChange(Preferences oldPreferences, Preferences newPreferences) {
        ProjectsManager projectsManager = JavaLanguageServerPlugin.getProjectsManager();
        if (projectsManager != null) {
            boolean annotationProcessingChanged;
            boolean androidSupportChanged;
            boolean protobufSupportChanged;
            boolean gradleJavaHomeChanged;
            boolean bl = gradleJavaHomeChanged = !Objects.equals(oldPreferences.getGradleJavaHome(), newPreferences.getGradleJavaHome());
            if (gradleJavaHomeChanged || this.hasAllowedChecksumsChanged(oldPreferences, newPreferences)) {
                for (IProject project : ProjectUtils.getGradleProjects()) {
                    if (!newPreferences.isGradleWrapperEnabled() && !gradleJavaHomeChanged) continue;
                    this.updateProject(projectsManager, project, gradleJavaHomeChanged);
                }
            }
            boolean bl2 = protobufSupportChanged = !Objects.equals(oldPreferences.isProtobufSupportEnabled(), newPreferences.isProtobufSupportEnabled());
            if (protobufSupportChanged) {
                for (IProject project : ProjectUtils.getGradleProjects()) {
                    projectsManager.updateProject(project, true);
                }
            }
            boolean bl3 = androidSupportChanged = !Objects.equals(oldPreferences.isAndroidSupportEnabled(), newPreferences.isAndroidSupportEnabled());
            if (androidSupportChanged) {
                for (IProject project : ProjectUtils.getGradleProjects()) {
                    projectsManager.updateProject(project, true);
                }
            }
            boolean bl4 = annotationProcessingChanged = !Objects.equals(oldPreferences.isGradleAnnotationProcessingEnabled(), newPreferences.isGradleAnnotationProcessingEnabled());
            if (annotationProcessingChanged) {
                if (newPreferences.isGradleAnnotationProcessingEnabled()) {
                    GradleUtils.synchronizeAnnotationProcessingConfiguration((IProgressMonitor)new NullProgressMonitor());
                } else {
                    for (IProject project : ProjectUtils.getGradleProjects()) {
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        if (javaProject == null) continue;
                        AptConfig.setEnabled((IJavaProject)javaProject, (boolean)false);
                    }
                }
            }
        }
    }

    private void updateProject(ProjectsManager projectsManager, IProject project, boolean gradleJavaHomeChanged) {
        String projectDir = project.getLocation().toFile().getAbsolutePath();
        Path projectPath = Paths.get(projectDir, new String[0]);
        if (gradleJavaHomeChanged || Files.exists(projectPath.resolve("gradlew"), new LinkOption[0])) {
            ProjectConfiguration configuration = CorePlugin.configurationManager().loadProjectConfiguration(project);
            GradleDistribution distribution = configuration.getBuildConfiguration().getGradleDistribution();
            if (gradleJavaHomeChanged || !(distribution instanceof WrapperGradleDistribution)) {
                projectsManager.updateProject(project, true);
            } else {
                try {
                    ValidationResult result = new WrapperValidator().checkWrapper(projectDir);
                    if (!result.isValid()) {
                        projectsManager.updateProject(project, true);
                    }
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        }
    }

    private boolean hasAllowedChecksumsChanged(Preferences oldPreferences, Preferences newPreferences) {
        if (!Objects.equals(oldPreferences.getGradleWrapperList(), newPreferences.getGradleWrapperList())) {
            WrapperValidator.putSha256(newPreferences.getGradleWrapperList());
            return true;
        }
        return false;
    }
}

