/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Defined_Reference;
import org.eclipse.titan.designer.AST.ASN1.IObjectSet_Element;
import org.eclipse.titan.designer.AST.ASN1.InformationFromObj;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSetElementVisitor_objectCollector;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSet_definition;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.ObjectSetElement_Visitor;
import org.eclipse.titan.designer.AST.ASN1.Parameterised_Reference;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Referenced_ObjectSet
extends ObjectSet
implements IObjectSet_Element,
IReferenceChainElement {
    private static final String OBJECTSETEXPECTED = "This is not an objectsetreference: `{0}''";
    public static final String MISMATCH = "ObjectClass mismatch: ObjectSet of class `{0}'' was expected instead of `{1}''";
    private final Reference reference;
    private ObjectSet osReferenced;
    private ObjectSet_definition referencedLast;

    public Referenced_ObjectSet(Reference reference) {
        this.reference = reference;
        if (null != reference) {
            reference.setFullNameParent(this);
        }
    }

    @Override
    public Referenced_ObjectSet newInstance() {
        return new Referenced_ObjectSet(this.reference);
    }

    @Override
    public IObjectSet_Element newOseInstance() {
        return this.newInstance();
    }

    @Override
    public String chainedDescription() {
        return "objectSet reference: " + this.reference;
    }

    @Override
    public Location getChainLocation() {
        if (null != this.reference && null != this.reference.getLocation()) {
            return this.reference.getLocation();
        }
        return null;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.reference) {
            this.reference.setMyScope(scope);
        }
    }

    public ObjectSet getRefd(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            ISetting setting;
            if (this.osReferenced != null && this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
                return this.osReferenced;
            }
            Assignment assignment = this.reference.getRefdAssignment(timestamp, true, referenceChain);
            if (null != assignment && null != (setting = this.reference.getRefdSetting(timestamp)) && !ISetting.Setting_type.S_ERROR.equals((Object)setting.getSettingtype())) {
                if (ISetting.Setting_type.S_OS.equals((Object)setting.getSettingtype())) {
                    this.osReferenced = (ObjectSet)setting;
                    return this.osReferenced;
                }
                this.location.reportSemanticError(MessageFormat.format(OBJECTSETEXPECTED, this.reference.getDisplayName()));
            }
        }
        this.osReferenced = new ObjectSet_definition();
        this.osReferenced.setFullNameParent(this);
        this.osReferenced.setMyGovernor(this.getMyGovernor());
        this.osReferenced.setIsErroneous(true);
        return this.osReferenced;
    }

    @Override
    public ObjectSet_definition getRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain temporalReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        ObjectSet tempObjectSet = this.getRefd(timestamp, temporalReferenceChain);
        this.referencedLast = tempObjectSet.getRefdLast(timestamp, temporalReferenceChain);
        if (newChain) {
            temporalReferenceChain.release();
        }
        return this.referencedLast;
    }

    public boolean isReferencedInformationFromObj() {
        return this.reference instanceof InformationFromObj;
    }

    public boolean isReferencedParameterisedReference() {
        return this.reference instanceof Parameterised_Reference;
    }

    public boolean isReferencedDefinedReference() {
        return this.reference instanceof Defined_Reference;
    }

    public Identifier getId() {
        return this.reference.getId();
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        ObjectSet_definition refdLast;
        ObjectClass_Definition refdClass;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null == this.myGovernor) {
            return;
        }
        ObjectClass_Definition myClass = this.myGovernor.getRefdLast(timestamp, null);
        if (myClass != (refdClass = (refdLast = this.getRefdLast(timestamp, null)).getMyGovernor().getRefdLast(timestamp, null))) {
            if (this.location != null && refdClass != null && myClass != null) {
                this.location.reportSemanticError(MessageFormat.format(MISMATCH, myClass.getFullName(), refdClass.getFullName()));
            }
            this.osReferenced = new ObjectSet_definition();
            this.osReferenced.setMyGovernor(this.myGovernor);
            this.osReferenced.check(timestamp);
        }
    }

    @Override
    public int getNofObjects() {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null == this.referencedLast) {
            return 0;
        }
        return this.referencedLast.getNofObjects();
    }

    @Override
    public ASN1Object getObjectByIndex(int index) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null == this.referencedLast) {
            return null;
        }
        return this.referencedLast.getObjectByIndex(index);
    }

    @Override
    public void accept(ObjectSetElement_Visitor visitor) {
        visitor.visitObjectSetReferenced(this);
    }

    @Override
    public void setMyScopeOse(Scope scope) {
        this.setMyScope(scope);
    }

    @Override
    public void setGenNameOse(String prefix, String suffix) {
        this.setGenName(prefix, suffix);
    }

    @Override
    public void accept(ObjectSetElementVisitor_objectCollector visitor) {
        visitor.visitObjectSet(this, false);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null != this.osReferenced) {
            this.osReferenced.addDeclaration(declarationCollector, index);
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null != this.osReferenced) {
            this.osReferenced.addProposal(propCollector, index);
        }
    }

    @Override
    public boolean memberAccept(ASTVisitor v) {
        return this.reference == null || this.reference.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData) {
        ObjectSet_definition last = this.getRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
        if (this.myScope.getModuleScopeGen() == last.getMyScope().getModuleScopeGen()) {
            last.generateCode(aData);
        }
    }
}

