/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class VisibleString_Type
extends ASN1Type {
    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_VISIBLESTRING;
    }

    @Override
    public IASN1Type newInstance() {
        return new VisibleString_Type();
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_CHARSTRING;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        switch (temp.getTypetype()) {
            case TYPE_CHARSTRING: 
            case TYPE_NUMERICSTRING: 
            case TYPE_PRINTABLESTRING: 
            case TYPE_IA5STRING: 
            case TYPE_VISIBLESTRING: 
            case TYPE_UTCTIME: 
            case TYPE_GENERALIZEDTIME: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTypename() {
        return "VisibleString";
    }

    @Override
    public String getOutlineIcon() {
        return "charstring.gif";
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (null == last || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.CHARSYMBOLS_VALUE);
                if (last.getIsErroneous(timestamp)) {
                    return selfReference;
                }
                last.setValuetype(timestamp, IValue.Value_type.CHARSTRING_VALUE);
                break;
            }
            case CHARSYMBOLS_VALUE: 
            case UNIVERSALCHARSTRING_VALUE: {
                last.setValuetype(timestamp, IValue.Value_type.CHARSTRING_VALUE);
                break;
            }
            case CHARSTRING_VALUE: 
            case ISO2022STRING_VALUE: {
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError("Character string value was expected");
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        CharString_Type.checkThisTemplateString(timestamp, this, template, isModified, implicitOmit, lhs);
        return false;
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        switch (coding) {
            case JSON: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                if (subreferences.size() > actualSubReference + 1) {
                    subreference.getLocation().reportSemanticError("A string element cannot be indexed");
                    return null;
                }
                if (subreferences.size() == actualSubReference + 1) {
                    reference.setStringElementReferencing();
                }
                Value indexValue = ((ArraySubReference)subreference).getValue();
                this.checkStringIndex(timestamp, indexValue, expectedIndex, refChain);
                return this;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("visible string");
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.getGenNameTemplate(aData, source)));
        } else if (this.getParentType() == null || !this.getParentType().generatesOwnClass(aData, source)) {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.hasRawAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return "VisibleString";
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanVisibleString");
        return "TitanVisibleString";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanVisibleString_template");
        return "TitanVisibleString_template";
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        this.generateCodeIspresentBound_forStrings(aData, expression, subreferences, subReferenceIndex, globalId, externalId, isTemplate, optype, field, targetScope);
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp())) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        aData.addBuiltinTypeImport("TitanVisibleString");
        return "TitanVisibleString.TitanVisibleString";
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        aData.addBuiltinTypeImport("TitanVisibleString");
        return MessageFormat.format("TitanVisibleString.convert_to_VisibleString({0})", fromName);
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        aData.addBuiltinTypeImport("TitanVisibleString");
        return "TitanVisibleString.TitanVisibleString_json_";
    }
}

