/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMapping;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class TypeMappings
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final List<TypeMapping> mappings = new ArrayList<TypeMapping>();
    private final Map<String, TypeMapping> mappingsMap = new HashMap<String, TypeMapping>();
    private CompilationTimeStamp lastTimeChecked;
    private Location location;

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addMapping(TypeMapping mapping) {
        this.mappings.add(mapping);
        mapping.setFullNameParent(this);
    }

    public int getNofMappings() {
        return this.mappings.size();
    }

    public TypeMapping getMappingByIndex(int index) {
        return this.mappings.get(index);
    }

    public boolean hasMappingForType(CompilationTimeStamp timestamp, IType type) {
        if (type.getIsErroneous(timestamp)) {
            return true;
        }
        return this.mappingsMap.containsKey(type.getTypename());
    }

    public TypeMapping getMappingForType(CompilationTimeStamp timestamp, IType type) {
        return this.mappingsMap.get(type.getTypename());
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.mappings.size();
        for (int i = 0; i < size; ++i) {
            if (this.mappings.get(i) != child) continue;
            return builder.append(".<mapping").append(i + 1).append('>');
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.mappings.size();
        for (int i = 0; i < size; ++i) {
            this.mappings.get(i).setMyScope(scope);
        }
    }

    public void copyMappings(TypeMappings otherMappings) {
        int size = otherMappings.getNofMappings();
        for (int i = 0; i < size; ++i) {
            this.mappings.add(otherMappings.getMappingByIndex(i));
        }
        this.getLocation().setEndOffset(otherMappings.getLocation().getEndOffset());
    }

    public void check(CompilationTimeStamp timestamp, Port_Type portType, boolean legacy, boolean incoming) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.mappingsMap.clear();
        int size = this.mappings.size();
        for (int i = 0; i < size; ++i) {
            TypeMapping mapping = this.mappings.get(i);
            mapping.check(timestamp, portType, legacy, incoming);
            Type sourceType = mapping.getSourceType();
            if (sourceType == null || sourceType.getTypeRefdLast(timestamp).getIsErroneous(timestamp)) continue;
            String sourceName = sourceType.getTypename();
            if (this.mappingsMap.containsKey(sourceName)) {
                sourceType.getLocation().reportSemanticError(MessageFormat.format("Duplicate mapping for type `{0}''", sourceName));
                String message = MessageFormat.format("The mapping of the type `{0}'' is already given here", sourceName);
                this.mappingsMap.get(sourceName).getLocation().reportSemanticWarning(message);
                continue;
            }
            this.mappingsMap.put(sourceName, mapping);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.mappings.size();
        for (int i = 0; i < size; ++i) {
            TypeMapping mapping = this.mappings.get(i);
            mapping.updateSyntax(reparser, false);
            reparser.updateLocation(mapping.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.mappings != null) {
            for (TypeMapping tm : this.mappings) {
                tm.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.mappings != null) {
            for (TypeMapping tm : this.mappings) {
                if (tm.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

