/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.UnivCharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_ModulePar_Template
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<default_template>";
    private static final String KIND = " template module parameter";
    private final Type type;
    private final TTCN3Template defaultTemplate;
    private ITTCN3Template realTemplate;

    public Def_ModulePar_Template(Identifier identifier, Type type, TTCN3Template defaultTemplate) {
        super(identifier);
        this.type = type;
        this.defaultTemplate = defaultTemplate;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_MODPAR_DEF, this);
            type.setFullNameParent(this);
        }
        if (defaultTemplate != null) {
            defaultTemplate.setFullNameParent(this);
        }
    }

    public ITTCN3Template getDefaultTemplate(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        return this.defaultTemplate;
    }

    public ITTCN3Template getRealTemplate(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        return this.realTemplate;
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_MODULEPAR_TEMPLATE;
    }

    public static String getKind() {
        return KIND;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.defaultTemplate == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.defaultTemplate != null) {
            this.defaultTemplate.setMyScope(scope);
        }
    }

    @Override
    public String getAssignmentName() {
        return "template module parameter";
    }

    @Override
    public String getOutlineIcon() {
        return "module_parameter.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isUsed = false;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionModuleParameter", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        if (this.type == null) {
            return;
        }
        this.type.setGenName("_T_", this.getGenName());
        this.type.check(timestamp);
        IType lastType = this.type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format("Module parameter can not be of port type `{0}''", lastType.getFullName()));
                break;
            }
            case TYPE_SIGNATURE: {
                this.location.reportSemanticError(MessageFormat.format("Module parameter can not be of signature type `{0}''", lastType.getFullName()));
                break;
            }
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                if (!((Function_Type)lastType).isRunsOnSelf()) break;
                this.location.reportSemanticError(MessageFormat.format("Module parameter can not be of function reference type `{0}'' which has runs on self clause", lastType.getFullName()));
                break;
            }
        }
        if (this.defaultTemplate != null) {
            this.realTemplate = this.defaultTemplate;
            this.realTemplate.setMyGovernor(this.type);
            if (this.defaultTemplate.getTemplatetype() == ITTCN3Template.Template_type.CSTR_PATTERN && lastType.getTypetype() == IType.Type_type.TYPE_UCHARSTRING) {
                this.realTemplate = this.defaultTemplate.setTemplatetype(timestamp, ITTCN3Template.Template_type.USTR_PATTERN);
                if (this.realTemplate instanceof UnivCharString_Pattern_Template) {
                    ((UnivCharString_Pattern_Template)this.realTemplate).getPatternstring().setPatterntype(PatternString.PatternType.UNIVCHARSTRING_PATTERN);
                }
            }
            ITTCN3Template temporalTemplate = this.type.checkThisTemplateRef(timestamp, this.realTemplate);
            temporalTemplate.checkThisTemplateGeneric(timestamp, this.type, false, true, true, true, false, null);
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Embedded circular recursion chain: `{0}''", true);
            tempReferenceChain.add(this);
            temporalTemplate.checkRecursions(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            this.defaultTemplate.setGenNameRecursive(this.getGenName());
            this.defaultTemplate.setCodeSection(GovernedSimple.CodeSectionType.CS_PRE_INIT);
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
    }

    @Override
    public String getProposalKind() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            this.type.getProposalDescription(builder);
        }
        builder.append(KIND);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public String getOutlineText() {
        StringBuilder text = new StringBuilder(this.getIdentifier().getDisplayName());
        text.append(" : ");
        text.append(this.type.getTypename());
        return text.toString();
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        if (this.defaultTemplate == null) {
            result.add(252);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.defaultTemplate != null) {
                if (enveloped) {
                    this.defaultTemplate.updateSyntax(reparser, false);
                    reparser.updateLocation(this.defaultTemplate.getLocation());
                } else if (reparser.envelopsDamage(this.defaultTemplate.getLocation())) {
                    this.defaultTemplate.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.defaultTemplate.getLocation());
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    this.withAttributesPath.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.defaultTemplate != null) {
            this.defaultTemplate.updateSyntax(reparser, false);
            reparser.updateLocation(this.defaultTemplate.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.defaultTemplate != null) {
            this.defaultTemplate.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.defaultTemplate == null || this.defaultTemplate.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        if (this.defaultTemplate != null) {
            this.defaultTemplate.setGenNameRecursive(genName);
        }
        aData.addBuiltinTypeImport("Param_Types");
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        if (!this.isLocal()) {
            if (VisibilityModifier.Private.equals((Object)this.getVisibilityModifier())) {
                source.append("private");
            } else {
                source.append("public");
            }
            source.append(" static ");
        }
        source.append("final ");
        String typeGeneratedName = this.type.getGenNameTemplate(aData, source);
        source.append(typeGeneratedName);
        source.append(' ');
        source.append(genName);
        source.append(" = new ");
        source.append(typeGeneratedName);
        source.append("();\n");
        if (this.defaultTemplate != null) {
            this.getLocation().update_location_object(aData, aData.getPreInit());
            this.defaultTemplate.generateCodeInit(aData, aData.getPreInit(), genName);
        }
        sb.append((CharSequence)source);
        StringBuilder moduleParamaterSetting = aData.getSetModuleParameters();
        moduleParamaterSetting.append(MessageFormat.format("if(par_name.equals(\"{0}\")) '{'\n", this.identifier.getDisplayName()));
        moduleParamaterSetting.append(MessageFormat.format("\t\t\t{0}.set_param(param);\n", genName));
        moduleParamaterSetting.append("\t\treturn true;\n");
        moduleParamaterSetting.append("\t\t} else ");
        StringBuilder moduleParamaterGetting = aData.getGetModuleParameters();
        moduleParamaterGetting.append(MessageFormat.format("if(par_name.equals(\"{0}\")) '{'\n", this.identifier.getDisplayName()));
        moduleParamaterGetting.append(MessageFormat.format("\t\t\treturn {0}.get_param(param_name);\n", genName));
        moduleParamaterGetting.append("\t\t} else ");
        StringBuilder moduleParamaterLogging = aData.getLogModuleParameters();
        if (moduleParamaterLogging.length() == 0) {
            moduleParamaterLogging.append(MessageFormat.format("\tTTCN_Logger.log_event_str(\"{0} := \");\n", this.identifier.getDisplayName()));
        } else {
            moduleParamaterLogging.append(MessageFormat.format("\t\t\tTTCN_Logger.log_event_str(\", {0} := \");\n", this.identifier.getDisplayName()));
        }
        moduleParamaterLogging.append(MessageFormat.format("\t\t\t{0}.log();\n", genName));
        StringBuilder listModulePars = aData.getListModulePars();
        listModulePars.append(MessageFormat.format("\t\tSystem.out.println(\"{0}.{1}\");\n", this.getMyScope().getModuleScope().getIdentifier().getDisplayName(), this.identifier.getDisplayName()));
    }

    @Override
    public void generateCodeString(JavaGenData aData, StringBuilder source) {
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
        aData.getSrc().append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        Type assType = this.getType(this.getLastTimeChecked());
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("template module parameter ");
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>").addStyledText(" ").addStyledText(this.getFullName(), 1);
        this.hoverContent.closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addMembersContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

