/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Continue_Statement
extends Statement {
    private static final String INCORRECTUSAGE = "Continue statement cannot be used outside loops";
    private static final String STATEMENT_NAME = "continue";
    private Statement loop_stmt;
    private AltGuards altGuards;

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CONTINUE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        if (pLoopStmt != null) {
            this.loop_stmt = pLoopStmt;
        }
        this.altGuards = pAltGuards;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.myStatementBlock == null || !this.myStatementBlock.hasEnclosingLoop()) {
            this.location.reportSemanticError(INCORRECTUSAGE);
        }
        if (this.loop_stmt != null) {
            if (this.altGuards != null) {
                // empty if block
            }
        } else {
            this.location.reportSemanticError(INCORRECTUSAGE);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.loop_stmt != null) {
            if (this.loop_stmt instanceof For_Statement) {
                For_Statement forStatment = (For_Statement)this.loop_stmt;
                forStatment.generateCodeStepAssigment(aData, source);
                source.append("continue;\n");
            } else if (this.loop_stmt instanceof DoWhile_Statement) {
                DoWhile_Statement doWhileStatement = (DoWhile_Statement)this.loop_stmt;
                doWhileStatement.generateCodeConditional(aData, source);
                source.append("continue;\n");
            } else {
                source.append("continue;\n");
            }
        } else {
            ErrorReporter.INTERNAL_ERROR((String)"Statement::generate_code_continue()");
        }
    }
}

