/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import java.util.Stack;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Referenced_Template
extends TTCN3Template {
    public static final String CIRCULARTEMPLATEREFERENCE = "circular template reference chain: `{0}''";
    private static final String TYPEMISSMATCH1 = "Type mismatch: a signature template of type `{0}'' was expected instead of `{1}''";
    private static final String TYPEMISSMATCH2 = "Type mismatch: a value or template of type `{0}'' was expected instead of `{1}''";
    private static final String INADEQUATETEMPLATERESTRICTION = "Inadequate restriction on the referenced {0} `{1}'', this may cause a dynamic test case error at runtime";
    private final Reference reference;

    public Referenced_Template(Reference reference) {
        this.reference = reference;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    public Referenced_Template(CompilationTimeStamp timestamp, SpecificValue_Template original) {
        this.copyGeneralProperties(original);
        IValue value = original.getSpecificValue();
        switch (value.getValuetype()) {
            case REFERENCED_VALUE: {
                this.reference = ((Referenced_Value)value).getReference();
                break;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                Identifier identifier = ((Undefined_LowerIdentifier_Value)value).getIdentifier();
                FieldSubReference subReference = new FieldSubReference(identifier);
                subReference.setLocation(value.getLocation());
                this.reference = new Reference(null);
                this.reference.addSubReference(subReference);
                this.reference.setLocation(value.getLocation());
                this.reference.setFullNameParent(this);
                this.reference.setMyScope(value.getMyScope());
                break;
            }
            default: {
                this.reference = null;
            }
        }
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.TEMPLATE_REFD;
    }

    @Override
    public String createStringRepresentation() {
        TTCN3Template last = this.getTemplateReferencedLast(CompilationTimeStamp.getBaseTimestamp());
        if (ITTCN3Template.Template_type.TEMPLATE_REFD.equals((Object)last.getTemplatetype())) {
            return this.reference.getDisplayName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(last.createStringRepresentation());
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public Location getLocation() {
        return new Location(this.reference.getLocation());
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous referenced template";
        }
        return "reference template";
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.reference != null) {
            this.reference.setCodeSection(codeSection);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return null;
        }
        IType type = assignment.getType(timestamp).getFieldType(timestamp, this.reference, 1, expectedValue, false);
        if (type == null) {
            this.setIsErroneous(true);
        }
        return type;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        IType type = this.getExpressionGovernor(timestamp, expectedValue);
        if (type == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return type.getTypeRefdLast(timestamp).getTypetypeTtcn3();
    }

    private ITTCN3Template getTemplateReferenced(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.reference == null) {
            this.setIsErroneous(true);
            return null;
        }
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass == null) {
            this.setIsErroneous(true);
            return this;
        }
        ITTCN3Template template = null;
        switch (ass.getAssignmentType()) {
            case A_TEMPLATE: {
                template = ((Def_Template)ass).getTemplate(timestamp);
                break;
            }
            case A_VAR_TEMPLATE: {
                ((Def_Var_Template)ass).check(timestamp);
                template = ((Def_Var_Template)ass).getInitialValue();
                break;
            }
            case A_MODULEPAR_TEMPLATE: {
                template = ((Def_ModulePar_Template)ass).getDefaultTemplate(timestamp);
                break;
            }
            default: {
                this.setIsErroneous(true);
                return this;
            }
        }
        if (template != null) {
            template = template.getReferencedSubTemplate(timestamp, this.reference, referenceChain, false);
        }
        List<ISubReference> subreferences = this.reference.getSubreferences();
        if (template != null) {
            return template;
        }
        if (subreferences == null || !this.reference.hasUnfoldableIndexSubReference(timestamp)) {
            if (this.reference.getUsedInIsbound()) {
                return this;
            }
            this.setIsErroneous(true);
        }
        return this;
    }

    @Override
    public TTCN3Template getTemplateReferencedLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.reference == null) {
            this.setIsErroneous(true);
            return this;
        }
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance(CIRCULARTEMPLATEREFERENCE, true) : referenceChain;
        TTCN3Template template = this;
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass != null) {
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: {
                    tempReferenceChain.markState();
                    if (tempReferenceChain.add(this)) {
                        ITTCN3Template refd = this.getTemplateReferenced(timestamp, tempReferenceChain);
                        if (refd != this) {
                            template = refd.getTemplateReferencedLast(timestamp, referenceChain);
                        }
                    } else {
                        this.setIsErroneous(true);
                    }
                    tempReferenceChain.previousState();
                    break;
                }
                case A_VAR_TEMPLATE: 
                case A_MODULEPAR_TEMPLATE: 
                case A_FUNCTION_RTEMP: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    return this;
                }
                default: {
                    this.setIsErroneous(true);
                    break;
                }
            }
        } else {
            this.setIsErroneous(true);
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        return template;
    }

    private boolean hasTemplateImpliciteOmit(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        Assignment ass;
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance(CIRCULARTEMPLATEREFERENCE, true) : referenceChain;
        boolean result = false;
        if (this.reference != null && (ass = this.reference.getRefdAssignment(timestamp, true)) != null && ass.getAssignmentType() == Assignment.Assignment_type.A_TEMPLATE) {
            Def_Template templateDefinition = (Def_Template)ass;
            if (templateDefinition.hasImplicitOmitAttribute(timestamp)) {
                result = true;
            } else {
                tempReferenceChain.markState();
                if (tempReferenceChain.add(this)) {
                    ITTCN3Template refd = this.getTemplateReferenced(timestamp, tempReferenceChain);
                    if (refd != this && refd instanceof Referenced_Template) {
                        result = ((Referenced_Template)refd).hasTemplateImpliciteOmit(timestamp, referenceChain);
                    }
                } else {
                    this.setIsErroneous(true);
                }
                tempReferenceChain.previousState();
            }
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        return result;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        TTCN3Template temp = this.getTemplateReferencedLast(timestamp);
        if (temp != this && !temp.getIsErroneous(timestamp)) {
            temp.checkSpecificValue(timestamp, allowOmit);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.reference != null) {
            ActualParameterList parameterList;
            ISubReference subReference = this.reference.getSubreferences().get(0);
            if (subReference instanceof ParameterisedSubReference && (parameterList = ((ParameterisedSubReference)subReference).getActualParameters()) != null) {
                parameterList.checkRecursions(timestamp, referenceChain);
            }
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            ITTCN3Template template = this.getTemplateReferenced(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (template != null && !template.getIsErroneous(timestamp) && !this.equals(template)) {
                template.checkRecursions(timestamp, referenceChain);
            }
        }
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        Assignment tempAssignment = this.reference.getRefdAssignment(timestamp, false);
        return tempAssignment == lhs;
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        TTCN3Template temp;
        if (this.getIsErroneous(timestamp) || this.reference == null) {
            return false;
        }
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return false;
        }
        boolean selfReference = lhs == assignment;
        assignment.check(timestamp);
        IType governor = assignment.getType(timestamp);
        if (governor != null) {
            governor = governor.getFieldType(timestamp, this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        }
        if (governor == null) {
            this.setIsErroneous(true);
            return selfReference;
        }
        TypeCompatibilityInfo info = new TypeCompatibilityInfo(type, governor, true);
        if (!type.isCompatible(timestamp, governor, info, null, null)) {
            IType last = type.getTypeRefdLast(timestamp);
            switch (last.getTypetype()) {
                case TYPE_PORT: {
                    break;
                }
                case TYPE_SIGNATURE: {
                    this.getLocation().reportSemanticError(MessageFormat.format(TYPEMISSMATCH1, type.getTypename(), governor.getTypename()));
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    if (info.getSubtypeError() == null) {
                        String errorString = info.getErrorStringString();
                        if (errorString == null) {
                            this.getLocation().reportSemanticError(MessageFormat.format(TYPEMISSMATCH2, type.getTypename(), governor.getTypename()));
                        } else {
                            this.getLocation().reportSemanticError(errorString);
                        }
                    } else {
                        this.getLocation().reportSemanticError(info.getSubtypeError());
                    }
                    this.setIsErroneous(true);
                    break;
                }
            }
        } else if (info.getNeedsConversion()) {
            this.set_needs_conversion();
        }
        if ((temp = this.getTemplateReferencedLast(timestamp)) != this) {
            ReferenceChain referenceChain = ReferenceChain.getInstance(CIRCULARTEMPLATEREFERENCE, true);
            boolean referencedHasImplicitOmit = this.hasTemplateImpliciteOmit(timestamp, referenceChain);
            referenceChain.release();
        }
        return selfReference;
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        TTCN3Template last = this.getTemplateReferencedLast(timestamp);
        last.checkTemplateSpecificLengthRestriction(timestamp, typeType);
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (this.reference == null) {
            if (omitAllowed) {
                this.checkRestrictionCommon(timestamp, this.getTemplateTypeName(), TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
            } else {
                this.checkRestrictionCommon(timestamp, this.getTemplateTypeName(), TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
            }
        } else {
            TTCN3Template templateLast;
            Assignment ass = this.reference.getRefdAssignment(timestamp, true);
            if (Assignment.Assignment_type.A_TEMPLATE == ass.getAssignmentType() && !this.equals(templateLast = this.getTemplateReferencedLast(timestamp))) {
                templateLast.checkValueomitRestriction(timestamp, this.getTemplateTypeName(), omitAllowed, usageLocation);
            }
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: 
                case A_VAR_TEMPLATE: 
                case A_FUNCTION_RTEMP: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: 
                case A_EXT_FUNCTION_RTEMP: {
                    if (ass instanceof Definition) {
                        TemplateRestriction.Restriction_type refdTemplateRestriction = ((Definition)ass).getTemplateRestriction();
                        if (TemplateRestriction.isLessRestrictive(omitAllowed ? TemplateRestriction.Restriction_type.TR_OMIT : TemplateRestriction.Restriction_type.TR_VALUE, refdTemplateRestriction = TemplateRestriction.getSubRestriction(refdTemplateRestriction, timestamp, this.reference))) {
                            this.getLocation().reportSemanticWarning(MessageFormat.format(INADEQUATETEMPLATERESTRICTION, ass.getAssignmentName(), this.reference.getDisplayName()));
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        if (this.reference != null) {
            Assignment ass = this.reference.getRefdAssignment(timestamp, true);
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: {
                    TTCN3Template templateLast = this.getTemplateReferencedLast(timestamp);
                    return templateLast.checkPresentRestriction(timestamp, definitionName, usageLocation);
                }
                case A_VAR_TEMPLATE: 
                case A_FUNCTION_RTEMP: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: 
                case A_EXT_FUNCTION_RTEMP: {
                    if (ass instanceof Definition) {
                        TemplateRestriction.Restriction_type refdTemplateRestriction = ((Definition)ass).getTemplateRestriction();
                        if (TemplateRestriction.isLessRestrictive(TemplateRestriction.Restriction_type.TR_PRESENT, refdTemplateRestriction = TemplateRestriction.getSubRestriction(refdTemplateRestriction, timestamp, this.reference))) {
                            this.getLocation().reportSemanticWarning(MessageFormat.format(INADEQUATETEMPLATERESTRICTION, ass.getAssignmentName(), this.reference.getDisplayName()));
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.reference == null) {
            return;
        }
        this.reference.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.reference == null || this.reference.accept(v);
    }

    @Override
    public boolean hasSingleExpression() {
        if (this.lengthRestriction != null || this.isIfpresent || this.get_needs_conversion()) {
            return false;
        }
        TTCN3Template lastTemplate = this.getTemplateReferencedLast(CompilationTimeStamp.getBaseTimestamp());
        if (lastTemplate != null && lastTemplate != this && lastTemplate.hasSingleExpression()) {
            for (Scope tempScope = this.myScope; tempScope != null; tempScope = tempScope.getParentScope()) {
                if (tempScope != lastTemplate.getMyScope()) continue;
                return true;
            }
        }
        return this.reference.hasSingleExpression();
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass == null) {
            return true;
        }
        switch (ass.getAssignmentType()) {
            case A_EXT_CONST: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_VAR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        StringBuilder result = new StringBuilder();
        if (castIsNeeded && (this.lengthRestriction != null || this.isIfpresent)) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing referenced template `" + this.getFullName() + "''"));
            return result;
        }
        ExpressionStruct expression = new ExpressionStruct();
        this.reference.generateCode(aData, expression);
        if (expression.preamble.length() > 0 || expression.postamble.length() > 0) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing referenced template `" + this.getFullName() + "''"));
            return result;
        }
        result.append((CharSequence)expression.expression);
        return result;
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, TemplateRestriction.Restriction_type templateRestriction) {
        if (this.lengthRestriction == null && !this.isIfpresent && templateRestriction == TemplateRestriction.Restriction_type.TR_NONE) {
            if (this.hasSingleExpression()) {
                expression.expression.append((CharSequence)this.getSingleExpression(aData, true));
                return;
            }
            if (this.get_needs_conversion()) {
                ExpressionStruct tempExpr = new ExpressionStruct();
                IType currentType = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType referencedType = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false).getType(CompilationTimeStamp.getBaseTimestamp()).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType referencedFieldType = referencedType.getFieldType(CompilationTimeStamp.getBaseTimestamp(), this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                ExpressionStruct refExpr = new ExpressionStruct();
                this.reference.generateConstRef(aData, refExpr);
                if (refExpr.preamble.length() > 0) {
                    expression.preamble.append((CharSequence)refExpr.preamble);
                }
                String tempId2 = currentType.generateConversion(aData, referencedFieldType, refExpr.expression.toString(), false, tempExpr);
                tempExpr.openMergeExpression(expression.preamble);
                expression.expression.append(tempId2);
            } else {
                this.reference.generateCode(aData, expression);
            }
            return;
        }
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            return;
        }
        String tempId = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", governor.getGenNameTemplate(aData, expression.expression), tempId));
        this.generateCodeInit(aData, expression.preamble, tempId);
        if (templateRestriction != TemplateRestriction.Restriction_type.TR_NONE) {
            TemplateRestriction.generateRestrictionCheckCode(aData, expression.preamble, this.location, tempId, templateRestriction);
        }
        expression.expression.append(tempId);
    }

    private boolean useSingleExpressionForInit() {
        TTCN3Template lastTemplate = this.getTemplateReferencedLast(CompilationTimeStamp.getBaseTimestamp());
        if (lastTemplate.getTemplatetype().equals((Object)ITTCN3Template.Template_type.TEMPLATE_REFD)) {
            return false;
        }
        if (lastTemplate.getMyScope().getModuleScopeGen() != this.myScope.getModuleScopeGen()) {
            return false;
        }
        if (!lastTemplate.hasSingleExpression()) {
            return false;
        }
        return !lastTemplate.getTemplatetype().equals((Object)ITTCN3Template.Template_type.SPECIFIC_VALUE);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        Assignment assignment;
        ActualParameterList actualParameterList;
        ISubReference tempSubreference = this.reference.getSubreferences().get(0);
        if (tempSubreference instanceof ParameterisedSubReference && (actualParameterList = ((ParameterisedSubReference)tempSubreference).getActualParameters()) != null) {
            actualParameterList.reArrangeInitCode(aData, source, usageModule);
        }
        if ((assignment = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false)).getAssignmentType() != Assignment.Assignment_type.A_TEMPLATE) {
            return;
        }
        ITTCN3Template template = ((Def_Template)assignment).getTemplate(CompilationTimeStamp.getBaseTimestamp());
        FormalParameterList formalParameterList = ((Def_Template)assignment).getFormalParameterList();
        if (formalParameterList != null) {
            template.reArrangeInitCode(aData, source, usageModule);
            if (assignment.getMyScope().getModuleScopeGen() == usageModule) {
                formalParameterList.generateCodeDefaultValues(aData, source);
            }
        } else {
            List<ISubReference> subReferences = this.reference.getSubreferences();
            if (subReferences != null && subReferences.size() > 1) {
                for (int i = 1; i < subReferences.size(); ++i) {
                    ISubReference subReference = subReferences.get(i);
                    if (subReference instanceof FieldSubReference) {
                        if (template.getTemplatetype() != ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST) break;
                        Identifier fieldId = ((FieldSubReference)subReference).getId();
                        template = ((Named_Template_List)template).getNamedTemplate(fieldId).getTemplate();
                        continue;
                    }
                    if (template.getTemplatetype() != ITTCN3Template.Template_type.TEMPLATE_LIST) break;
                    IValue arrayIndex = ((ArraySubReference)subReference).getValue();
                    ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    arrayIndex = arrayIndex.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
                    referenceChain.release();
                    if (arrayIndex.getValuetype() != IValue.Value_type.INTEGER_VALUE) break;
                    long index = ((Integer_Value)arrayIndex).getValue();
                    if (template.getMyGovernor().getTypetype() == IType.Type_type.TYPE_ARRAY) {
                        index -= ((Array_Type)template.getMyGovernor()).getDimension().getOffset();
                    }
                    template = ((Template_List)template).getTemplateByIndex((int)index);
                }
            }
            if (assignment.getMyScope().getModuleScopeGen() == usageModule) {
                template.generateCodeInit(aData, source, template.get_lhs_name());
            }
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.reArrangeInitCode(aData, source, usageModule);
        }
    }

    private void generateRearrangeInitCodeReferenced(JavaGenData aData, StringBuilder source, ExpressionStruct expression) {
        ISubReference subReference;
        Stack<ISubReference> referenceStack = new Stack<ISubReference>();
        ITTCN3Template template = this;
        while (true) {
            if (template.getTemplatetype() == ITTCN3Template.Template_type.TEMPLATE_REFD) {
                Reference reference = ((Referenced_Template)template).getReference();
                Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (assignment.getAssignmentType() != Assignment.Assignment_type.A_TEMPLATE || ((Def_Template)assignment).getFormalParameterList() != null || assignment.getMyScope().getModuleScopeGen() != this.myScope.getModuleScopeGen()) break;
                List<ISubReference> subReferences = reference.getSubreferences();
                if (subReferences != null && subReferences.size() > 1) {
                    for (int i = subReferences.size(); i > 1; --i) {
                        referenceStack.push(subReferences.get(i - 1));
                    }
                }
                template = ((Def_Template)assignment).getTemplate(CompilationTimeStamp.getBaseTimestamp());
                continue;
            }
            if (referenceStack.isEmpty()) break;
            subReference = (ISubReference)referenceStack.peek();
            if (subReference instanceof FieldSubReference) {
                if (template.getTemplatetype() != ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST) break;
                Identifier fieldId = ((FieldSubReference)subReference).getId();
                template = ((Named_Template_List)template).getNamedTemplate(fieldId).getTemplate();
            } else {
                if (template.getTemplatetype() != ITTCN3Template.Template_type.TEMPLATE_LIST) break;
                IValue arrayIndex = ((ArraySubReference)subReference).getValue();
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                arrayIndex = arrayIndex.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
                referenceChain.release();
                if (arrayIndex.getValuetype() != IValue.Value_type.INTEGER_VALUE) break;
                long index = ((Integer_Value)arrayIndex).getValue();
                if (template.getMyGovernor().getTypetype() == IType.Type_type.TYPE_ARRAY) {
                    index -= ((Array_Type)template.getMyGovernor()).getDimension().getOffset();
                }
                template = ((Template_List)template).getTemplateByIndex((int)index);
            }
            referenceStack.pop();
        }
        template.generateCodeInit(aData, source, template.get_lhs_name());
        expression.expression.append(template.getGenNameOwn(aData));
        while (!referenceStack.isEmpty()) {
            subReference = (ISubReference)referenceStack.pop();
            if (subReference instanceof FieldSubReference) {
                expression.expression.append(MessageFormat.format(".get_field_{0}()", FieldSubReference.getJavaGetterName(((FieldSubReference)subReference).getId().getName())));
                continue;
            }
            expression.expression.append(".get_at(");
            ((ArraySubReference)subReference).getValue().generateCodeExpression(aData, expression, false);
            expression.expression.append(')');
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        ExpressionStruct tempExpr;
        Assignment assignment;
        this.lastTimeBuilt = aData.getBuildTimstamp();
        if (this.useSingleExpressionForInit() && this.hasSingleExpression()) {
            source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, this.getSingleExpression(aData, false)));
            return;
        }
        ExpressionStruct expression = new ExpressionStruct();
        boolean useReferenceForCodegeneration = true;
        if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT && (assignment = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false)).getAssignmentType() == Assignment.Assignment_type.A_TEMPLATE) {
            if (((Def_Template)assignment).getFormalParameterList() != null) {
                this.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            } else if (assignment.getMyScope().getModuleScopeGen() == this.myScope.getModuleScopeGen()) {
                this.generateRearrangeInitCodeReferenced(aData, source, expression);
                useReferenceForCodegeneration = false;
            }
        }
        if (useReferenceForCodegeneration) {
            this.reference.generateConstRef(aData, expression);
        }
        if (expression.preamble.length() > 0 || expression.postamble.length() > 0) {
            source.append("{\n");
            source.append((CharSequence)expression.preamble);
            if (this.get_needs_conversion()) {
                tempExpr = new ExpressionStruct();
                IType currentType = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType referencedType = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false).getType(CompilationTimeStamp.getBaseTimestamp()).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType referencedFieldType = referencedType.getFieldType(CompilationTimeStamp.getBaseTimestamp(), this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                ExpressionStruct refExpr = new ExpressionStruct();
                this.reference.generateConstRef(aData, refExpr);
                if (refExpr.preamble.length() > 0) {
                    source.append((CharSequence)refExpr.preamble);
                }
                String tempId2 = currentType.generateConversion(aData, referencedFieldType, refExpr.expression.toString(), false, tempExpr);
                tempExpr.openMergeExpression(source);
                source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, tempId2));
            } else {
                source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, expression.expression));
            }
            source.append((CharSequence)expression.postamble);
            source.append("}\n");
        } else if (this.get_needs_conversion()) {
            tempExpr = new ExpressionStruct();
            IType currentType = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            IType referencedType = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false).getType(CompilationTimeStamp.getBaseTimestamp()).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            IType referencedFieldType = referencedType.getFieldType(CompilationTimeStamp.getBaseTimestamp(), this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            ExpressionStruct refExpr = new ExpressionStruct();
            this.reference.generateConstRef(aData, refExpr);
            if (refExpr.preamble.length() > 0) {
                source.append((CharSequence)refExpr.preamble);
            }
            String tempId2 = currentType.generateConversion(aData, referencedFieldType, refExpr.expression.toString(), false, tempExpr);
            tempExpr.openMergeExpression(source);
            source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, tempId2));
        } else {
            source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, expression.expression));
        }
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
    }
}

