/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ExternalConst;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Component_Type
extends Type {
    private static final String COMPONENT_GIF = "component.gif";
    private static final String COMPONENTVALUEEXPECTED = "Component value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `{0}''";
    private static final String INVALIDSUBREFERENCE = "Referencing fields of a component is not allowed";
    public static final String[] SIMPLE_COMPONENT_PROPOSALS = new String[]{"alive", "create;", "create alive;", "done", "kill;", "killed", "running", "stop;"};
    private static final String[] ANY_COMPONENT_PROPOSALS = new String[]{"running", "alive", "done", "killed"};
    private static final String[] ALL_COMPONENT_PROPOSALS = new String[]{"running", "alive", "done", "killed", "stop;", "kill;"};
    private final ComponentTypeBody componentBody;

    public Component_Type(ComponentTypeBody component) {
        this.componentBody = component;
        if (this.componentBody != null) {
            this.componentBody.setFullNameParent(this);
            this.componentBody.setMyType(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_COMPONENT;
    }

    public ComponentTypeBody getComponentBody() {
        return this.componentBody;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.componentBody.setMyScope(scope);
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
        super.setAttributeParentPath(parent);
        this.componentBody.setAttributeParentPath(this.withAttributesPath);
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("component");
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        return IType.Type_type.TYPE_COMPONENT.equals((Object)temp.getTypetype()) && this.componentBody.isCompatible(timestamp, ((Component_Type)temp).componentBody);
    }

    @Override
    public boolean isCompatibleByPort(CompilationTimeStamp timestamp, IType otherType) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType t2 = otherType.getTypeRefdLast(timestamp);
        if (t2.getTypetype() != IType.Type_type.TYPE_COMPONENT) {
            return false;
        }
        if (this.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return false;
        }
        ComponentTypeBody b2 = ((Component_Type)t2).getComponentBody();
        Assignments b1Assignments = this.componentBody.getAssignmentsScope();
        for (int i = 0; i < b1Assignments.getNofAssignments(); ++i) {
            Assignment assignment = b1Assignments.getAssignmentByIndex(i);
            if (assignment.getAssignmentType() != Assignment.Assignment_type.A_PORT) continue;
            IType portType = assignment.getType(timestamp).getTypeRefdLast(timestamp);
            Identifier identifier = assignment.getIdentifier();
            boolean found = false;
            Assignments b2Assignments = b2.getAssignmentsScope();
            for (int j = 0; j < b2Assignments.getNofAssignments(); ++j) {
                Assignment assignment2 = b2Assignments.getAssignmentByIndex(j);
                Identifier identifier2 = assignment2.getIdentifier();
                if (!identifier.equals(identifier2) || assignment2.getAssignmentType() != Assignment.Assignment_type.A_PORT) continue;
                IType portType2 = assignment2.getType(timestamp).getTypeRefdLast(timestamp);
                if (portType.equals(portType2)) {
                    found = true;
                    break;
                }
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return COMPONENT_GIF;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.initAttributes(timestamp);
        this.componentBody.check(timestamp);
        this.lastTimeChecked = timestamp;
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case TTCN3_NULL_VALUE: {
                value.setValuetype(timestamp, IValue.Value_type.EXPRESSION_VALUE);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(COMPONENTVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format(INVALIDSUBREFERENCE, ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        this.componentBody.addProposal(propCollector, i);
        if (subrefs.size() == i + 1) {
            for (String proposal : SIMPLE_COMPONENT_PROPOSALS) {
                propCollector.addProposal(proposal, proposal, ImageCache.getImage(this.getOutlineIcon()), "");
            }
            propCollector.addTemplateProposal("create", new Template("create( name )", "", propCollector.getContextIdentifier(), "create( ${name} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("create", new Template("create( name ) alive", "", propCollector.getContextIdentifier(), "create( ${name} ) alive;", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("create", new Template("create( name, location )", "", propCollector.getContextIdentifier(), "create( ${name}, ${location} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("create", new Template("create( name, location ) alive", "", propCollector.getContextIdentifier(), "create( ${name}, ${location} ) alive;", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("start", new Template("start( function name )", "", propCollector.getContextIdentifier(), "start( ${functionName} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    public static void addAnyorAllProposal(ProposalCollector propCollector, int i) {
        block4: {
            String fakeModuleName;
            block3: {
                List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
                if (i != 0 || subrefs.isEmpty() || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(0).getReferenceType())) {
                    return;
                }
                fakeModuleName = propCollector.getReference().getModuleIdentifier().getDisplayName();
                if (!"any component".equals(fakeModuleName)) break block3;
                for (String proposal : ANY_COMPONENT_PROPOSALS) {
                    propCollector.addProposal(proposal, proposal, ImageCache.getImage(COMPONENT_GIF), "");
                }
                break block4;
            }
            if (!"all component".equals(fakeModuleName)) break block4;
            for (String proposal : ALL_COMPONENT_PROPOSALS) {
                propCollector.addProposal(proposal, proposal, ImageCache.getImage(COMPONENT_GIF), "");
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        this.componentBody.addDeclaration(declarationCollector, i);
    }

    @Override
    public Object[] getOutlineChildren() {
        return this.componentBody.getDefinitions().toArray();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            if (this.componentBody != null && reparser.envelopsDamage(this.componentBody.getLocation())) {
                this.componentBody.updateSyntax(reparser, true);
                reparser.updateLocation(this.componentBody.getLocation());
                handled = true;
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        this.componentBody.updateSyntax(reparser, false);
        reparser.updateLocation(this.componentBody.getLocation());
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    public static IType checkExpressionOperandComponentRefernce(CompilationTimeStamp timestamp, IValue value, String operationName, boolean anyFrom) {
        switch (value.getValuetype()) {
            case EXPRESSION_VALUE: {
                Expression_Value expression = (Expression_Value)value;
                if (Expression_Value.Operation_type.APPLY_OPERATION.equals((Object)expression.getOperationType())) {
                    ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IValue last = value.getValueRefdLast(timestamp, chain);
                    chain.release();
                    if (last == null || last.getIsErroneous(timestamp)) {
                        value.setIsErroneous(true);
                        return null;
                    }
                    IType returnValue = last.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                    if (returnValue == null) {
                        value.setIsErroneous(true);
                        return null;
                    }
                    IType type = returnValue.getTypeRefdLast(timestamp);
                    if (type.getIsErroneous(timestamp)) {
                        value.setIsErroneous(true);
                        return null;
                    }
                    if (anyFrom) {
                        if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                            type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                        }
                        if (!IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) {
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                    } else if (!IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) {
                        value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return null;
                    }
                    return returnValue;
                }
                return null;
            }
            case REFERENCED_VALUE: {
                IType returnValue;
                Reference reference = ((Referenced_Value)value).getReference();
                Assignment assignment = reference.getRefdAssignment(timestamp, true);
                if (assignment == null) {
                    value.setIsErroneous(true);
                    return null;
                }
                switch (assignment.getAssignmentType()) {
                    case A_CONST: {
                        IValue tempValue;
                        returnValue = ((Def_Const)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (returnValue == null) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        IType type = returnValue.getTypeRefdLast(timestamp);
                        if (type.getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (anyFrom) {
                            if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                            while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                            }
                            if (!IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                        } else if (!IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) {
                            reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if ((tempValue = ((Def_Const)assignment).getValue()) == null) {
                            return null;
                        }
                        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                        tempValue = tempValue.getReferencedSubValue(timestamp, reference, 1, chain);
                        chain.release();
                        if (tempValue == null) {
                            return null;
                        }
                        chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                        tempValue = tempValue.getValueRefdLast(timestamp, chain);
                        chain.release();
                        if (IValue.Value_type.TTCN3_NULL_VALUE.equals((Object)tempValue.getValuetype())) {
                            reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the `null'' component reference", operationName));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (!IValue.Value_type.EXPRESSION_VALUE.equals((Object)tempValue.getValuetype())) {
                            return null;
                        }
                        switch (((Expression_Value)tempValue).getOperationType()) {
                            case MTC_COMPONENT_OPERATION: {
                                reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the component reference of the `mtc''", operationName));
                                value.setIsErroneous(true);
                                return null;
                            }
                            case COMPONENT_NULL_OPERATION: {
                                reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the `null'' component reference", operationName));
                                value.setIsErroneous(true);
                                return null;
                            }
                            case SYSTEM_COMPONENT_OPERATION: {
                                reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the component reference of the `system''", operationName));
                                value.setIsErroneous(true);
                                return null;
                            }
                        }
                        break;
                    }
                    case A_EXT_CONST: {
                        returnValue = ((Def_ExternalConst)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (returnValue == null) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        IType type = returnValue.getTypeRefdLast(timestamp);
                        if (type.getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (anyFrom) {
                            if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                            while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                            }
                            if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return null;
                    }
                    case A_MODULEPAR: {
                        returnValue = ((Def_ModulePar)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (returnValue == null) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        IType type = returnValue.getTypeRefdLast(timestamp);
                        if (type.getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (anyFrom) {
                            if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                            while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                            }
                            if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return null;
                    }
                    case A_VAR: {
                        returnValue = ((Def_Var)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (returnValue == null) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        IType type = returnValue.getTypeRefdLast(timestamp);
                        if (type.getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (anyFrom) {
                            if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                            while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                            }
                            if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return null;
                    }
                    case A_FUNCTION_RVAL: {
                        returnValue = ((Def_Function)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (returnValue == null) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        IType type = returnValue.getTypeRefdLast(timestamp);
                        if (type.getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (anyFrom) {
                            if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                            while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                            }
                            if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return null;
                    }
                    case A_EXT_FUNCTION_RVAL: {
                        returnValue = ((Def_Extfunction)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (returnValue == null) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        IType type = returnValue.getTypeRefdLast(timestamp);
                        if (type.getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (anyFrom) {
                            if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                            while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                            }
                            if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return null;
                    }
                    case A_PAR_VAL: 
                    case A_PAR_VAL_IN: 
                    case A_PAR_VAL_OUT: 
                    case A_PAR_VAL_INOUT: {
                        returnValue = ((FormalParameter)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (returnValue == null) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        IType type = returnValue.getTypeRefdLast(timestamp);
                        if (type.getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (anyFrom) {
                            if (!IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of `{1}''", operationName, type.getTypename()));
                                value.setIsErroneous(true);
                                return null;
                            }
                            while (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
                                type = ((Array_Type)type).getElementType().getTypeRefdLast(timestamp);
                            }
                            if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                            value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component array reference was expected instead of array of type `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return null;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return null;
                    }
                    default: {
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' should be a component reference instead of `{1}''", operationName, assignment.getDescription()));
                        value.setIsErroneous(true);
                        return null;
                    }
                }
                return returnValue;
            }
        }
        return null;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        errorLocation.reportSemanticError("The `map'/`unmap' parameters of a port type cannot be or contain a field/element of component type");
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.componentBody != null) {
            this.componentBody.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.componentBody == null || this.componentBody.accept(v);
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.getGenNameTemplate(aData, source)));
        } else {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
        if (this.hasDoneAttribute()) {
            this.generateCodeDone(aData, source);
        }
        if (this.subType != null) {
            this.subType.generateCode(aData, source);
        }
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanComponent");
        return "TitanComponent";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanComponent_template");
        return "TitanComponent_template";
    }

    @Override
    public void generateCodeTypedescriptor(JavaGenData aData, StringBuilder source, StringBuilder localTarget, Map<String, String> attributeRegistry) {
        aData.addBuiltinTypeImport("Base_Type.TTCN_Typedescriptor");
        String genname = this.getGenNameOwn();
        String descriptorName = MessageFormat.format("{0}_descr_", genname);
        if (localTarget == null && aData.hasGlobalVariable(descriptorName)) {
            return;
        }
        String globalVariable = MessageFormat.format("\t\tpublic static final TTCN_Typedescriptor {0}_descr_ = {1}_descr_;\n", genname, this.getGenNameValue(aData, source));
        if (localTarget == null) {
            aData.addGlobalVariable(descriptorName, globalVariable);
        } else {
            localTarget.append(globalVariable);
        }
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp()) || this.hasEncodeAttribute("JSON")) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        aData.addBuiltinTypeImport("TitanComponent");
        return "TitanComponent.TitanComponent";
    }
}

