/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.values.ISO2022String_Value;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.UniversalCharstring_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalChar;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class UniversalCharstring_Value
extends Value {
    public static final String ISOCONVERTION = "ISO-10646 string value cannot be converted to ISO-2022 string";
    private final UniversalCharstring value;

    public UniversalCharstring_Value(UniversalCharstring value) {
        this.value = value;
    }

    protected UniversalCharstring_Value(Charstring_Value original) {
        this.copyGeneralProperties(original);
        this.value = new UniversalCharstring(original.getValue(), original.getLocation());
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.UNIVERSALCHARSTRING_VALUE;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_UCHARSTRING;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('\"').append(this.value.getStringRepresentation()).append('\"');
        return builder.toString();
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new UniversalCharstring_Type();
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value arrayIndex = ((ArraySubReference)subreference).getValue();
                IValue valueIndex = arrayIndex.getValueRefdLast(timestamp, refChain);
                if (!valueIndex.isUnfoldable(timestamp)) {
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)valueIndex.getValuetype())) {
                        int index = ((Integer_Value)valueIndex).intValue();
                        return this.getStringElement(index, arrayIndex.getLocation());
                    }
                    arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                    return null;
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    public UniversalCharstring getValue() {
        return this.value;
    }

    public int getValueLength() {
        if (this.value == null || this.isErroneous) {
            return 0;
        }
        return this.value.length();
    }

    public UniversalCharstring_Value getStringElement(int index, Location location) {
        if (this.value == null) {
            return null;
        }
        if (index < 0) {
            location.reportSemanticError(MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a string element", index));
            return null;
        }
        if (index >= this.value.length()) {
            location.reportSemanticError(MessageFormat.format("Index overflow when accessing a string element: the index is {0}, but the string has only {1} elements", index, this.value.length()));
            return null;
        }
        UniversalCharstring_Value result = new UniversalCharstring_Value(this.value.substring(index, index + 1));
        result.setMyGovernor(this.myGovernor);
        result.setMyScope(this.myScope);
        return result;
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        switch (newType) {
            case CHARSTRING_VALUE: {
                return Charstring_Value.convert(timestamp, this);
            }
            case ISO2022STRING_VALUE: {
                this.location.reportSemanticError(ISOCONVERTION);
                this.setIsErroneous(true);
                return this;
            }
        }
        return super.setValuetype(timestamp, newType);
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        switch (last.getValuetype()) {
            case CHARSTRING_VALUE: {
                return this.value.checkEquality(((Charstring_Value)last).getValue());
            }
            case UNIVERSALCHARSTRING_VALUE: {
                return this.value.checkEquality(((UniversalCharstring_Value)last).getValue());
            }
            case ISO2022STRING_VALUE: {
                return this.value.checkEquality(((ISO2022String_Value)last).getValueISO2022String());
            }
        }
        return false;
    }

    public boolean checkDynamicEncodingString(CompilationTimeStamp timestamp, IType type) {
        IType ct = type.getTypeWithCodingTable(timestamp, false);
        if (ct == null) {
            return false;
        }
        boolean errorFound = false;
        for (int i = 0; i < this.value.length(); ++i) {
            UniversalChar temp = this.value.get(i);
            if (temp.group() == 0 && temp.plane() == 0 && temp.row() == 0) continue;
            errorFound = true;
            break;
        }
        if (!errorFound) {
            String str = this.value.getString();
            IType.MessageEncoding_type coding = Type.getEncodingType(str);
            boolean builtIn = !coding.equals((Object)IType.MessageEncoding_type.PER) && !coding.equals((Object)IType.MessageEncoding_type.CUSTOM);
            errorFound = true;
            List<IType.Coding_Type> codingTable = ct.getCodingTable();
            for (int i = 0; i < codingTable.size(); ++i) {
                IType.Coding_Type temp = codingTable.get(i);
                if (builtIn != temp.builtIn || (!builtIn || coding != temp.builtInCoding) && (builtIn || !str.equals(temp.customCoding.name))) continue;
                errorFound = false;
                break;
            }
        }
        return errorFound;
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        aData.addBuiltinTypeImport("TitanUniversalCharString");
        StringBuilder result = new StringBuilder();
        result.append(MessageFormat.format("new TitanUniversalCharString({0})", this.value.generateSingleExpression(aData)));
        return result;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        aData.addBuiltinTypeImport("TitanUniversalCharString");
        source.append(MessageFormat.format("{0}.operator_assign(new TitanUniversalCharString({1}));\n", name, this.value.generateSingleExpression(aData)));
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }
}

