/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandler;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandlerAFTRerences;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandlerComponent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class AssignmentHandlerFactory {
    private AssignmentHandlerFactory() {
    }

    public static AssignmentHandler getDefinitionHandler(Assignment assignment) {
        switch (assignment.getAssignmentType()) {
            case A_ALTSTEP: 
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: 
            case A_FUNCTION_RVAL: 
            case A_TESTCASE: {
                return new AssignmentHandlerAFTRerences(assignment);
            }
            case A_TYPE: {
                IType type = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
                if (type instanceof Component_Type) {
                    return new AssignmentHandlerComponent(assignment);
                }
                return new AssignmentHandlerAFTRerences(assignment);
            }
        }
        return new AssignmentHandlerAFTRerences(assignment);
    }
}

