/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.compiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.titan.common.utils.CommentUtils;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public final class ProjectSourceCompiler {
    private static final String PACKAGE_RUNTIME_ROOT = "org.eclipse.titan.runtime.core";

    private ProjectSourceCompiler() {
    }

    public static String getPackageRuntimeRoot() {
        return PACKAGE_RUNTIME_ROOT;
    }

    public static String getPackageGeneratedRoot(IProject project) {
        String projectName = project.getName().replaceAll("[^\\p{IsAlphabetic}^\\p{IsDigit}]", "_");
        return MessageFormat.format("org.eclipse.titan.{0}.generated", projectName);
    }

    public static String getPackageUserProvidedRoot(IProject project) {
        String projectName = project.getName().replaceAll("[^\\p{IsAlphabetic}^\\p{IsDigit}]", "_");
        return MessageFormat.format("org.eclipse.titan.{0}.user_provided", projectName);
    }

    public static String getGeneratedRoot(IProject project) {
        String projectName = project.getName().replaceAll("[^\\p{IsAlphabetic}^\\p{IsDigit}]", "_");
        return MessageFormat.format("java_src/org/eclipse/titan/{0}/generated", projectName);
    }

    public static String getUserProvidedRoot(IProject project) {
        String projectName = project.getName().replaceAll("[^\\p{IsAlphabetic}^\\p{IsDigit}]", "_");
        return MessageFormat.format("user_provided/org/eclipse/titan/{0}/user_provided", projectName);
    }

    public static void generateSourceFolder(IProject project) throws CoreException {
        IFolder folder = project.getFolder(ProjectSourceCompiler.getGeneratedRoot(project));
        FileUtils.createDir((IFolder)folder);
    }

    public static boolean compile(BuildTimestamp timestamp, Module aModule, boolean aDebug) throws CoreException {
        IResource sourceFile = aModule.getLocation().getFile();
        if (MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySyntacticMarker", sourceFile, 2) || MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflyMixedMarker", sourceFile) || MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySemanticMarker", sourceFile, 2)) {
            return false;
        }
        JavaGenData data = new JavaGenData(aModule, timestamp);
        data.collectProjectSettings(aModule.getLocation());
        data.setDebug(aDebug);
        aModule.generateCode(data);
        if (data.getAddSourceInfo() && (data.getPreInit().length() > 0 || data.getPostInit().length() > 0)) {
            data.addCommonLibraryImport("TTCN_Logger.TTCN_Location");
            data.addCommonLibraryImport("TTCN_Logger.TTCN_Location.entity_type_t");
        }
        if (data.getStartPTCFunction().length() > 0) {
            data.addBuiltinTypeImport("Text_Buf");
        }
        IProject project = aModule.getProject();
        StringBuilder sourceCode = new StringBuilder();
        ProjectSourceCompiler.writeHeader(project, sourceCode, data);
        sourceCode.append((CharSequence)data.getGlobalVariables());
        sourceCode.append('\n');
        sourceCode.append((CharSequence)data.getConstructor());
        for (StringBuilder typeString : data.getTypes().values()) {
            sourceCode.append((CharSequence)typeString);
        }
        for (String typeConversion : data.getTypesConversions().values()) {
            sourceCode.append(typeConversion);
        }
        sourceCode.append((CharSequence)data.getSrc());
        ProjectSourceCompiler.writeFooter(data, sourceCode, sourceFile, aModule);
        IFolder folder = project.getFolder(ProjectSourceCompiler.getGeneratedRoot(project));
        IFile file = folder.getFile(aModule.getName() + ".java");
        FileUtils.createDir((IFolder)folder);
        String content = sourceCode.toString();
        if (file.exists()) {
            if (ProjectSourceCompiler.needsUpdate(file, content)) {
                ByteArrayInputStream outputStream = new ByteArrayInputStream(content.getBytes());
                file.setContents((InputStream)outputStream, 3, null);
                TITANDebugConsole.println("re-Generated code for module `" + aModule.getIdentifier().getDisplayName() + "'");
                return true;
            }
        } else {
            ByteArrayInputStream outputStream = new ByteArrayInputStream(content.getBytes());
            file.create((InputStream)outputStream, 1, null);
            return true;
        }
        return false;
    }

    public static void generateCommonHeaderComments(StringBuilder contentBuilder) {
        if (contentBuilder == null) {
            return;
        }
        contentBuilder.append(CommentUtils.getHeaderCommentsWithCopyright((String)"// ", (String)GeneralConstants.VERSION_STRING));
    }

    public static void generateGeneratedPackageInfo(IProject project) throws CoreException {
        IFolder folder = project.getFolder(ProjectSourceCompiler.getGeneratedRoot(project));
        IFile file = folder.getFile("package-info.java");
        FileUtils.createDir((IFolder)folder);
        StringBuilder contentBuilder = new StringBuilder();
        ProjectSourceCompiler.generateCommonHeaderComments(contentBuilder);
        contentBuilder.append("/**\n");
        contentBuilder.append(MessageFormat.format(" * <code>{0}</code> package contains classes\n", ProjectSourceCompiler.getPackageGeneratedRoot(project)));
        contentBuilder.append(MessageFormat.format(" * that were generated by Titan's Java code generator, from the TTCN-3 and ASN.1 source codes in the project {0}.\n", project.getName()));
        contentBuilder.append(" *<p>\n");
        contentBuilder.append(" * ").append("Do not edit this file unless you know what you are doing!").append("\n");
        contentBuilder.append(" */\n");
        contentBuilder.append("package ");
        contentBuilder.append(ProjectSourceCompiler.getPackageGeneratedRoot(project));
        contentBuilder.append(";\n\n");
        String content = contentBuilder.toString();
        if (file.exists()) {
            if (ProjectSourceCompiler.needsUpdate(file, content.toString())) {
                ByteArrayInputStream outputStream = new ByteArrayInputStream(content.getBytes());
                file.setContents((InputStream)outputStream, 3, null);
            }
        } else {
            ByteArrayInputStream outputStream = new ByteArrayInputStream(content.getBytes());
            file.create((InputStream)outputStream, 1, null);
        }
    }

    public static void generateUserProvidedPackageInfo(IProject project) throws CoreException {
        IFolder folder = project.getFolder(ProjectSourceCompiler.getUserProvidedRoot(project));
        IFile file = folder.getFile("package-info.java");
        FileUtils.createDir((IFolder)folder);
        StringBuilder contentBuilder = new StringBuilder();
        ProjectSourceCompiler.generateCommonHeaderComments(contentBuilder);
        contentBuilder.append("/**\n");
        contentBuilder.append(MessageFormat.format(" * <code>{0}</code> package contains classes\n", ProjectSourceCompiler.getPackageUserProvidedRoot(project)));
        contentBuilder.append(MessageFormat.format(" * that were written by the user, and contain the implementations of test ports and external functions, in the project {0}.\n", project.getName()));
        contentBuilder.append(" *<p>\n");
        contentBuilder.append(" * ").append("Do not edit this file unless you know what you are doing!").append("\n");
        contentBuilder.append(" */\n");
        contentBuilder.append("package ");
        contentBuilder.append(ProjectSourceCompiler.getPackageUserProvidedRoot(project));
        contentBuilder.append(";\n\n");
        String content = contentBuilder.toString();
        if (file.exists()) {
            if (ProjectSourceCompiler.needsUpdate(file, content.toString())) {
                ByteArrayInputStream outputStream = new ByteArrayInputStream(content.getBytes());
                file.setContents((InputStream)outputStream, 3, null);
            }
        } else {
            ByteArrayInputStream outputStream = new ByteArrayInputStream(content.getBytes());
            file.create((InputStream)outputStream, 1, null);
        }
    }

    public static void generateSingleMain(IProject project, Set<String> knownModuleNames) throws CoreException {
        ByteArrayInputStream outputStream;
        IFolder folder = project.getFolder(ProjectSourceCompiler.getGeneratedRoot(project));
        IFile file = folder.getFile("Single_main.java");
        FileUtils.createDir((IFolder)folder);
        StringBuilder contentBuilder = new StringBuilder();
        ProjectSourceCompiler.generateCommonHeaderComments(contentBuilder);
        contentBuilder.append("// Do not edit this file unless you know what you are doing!\n");
        contentBuilder.append('\n');
        contentBuilder.append("package ");
        contentBuilder.append(ProjectSourceCompiler.getPackageGeneratedRoot(project));
        contentBuilder.append(";\n\n");
        contentBuilder.append(MessageFormat.format("import {0}.Module_List;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.PreGenRecordOf;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.Runtime_Single_main;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.TTCN_Logger;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.TitanLoggerApi;\n", PACKAGE_RUNTIME_ROOT));
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(project);
        for (String moduleName : knownModuleNames) {
            Module referencedModule = sourceParser.getModuleByName(moduleName);
            contentBuilder.append(MessageFormat.format("import {0}.{1};\n", ProjectSourceCompiler.getPackageGeneratedRoot(referencedModule.getProject()), moduleName));
        }
        contentBuilder.append("\npublic class Single_main {\n\n");
        contentBuilder.append("\tpublic static void main( String[] args ) {\n");
        contentBuilder.append("\t\tlong absoluteStart = System.nanoTime();\n");
        contentBuilder.append("\t\tModule_List.add_module(new PreGenRecordOf());\n");
        contentBuilder.append("\t\tModule_List.add_module(new TitanLoggerApi());\n");
        for (String moduleName : knownModuleNames) {
            contentBuilder.append(MessageFormat.format("\t\tModule_List.add_module(new {0}());\n", moduleName));
        }
        contentBuilder.append(MessageFormat.format("\t\tTTCN_Logger.set_executable_name(\"{0}\");\n", project.getName()));
        contentBuilder.append("\t\tint returnValue = Runtime_Single_main.singleMain( args );\n");
        contentBuilder.append("\t\tSystem.out.println(\"Total execution took \" + (System.nanoTime() - absoluteStart) * (1e-9) + \" seconds to complete\");\n");
        contentBuilder.append("\t\tSystem.exit(returnValue);\n");
        contentBuilder.append("\t}\n");
        contentBuilder.append("}\n\n");
        String content = contentBuilder.toString();
        if (file.exists()) {
            if (ProjectSourceCompiler.needsUpdate(file, content.toString())) {
                outputStream = new ByteArrayInputStream(content.getBytes());
                file.setContents((InputStream)outputStream, 3, null);
            }
        } else {
            outputStream = new ByteArrayInputStream(content.getBytes());
            file.create((InputStream)outputStream, 1, null);
        }
    }

    public static void generateParallelMain(IProject project, Set<String> knownModuleNames) throws CoreException {
        ByteArrayInputStream outputStream;
        IFolder folder = project.getFolder(ProjectSourceCompiler.getGeneratedRoot(project));
        IFile file = folder.getFile("Parallel_main.java");
        FileUtils.createDir((IFolder)folder);
        StringBuilder contentBuilder = new StringBuilder();
        ProjectSourceCompiler.generateCommonHeaderComments(contentBuilder);
        contentBuilder.append("// Do not edit this file unless you know what you are doing!\n");
        contentBuilder.append('\n');
        contentBuilder.append("package ");
        contentBuilder.append(ProjectSourceCompiler.getPackageGeneratedRoot(project));
        contentBuilder.append(";\n\n");
        contentBuilder.append(MessageFormat.format("import {0}.Module_List;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.PreGenRecordOf;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.Runtime_Parallel_main;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.TTCN_Logger;\n", PACKAGE_RUNTIME_ROOT));
        contentBuilder.append(MessageFormat.format("import {0}.TitanLoggerApi;\n", PACKAGE_RUNTIME_ROOT));
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(project);
        for (String moduleName : knownModuleNames) {
            Module referencedModule = sourceParser.getModuleByName(moduleName);
            contentBuilder.append(MessageFormat.format("import {0}.{1};\n", ProjectSourceCompiler.getPackageGeneratedRoot(referencedModule.getProject()), moduleName));
        }
        contentBuilder.append("\npublic class Parallel_main {\n\n");
        contentBuilder.append("\tpublic static void main( String[] args ) {\n");
        contentBuilder.append("\t\tlong absoluteStart = System.nanoTime();\n");
        contentBuilder.append("\t\tModule_List.add_module(new PreGenRecordOf());\n");
        contentBuilder.append("\t\tModule_List.add_module(new TitanLoggerApi());\n");
        for (String moduleName : knownModuleNames) {
            contentBuilder.append(MessageFormat.format("\t\tModule_List.add_module(new {0}());\n", moduleName));
        }
        contentBuilder.append(MessageFormat.format("\t\tTTCN_Logger.set_executable_name(\"{0}\");\n", project.getName()));
        contentBuilder.append("\t\tint returnValue = Runtime_Parallel_main.parallelMain(args);\n");
        contentBuilder.append("\t\tSystem.out.println(\"Total execution took \" + (System.nanoTime() - absoluteStart) * (1e-9) + \" seconds to complete\");\n");
        contentBuilder.append("\t\tSystem.exit(returnValue);\n");
        contentBuilder.append("\t}\n");
        contentBuilder.append("}\n\n");
        String content = contentBuilder.toString();
        if (file.exists()) {
            if (ProjectSourceCompiler.needsUpdate(file, content.toString())) {
                outputStream = new ByteArrayInputStream(content.getBytes());
                file.setContents((InputStream)outputStream, 3, null);
            }
        } else {
            outputStream = new ByteArrayInputStream(content.getBytes());
            file.create((InputStream)outputStream, 1, null);
        }
    }

    private static boolean needsUpdate(IFile file, String content) throws CoreException {
        boolean result = true;
        InputStream filestream = file.getContents();
        BufferedInputStream bufferedFile = new BufferedInputStream(filestream);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        BufferedInputStream bufferedOutput = new BufferedInputStream(contentStream);
        try {
            int read1 = bufferedFile.read();
            int read2 = bufferedOutput.read();
            while (read1 != -1 && read1 == read2) {
                read1 = bufferedFile.read();
                read2 = bufferedOutput.read();
            }
            result = read1 != read2;
            bufferedFile.close();
            bufferedOutput.close();
        }
        catch (IOException exception) {
            return true;
        }
        return result;
    }

    private static void writeHeader(IProject project, StringBuilder aSb, JavaGenData aData) {
        ProjectSourceCompiler.generateCommonHeaderComments(aSb);
        aSb.append("// Do not edit this file unless you know what you are doing.\n");
        aSb.append('\n');
        aSb.append("package ");
        aSb.append(ProjectSourceCompiler.getPackageGeneratedRoot(project));
        aSb.append(";\n\n");
        for (String importName : aData.getInternalImports()) {
            aSb.append("import ");
            aSb.append(PACKAGE_RUNTIME_ROOT);
            aSb.append('.');
            aSb.append(importName);
            aSb.append(";\n");
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(project);
        for (String importName : aData.getInterModuleImports()) {
            Module referencedModule = sourceParser.getModuleByName(importName);
            aSb.append(MessageFormat.format("import {0}.{1};\n", ProjectSourceCompiler.getPackageGeneratedRoot(referencedModule.getProject()), importName));
        }
        for (String importName : aData.getImports()) {
            ProjectSourceCompiler.writeImport(aSb, importName);
        }
        aSb.append('\n');
        aSb.append((CharSequence)aData.getClassHeader());
        aSb.append('\n');
    }

    private static void writeFooter(JavaGenData aData, StringBuilder aSb, IResource sourceFile, Module aModule) {
        if (aData.getSetModuleParameters().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic boolean set_module_param(final Param_Types.Module_Parameter param)\n");
            aSb.append("\t{\n");
            aSb.append("\t\tfinal String par_name = param.get_id().get_current_name();\n");
            aSb.append("\t\t");
            aSb.append((CharSequence)aData.getSetModuleParameters());
            aSb.append("{\n");
            aSb.append("\t\t\treturn false;\n");
            aSb.append("\t\t}\n");
            aSb.append("\t}\n\n");
            aSb.append("\t@Override\n");
            aSb.append("\tpublic boolean has_set_module_param() {\n");
            aSb.append("\t\treturn true;\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getGetModuleParameters().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic Param_Types.Module_Parameter get_module_param(final Param_Types.Module_Param_Name param_name)\n");
            aSb.append("\t{\n");
            aSb.append("\t\tfinal String par_name = param_name.get_current_name();\n");
            aSb.append("\t\t");
            aSb.append((CharSequence)aData.getGetModuleParameters());
            aSb.append("{\n");
            aSb.append("\t\t\treturn null;\n");
            aSb.append("\t\t}\n");
            aSb.append("\t}\n\n");
            aSb.append("\t@Override\n");
            aSb.append("\tpublic boolean has_get_module_param() {\n");
            aSb.append("\t\treturn true;\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getLogModuleParameters().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic void log_module_param()\n");
            aSb.append("\t{\n");
            aSb.append("\t\t");
            aSb.append((CharSequence)aData.getLogModuleParameters());
            aSb.append("\t}\n\n");
            aSb.append("\t@Override\n");
            aSb.append("\tpublic boolean has_log_module_param() {\n");
            aSb.append("\t\treturn true;\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getPreInit().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic void pre_init_module()\n");
            aSb.append("\t{\n");
            aSb.append("\t\tif (pre_init_called) {\n");
            aSb.append("\t\t\treturn;\n");
            aSb.append("\t\t}\n");
            aSb.append("\t\tpre_init_called = true;\n");
            if (aData.getAddSourceInfo()) {
                aSb.append(MessageFormat.format("\t\tfinal TTCN_Location current_location = TTCN_Location.enter(\"{0}\", {1}, entity_type_t.LOCATION_UNKNOWN, \"{2}\");\n", sourceFile.getName(), 0, aModule.getIdentifier().getDisplayName()));
            }
            aSb.append((CharSequence)aData.getPreInit());
            if (aData.getAddSourceInfo()) {
                aSb.append("\t\tcurrent_location.leave();\n");
            }
            aSb.append("\t}\n\n");
        }
        if (aData.getPostInit().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic void post_init_module()\n");
            aSb.append("\t{\n");
            aSb.append("\t\tif (post_init_called) {\n");
            aSb.append("\t\t\treturn;\n");
            aSb.append("\t\t}\n");
            aSb.append("\t\tpost_init_called = true;\n");
            aSb.append("\t\tTTCN_Logger.log_module_init(module_name, false);\n");
            if (aData.getAddSourceInfo()) {
                aSb.append(MessageFormat.format("\t\tfinal TTCN_Location current_location = TTCN_Location.enter(\"{0}\", {1}, entity_type_t.LOCATION_UNKNOWN, \"{2}\");\n", sourceFile.getName(), 0, aModule.getIdentifier().getDisplayName()));
            }
            aSb.append((CharSequence)aData.getPostInit());
            if (aData.getAddSourceInfo()) {
                aSb.append("\t\tcurrent_location.leave();\n");
            }
            aSb.append("\t\tTTCN_Logger.log_module_init(module_name, true);\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getStartPTCFunction().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic boolean start_ptc_function(final String function_name, final Text_Buf function_arguments) {\n");
            aSb.append("\t\t");
            aSb.append((CharSequence)aData.getStartPTCFunction());
            aSb.append("{\n");
            aSb.append("\t\t\tthrow new TtcnError(MessageFormat.format(\"Internal error: Startable function {0} does not exist in module {1}.\", function_name, module_name));\n");
            aSb.append("\t\t}\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getExecuteTestcase().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic void execute_testcase(final String tescase_name) {\n");
            aSb.append("\t\t");
            aSb.append((CharSequence)aData.getExecuteTestcase());
            aSb.append("{\n");
            aSb.append("\t\t\tthrow new TtcnError(MessageFormat.format(\"Test case {0} does not exist in module {1}.\", tescase_name, module_name));\n");
            aSb.append("\t\t}\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getExecuteAllTestcase().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic void execute_all_testcases() {\n");
            aSb.append((CharSequence)aData.getExecuteAllTestcase());
            aSb.append("\t}\n\n");
        }
        if (aData.getInitComp().length() > 0) {
            aSb.append("\tpublic boolean init_comp_type(final String component_type, final boolean init_base_comps) {\n");
            aSb.append("\t\t");
            aSb.append((CharSequence)aData.getInitComp());
            aSb.append("{\n");
            aSb.append("\t\t\treturn false;\n");
            aSb.append("\t\t}\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getInitSystemPort().length() > 0) {
            aSb.append("\tpublic boolean init_system_port(final String component_type, final String port_name)\n");
            aSb.append("\t{\n");
            aSb.append((CharSequence)aData.getInitSystemPort());
            aSb.append("\t\t{\n");
            aSb.append("\t\t\treturn false;\n");
            aSb.append("\t\t}\n");
            aSb.append("\t}\n\n");
        }
        if (aData.getListTestcases().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic void list_testcases() {\n");
            aSb.append((CharSequence)aData.getListTestcases());
            aSb.append("\t}\n\n");
        }
        if (aData.getListModulePars().length() > 0) {
            aSb.append("\t@Override\n");
            aSb.append("\tpublic void list_modulepars() {\n");
            aSb.append((CharSequence)aData.getListModulePars());
            aSb.append("\t}\n\n");
        }
        aSb.append("}\n");
    }

    private static void writeImport(StringBuilder aSb, String aImportName) {
        aSb.append("import ");
        aSb.append(aImportName);
        aSb.append(";\n");
    }
}

