/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.titan.designer.Activator;

public class RemoveTrailingWsOnSave {
    public static void doRemove(IDocument doc) {
        if (doc == null) {
            return;
        }
        boolean isTrim = Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.indentation.removeTrailingWs");
        if (isTrim && doc != null) {
            String delim = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
            FindReplaceDocumentAdapter frAdapter = new FindReplaceDocumentAdapter(doc);
            IRegion region = null;
            do {
                try {
                    region = frAdapter.find(0, "[ \t]+" + delim, true, false, false, true);
                    if (region == null) continue;
                    frAdapter.replace(delim, true);
                }
                catch (BadLocationException e) {
                    break;
                }
            } while (region != null);
        }
    }
}

