/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.FoldingSupport;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.editors.RemoveTrailingWsOnSave;
import org.eclipse.titan.designer.editors.actions.ToggleComment;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.ConfigFoldingSupport;
import org.eclipse.titan.designer.editors.configeditor.Configuration;
import org.eclipse.titan.designer.editors.configeditor.DocumentSetupParticipant;
import org.eclipse.titan.designer.editors.configeditor.PairMatcher;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.FileSaveTracker;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;

public final class ConfigTextEditor
extends AbstractDecoratedTextEditor
implements ISemanticTITANEditor,
IEditorWithCarretOffset {
    private static final String CONTENTASSISTPROPOSAL = "ContentAssistProposal.";
    private static final String CONFIG_EDITOR = "org.eclipse.titan.designer.editors.configeditor.ConfigEditor";
    private static final String EDITOR_CONTEXT = "org.eclipse.titan.designer.editors.configeditor.context";
    private static final String EDITOR_SCOPE = "org.eclipse.titan.designer.editors.ConfigEditorScope";
    private static final String TOGGLE_COMMENT_ACTION_ID = "org.eclipse.titan.designer.editors.configeditor.ToggleComment";
    private ProjectionSupport projectionSupport;
    private List<Annotation> oldAnnotations = new ArrayList<Annotation>();
    private ProjectionAnnotationModel annotationModel;
    private ColorManager colorManager;
    private Configuration configuration;
    private ProjectionViewer projectionViewer;
    private final ConfigEditor parentEditor;
    private final IPropertyChangeListener foldingListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("org.eclipse.titan.designer.foldingEnabledPreference".equals(property) || "org.eclipse.titan.designer.foldComments".equals(property) || "org.eclipse.titan.designer.foldStatementBlocks".equals(property) || "org.eclipse.titan.designer.foldParenthesis".equals(property) || "org.eclipse.titan.designer.distance".equals(property)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConfigTextEditor.this.updateFoldingStructure(new ConfigFoldingSupport().calculatePositions(ConfigTextEditor.this.getDocument()));
                    }
                });
            }
        }
    };

    public ConfigTextEditor(ConfigEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore[] stores = new IPreferenceStore[]{this.getPreferenceStore(), Activator.getDefault().getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.colorManager = new ColorManager();
        this.configuration = new Configuration(this.colorManager, this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.configuration);
        DocumentSetupParticipant participant = new DocumentSetupParticipant();
        ForwardingDocumentProvider forwardingProvider = new ForwardingDocumentProvider("__config_partitioning", (IDocumentSetupParticipant)participant, (IDocumentProvider)new TextFileDocumentProvider());
        this.setDocumentProvider((IDocumentProvider)forwardingProvider);
        this.setEditorContextMenuId(EDITOR_CONTEXT);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("org.eclipse.titan.designer")) {
            this.colorManager.update(event.getProperty());
            this.invalidateTextPresentation();
            this.updateTITANIndentPrefixes();
            return true;
        }
        return super.affectsTextPresentation(event);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        PairMatcher pairMatcher = new PairMatcher();
        support.setCharacterPairMatcher((ICharacterPairMatcher)pairMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("org.eclipse.titan.designer.matchingBracketEnabled", "org.eclipse.titan.designer.color.matchingBracket", "org.eclipse.titan.designer.matchingBracketEnabled", "org.eclipse.titan.designer.color.matchingBracket");
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction caAction = new TextOperationAction(Activator.getDefault().getResourceBundle(), CONTENTASSISTPROPOSAL, (ITextEditor)this, 13);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        caAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(CONTENTASSISTPROPOSAL, (IAction)caAction);
        this.markAsStateDependentAction(CONTENTASSISTPROPOSAL, true);
        ToggleComment tcAction = new ToggleComment(Activator.getDefault().getResourceBundle(), "ToggleComment.", this);
        tcAction.setActionDefinitionId(TOGGLE_COMMENT_ACTION_ID);
        this.setAction(TOGGLE_COMMENT_ACTION_ID, (IAction)tcAction);
        this.markAsStateDependentAction(TOGGLE_COMMENT_ACTION_ID, true);
        tcAction.configure(this.getSourceViewer(), this.getSourceViewerConfiguration());
        tcAction.setText("Toggle Comment");
        tcAction.setImageDescriptor(ImageCache.getImageDescriptor("comment.png"));
    }

    public void dispose() {
        this.oldAnnotations = null;
        this.projectionSupport.dispose();
        this.annotationModel = null;
        this.configuration = null;
        this.projectionViewer = null;
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.foldingListener);
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            EditorTracker.remove(file, this);
        }
        super.dispose();
    }

    @Override
    public IDocument getDocument() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        return sourceViewer.getDocument();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(this.projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        this.projectionViewer.doOperation(19);
        this.annotationModel = this.projectionViewer.getProjectionAnnotationModel();
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigTextEditor.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
            }
        });
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            EditorTracker.put(file, this);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.foldingListener);
        IContextService contextService = (IContextService)this.getEditorSite().getService(IContextService.class);
        contextService.activateContext(EDITOR_SCOPE);
        return viewer;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "additions", TOGGLE_COMMENT_ACTION_ID);
    }

    @Override
    public void updateOutlinePage() {
    }

    public void refreshOutlinePage() {
    }

    @Override
    public void updateFoldingStructure(List<Position> positions) {
        FoldingSupport.updateFoldingStructure(this.annotationModel, this.oldAnnotations, positions);
    }

    @Override
    public void invalidateTextPresentation() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            viewer.invalidateTextPresentation();
        }
    }

    protected void updateTITANIndentPrefixes() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        ISourceViewer sourceViewer = this.getSourceViewer();
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        for (int i = 0; i < types.length; ++i) {
            String[] prefixes = configuration.getIndentPrefixes(sourceViewer, types[i]);
            if (prefixes == null || prefixes.length <= 0) continue;
            sourceViewer.setIndentPrefixes(prefixes, types[i]);
        }
    }

    public ConfigEditor getParentEditor() {
        return this.parentEditor;
    }

    @Override
    public int getCarretOffset() {
        int widgetOffset = this.getSourceViewer().getTextWidget().getCaretOffset();
        return this.projectionViewer.widgetOffset2ModelOffset(widgetOffset);
    }

    public void setCarretOffset(int i) {
        int temp = this.projectionViewer.modelOffset2WidgetOffset(i);
        this.getSourceViewer().getTextWidget().setCaretOffset(temp);
    }

    public static IEditorDescriptor findCFGEditor(IWorkbench workbench) {
        return workbench.getEditorRegistry().findEditor(CONFIG_EDITOR);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            FileSaveTracker.fileBeingSaved(file);
        }
        RemoveTrailingWsOnSave.doRemove(this.getDocument());
        super.doSave(progressMonitor);
    }

    @Override
    public void analyzeCurrentFile(IFile file) {
    }
}

