/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.MCSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class MCSubPage {
    private Text localAddressText;
    private Text tcpPortText;
    private Text killTimerText;
    private Text numHCsText;
    private CCombo unixDomainSocketText;
    private final ConfigEditor editor;
    private MCSectionHandler mcSectionHandler;
    private boolean valueChanged = false;

    public MCSubPage(ConfigEditor editor) {
        this.editor = editor;
    }

    void createMainControllerSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 386);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        section.setText("Main Controller options");
        section.setDescription("Specify the Main Controller directing options for this configuration.");
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        GridData gd = new GridData(4, 0, true, false);
        section.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section, 64);
        section.setClient((Control)client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        this.valueChanged = true;
        toolkit.createLabel(client, "Local Address:");
        this.localAddressText = toolkit.createText(client, "", 4);
        this.localAddressText.setLayoutData((Object)new GridData(768));
        this.localAddressText.setEnabled(this.mcSectionHandler != null);
        this.localAddressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MCSubPage.this.valueChanged || MCSubPage.this.mcSectionHandler == null) {
                    return;
                }
                MCSubPage.this.editor.setDirty();
                String temp = MCSubPage.this.localAddressText.getText();
                if (temp == null || temp.length() == 0) {
                    if (MCSubPage.this.mcSectionHandler.getLocalAddressRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)MCSubPage.this.mcSectionHandler.getLocalAddressRoot());
                    }
                    MCSubPage.this.mcSectionHandler.setLocalAddress(null);
                    MCSubPage.this.mcSectionHandler.setLocalAddressRoot(null);
                    MCSubPage.this.removeMCSection();
                } else if (MCSubPage.this.mcSectionHandler.getLocalAddress() == null) {
                    MCSubPage.this.createMCSection();
                    ParserRuleContext localAddressRoot = new ParserRuleContext();
                    MCSubPage.this.mcSectionHandler.setLocalAddressRoot((ParseTree)localAddressRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)localAddressRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)localAddressRoot, (ParseTree)new AddedParseTree("\nlocalAddress := "));
                    AddedParseTree localAddress = new AddedParseTree(temp.trim());
                    MCSubPage.this.mcSectionHandler.setLocalAddress((ParseTree)localAddress);
                    ConfigTreeNodeUtilities.addChild((ParseTree)localAddressRoot, (ParseTree)localAddress);
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)MCSubPage.this.mcSectionHandler.getLocalAddress(), (String)temp.trim());
                }
            }
        });
        if (this.mcSectionHandler != null && this.mcSectionHandler.getLocalAddress() != null) {
            this.localAddressText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getLocalAddress()));
        }
        toolkit.createLabel(client, "TCP port:");
        this.tcpPortText = toolkit.createText(client, "", 4);
        this.tcpPortText.setEnabled(this.mcSectionHandler != null);
        this.tcpPortText.setLayoutData((Object)new GridData(75, -1));
        this.tcpPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MCSubPage.this.valueChanged || MCSubPage.this.mcSectionHandler == null) {
                    return;
                }
                MCSubPage.this.editor.setDirty();
                String temp = MCSubPage.this.tcpPortText.getText();
                if (temp == null || temp.length() == 0) {
                    if (MCSubPage.this.mcSectionHandler.getTcpPortRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)MCSubPage.this.mcSectionHandler.getTcpPortRoot());
                    }
                    MCSubPage.this.mcSectionHandler.setTcpPort(null);
                    MCSubPage.this.mcSectionHandler.setTcpPortRoot(null);
                    MCSubPage.this.removeMCSection();
                } else if (MCSubPage.this.mcSectionHandler.getTcpPort() == null) {
                    MCSubPage.this.createMCSection();
                    ParserRuleContext tcpPortRoot = new ParserRuleContext();
                    MCSubPage.this.mcSectionHandler.setTcpPortRoot((ParseTree)tcpPortRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)tcpPortRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)tcpPortRoot, (ParseTree)new AddedParseTree("\nTCPPort := "));
                    AddedParseTree tcpPort = new AddedParseTree(temp.trim());
                    MCSubPage.this.mcSectionHandler.setTcpPort((ParseTree)tcpPort);
                    ConfigTreeNodeUtilities.addChild((ParseTree)tcpPortRoot, (ParseTree)tcpPort);
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)MCSubPage.this.mcSectionHandler.getTcpPort(), (String)temp.trim());
                }
            }
        });
        if (this.mcSectionHandler != null && this.mcSectionHandler.getTcpPort() != null) {
            this.tcpPortText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getTcpPort()));
        }
        toolkit.createLabel(client, "Kill timer:");
        this.killTimerText = toolkit.createText(client, "", 4);
        this.killTimerText.setEnabled(this.mcSectionHandler != null);
        this.killTimerText.setLayoutData((Object)new GridData(75, -1));
        this.killTimerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MCSubPage.this.valueChanged || MCSubPage.this.mcSectionHandler == null) {
                    return;
                }
                MCSubPage.this.editor.setDirty();
                String temp = MCSubPage.this.killTimerText.getText();
                if (temp == null || temp.length() == 0) {
                    if (MCSubPage.this.mcSectionHandler.getKillTimerRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)MCSubPage.this.mcSectionHandler.getKillTimerRoot());
                    }
                    MCSubPage.this.mcSectionHandler.setKillTimer(null);
                    MCSubPage.this.mcSectionHandler.setKillTimerRoot(null);
                    MCSubPage.this.removeMCSection();
                } else if (MCSubPage.this.mcSectionHandler.getKillTimer() == null) {
                    MCSubPage.this.createMCSection();
                    ParserRuleContext killTimerRoot = new ParserRuleContext();
                    MCSubPage.this.mcSectionHandler.setKillTimerRoot((ParseTree)killTimerRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)killTimerRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)killTimerRoot, (ParseTree)new AddedParseTree("\nkillTimer := "));
                    AddedParseTree killTimer = new AddedParseTree(temp.trim());
                    MCSubPage.this.mcSectionHandler.setTcpPort((ParseTree)killTimer);
                    ConfigTreeNodeUtilities.addChild((ParseTree)killTimerRoot, (ParseTree)killTimer);
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)MCSubPage.this.mcSectionHandler.getKillTimer(), (String)temp.trim());
                }
            }
        });
        if (this.mcSectionHandler != null && this.mcSectionHandler.getKillTimer() != null) {
            this.killTimerText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getKillTimer()));
        }
        toolkit.createLabel(client, "Number of Host Contollers:");
        this.numHCsText = toolkit.createText(client, "", 4);
        this.numHCsText.setEnabled(this.mcSectionHandler != null);
        this.numHCsText.setLayoutData((Object)new GridData(75, -1));
        this.numHCsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MCSubPage.this.valueChanged || MCSubPage.this.mcSectionHandler == null) {
                    return;
                }
                MCSubPage.this.editor.setDirty();
                String temp = MCSubPage.this.numHCsText.getText();
                if (temp == null || temp.length() == 0) {
                    if (MCSubPage.this.mcSectionHandler.getNumHCsTextRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)MCSubPage.this.mcSectionHandler.getNumHCsTextRoot());
                    }
                    MCSubPage.this.mcSectionHandler.setNumHCsText(null);
                    MCSubPage.this.mcSectionHandler.setNumHCsTextRoot(null);
                    MCSubPage.this.removeMCSection();
                } else if (MCSubPage.this.mcSectionHandler.getNumHCsText() == null) {
                    MCSubPage.this.createMCSection();
                    ParserRuleContext numHCsTextRoot = new ParserRuleContext();
                    MCSubPage.this.mcSectionHandler.setKillTimerRoot((ParseTree)numHCsTextRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)numHCsTextRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)numHCsTextRoot, (ParseTree)new AddedParseTree("\nnumHCs := "));
                    AddedParseTree numHCsText = new AddedParseTree(temp.trim());
                    MCSubPage.this.mcSectionHandler.setNumHCsText((ParseTree)numHCsText);
                    ConfigTreeNodeUtilities.addChild((ParseTree)numHCsTextRoot, (ParseTree)numHCsText);
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)MCSubPage.this.mcSectionHandler.getNumHCsText(), (String)temp.trim());
                }
            }
        });
        if (this.mcSectionHandler != null && this.mcSectionHandler.getNumHCsText() != null) {
            this.numHCsText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getNumHCsText()));
        }
        toolkit.createLabel(client, "Use of unix domain socket communication:");
        this.unixDomainSocketText = new CCombo(client, 0x800000);
        this.unixDomainSocketText.setEnabled(this.mcSectionHandler != null);
        this.unixDomainSocketText.setLayoutData((Object)new GridData(75, -1));
        this.unixDomainSocketText.add("Yes");
        this.unixDomainSocketText.add("No");
        this.unixDomainSocketText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MCSubPage.this.valueChanged || MCSubPage.this.mcSectionHandler == null) {
                    return;
                }
                MCSubPage.this.editor.setDirty();
                String temp = MCSubPage.this.unixDomainSocketText.getText();
                if (temp == null || temp.length() == 0) {
                    if (MCSubPage.this.mcSectionHandler.getUnixDomainSocketRoot() != null) {
                        ConfigTreeNodeUtilities.removeChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)MCSubPage.this.mcSectionHandler.getUnixDomainSocketRoot());
                    }
                    MCSubPage.this.mcSectionHandler.setUnixDomainSocket(null);
                    MCSubPage.this.mcSectionHandler.setUnixDomainSocketRoot(null);
                    MCSubPage.this.removeMCSection();
                } else if (MCSubPage.this.mcSectionHandler.getUnixDomainSocket() == null) {
                    MCSubPage.this.createMCSection();
                    ParserRuleContext unixDomainSocketRoot = new ParserRuleContext();
                    MCSubPage.this.mcSectionHandler.setUnixDomainSocketRoot((ParseTree)unixDomainSocketRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)MCSubPage.this.mcSectionHandler.getLastSectionRoot(), (ParseTree)unixDomainSocketRoot);
                    ConfigTreeNodeUtilities.addChild((ParseTree)unixDomainSocketRoot, (ParseTree)new AddedParseTree("\nUnixSocketsEnabled := "));
                    AddedParseTree unixDomainSocket = new AddedParseTree(temp.trim());
                    MCSubPage.this.mcSectionHandler.setUnixDomainSocket((ParseTree)unixDomainSocket);
                    ConfigTreeNodeUtilities.addChild((ParseTree)unixDomainSocketRoot, (ParseTree)unixDomainSocket);
                } else {
                    ConfigTreeNodeUtilities.setText((ParseTree)MCSubPage.this.mcSectionHandler.getUnixDomainSocket(), (String)temp.trim());
                }
            }
        });
        if (this.mcSectionHandler != null && this.mcSectionHandler.getUnixDomainSocket() != null) {
            this.unixDomainSocketText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getUnixDomainSocket()));
        }
        this.valueChanged = false;
    }

    private void internalRefresh() {
        if (this.mcSectionHandler == null) {
            this.localAddressText.setEnabled(false);
            this.tcpPortText.setEnabled(false);
            this.killTimerText.setEnabled(false);
            this.numHCsText.setEnabled(false);
            this.unixDomainSocketText.setEnabled(false);
            return;
        }
        this.valueChanged = true;
        this.localAddressText.setEnabled(true);
        this.tcpPortText.setEnabled(true);
        this.killTimerText.setEnabled(true);
        this.numHCsText.setEnabled(true);
        this.unixDomainSocketText.setEnabled(true);
        if (this.mcSectionHandler.getLocalAddress() != null) {
            this.localAddressText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getLocalAddress()).trim());
        }
        if (this.mcSectionHandler.getTcpPort() != null) {
            this.tcpPortText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getTcpPort()).trim());
        }
        if (this.mcSectionHandler.getKillTimer() != null) {
            this.killTimerText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getKillTimer()).trim());
        }
        if (this.mcSectionHandler.getNumHCsText() != null) {
            this.numHCsText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getNumHCsText()).trim());
        }
        if (this.mcSectionHandler.getUnixDomainSocket() != null) {
            this.unixDomainSocketText.setText(ConfigTreeNodeUtilities.toString((ParseTree)this.mcSectionHandler.getUnixDomainSocket()).trim());
        }
        this.valueChanged = false;
    }

    public void refreshData(MCSectionHandler mcSectionHandler) {
        this.mcSectionHandler = mcSectionHandler;
        if (this.localAddressText != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MCSubPage.this.internalRefresh();
                }
            });
        }
    }

    private void createMCSection() {
        if (this.mcSectionHandler == null || this.mcSectionHandler.getLastSectionRoot() != null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.mcSectionHandler.setLastSectionRoot((ParseTree)sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[MAIN_CONTROLLER]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    private void removeMCSection() {
        if (this.mcSectionHandler == null || this.mcSectionHandler.getLastSectionRoot() == null) {
            return;
        }
        if (this.mcSectionHandler.getLocalAddress() == null && this.mcSectionHandler.getTcpPort() == null && this.mcSectionHandler.getKillTimer() == null && this.mcSectionHandler.getNumHCsText() == null && this.mcSectionHandler.getUnixDomainSocket() == null) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.mcSectionHandler.getLastSectionRoot());
            this.mcSectionHandler.setLastSectionRoot(null);
        }
    }
}

