/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.AssignmentMatch;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReferenceAnalyzer;

public class AssignmentContext
extends ProposalContext {
    private static Map<String, IType.Type_type> basicTypes = new HashMap<String, IType.Type_type>();
    private AssignmentMatch aMatch = this.getAssignmentMatch();

    public AssignmentContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        IType.Type_type ttype;
        CompilationTimeStamp timestamp = this.proposalContextInfo.module.getLastCompilationTimeStamp();
        if (this.aMatch.reference == null && this.aMatch.typeType == null) {
            return;
        }
        if (this.proposalContextInfo.scope == null) {
            return;
        }
        IType type = null;
        if (this.aMatch.typeType != null) {
            ttype = this.aMatch.typeType;
        } else {
            IType asstype;
            Def_Var defvar;
            Assignment assignment = this.proposalContextInfo.scope.getAssBySRef(timestamp, this.aMatch.reference);
            if (assignment == null) {
                return;
            }
            if (assignment instanceof Def_Var && (defvar = (Def_Var)assignment).getType(timestamp) instanceof Referenced_Type && (asstype = ((Referenced_Type)defvar.getType(timestamp)).getTypeRefdLast(timestamp)) instanceof Class_Type) {
                type = ((Class_Type)asstype).getFieldType(timestamp, this.aMatch.reference, 1, null, false);
            }
            if (type == null) {
                type = assignment.getType(timestamp);
            }
            if (type == null) {
                return;
            }
            ttype = type.getTypetypeTtcn3();
        }
        ArrayList<String> excludeNames = new ArrayList<String>();
        excludeNames.add(this.aMatch.name);
        this.addItemsByType(type, ttype, propCollector, this.aMatch.prefix != null ? this.aMatch.prefix : "", excludeNames);
    }

    private AssignmentMatch getAssignmentMatch() {
        AssignmentMatch assignmentMatch = new AssignmentMatch();
        Matcher m = this.proposalContextInfo.matcher;
        String vartype = m.group(2);
        assignmentMatch.name = m.group(3);
        assignmentMatch.prefix = m.group(4);
        IType.Type_type typeType = basicTypes.get(vartype);
        if (typeType != null) {
            assignmentMatch.typeType = typeType;
        } else {
            assignmentMatch.reference = TTCN3ReferenceAnalyzer.parseForCompletion(this.proposalContextInfo.file, assignmentMatch.name);
        }
        return assignmentMatch;
    }

    static {
        basicTypes.put("boolean", IType.Type_type.TYPE_BOOL);
        basicTypes.put("bitstring", IType.Type_type.TYPE_BITSTRING);
        basicTypes.put("charstring", IType.Type_type.TYPE_CHARSTRING);
        basicTypes.put("float", IType.Type_type.TYPE_REAL);
        basicTypes.put("hexstring", IType.Type_type.TYPE_HEXSTRING);
        basicTypes.put("integer", IType.Type_type.TYPE_INTEGER);
        basicTypes.put("octetstring", IType.Type_type.TYPE_OCTETSTRING);
    }
}

