/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegexpEntryDialog
extends Dialog {
    private static final String TITLE = "Regular expression";
    private final String title;
    private String entry = "";
    private Label entryLabel;
    private Text entryText;
    private Label errorLabel;

    public RegexpEntryDialog(Shell shell) {
        super(shell);
        this.title = TITLE;
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    private void validate(String newText) {
        block3: {
            try {
                Pattern.compile(newText);
                this.errorLabel.setVisible(false);
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(true);
                }
            }
            catch (PatternSyntaxException e) {
                this.errorLabel.setVisible(true);
                Button button = this.getButton(0);
                if (button == null) break block3;
                button.setEnabled(false);
            }
        }
    }

    protected void okPressed() {
        this.entry = this.entryText.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        this.createNameArea(panel);
        Dialog.applyDialogFont((Control)container);
        this.validate("");
        return container;
    }

    protected void createNameArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(32));
        label.setToolTipText("tooltip");
        this.entryLabel = new Label(parent, 0);
        this.entryLabel.setText("text");
        this.entryLabel.setLayoutData((Object)new GridData(32));
        this.entryLabel.setToolTipText("tooltip");
        this.entryText = new Text(parent, 2052);
        this.entryText.setLayoutData((Object)new GridData(768));
        this.entryText.setText(this.entry);
        this.entryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegexpEntryDialog.this.validate(RegexpEntryDialog.this.entryText.getText());
            }
        });
        this.entryLabel.setSize(this.entryLabel.getSize().x, this.entryText.getSize().y);
        this.errorLabel = new Label(parent, 0);
        this.errorLabel.setText("error");
        this.errorLabel.setLayoutData((Object)new GridData(32));
        this.errorLabel.setToolTipText("error tooltip");
        this.errorLabel.setVisible(false);
    }
}

