/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CCompilerOptionsData {
    public static final String CXX_COMPILER_PROPERTY = "C/C++ compiler";
    public static final String CXX_COMPILER_TAG = "CxxCompiler";
    public static final String DEFAULT_VALUE = "g++";

    private CCompilerOptionsData() {
    }

    public static String getCompilerName(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", CXX_COMPILER_PROPERTY));
            if (temp == null || temp.length() == 0) {
                temp = DEFAULT_VALUE;
            }
            return temp;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting the compiler of `" + project.getName() + "'"), (Throwable)e);
            return DEFAULT_VALUE;
        }
    }

    public static void removeTITANAttributes(IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", CXX_COMPILER_PROPERTY), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing properties of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        NodeList resourceList = root.getChildNodes();
        String newValue = DEFAULT_VALUE;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            if (!CXX_COMPILER_TAG.equals(name)) continue;
            newValue = node.getTextContent();
            break;
        }
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", CXX_COMPILER_PROPERTY);
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While loading properties of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", CXX_COMPILER_PROPERTY));
            if (temp != null && !DEFAULT_VALUE.equals(temp)) {
                Element element = document.createElement(CXX_COMPILER_TAG);
                element.appendChild(document.createTextNode(temp));
                makefileSettings.appendChild(element);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving properties of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        NodeList resourceList = source.getChildNodes();
        String newValue = DEFAULT_VALUE;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            if (!CXX_COMPILER_TAG.equals(name)) continue;
            newValue = node.getTextContent();
        }
        if (saveDefaultValues || newValue != null && !DEFAULT_VALUE.equals(newValue)) {
            Element node = document.createElement(CXX_COMPILER_TAG);
            node.appendChild(document.createTextNode(newValue));
            makefileSettings.appendChild(node);
        }
    }
}

