/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.samples;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.compiler.ProjectSourceCompiler;
import org.eclipse.titan.designer.samples.HelloWorldSample;

public class HelloWorldJavaSample
extends HelloWorldSample {
    private static final Map<String, String> OTHER_FILE_CONTENT = new HashMap<String, String>();
    private static final Map<String, String> SOURCE_FILE_CONTENT = new HashMap<String, String>();
    protected static final String TESTPORT_JAVA_PACKAGE = "package {0};\n\n";
    protected static final String TESTPORT_JAVA_IMPORT = "import {0}.MyExample.PCOType_BASE;\nimport " + ProjectSourceCompiler.getPackageRuntimeRoot() + ".TitanCharString;\n";
    protected static final String TESTPORT_JAVA_BODY = "\npublic class PCOType extends PCOType_BASE {\n\n\tpublic PCOType(String port_name) {\n\t\tsuper(port_name);\n\t}\n\n\t@Override\n\tprotected void outgoing_send(TitanCharString send_par) {\n\t\tSystem.out.println(send_par);\n\t\tincoming_message(new TitanCharString(\"Hello, TTCN-3!\"));\n\t}\n}";

    @Override
    protected void preconfigure(IProject project) {
        if (project == null) {
            return;
        }
        String userProvidedRoot = ProjectSourceCompiler.getUserProvidedRoot(project);
        StringBuilder testPort = new StringBuilder();
        this.generateTestPort(project, testPort);
        OTHER_FILE_CONTENT.clear();
        OTHER_FILE_CONTENT.put(userProvidedRoot + "/PCOType.java", testPort.toString());
    }

    @Override
    protected void configure(IProject project) {
    }

    @Override
    public Map<String, String> getOtherFileContent() {
        return OTHER_FILE_CONTENT;
    }

    @Override
    public Map<String, String> getSourceFileContent() {
        return SOURCE_FILE_CONTENT;
    }

    private void generateTestPort(IProject project, StringBuilder contentBuilder) {
        if (contentBuilder == null) {
            return;
        }
        ProjectSourceCompiler.generateCommonHeaderComments(contentBuilder);
        contentBuilder.append(MessageFormat.format(TESTPORT_JAVA_PACKAGE, ProjectSourceCompiler.getPackageUserProvidedRoot(project))).append(MessageFormat.format(TESTPORT_JAVA_IMPORT, ProjectSourceCompiler.getPackageGeneratedRoot(project))).append(TESTPORT_JAVA_BODY);
    }

    static {
        SOURCE_FILE_CONTENT.put("MyExample.ttcn", MYEXAMPLE_TTCN);
        SOURCE_FILE_CONTENT.put("MyExample.cfg", MYEXAMPLE_CFG);
    }
}

