/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.wizards.NewTTCN3ModuleWizard;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public final class NewTTCN3ModuleCreationWizardPage
extends WizardNewFileCreationPage {
    private static final String EMPTYNAMEERROR = "TTCN3 modules must have a name.";
    private static final String INVALIDMODULENAME = "Invalid TTCN3 module name {0}";
    private static final String MODULENAMEREGEXP = "[a-zA-Z][a-zA-Z_0-9]*";
    private static final Pattern MODULENAMEPATTERN = Pattern.compile("[a-zA-Z][a-zA-Z_0-9]*");
    private static final String TITLE = "New TTCN3 module";
    private static final String DESCRIPTION = "Create a new TTCN3 module";
    private static final String ERROR_MESSAGE = "When provided the extension of the TTCN3 Module must be \"ttcn\" or \"ttcn3\"";
    private static final String OCCUPIED = "This module name would create a file that already exists.";
    private final boolean hasLicense = LicenseValidator.check();
    private final NewTTCN3ModuleWizard wizard;

    public NewTTCN3ModuleCreationWizardPage(IStructuredSelection selection, NewTTCN3ModuleWizard wizard) {
        super(TITLE, selection);
        this.wizard = wizard;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getTitle() {
        return TITLE;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getContainerFullPath().append(this.getFileName()).getFileExtension();
        if (extension == null) {
            IPath fullPath = this.getContainerFullPath().append(this.getFileName()).addFileExtension(GlobalParser.SUPPORTED_TTCN3_EXTENSIONS[1]);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            while (fullPath.segmentCount() > 1) {
                if (root.getFile(fullPath).exists()) {
                    this.setErrorMessage(OCCUPIED);
                    return false;
                }
                fullPath = fullPath.removeLastSegments(1);
            }
        } else if (!GlobalParser.isSupportedTTCN3Extension(extension)) {
            this.setErrorMessage(ERROR_MESSAGE);
            return false;
        }
        IPath path = this.getContainerFullPath();
        if (this.hasLicense && path != null) {
            String moduleName;
            int dotIndex;
            String dotLessModuleName;
            Module module;
            WorkspaceJob job;
            IFile file = this.createFileHandle(path.append(this.getFileName()));
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
            if (projectSourceParser.getLastTimeChecked() == null && (job = projectSourceParser.analyzeAll()) != null) {
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
            }
            if ((module = projectSourceParser.getModuleByName(dotLessModuleName = (dotIndex = (moduleName = this.getFileName()).indexOf(46)) == -1 ? moduleName : moduleName.substring(0, dotIndex))) != null) {
                this.setErrorMessage("A module with the name " + moduleName + " already exists in the project " + file.getProject().getName());
                return false;
            }
        }
        return this.validateName();
    }

    private boolean validateName() {
        String longModuleName;
        String originalmoduleName = this.getFileName();
        if (originalmoduleName == null) {
            return false;
        }
        int dotIndex = originalmoduleName.lastIndexOf(46);
        String string = longModuleName = dotIndex == -1 ? originalmoduleName : originalmoduleName.substring(0, dotIndex);
        if ("".equals(longModuleName)) {
            this.setErrorMessage(EMPTYNAMEERROR);
            return false;
        }
        if (!MODULENAMEPATTERN.matcher(longModuleName).matches()) {
            this.setErrorMessage(MessageFormat.format(INVALIDMODULENAME, longModuleName));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected InputStream getInitialContents() {
        switch (this.wizard.getOptionsPage().getGeneratedModuleType()) {
            case EMPTY: {
                return super.getInitialContents();
            }
            case NAME_AND_EMPTY_BODY: {
                String temporalModule = TTCN3CodeSkeletons.getTTCN3ModuleWithEmptyBody(this.getModuleName());
                return new BufferedInputStream(new ByteArrayInputStream(temporalModule.getBytes()));
            }
            case SKELETON: {
                String temporalModuleSkeleton = TTCN3CodeSkeletons.getTTCN3ModuleSkeleton(this.getModuleName());
                return new BufferedInputStream(new ByteArrayInputStream(temporalModuleSkeleton.getBytes()));
            }
        }
        return super.getInitialContents();
    }

    private String getModuleName() {
        String moduleName = this.getFileName();
        int dotIndex = moduleName.indexOf(46);
        String dotLessModuleName = dotIndex == -1 ? moduleName : moduleName.substring(0, dotIndex);
        return dotLessModuleName;
    }
}

