/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewProjectNameDialog
extends Dialog {
    private String name;
    private Text nameText;
    private Label verdict;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewProjectNameDialog.this.validate();
        }
    };

    public NewProjectNameDialog(Shell shell, String name) {
        super(shell);
        if (shell != null) {
            this.setShellStyle(shell.getStyle() | 0x10);
        }
        this.name = name;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Existing project found.");
    }

    public String getName() {
        return this.name;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite nameContainer = new Composite(parent, 0);
        nameContainer.setLayout((Layout)new GridLayout(2, false));
        nameContainer.setLayoutData((Object)new GridData(1808));
        Label nameLabel = new Label(nameContainer, 0);
        nameLabel.setText("The name of the project to create: ");
        this.nameText = new Text(nameContainer, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.name);
        this.nameText.addModifyListener(this.modifyListener);
        this.verdict = new Label(container, 0);
        this.verdict.setText("There is already a project with this name in the workspace.");
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected Control createContents(Composite parent) {
        Control temp = super.createContents(parent);
        this.validate();
        return temp;
    }

    private void validate() {
        if (this.nameText == null) {
            return;
        }
        this.name = this.nameText.getText();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.name);
        if (project.exists()) {
            this.verdict.setVisible(true);
            this.getButton(0).setEnabled(false);
        } else {
            this.verdict.setVisible(false);
            this.getButton(0).setEnabled(true);
        }
    }
}

