/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.windows;

import edu.uci.ics.jung.graph.Graph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Deque;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.common.Layouts;
import org.eclipse.titanium.graph.gui.dialogs.ExportImagePreferencesDialog;
import org.eclipse.titanium.graph.gui.utils.LayoutEntry;
import org.eclipse.titanium.graph.gui.windows.GraphEditor;
import org.eclipse.titanium.graph.utils.CheckParallelPaths;
import org.eclipse.titanium.graph.utils.CircleCheck;
import org.eclipse.titanium.graph.visualization.BadLayoutException;
import org.eclipse.titanium.graph.visualization.ErrorType;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.titanium.gui.FindWindow;

public class ComponentTopologyGraphEditor
extends GraphEditor {
    public static final String ID = "org.eclipse.titanium.graph.editors.ComponentTopologyGraphEditor";

    @Override
    protected void initWindow() {
        this.drawArea = new JPanel();
        this.window.add((Component)this.drawArea, "Center");
        this.drawArea.setSize(this.windowSize.width, this.windowSize.height);
        this.drawArea.setPreferredSize(new Dimension(this.windowSize.width, this.windowSize.height));
        this.menuBar = new JMenuBar();
        this.window.add((Component)this.menuBar, "North");
        JMenu mnFile = new JMenu("File");
        ActionListener saveGraph = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = "";
                try {
                    path = ComponentTopologyGraphEditor.this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path"));
                }
                catch (CoreException exc) {
                    ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while reading persistent property", (Exception)((Object)exc));
                }
                final String oldPath = path;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FileDialog dialog = new FileDialog(ComponentTopologyGraphEditor.this.editorComposite.getShell(), 8192);
                        dialog.setText("Save Pajek file");
                        dialog.setFilterPath(oldPath);
                        dialog.setFilterExtensions(new String[]{"*.net", "*.dot"});
                        String graphFilePath = dialog.open();
                        if (graphFilePath == null) {
                            return;
                        }
                        String newPath = graphFilePath.substring(0, graphFilePath.lastIndexOf(File.separator) + 1);
                        try {
                            QualifiedName name = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path");
                            ComponentTopologyGraphEditor.this.project.setPersistentProperty(name, newPath);
                            if ("dot".equals(graphFilePath.substring(graphFilePath.lastIndexOf(46) + 1, graphFilePath.length()))) {
                                GraphHandler.saveGraphToDot((Graph<NodeDescriptor, EdgeDescriptor>)ComponentTopologyGraphEditor.this.graph, graphFilePath, ComponentTopologyGraphEditor.this.project.getName());
                            } else {
                                GraphHandler.saveGraphToPajek((Graph<NodeDescriptor, EdgeDescriptor>)ComponentTopologyGraphEditor.this.graph, graphFilePath);
                            }
                        }
                        catch (BadLayoutException be) {
                            ErrorReporter.logExceptionStackTrace((String)("Error while saving image to " + newPath), (Throwable)be);
                            ComponentTopologyGraphEditor.this.errorHandler.reportErrorMessage("Bad layout\n\n" + be.getMessage());
                        }
                        catch (Exception ce) {
                            ErrorReporter.logExceptionStackTrace((String)("Error while saving image to " + newPath), (Throwable)ce);
                            ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while setting persistent property", ce);
                        }
                    }
                });
            }
        };
        final JMenuItem mntmSave = new JMenuItem("Save (Ctrl+S)");
        mntmSave.addActionListener(saveGraph);
        mnFile.add(mntmSave);
        ActionListener exportImage = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = "";
                try {
                    path = ComponentTopologyGraphEditor.this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path"));
                }
                catch (CoreException exc) {
                    ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while reading persistent property", (Exception)((Object)exc));
                }
                final String oldPath = path;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExportImagePreferencesDialog prefDialog = new ExportImagePreferencesDialog(ComponentTopologyGraphEditor.this.editorComposite.getShell());
                        GraphHandler.ImageExportType mode = prefDialog.open();
                        FileDialog dialog = new FileDialog(ComponentTopologyGraphEditor.this.editorComposite.getShell(), 8192);
                        dialog.setText("Export image");
                        dialog.setFilterPath(oldPath);
                        dialog.setFilterExtensions(new String[]{"*.png"});
                        String graphFilePath = dialog.open();
                        if (graphFilePath == null) {
                            return;
                        }
                        String newPath = graphFilePath.substring(0, graphFilePath.lastIndexOf(File.separator) + 1);
                        try {
                            QualifiedName name = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path");
                            ComponentTopologyGraphEditor.this.project.setPersistentProperty(name, newPath);
                            ComponentTopologyGraphEditor.this.handler.saveToImage(graphFilePath, mode);
                        }
                        catch (BadLayoutException be) {
                            ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while saving image", be);
                            ComponentTopologyGraphEditor.this.errorHandler.reportErrorMessage(be.getMessage());
                        }
                        catch (CoreException ce) {
                            ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while setting persistent property", (Exception)((Object)ce));
                        }
                    }
                });
            }
        };
        final JMenuItem mntmExportToImage = new JMenuItem("Export to image file (Ctrl+E)");
        mntmExportToImage.addActionListener(exportImage);
        mnFile.add(mntmExportToImage);
        this.layoutMenu = new JMenu("Layout");
        this.layoutGroup = new ButtonGroup();
        this.layoutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IProgressMonitor monitor = Job.getJobManager().createProgressGroup();
                monitor.beginTask("Change layout", 100);
                if (!(e.getSource() instanceof LayoutEntry)) {
                    ComponentTopologyGraphEditor.this.errorHandler.reportErrorMessage("Unexpected error\n\nAn unusual error has been logged (see error log for further information)");
                    ErrorReporter.logError((String)"The layout changing event's source is not of type \"LayoutEntry\"!");
                    return;
                }
                LayoutEntry layout = (LayoutEntry)e.getSource();
                if (ComponentTopologyGraphEditor.this.handler.getVisualizator() != null) {
                    ComponentTopologyGraphEditor.this.drawArea.remove((Component)((Object)ComponentTopologyGraphEditor.this.handler.getVisualizator()));
                }
                try {
                    ComponentTopologyGraphEditor.this.handler.changeLayout(layout, ComponentTopologyGraphEditor.this.windowSize);
                    ComponentTopologyGraphEditor.this.drawArea.add((Component)((Object)ComponentTopologyGraphEditor.this.handler.getVisualizator()));
                    if (ComponentTopologyGraphEditor.this.satView != null) {
                        ComponentTopologyGraphEditor.this.satView.add(ComponentTopologyGraphEditor.this.handler.getSatelliteViewer());
                    }
                    ComponentTopologyGraphEditor.this.window.pack();
                }
                catch (BadLayoutException exc) {
                    layout.setSelected(false);
                    ComponentTopologyGraphEditor.this.chosenLayout.setSelected(true);
                    if (exc.getType() == ErrorType.EMPTY_GRAPH || exc.getType() == ErrorType.NO_OBJECT) {
                        return;
                    }
                    try {
                        ComponentTopologyGraphEditor.this.handler.changeLayout(ComponentTopologyGraphEditor.this.chosenLayout, ComponentTopologyGraphEditor.this.windowSize);
                        ComponentTopologyGraphEditor.this.drawArea.add((Component)((Object)ComponentTopologyGraphEditor.this.handler.getVisualizator()));
                        if (ComponentTopologyGraphEditor.this.satView != null) {
                            ComponentTopologyGraphEditor.this.satView.add(ComponentTopologyGraphEditor.this.handler.getSatelliteViewer());
                        }
                        ComponentTopologyGraphEditor.this.window.pack();
                        monitor.done();
                    }
                    catch (BadLayoutException exc2) {
                        monitor.done();
                        if (exc2.getType() != ErrorType.CYCLIC_GRAPH && exc2.getType() != ErrorType.EMPTY_GRAPH) {
                            ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while creating layout", exc2);
                        } else {
                            ComponentTopologyGraphEditor.this.errorHandler.reportErrorMessage(exc2.getMessage());
                        }
                    }
                    catch (IllegalStateException exc3) {
                        monitor.done();
                        ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while creating layout", exc3);
                    }
                    if (exc.getType() != ErrorType.CYCLIC_GRAPH && exc.getType() != ErrorType.EMPTY_GRAPH) {
                        ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while creating layout", exc);
                    } else {
                        ComponentTopologyGraphEditor.this.errorHandler.reportErrorMessage(exc.getMessage());
                    }
                }
                catch (IllegalStateException exc) {
                    layout.setSelected(false);
                    ComponentTopologyGraphEditor.this.chosenLayout.setSelected(true);
                    try {
                        ComponentTopologyGraphEditor.this.handler.changeLayout(ComponentTopologyGraphEditor.this.chosenLayout, ComponentTopologyGraphEditor.this.windowSize);
                        ComponentTopologyGraphEditor.this.drawArea.add((Component)((Object)ComponentTopologyGraphEditor.this.handler.getVisualizator()));
                        if (ComponentTopologyGraphEditor.this.satView != null) {
                            ComponentTopologyGraphEditor.this.satView.add(ComponentTopologyGraphEditor.this.handler.getSatelliteViewer());
                        }
                        ComponentTopologyGraphEditor.this.window.pack();
                        monitor.done();
                    }
                    catch (BadLayoutException exc2) {
                        monitor.done();
                        if (exc2.getType() != ErrorType.CYCLIC_GRAPH && exc2.getType() != ErrorType.EMPTY_GRAPH) {
                            ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while creating layout", exc2);
                        } else {
                            ComponentTopologyGraphEditor.this.errorHandler.reportErrorMessage(exc2.getMessage());
                        }
                    }
                    catch (IllegalStateException exc3) {
                        monitor.done();
                        ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while creating layout", exc3);
                    }
                    ComponentTopologyGraphEditor.this.errorHandler.reportException("Error while creating layout", exc);
                }
                ComponentTopologyGraphEditor.this.chosenLayout = layout.newInstance();
                monitor.done();
            }
        };
        JMenu findMenu = new JMenu("Find");
        final JMenuItem nodeByName = new JMenuItem("Node by name (Ctrl+F)");
        final ComponentTopologyGraphEditor thisEditor = this;
        nodeByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ComponentTopologyGraphEditor.this.wndFind != null) {
                            ComponentTopologyGraphEditor.this.wndFind.close();
                        }
                        try {
                            ComponentTopologyGraphEditor.this.wndFind = new FindWindow<NodeDescriptor>(ComponentTopologyGraphEditor.this.editorComposite.getShell(), thisEditor, ComponentTopologyGraphEditor.this.graph.getVertices());
                            ComponentTopologyGraphEditor.this.wndFind.open();
                        }
                        catch (IllegalArgumentException e) {
                            ComponentTopologyGraphEditor.this.errorHandler.reportException("", e);
                        }
                    }
                });
            }
        });
        findMenu.add(nodeByName);
        JMenu tools = new JMenu("Tools");
        JMenuItem findCircles = new JMenuItem("Show circles");
        JMenuItem findPaths = new JMenuItem("Show parallel paths");
        JMenuItem clearResults = new JMenuItem("Clear Results");
        findCircles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Job circlesJob = new Job("Searching for circles"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (ComponentTopologyGraphEditor.this.graph == null) {
                            return null;
                        }
                        CircleCheck checker = new CircleCheck(ComponentTopologyGraphEditor.this.graph);
                        if (checker.isCyclic()) {
                            for (EdgeDescriptor edgeDescriptor : ComponentTopologyGraphEditor.this.graph.getEdges()) {
                                edgeDescriptor.setColour(Color.lightGray);
                            }
                            for (Deque deque : checker.getCircles()) {
                                for (EdgeDescriptor e : deque) {
                                    e.setColour(NodeColours.DARK_RED);
                                }
                            }
                            ComponentTopologyGraphEditor.this.refresh();
                        } else {
                            ComponentTopologyGraphEditor.this.errorHandler.reportInformation("Result:\n\nThis graph is not cyclic!");
                        }
                        return Status.OK_STATUS;
                    }
                };
                circlesJob.schedule();
            }
        });
        findPaths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Job pathsJob = new Job("Searching for parallel paths"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (ComponentTopologyGraphEditor.this.graph == null) {
                            return null;
                        }
                        CheckParallelPaths checker = null;
                        checker = new CheckParallelPaths(ComponentTopologyGraphEditor.this.graph);
                        if (checker.hasParallelPaths()) {
                            for (EdgeDescriptor edgeDescriptor : ComponentTopologyGraphEditor.this.graph.getEdges()) {
                                edgeDescriptor.setColour(Color.lightGray);
                            }
                            for (Deque deque : checker.getPaths()) {
                                for (EdgeDescriptor e : deque) {
                                    e.setColour(NodeColours.DARK_RED);
                                }
                            }
                            ComponentTopologyGraphEditor.this.refresh();
                        } else {
                            ComponentTopologyGraphEditor.this.errorHandler.reportInformation("Result:\n\nThere are no parallel paths in this graph!");
                        }
                        return Status.OK_STATUS;
                    }
                };
                pathsJob.schedule();
            }
        });
        clearResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                for (EdgeDescriptor e : ComponentTopologyGraphEditor.this.graph.getEdges()) {
                    e.setColour(Color.black);
                }
                ComponentTopologyGraphEditor.this.refresh();
            }
        });
        tools.add(findCircles);
        tools.add(findPaths);
        tools.add(clearResults);
        this.menuBar.add(mnFile);
        this.menuBar.add(findMenu);
        this.menuBar.add(tools);
        this.menuBar.add(this.layoutMenu);
        this.handlerService.activateHandler("org.eclipse.titanium.commands.GraphSearch", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                nodeByName.getActionListeners()[0].actionPerformed(null);
                ComponentTopologyGraphEditor.this.handlers.add(this);
                return null;
            }
        });
        this.handlerService.activateHandler("org.eclipse.titanium.commands.GraphSave", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                mntmSave.getActionListeners()[0].actionPerformed(null);
                ComponentTopologyGraphEditor.this.handlers.add(this);
                return null;
            }
        });
        this.handlerService.activateHandler("org.eclipse.titanium.commands.GraphExport", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                mntmExportToImage.getActionListeners()[0].actionPerformed(null);
                ComponentTopologyGraphEditor.this.handlers.add(this);
                return null;
            }
        });
        LayoutEntry isom = Layouts.LAYOUT_ISOM.newInstance();
        isom.addActionListener(this.layoutListener);
        this.layoutGroup.add(isom);
        this.layoutMenu.add(isom);
        JMenu dagMenu = new JMenu("Directed layouts");
        this.layoutMenu.add(dagMenu);
        LayoutEntry tdag = Layouts.LAYOUT_TDAG.newInstance();
        tdag.setSelected(true);
        tdag.addActionListener(this.layoutListener);
        dagMenu.add(tdag);
        this.layoutGroup.add(tdag);
        LayoutEntry rtdag = Layouts.LAYOUT_RTDAG.newInstance();
        rtdag.addActionListener(this.layoutListener);
        dagMenu.add(rtdag);
        this.layoutGroup.add(rtdag);
    }

    @Override
    public void recolour(Collection<NodeDescriptor> nodeSet) {
        for (NodeDescriptor v : nodeSet) {
            v.setNodeColour(NodeColours.LIGHT_GREEN);
        }
    }

    @Override
    protected void initGeneratorAndHandler(Composite parent) {
        this.handler = new GraphHandler();
    }
}

