/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.sonar.metrics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.TestcaseMetric;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SonarMetricsExporter {
    public void export(MetricData metricData, File file) throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element projectElement = document.createElement("project");
        Element nameElement = document.createElement("name");
        String projectName = metricData.getProject().getName();
        nameElement.appendChild(document.createTextNode(projectName));
        projectElement.appendChild(nameElement);
        Element modulesElement = document.createElement("modules");
        projectElement.appendChild(modulesElement);
        for (Module module : metricData.getModules()) {
            Element moduleElement = document.createElement("module");
            Element projectRelativePathElement = document.createElement("projectRelativePath");
            String projectRelativePath = module.getLocation().getFile().getProjectRelativePath().toPortableString();
            projectRelativePathElement.appendChild(document.createTextNode(projectRelativePath));
            moduleElement.appendChild(projectRelativePathElement);
            Element linesOfCodeElement = document.createElement("linesOfCode");
            linesOfCodeElement.appendChild(document.createTextNode(metricData.get(ModuleMetric.LINES_OF_CODE, module).toString()));
            moduleElement.appendChild(linesOfCodeElement);
            Element statementsElement = document.createElement("statements");
            statementsElement.appendChild(document.createTextNode(metricData.get(ModuleMetric.NOF_STATEMENTS, module).toString()));
            moduleElement.appendChild(statementsElement);
            Element functionsElement = document.createElement("functions");
            functionsElement.appendChild(document.createTextNode(metricData.get(ModuleMetric.NOF_FUNCTIONS, module).toString()));
            moduleElement.appendChild(functionsElement);
            Element altstepsElement = document.createElement("altsteps");
            altstepsElement.appendChild(document.createTextNode(metricData.get(ModuleMetric.NOF_ALTSTEPS, module).toString()));
            moduleElement.appendChild(altstepsElement);
            Element testCasesElement = document.createElement("testCases");
            testCasesElement.appendChild(document.createTextNode(metricData.get(ModuleMetric.NOF_TESTCASES, module).toString()));
            moduleElement.appendChild(testCasesElement);
            Element complexityElement = document.createElement("complexity");
            complexityElement.appendChild(document.createTextNode("" + this.calculateComplexity(metricData, module)));
            moduleElement.appendChild(complexityElement);
            modulesElement.appendChild(moduleElement);
        }
        document.appendChild(projectElement);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        tr.transform(new DOMSource(document), new StreamResult(new FileOutputStream(file)));
    }

    private int calculateComplexity(MetricData metricData, Module module) {
        int complexity = 0;
        for (Def_Function function : metricData.getFunctions().get(module)) {
            complexity += metricData.get(FunctionMetric.CYCLOMATIC_COMPLEXITY, function).intValue();
        }
        for (Def_Altstep altstep : metricData.getAltsteps().get(module)) {
            complexity += metricData.get(AltstepMetric.CYCLOMATIC_COMPLEXITY, altstep).intValue();
        }
        for (Def_Testcase testcase : metricData.getTestcases().get(module)) {
            complexity += metricData.get(TestcaseMetric.CYCLOMATIC_COMPLEXITY, testcase).intValue();
        }
        return complexity;
    }
}

