/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TtcnError;

public class JSON {
    public static final int JSON_ERROR_INVALID_TOKEN = -1;
    public static final int JSON_ERROR_FATAL = -2;
    public static final int JSON_METAINFO_NOT_APPLICABLE = 0;
    public static final int JSON_METAINFO_NONE = 1;
    public static final int JSON_METAINFO_NEEDED = 2;
    public static final int JSON_METAINFO_UNBOUND = 3;
    public static final int CHOSEN_FIELD_UNSET = -1;
    public static final int CHOSEN_FIELD_OMITTED = -2;
    public static final String JSON_DEC_BAD_TOKEN_ERROR = "Failed to extract valid token, invalid JSON format%s";
    public static final String JSON_DEC_FORMAT_ERROR = "Invalid JSON %s format, expecting %s value";
    public static final String JSON_DEC_NAME_TOKEN_ERROR = "Invalid JSON token, expecting JSON field name";
    public static final String JSON_DEC_OBJECT_END_TOKEN_ERROR = "Invalid JSON token, expecting JSON name-value pair or object end mark%s";
    public static final String JSON_DEC_REC_OF_END_TOKEN_ERROR = "Invalid JSON token, expecting JSON value or array end mark%s";
    public static final String JSON_DEC_ARRAY_ELEM_TOKEN_ERROR = "Invalid JSON token, expecting %d more JSON value%s";
    public static final String JSON_DEC_ARRAY_END_TOKEN_ERROR = "Invalid JSON token, expecting JSON array end mark%s";
    public static final String JSON_DEC_FIELD_TOKEN_ERROR = "Invalid JSON token found while decoding field '%s'";
    public static final String JSON_DEC_INVALID_NAME_ERROR = "Invalid field name '%s'";
    public static final String JSON_DEC_MISSING_FIELD_ERROR = "No JSON data found for field '%s'";
    public static final String JSON_DEC_STATIC_OBJECT_END_TOKEN_ERROR = "Invalid JSON token, expecting JSON object end mark%s";
    public static final String JSON_DEC_AS_VALUE_ERROR = "Extracted JSON %s could not be decoded by any field of the union";
    public static final String JSON_DEC_METAINFO_NAME_ERROR = "Meta info provided for non-existent field '%s'";
    public static final String JSON_DEC_METAINFO_VALUE_ERROR = "Invalid meta info for field '%s'";
    public static final String JSON_DEC_METAINFO_NOT_APPLICABLE = "Meta info not applicable to field '%s'";
    public static final String JSON_DEC_CHOSEN_FIELD_NOT_NULL = "Invalid JSON token, expecting 'null' (as indicated by a condition in attribute 'chosen')%s";
    public static final String JSON_DEC_CHOSEN_FIELD_OMITTED = "Field '%s' cannot be omitted (as indicated by a condition in attribute 'chosen')";
    public static final String JSON_DEC_CHOSEN_FIELD_OMITTED_NULL = "Field cannot be omitted (as indicated by a condition in attribute 'chosen')%s";
    public static final TTCN_JSONdescriptor ENUMERATED_json_ = new TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, json_string_escaping.ESCAPE_AS_SHORT);
    private static final RAW.TTCN_RAWdescriptor cbor_float_raw_ = new RAW.TTCN_RAWdescriptor(64, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    private static final Base_Type.TTCN_Typedescriptor cbor_float_descr_ = new Base_Type.TTCN_Typedescriptor(null, null, cbor_float_raw_, null, null);
    private static final RAW.TTCN_RAWdescriptor bson_float_raw_ = new RAW.TTCN_RAWdescriptor(64, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_MSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    private static final Base_Type.TTCN_Typedescriptor bson_float_descr_ = new Base_Type.TTCN_Typedescriptor(null, null, bson_float_raw_, null, null);

    private JSON() {
    }

    private static byte[] check_and_get_buffer(TTCN_Buffer buff, int bytes) {
        if (bytes < 0) {
            throw new TtcnError(MessageFormat.format("Incorrect length byte received: {0}, while decoding using cbor2json()", bytes));
        }
        if (buff.get_pos() + bytes > buff.get_len()) {
            throw new TtcnError("Not enough bytes in bytestream while decoding using cbor2json().");
        }
        return buff.get_read_data();
    }

    private static void encode_ulong_long_int_cbor(TTCN_Buffer buff, int bytes, long value) {
        for (int i = bytes - 1; i >= 0; --i) {
            buff.put_c((byte)(value >> i * 8));
        }
    }

    private static void encode_int_cbor(TTCN_Buffer buff, int major_type, TitanInteger int_num) {
        boolean is_negative = false;
        if (int_num.is_less_than(0)) {
            major_type = 32;
            int_num = int_num.sub().sub(1);
            is_negative = true;
        }
        if (int_num.is_native()) {
            int uns_num = int_num.get_int();
            if (uns_num <= 23) {
                buff.put_c((byte)(major_type + uns_num));
            } else if (uns_num <= 255) {
                buff.put_c((byte)(major_type + 24));
                JSON.encode_ulong_long_int_cbor(buff, 1, uns_num);
            } else if (uns_num <= 65535) {
                buff.put_c((byte)(major_type + 25));
                JSON.encode_ulong_long_int_cbor(buff, 2, uns_num);
            } else {
                buff.put_c((byte)(major_type + 26));
                JSON.encode_ulong_long_int_cbor(buff, 4, uns_num);
            }
        } else {
            BigInteger bn = int_num.get_BigInteger();
            byte[] byteArray = bn.toByteArray();
            int bn_length = byteArray.length;
            long long_int = int_num.get_long();
            if (bn_length <= 4) {
                buff.put_c((byte)(major_type + 26));
                JSON.encode_ulong_long_int_cbor(buff, 4, long_int);
            } else if (bn_length <= 8) {
                buff.put_c((byte)(major_type + 27));
                JSON.encode_ulong_long_int_cbor(buff, 8, long_int);
            } else {
                major_type = 192;
                buff.put_c((byte)(major_type += is_negative ? 3 : 2));
                major_type = 64;
                JSON.encode_int_cbor(buff, major_type, new TitanInteger(bn_length));
                buff.put_s(byteArray);
            }
        }
    }

    private static void decode_int_cbor(TTCN_Buffer buff, int bytes, TitanInteger result) {
        byte[] tmp = JSON.check_and_get_buffer(buff, bytes);
        TTCN_Buffer tmp_buf = new TTCN_Buffer();
        tmp_buf.put_s(tmp);
        TitanOctetString os = new TitanOctetString();
        tmp_buf.get_string(os);
        result.operator_assign(AdditionalFunctions.oct2int(os).get_int());
        buff.increase_pos(bytes);
    }

    private static void decode_uint_cbor(TTCN_Buffer buff, int bytes, TitanInteger result) {
        result.operator_assign(0);
        byte[] tmp = JSON.check_and_get_buffer(buff, bytes);
        for (int i = bytes - 1; i >= 0; --i) {
            result.operator_assign(result.add(tmp[bytes - 1 - i] << i * 8));
        }
        buff.increase_pos(bytes);
    }

    private static void decode_ulong_long_int_cbor(TTCN_Buffer buff, int bytes, AtomicLong value) {
        value.set(0L);
        byte[] tmp = JSON.check_and_get_buffer(buff, bytes);
        for (int i = bytes - 1; i >= 0; --i) {
            value.getAndAdd(tmp[bytes - 1 - i] << i * 8);
        }
        buff.increase_pos(bytes);
    }

    private static void decode_integer_cbor(TTCN_Buffer buff, int minor_type, TitanInteger result) {
        if (minor_type <= 23) {
            result.operator_assign(minor_type);
        } else if (minor_type == 24) {
            JSON.decode_uint_cbor(buff, 1, result);
        } else if (minor_type == 25) {
            JSON.decode_uint_cbor(buff, 2, result);
        } else if (minor_type == 26) {
            JSON.decode_uint_cbor(buff, 4, result);
        } else if (minor_type == 27) {
            JSON.decode_int_cbor(buff, 8, result);
        }
    }

    private static void decode_bytestring_cbor(TTCN_Buffer buff, JSON_Tokenizer tok, int minor_type, int tag) {
        TitanInteger length = new TitanInteger();
        JSON.decode_integer_cbor(buff, minor_type, length);
        byte[] tmp = JSON.check_and_get_buffer(buff, length.get_int());
        TitanOctetString os = new TitanOctetString(tmp);
        buff.increase_pos(length.get_int());
        TitanCharString cs = new TitanCharString();
        if (tag == 22 || tag == 23 || tag == 2 || tag == 3) {
            cs = AdditionalFunctions.encode_base64(os);
            if (tag != 22) {
                String data = cs.get_value().toString();
                if ((data = data.replace('+', '-').replace('/', '_')).length() > 0 && data.charAt(data.length() - 1) == '=') {
                    data = data.substring(0, data.length() - 1);
                }
                if (data.length() > 0 && data.charAt(data.length() - 1) == '=') {
                    data = data.substring(0, data.length() - 1);
                }
                cs = new TitanCharString(data);
            }
        } else if (tag == 21) {
            cs = AdditionalFunctions.oct2str(os);
        }
        String tmp_str = MessageFormat.format("\"{0}{1}\"", tag == 3 ? "~" : "", cs);
        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str);
    }

    public static void json2cbor_coding(TTCN_Buffer buff, JSON_Tokenizer tok, AtomicInteger num_of_items) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        int prev_pos = tok.get_buf_pos();
        tok.get_next_token(token, content, len);
        switch (token.get()) {
            case JSON_TOKEN_NUMBER: {
                String str = content.toString();
                int curr_pos = tok.get_buf_pos();
                tok.set_buf_pos(prev_pos);
                AtomicBoolean is_float = new AtomicBoolean(false);
                tok.check_for_number(is_float);
                tok.set_buf_pos(curr_pos);
                if (is_float.get()) {
                    int c = 224;
                    buff.put_c((byte)(c += 27));
                    TitanFloat f = AdditionalFunctions.str2float(str);
                    f.encode(cbor_float_descr_, buff, TTCN_EncDec.coding_type.CT_RAW, 0);
                } else {
                    boolean c = false;
                    TitanInteger int_num = AdditionalFunctions.str2int(str);
                    JSON.encode_int_cbor(buff, 0, int_num);
                }
                num_of_items.incrementAndGet();
                break;
            }
            case JSON_TOKEN_STRING: 
            case JSON_TOKEN_NAME: {
                int c = 96;
                TitanInteger length = new TitanInteger(token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME ? len.get() : len.get() - 2);
                JSON.encode_int_cbor(buff, 96, length);
                String str = token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME ? content.toString() : content.substring(1, content.length() - 1);
                buff.put_string(new TitanCharString(str));
                num_of_items.incrementAndGet();
                break;
            }
            case JSON_TOKEN_ARRAY_START: {
                int c = 128;
                AtomicInteger nof_items = new AtomicInteger(0);
                TTCN_Buffer sub_buff = new TTCN_Buffer();
                tok.get_next_token(token, null, null);
                prev_pos = tok.get_buf_pos();
                while (prev_pos != 0) {
                    if (token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_END) {
                        TitanInteger num = new TitanInteger(nof_items.get());
                        JSON.encode_int_cbor(buff, 128, num);
                        buff.put_buf(sub_buff);
                        break;
                    }
                    tok.set_buf_pos(prev_pos);
                    JSON.json2cbor_coding(sub_buff, tok, nof_items);
                    tok.get_next_token(token, null, null);
                    prev_pos = tok.get_buf_pos();
                }
                num_of_items.incrementAndGet();
                break;
            }
            case JSON_TOKEN_ARRAY_END: {
                throw new TtcnError("Unexpected array end character while encoding using json2cbor().");
            }
            case JSON_TOKEN_OBJECT_START: {
                int c = 160;
                AtomicInteger nof_items = new AtomicInteger(0);
                TTCN_Buffer sub_buff = new TTCN_Buffer();
                tok.get_next_token(token, null, null);
                prev_pos = tok.get_buf_pos();
                while (prev_pos != 0) {
                    if (token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
                        TitanInteger num = new TitanInteger(nof_items.get() / 2);
                        JSON.encode_int_cbor(buff, 160, num);
                        buff.put_buf(sub_buff);
                        break;
                    }
                    tok.set_buf_pos(prev_pos);
                    JSON.json2cbor_coding(sub_buff, tok, nof_items);
                    tok.get_next_token(token, null, null);
                    prev_pos = tok.get_buf_pos();
                }
                num_of_items.incrementAndGet();
                break;
            }
            case JSON_TOKEN_OBJECT_END: {
                throw new TtcnError("Unexpected object end character while encoding using json2cbor().");
            }
            case JSON_TOKEN_LITERAL_FALSE: 
            case JSON_TOKEN_LITERAL_TRUE: 
            case JSON_TOKEN_LITERAL_NULL: {
                int c = 224;
                int i = 0;
                if (token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_FALSE) {
                    i = 20;
                } else if (token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_TRUE) {
                    i = 21;
                } else if (token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL) {
                    i = 22;
                }
                JSON.encode_int_cbor(buff, 224, new TitanInteger(i));
                num_of_items.incrementAndGet();
                break;
            }
            default: {
                throw new TtcnError("Unexpected json token " + (Object)((Object)token.get()) + ", while encoding using json2cbor().");
            }
        }
    }

    public static void cbor2json_coding(TTCN_Buffer buff, JSON_Tokenizer tok, boolean in_object) {
        byte type = JSON.check_and_get_buffer(buff, 1)[0];
        buff.increase_pos(1);
        int major_type = type >> 5;
        int minor_type = type & 0x1F;
        block0 : switch (major_type) {
            case 0: {
                TitanInteger i = new TitanInteger();
                JSON.decode_integer_cbor(buff, minor_type, i);
                if (i.is_native()) {
                    String tmp_str = Integer.toString(i.get_int());
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                    break;
                }
                String tmp_str = i.get_BigInteger().toString();
                tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                break;
            }
            case 1: {
                switch (minor_type) {
                    case 24: {
                        TitanInteger num = new TitanInteger();
                        JSON.decode_uint_cbor(buff, 1, num);
                        TitanInteger i = num.add(1).mul(-1);
                        String tmp_str = i.is_native() ? Integer.toString(i.get_int()) : i.get_BigInteger().toString();
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                        break block0;
                    }
                    case 25: {
                        TitanInteger num = new TitanInteger();
                        JSON.decode_uint_cbor(buff, 2, num);
                        TitanInteger i = num.add(1).mul(-1);
                        String tmp_str = i.is_native() ? Integer.toString(i.get_int()) : i.get_BigInteger().toString();
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                        break block0;
                    }
                    case 26: {
                        AtomicLong num = new AtomicLong();
                        JSON.decode_ulong_long_int_cbor(buff, 4, num);
                        TitanInteger i = new TitanInteger();
                        i.operator_assign((int)((num.get() + 1L) * -1L));
                        String tmp_str = i.is_native() ? Integer.toString(i.get_int()) : i.get_BigInteger().toString();
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                        break block0;
                    }
                    case 27: {
                        TitanInteger i = new TitanInteger();
                        JSON.decode_int_cbor(buff, 8, i);
                        i.operator_assign(i.add(1));
                        i.operator_assign(i.mul(-1));
                        String tmp_str = i.is_native() ? Integer.toString(i.get_int()) : i.get_BigInteger().toString();
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                        break block0;
                    }
                }
                if (minor_type >= 24) break;
                String tmp_str = Integer.toString((minor_type + 1) * -1);
                tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                break;
            }
            case 2: {
                JSON.decode_bytestring_cbor(buff, tok, minor_type, 23);
                break;
            }
            case 3: {
                TitanInteger length = new TitanInteger();
                JSON.decode_integer_cbor(buff, minor_type, length);
                byte[] tmp = JSON.check_and_get_buffer(buff, length.get_int());
                String json_str = new String(tmp);
                if (in_object) {
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, json_str);
                } else {
                    String tmp_str = "\"" + json_str + "\"";
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str);
                }
                buff.increase_pos(length.get_int());
                break;
            }
            case 4: {
                tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_START, null);
                TitanInteger num_of_items = new TitanInteger();
                JSON.decode_integer_cbor(buff, minor_type, num_of_items);
                for (int i = 0; i < num_of_items.get_int(); ++i) {
                    JSON.cbor2json_coding(buff, tok, false);
                }
                tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_END, null);
                break;
            }
            case 5: {
                tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                TitanInteger num_of_items = new TitanInteger();
                JSON.decode_integer_cbor(buff, minor_type, num_of_items);
                int num_of_pairs = num_of_items.get_int() * 2;
                for (int i = 0; i < num_of_pairs; ++i) {
                    JSON.cbor2json_coding(buff, tok, i % 2 == 0);
                }
                tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                break;
            }
            case 6: {
                int tag = minor_type;
                switch (tag) {
                    case 2: 
                    case 3: 
                    case 21: 
                    case 22: 
                    case 23: {
                        type = JSON.check_and_get_buffer(buff, 1)[0];
                        buff.increase_pos(1);
                        minor_type = type & 0x1F;
                        JSON.decode_bytestring_cbor(buff, tok, minor_type, tag);
                        break block0;
                    }
                }
                JSON.cbor2json_coding(buff, tok, in_object);
                break;
            }
            case 7: {
                switch (minor_type) {
                    case 20: {
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_FALSE, null);
                        break block0;
                    }
                    case 21: {
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_TRUE, null);
                        break block0;
                    }
                    case 22: {
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL, null);
                        break block0;
                    }
                    case 25: {
                        byte[] halfp = JSON.check_and_get_buffer(buff, 2);
                        buff.increase_pos(2);
                        int half = (halfp[0] << 8) + (halfp[1] & 0xFF);
                        int exp = half >> 10 & 0x1F;
                        int mant = half & 0x3FF;
                        double val = exp == 0 ? Math.pow(mant, -24.0) : (exp != 31 ? Math.pow(mant + 1024, exp - 25) : (mant == 0 ? Double.POSITIVE_INFINITY : Double.NaN));
                        val = (half & 0x8000) != 0 ? -val : val;
                        TitanFloat f = new TitanFloat(val);
                        f.JSON_encode(cbor_float_descr_, tok);
                        break block0;
                    }
                    case 26: {
                        TitanOctetString os = new TitanOctetString(JSON.check_and_get_buffer(buff, 4));
                        buff.increase_pos(4);
                        TitanInteger i = AdditionalFunctions.oct2int(os);
                        TitanFloat f = AdditionalFunctions.int2float(i);
                        f.JSON_encode(cbor_float_descr_, tok);
                        break block0;
                    }
                    case 27: {
                        JSON.cbor_float_raw_.fieldlength = 64;
                        TitanFloat f = new TitanFloat();
                        TitanOctetString os = new TitanOctetString(JSON.check_and_get_buffer(buff, 8));
                        TitanInteger i = AdditionalFunctions.oct2int(os);
                        if (i.get_long() != 9221120237041090560L) {
                            f.decode(cbor_float_descr_, buff, TTCN_EncDec.coding_type.CT_RAW, 0);
                            f.JSON_encode(cbor_float_descr_, tok);
                            break block0;
                        }
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, "\"not_a_number\"");
                        buff.increase_pos(8);
                        break block0;
                    }
                }
                if (minor_type >= 0 && minor_type <= 23) {
                    String tmp_str = Integer.toString(minor_type);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                    break;
                }
                if (minor_type != 24) break;
                byte simple_value = buff.get_read_data()[0];
                buff.increase_pos(1);
                String tmp_str = Integer.toString(simple_value);
                tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                break;
            }
            default: {
                throw new TtcnError("Unexpected major type " + major_type + " while decoding using cbor2json().");
            }
        }
    }

    private static byte[] check_and_get_buffer_bson(TTCN_Buffer buff, int bytes) {
        if (bytes < 0) {
            throw new TtcnError("Incorrect length byte received: " + bytes + "%d, while decoding using bson2json()");
        }
        if (buff.get_pos() + bytes > buff.get_len()) {
            throw new TtcnError("Not enough bytes in bytestream while decoding using bson2json().");
        }
        return buff.get_read_data();
    }

    private static void encode_int_bson(TTCN_Buffer buff, TitanInteger int_num, TitanInteger length) {
        if (int_num.is_native()) {
            length.operator_assign(length.add(4));
            int value = int_num.get_int();
            for (int i = 0; i < 4; ++i) {
                buff.put_c((byte)(value >> i * 8));
            }
        } else {
            BigInteger bn = int_num.get_BigInteger();
            byte[] byteArray = bn.toByteArray();
            int bn_length = byteArray.length;
            long long_int = 0L;
            int bytes = 0;
            if (bn_length <= 4) {
                bytes = 4;
                long_int = int_num.get_long();
            } else if (bn_length <= 8) {
                bytes = 8;
                long_int = int_num.get_long();
            } else {
                throw new TtcnError("An integer value which cannot be represented on 64bits cannot be encoded using json2bson()");
            }
            for (int i = 0; i < bytes; ++i) {
                buff.put_c((byte)(long_int >> i * 8));
            }
            length.operator_assign(length.add(bytes));
        }
    }

    private static TitanInteger decode_int_bson(TTCN_Buffer buff, int bytes) {
        byte[] uc = JSON.check_and_get_buffer_bson(buff, bytes);
        buff.increase_pos(bytes);
        if (bytes <= 4) {
            int value = 0;
            for (int i = 0; i < 4; ++i) {
                value += uc[i] << i * 8;
            }
            return new TitanInteger(value);
        }
        if (bytes <= 8) {
            TTCN_Buffer tmp_buf = new TTCN_Buffer();
            for (int i = 0; i < bytes; ++i) {
                tmp_buf.put_c(uc[bytes - i - 1]);
            }
            TitanOctetString os = new TitanOctetString();
            tmp_buf.get_string(os);
            TitanInteger value = AdditionalFunctions.oct2int(os);
            return value;
        }
        throw new TtcnError("An integer value larger than 64 bytes cannot be decoded using bson2json()");
    }

    private static void put_name(TTCN_Buffer buff, TitanInteger length, TitanCharString name, boolean in_array) {
        if (in_array) {
            buff.put_cs(name);
            buff.put_c((byte)0);
            length.operator_assign(length.add(name.lengthof()).add(1));
            TitanInteger num = AdditionalFunctions.str2int(name);
            num = num.add(1);
            name.operator_assign(AdditionalFunctions.int2str(num));
        } else {
            buff.put_cs(name);
            buff.put_c((byte)0);
            length.operator_assign(length.add(name.lengthof()).add(1));
        }
    }

    private static void get_name(TTCN_Buffer buff, JSON_Tokenizer tok, boolean in_array) {
        byte[] uc = buff.get_read_data();
        String tmp_str = new String(uc);
        if (!in_array) {
            tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, tmp_str);
        }
        buff.increase_pos(tmp_str.length() + 1);
    }

    private static boolean encode_bson_binary(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString cs2 = new TitanCharString(content.substring(1, content.length() - 1));
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME) {
            return false;
        }
        TitanCharString cs3 = new TitanCharString(content);
        if (cs3.operator_not_equals("$type")) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString cs4 = new TitanCharString(content.substring(1, content.length() - 1));
        if (cs4.lengthof().operator_not_equals(2)) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)5);
        length.operator_assign(length.add(1));
        TitanOctetString os = AdditionalFunctions.decode_base64(cs2);
        TitanInteger os_len = os.lengthof();
        JSON.encode_int_bson(buff, os_len, length);
        try {
            int type = Integer.parseInt(cs4.get_value().toString(), 16);
            buff.put_c((byte)type);
        }
        catch (NumberFormatException e) {
            throw new TtcnError("Incorrect binary format while encoding with json2bson()");
        }
        length.operator_assign(length.add(1));
        buff.put_os(os);
        length.operator_assign(length.add(os_len));
        return true;
    }

    private static boolean encode_bson_date(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME) {
            return false;
        }
        TitanCharString cs = new TitanCharString(content);
        if (cs.operator_not_equals("$numberLong")) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER) {
            return false;
        }
        TitanCharString cs2 = new TitanCharString(content);
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        TitanInteger int_num = AdditionalFunctions.str2int(cs2);
        buff.put_c((byte)9);
        length.operator_assign(length.add(1));
        long long_int = int_num.get_long();
        for (int i = 0; i < 8; ++i) {
            buff.put_c((byte)(long_int >> i * 8));
        }
        length.operator_assign(length.add(8));
        return true;
    }

    private static boolean encode_bson_timestamp(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME) {
            return false;
        }
        TitanCharString cs = new TitanCharString(content);
        if (cs.operator_not_equals("t")) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER) {
            return false;
        }
        TitanCharString cs2 = new TitanCharString(content);
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME) {
            return false;
        }
        TitanCharString cs3 = new TitanCharString(content);
        if (cs3.operator_not_equals("i")) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER) {
            return false;
        }
        TitanCharString cs4 = new TitanCharString(content);
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        TitanInteger timestamp = AdditionalFunctions.str2int(cs2);
        TitanInteger increment = AdditionalFunctions.str2int(cs4);
        buff.put_c((byte)17);
        length.operator_assign(length.add(1));
        JSON.encode_int_bson(buff, increment, length);
        JSON.encode_int_bson(buff, timestamp, length);
        return true;
    }

    private static boolean encode_bson_regex(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString regex = new TitanCharString(content.substring(1, content.length() - 1));
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME) {
            return false;
        }
        TitanCharString cs2 = new TitanCharString(content);
        if (cs2.operator_not_equals("$options")) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString options = new TitanCharString(content.substring(1, content.length() - 1));
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)11);
        length.operator_assign(length.add(1));
        buff.put_cs(regex);
        length.operator_assign(length.add(regex.lengthof()));
        buff.put_c((byte)0);
        length.operator_assign(length.add(1));
        buff.put_cs(options);
        length.operator_assign(length.add(options.lengthof()));
        buff.put_c((byte)0);
        length.operator_assign(length.add(1));
        return true;
    }

    private static boolean encode_bson_oid(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString id = new TitanCharString(content.substring(1, content.length() - 1));
        if (id.lengthof().operator_not_equals(24)) {
            return false;
        }
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)7);
        length.operator_assign(length.add(1));
        char[] hex = new char[12];
        for (int i = 0; i < 24; i += 2) {
            String octDigit = "" + id.get_at(i).get_char() + id.get_at(i + 1).get_char();
            try {
                int value = Integer.parseInt(octDigit, 16);
                hex[i / 2] = (char)value;
                continue;
            }
            catch (NumberFormatException e) {
                throw new TtcnError("Incorrect binary format while encoding with json2bson()");
            }
        }
        buff.put_s(hex);
        length.operator_assign(length.add(12));
        return true;
    }

    private static boolean encode_bson_ref(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString name = new TitanCharString(content.substring(1, content.length() - 1));
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME) {
            return false;
        }
        TitanCharString cs = new TitanCharString(content);
        if (cs.operator_not_equals("$id")) {
            return false;
        }
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString id = new TitanCharString(content.substring(1, content.length() - 1));
        if (id.lengthof().operator_not_equals(24)) {
            return false;
        }
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)12);
        length.operator_assign(length.add(1));
        TitanInteger name_length = name.lengthof().add(1);
        JSON.encode_int_bson(buff, name_length, length);
        buff.put_cs(name);
        buff.put_c((byte)0);
        length.operator_assign(length.add(name_length));
        char[] hex = new char[12];
        for (int i = 0; i < 24; i += 2) {
            String octDigit = "" + id.get_at(i).get_char() + id.get_at(i + 1).get_char();
            try {
                int value = Integer.parseInt(octDigit, 16);
                hex[i / 2] = (char)value;
                continue;
            }
            catch (NumberFormatException e) {
                throw new TtcnError("Incorrect binary format while encoding with json2bson()");
            }
        }
        buff.put_s(hex);
        length.operator_assign(length.add(12));
        return true;
    }

    private static boolean encode_bson_undefined(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_TRUE) {
            return false;
        }
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)6);
        length.operator_assign(length.add(1));
        return true;
    }

    private static boolean encode_bson_minkey(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER) {
            return false;
        }
        TitanCharString cs = new TitanCharString(content);
        if (cs.operator_not_equals("1")) {
            return false;
        }
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)-1);
        length.operator_assign(length.add(1));
        return true;
    }

    private static boolean encode_bson_maxkey(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER) {
            return false;
        }
        TitanCharString cs = new TitanCharString(content);
        if (cs.operator_not_equals("1")) {
            return false;
        }
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)127);
        length.operator_assign(length.add(1));
        return true;
    }

    private static boolean encode_bson_numberlong(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString cs = new TitanCharString(content.substring(1, content.length() - 1));
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)18);
        length.operator_assign(length.add(1));
        TitanInteger number = AdditionalFunctions.str2int(cs);
        long value = number.get_long();
        for (int i = 0; i < 8; ++i) {
            buff.put_c((byte)(value >> i * 8));
        }
        length.operator_assign(length.add(8));
        return true;
    }

    private static boolean encode_bson_code_with_scope(TTCN_Buffer buff, JSON_Tokenizer tok, TitanInteger length) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING) {
            return false;
        }
        TitanCharString cs = new TitanCharString(content.substring(1, content.length() - 1));
        tok.get_next_token(token, content, len);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME) {
            return false;
        }
        TitanCharString cs2 = new TitanCharString(content);
        if (cs2.operator_not_equals("$scope")) {
            return false;
        }
        TitanInteger code_w_scope_length = new TitanInteger(0);
        boolean is_special = false;
        TitanCharString f_name = new TitanCharString();
        TTCN_Buffer sub_buff = new TTCN_Buffer();
        JSON.json2bson_coding(sub_buff, tok, false, false, code_w_scope_length, f_name, false);
        tok.get_next_token(token, null, null);
        if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
            return false;
        }
        buff.put_c((byte)15);
        length.operator_assign(length.add(1));
        code_w_scope_length.add(code_w_scope_length.add(cs.lengthof().add(5)));
        JSON.encode_int_bson(buff, code_w_scope_length, code_w_scope_length);
        JSON.encode_int_bson(buff, cs.lengthof().add(1), length);
        buff.put_string(cs);
        buff.put_c((byte)0);
        buff.put_buf(sub_buff);
        length.operator_assign(length.add(code_w_scope_length.sub(4)));
        return true;
    }

    public static void json2bson_coding(TTCN_Buffer buff, JSON_Tokenizer tok, boolean in_object, boolean in_array, TitanInteger length, TitanCharString obj_name, boolean is_special) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>();
        StringBuilder content = new StringBuilder();
        AtomicInteger len = new AtomicInteger();
        int prev_pos = tok.get_buf_pos();
        tok.get_next_token(token, content, len);
        if (!in_object && token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START && token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_START) {
            throw new TtcnError("Json document must be an object or array when encoding with json2bson()");
        }
        switch (token.get()) {
            case JSON_TOKEN_OBJECT_START: {
                TTCN_Buffer tmp_buff;
                TTCN_Buffer sub_buff = new TTCN_Buffer();
                TitanInteger sub_len = new TitanInteger(0);
                TitanCharString subobj_name = new TitanCharString();
                if (obj_name.is_bound()) {
                    subobj_name = obj_name;
                }
                tok.get_next_token(token, null, null);
                prev_pos = tok.get_buf_pos();
                while (prev_pos != 0) {
                    if (token.get() != JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END) {
                        tok.set_buf_pos(prev_pos);
                        JSON.json2bson_coding(sub_buff, tok, true, false, sub_len, subobj_name, is_special);
                        if (is_special) {
                            tmp_buff = new TTCN_Buffer();
                            tmp_buff.put_c(sub_buff.get_data()[0]);
                            JSON.put_name(tmp_buff, sub_len, subobj_name, in_array);
                            tmp_buff.put_s(Arrays.copyOfRange(sub_buff.get_data(), 1, sub_buff.get_data().length));
                            sub_buff = tmp_buff;
                            in_object = false;
                            break;
                        }
                    } else {
                        sub_buff.put_c((byte)0);
                        sub_len.operator_assign(sub_len.add(1));
                        break;
                    }
                    tok.get_next_token(token, null, null);
                    prev_pos = tok.get_buf_pos();
                }
                if (in_object) {
                    tmp_buff = new TTCN_Buffer();
                    tmp_buff.put_c((byte)3);
                    length.operator_assign(length.add(1));
                    JSON.put_name(tmp_buff, length, obj_name, in_array);
                    JSON.encode_int_bson(tmp_buff, sub_len, sub_len);
                    length.operator_assign(length.add(sub_len));
                    tmp_buff.put_buf(sub_buff);
                    sub_buff = tmp_buff;
                } else if (!is_special) {
                    length.operator_assign(length.add(sub_len));
                    JSON.encode_int_bson(buff, length, length);
                } else {
                    length.operator_assign(length.add(sub_len));
                    is_special = false;
                }
                buff.put_buf(sub_buff);
                break;
            }
            case JSON_TOKEN_OBJECT_END: {
                throw new TtcnError("Unexpected object end character while encoding using json2bson().");
            }
            case JSON_TOKEN_NAME: {
                TitanCharString cs = new TitanCharString(content);
                prev_pos = tok.get_buf_pos();
                if (cs.operator_equals("$binary")) {
                    is_special = JSON.encode_bson_binary(buff, tok, length);
                } else if (cs.operator_equals("$date")) {
                    is_special = JSON.encode_bson_date(buff, tok, length);
                } else if (cs.operator_equals("$timestamp")) {
                    is_special = JSON.encode_bson_timestamp(buff, tok, length);
                } else if (cs.operator_equals("$regex")) {
                    is_special = JSON.encode_bson_regex(buff, tok, length);
                } else if (cs.operator_equals("$oid")) {
                    is_special = JSON.encode_bson_oid(buff, tok, length);
                } else if (cs.operator_equals("$ref")) {
                    is_special = JSON.encode_bson_ref(buff, tok, length);
                } else if (cs.operator_equals("$undefined")) {
                    is_special = JSON.encode_bson_undefined(buff, tok, length);
                } else if (cs.operator_equals("$minKey")) {
                    is_special = JSON.encode_bson_minkey(buff, tok, length);
                } else if (cs.operator_equals("$maxKey")) {
                    is_special = JSON.encode_bson_maxkey(buff, tok, length);
                } else if (cs.operator_equals("$numberLong")) {
                    is_special = JSON.encode_bson_numberlong(buff, tok, length);
                } else if (cs.operator_equals("$code")) {
                    is_special = JSON.encode_bson_code_with_scope(buff, tok, length);
                } else {
                    obj_name.operator_assign(cs);
                }
                if (is_special) break;
                tok.set_buf_pos(prev_pos);
                obj_name.operator_assign(cs);
                break;
            }
            case JSON_TOKEN_STRING: {
                buff.put_c((byte)2);
                length.operator_assign(length.add(1));
                JSON.put_name(buff, length, obj_name, in_array);
                JSON.encode_int_bson(buff, new TitanInteger(len.get() - 1), length);
                String tmp_str = content.substring(1, content.length() - 1);
                buff.put_string(new TitanCharString(tmp_str));
                buff.put_c((byte)0);
                length.operator_assign(length.add(len.get() - 1));
                break;
            }
            case JSON_TOKEN_NUMBER: {
                String str = content.toString();
                int curr_pos = tok.get_buf_pos();
                tok.set_buf_pos(prev_pos);
                AtomicBoolean is_float = new AtomicBoolean(false);
                tok.check_for_number(is_float);
                tok.set_buf_pos(curr_pos);
                if (is_float.get()) {
                    buff.put_c((byte)1);
                    JSON.put_name(buff, length, obj_name, in_array);
                    TitanFloat f = AdditionalFunctions.str2float(str);
                    f.encode(bson_float_descr_, buff, TTCN_EncDec.coding_type.CT_RAW, 0);
                    break;
                }
                TitanInteger int_num = AdditionalFunctions.str2int(str);
                if (int_num.is_native()) {
                    buff.put_c((byte)16);
                    length.operator_assign(length.add(1));
                } else {
                    buff.put_c((byte)18);
                    length.operator_assign(length.add(1));
                }
                JSON.put_name(buff, length, obj_name, in_array);
                JSON.encode_int_bson(buff, int_num, length);
                break;
            }
            case JSON_TOKEN_LITERAL_FALSE: {
                buff.put_c((byte)8);
                JSON.put_name(buff, length, obj_name, in_array);
                buff.put_c((byte)0);
                break;
            }
            case JSON_TOKEN_LITERAL_TRUE: {
                buff.put_c((byte)8);
                JSON.put_name(buff, length, obj_name, in_array);
                buff.put_c((byte)1);
                break;
            }
            case JSON_TOKEN_LITERAL_NULL: {
                buff.put_c((byte)10);
                JSON.put_name(buff, length, obj_name, in_array);
                break;
            }
            case JSON_TOKEN_ARRAY_START: {
                if (!in_object) {
                    in_object = true;
                } else {
                    buff.put_c((byte)4);
                    length.operator_assign(length.add(1));
                    JSON.put_name(buff, length, obj_name, in_array);
                }
                obj_name.operator_assign("0");
                TTCN_Buffer sub_buff = new TTCN_Buffer();
                TitanInteger sub_length = new TitanInteger(0);
                tok.get_next_token(token, null, null);
                prev_pos = tok.get_buf_pos();
                while (prev_pos != 0) {
                    if (token.get() == JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_END) {
                        sub_buff.put_c((byte)0);
                        sub_length.operator_assign(sub_length.add(1));
                        break;
                    }
                    tok.set_buf_pos(prev_pos);
                    in_array = true;
                    JSON.json2bson_coding(sub_buff, tok, in_object, in_array, sub_length, obj_name, is_special);
                    tok.get_next_token(token, null, null);
                    prev_pos = tok.get_buf_pos();
                }
                JSON.encode_int_bson(buff, sub_length, sub_length);
                length.operator_assign(length.add(sub_length));
                buff.put_buf(sub_buff);
                break;
            }
            default: {
                throw new TtcnError("Unexpected json token " + (Object)((Object)token.get()) + ", while encoding using json2bson().");
            }
        }
    }

    public static void bson2json_coding(TTCN_Buffer buff, JSON_Tokenizer tok, boolean in_object, boolean in_array) {
        TitanInteger length = new TitanInteger(0);
        if (!in_object) {
            length = JSON.decode_int_bson(buff, 4);
            JSON.check_and_get_buffer_bson(buff, length.get_int() - 4);
            tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
            while (JSON.check_and_get_buffer_bson(buff, 1)[0] != 0) {
                JSON.bson2json_coding(buff, tok, true, in_array);
            }
            buff.increase_pos(1);
            tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
        } else {
            byte[] type = JSON.check_and_get_buffer_bson(buff, 1);
            buff.increase_pos(1);
            JSON.get_name(buff, tok, in_array);
            switch (type[0]) {
                case 0: {
                    throw new TtcnError("Unexpected document end character while decoding with bson2json()");
                }
                case 1: {
                    TitanFloat f = new TitanFloat();
                    JSON.check_and_get_buffer_bson(buff, 8);
                    f.decode(bson_float_descr_, buff, TTCN_EncDec.coding_type.CT_RAW, 0);
                    f.JSON_encode(bson_float_descr_, tok);
                    break;
                }
                case 2: 
                case 13: 
                case 14: {
                    TitanInteger len = JSON.decode_int_bson(buff, 4);
                    byte[] uc = JSON.check_and_get_buffer_bson(buff, len.get_int());
                    String tmp_str = new String(uc);
                    buff.increase_pos(len.get_int());
                    String tmp_str2 = "\"" + tmp_str + "\"";
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str2);
                    break;
                }
                case 3: {
                    length = JSON.decode_int_bson(buff, 4);
                    JSON.check_and_get_buffer_bson(buff, length.get_int() - 4);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    while (JSON.check_and_get_buffer_bson(buff, 1)[0] != 0) {
                        JSON.bson2json_coding(buff, tok, in_object, false);
                    }
                    buff.increase_pos(1);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 4: {
                    length = JSON.decode_int_bson(buff, 4);
                    JSON.check_and_get_buffer_bson(buff, length.get_int() - 4);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_START, null);
                    while (JSON.check_and_get_buffer_bson(buff, 1)[0] != 0) {
                        JSON.bson2json_coding(buff, tok, in_object, true);
                    }
                    buff.increase_pos(1);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_END, null);
                    break;
                }
                case 5: {
                    TitanInteger bytestr_length = JSON.decode_int_bson(buff, 4);
                    TitanOctetString os = new TitanOctetString(JSON.check_and_get_buffer_bson(buff, 1));
                    buff.increase_pos(1);
                    TitanInteger typestr_type = AdditionalFunctions.oct2int(os);
                    String str_type = String.format("%02X", typestr_type.get_int());
                    TitanOctetString data = new TitanOctetString(JSON.check_and_get_buffer_bson(buff, bytestr_length.get_int()));
                    buff.increase_pos(bytestr_length.get_int());
                    TitanCharString cs = AdditionalFunctions.encode_base64(data);
                    String data_str = "\"" + cs.get_value() + "\"";
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$binary");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, data_str);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$type");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, str_type);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 6: {
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$undefined");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_TRUE);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 7: {
                    TitanOctetString os = new TitanOctetString(JSON.check_and_get_buffer_bson(buff, 12));
                    StringBuilder tmp_oct = new StringBuilder();
                    for (int i = 0; i < 12; ++i) {
                        tmp_oct.append(String.format("%02X", os.get_at(i).get_nibble()));
                    }
                    String str_hex = "\"" + tmp_oct + "\"";
                    buff.increase_pos(12);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$oid");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, str_hex);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 8: {
                    byte[] uc = JSON.check_and_get_buffer_bson(buff, 1);
                    if (uc[0] == 0) {
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_FALSE, null);
                    } else {
                        tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_TRUE, null);
                    }
                    buff.increase_pos(1);
                    break;
                }
                case 9: {
                    TitanInteger date = JSON.decode_int_bson(buff, 8);
                    String tmp_str = Long.toString(date.get_long());
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$date");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$numberLong");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 10: {
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL, null);
                    break;
                }
                case 11: {
                    byte[] uc = JSON.check_and_get_buffer_bson(buff, 1);
                    String tmp_str = new String(uc);
                    buff.increase_pos(tmp_str.length() + 1);
                    String regex = "\"" + tmp_str + "\"";
                    uc = JSON.check_and_get_buffer_bson(buff, 1);
                    tmp_str = new String(uc);
                    buff.increase_pos(tmp_str.length() + 1);
                    String options = "\"" + tmp_str + "\"";
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$regex");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, regex);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$options");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, options);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 12: {
                    TitanInteger name_len = JSON.decode_int_bson(buff, 4);
                    byte[] uc = JSON.check_and_get_buffer_bson(buff, name_len.get_int());
                    String tmp_name = new String(uc);
                    buff.increase_pos(name_len.get_int());
                    String tmp_str = "\"" + tmp_name + "\"";
                    TitanOctetString os = new TitanOctetString(JSON.check_and_get_buffer_bson(buff, 12));
                    buff.increase_pos(12);
                    StringBuilder tmp_oct = new StringBuilder();
                    for (int i = 0; i < 12; ++i) {
                        tmp_oct.append(String.format("%02X", os.get_at(i).get_nibble()));
                    }
                    String str_hex = "\"" + tmp_oct + "\"";
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$ref");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$id");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, str_hex);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 15: {
                    TitanInteger len = JSON.decode_int_bson(buff, 4);
                    JSON.check_and_get_buffer_bson(buff, len.get_int() - 4);
                    len = JSON.decode_int_bson(buff, 4);
                    byte[] uc = JSON.check_and_get_buffer_bson(buff, len.get_int());
                    String tmp_str = new String(uc);
                    String tmp_str2 = "\"" + tmp_str + "\"";
                    buff.increase_pos(len.get_int());
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$code");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str2);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$scope");
                    JSON.bson2json_coding(buff, tok, false, false);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 16: {
                    TitanInteger value = JSON.decode_int_bson(buff, 4);
                    String tmp_str = Integer.toString(value.get_int());
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                    break;
                }
                case 17: {
                    TitanInteger increment = JSON.decode_int_bson(buff, 4);
                    TitanInteger timestamp = JSON.decode_int_bson(buff, 4);
                    String increment_str = Integer.toString(increment.get_int());
                    String timestamp_str = Integer.toString(timestamp.get_int());
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$timestamp");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "t");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, timestamp_str);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "i");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, increment_str);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case 18: {
                    TitanInteger value = JSON.decode_int_bson(buff, 8);
                    String tmp_str = Long.toString(value.get_long());
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
                    break;
                }
                case 127: {
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$maxKey");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, "1");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                case -1: {
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "$minKey");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, "1");
                    tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                    break;
                }
                default: {
                    throw new TtcnError("Unexpected type " + type[0] + " while decoding using bson2json().");
                }
            }
        }
    }

    public static final class TTCN_JSONdescriptor {
        private final boolean omit_as_null;
        private final String alias;
        private final boolean as_value;
        private final String default_value;
        private final Base_Type actual_default_value;
        private final boolean metainfo_unbound;
        private final boolean as_number;
        private final boolean as_map;
        private final int nof_enum_texts;
        private final List<JsonEnumText> enum_texts;
        private final boolean use_null;
        private final json_string_escaping escaping;

        public TTCN_JSONdescriptor(boolean omit_as_null, String alias, boolean as_value, Base_Type actual_default_value, boolean metainfo_unbound, boolean as_number, boolean as_map, int nof_enum_texts, List<JsonEnumText> enum_texts, boolean use_null, json_string_escaping escaping) {
            this.omit_as_null = omit_as_null;
            this.alias = alias;
            this.as_value = as_value;
            this.default_value = null;
            this.actual_default_value = actual_default_value;
            this.metainfo_unbound = metainfo_unbound;
            this.as_number = as_number;
            this.as_map = as_map;
            this.nof_enum_texts = nof_enum_texts;
            this.enum_texts = enum_texts;
            this.use_null = use_null;
            this.escaping = escaping;
        }

        public boolean isOmit_as_null() {
            return this.omit_as_null;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isAs_value() {
            return this.as_value;
        }

        public String getDefault_value() {
            return this.default_value;
        }

        public Base_Type getActualDefaultValue() {
            return this.actual_default_value;
        }

        public boolean isMetainfo_unbound() {
            return this.metainfo_unbound;
        }

        public boolean isAs_number() {
            return this.as_number;
        }

        public boolean isAs_map() {
            return this.as_map;
        }

        public int getNof_enum_texts() {
            return this.nof_enum_texts;
        }

        public List<JsonEnumText> getEnum_texts() {
            return this.enum_texts;
        }

        public boolean isUse_null() {
            return this.use_null;
        }

        public json_string_escaping getEscaping() {
            return this.escaping;
        }
    }

    public static enum json_string_escaping {
        ESCAPE_AS_SHORT,
        ESCAPE_AS_USI,
        ESCAPE_AS_TRANSPARENT;

    }

    public static final class JsonEnumText {
        private final int index;
        private final String text;

        public JsonEnumText(int index, String text) {
            this.index = index;
            this.text = text;
        }

        public int getIndex() {
            return this.index;
        }

        public String getText() {
            return this.text;
        }
    }
}

