/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanCharString_Element;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString_Element;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanUniversalCharString
extends Base_Type {
    public static final RAW.TTCN_RAWdescriptor TitanUniversalCharString_raw_ = new RAW.TTCN_RAWdescriptor(0, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanUniversalCharString_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanUniversalCharString_descr_ = new Base_Type.TTCN_Typedescriptor("universal charstring", null, TitanUniversalCharString_raw_, TitanUniversalCharString_json_, null);
    List<TitanUniversalChar> val_ptr;
    StringBuilder cstr;
    boolean charstring;

    public TitanUniversalCharString() {
    }

    public TitanUniversalCharString(TitanUniversalChar otherValue) {
        if (!otherValue.is_char()) {
            this.val_ptr = new ArrayList<TitanUniversalChar>();
            this.val_ptr.add(otherValue);
            this.charstring = false;
        } else {
            this.cstr = new StringBuilder();
            this.cstr.append(otherValue.getUc_cell());
            this.charstring = true;
        }
    }

    public TitanUniversalCharString(char uc_group, char uc_plane, char uc_row, char uc_cell) {
        TitanUniversalChar uc = new TitanUniversalChar(uc_group, uc_plane, uc_row, uc_cell);
        if (uc.is_char()) {
            this.cstr = new StringBuilder();
            this.cstr.append(uc_cell);
            this.charstring = true;
        } else {
            this.val_ptr = new ArrayList<TitanUniversalChar>();
            this.val_ptr.add(uc);
            this.charstring = false;
        }
    }

    public TitanUniversalCharString(List<TitanUniversalChar> otherValue) {
        this.val_ptr = TitanUniversalCharString.copy_list(otherValue);
        this.charstring = false;
    }

    public TitanUniversalCharString(TitanUniversalChar[] otherValue) {
        this.val_ptr = new ArrayList<TitanUniversalChar>(otherValue.length);
        for (int i = 0; i < otherValue.length; ++i) {
            this.val_ptr.add(otherValue[i]);
        }
        this.charstring = false;
    }

    public TitanUniversalCharString(String otherValue) {
        this.cstr = new StringBuilder(otherValue);
        this.charstring = true;
    }

    public TitanUniversalCharString(StringBuilder otherValue) {
        this.cstr = new StringBuilder(otherValue);
        this.charstring = true;
    }

    public TitanUniversalCharString(TitanCharString otherValue) {
        otherValue.must_bound("Copying an unbound charstring value.");
        this.cstr = new StringBuilder(otherValue.get_value());
        this.charstring = true;
    }

    public TitanUniversalCharString(TitanCharString_Element otherValue) {
        otherValue.must_bound("Copying an unbound charstring value.");
        this.cstr = new StringBuilder(otherValue.get_char());
        this.charstring = true;
    }

    public TitanUniversalCharString(TitanUniversalCharString otherValue) {
        otherValue.must_bound("Copying an unbound universal charstring value.");
        this.charstring = otherValue.charstring;
        if (this.charstring) {
            this.cstr = new StringBuilder(otherValue.cstr);
        } else {
            this.val_ptr = TitanUniversalCharString.copy_list(otherValue.val_ptr);
        }
    }

    public TitanUniversalCharString(TitanUniversalCharString_Element otherValue) {
        otherValue.must_bound("Initialization of a universal charstring with an unbound universal charstring element.");
        if (otherValue.get_char().is_char()) {
            this.cstr = new StringBuilder();
            this.cstr.append(otherValue.get_char().getUc_cell());
            this.charstring = true;
        } else {
            this.val_ptr = new ArrayList<TitanUniversalChar>();
            this.val_ptr.add(otherValue.get_char());
            this.charstring = false;
        }
    }

    private static List<TitanUniversalChar> copy_list(List<TitanUniversalChar> uList) {
        if (uList == null) {
            return null;
        }
        ArrayList<TitanUniversalChar> clonedList = new ArrayList<TitanUniversalChar>(uList.size());
        for (TitanUniversalChar uc : uList) {
            clonedList.add(new TitanUniversalChar(uc));
        }
        return clonedList;
    }

    public List<TitanUniversalChar> get_value() {
        this.must_bound("Casting an unbound universal charstring value to const universal_char*.");
        if (this.charstring) {
            this.convert_cstr_to_uni();
        }
        return this.val_ptr;
    }

    public void set_value(List<TitanUniversalChar> other_value) {
        if (other_value != null) {
            this.val_ptr = other_value;
            this.cstr = null;
            this.charstring = false;
        }
    }

    public TitanUniversalCharString operator_assign(TitanUniversalCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound universal charstring value.");
        if (otherValue != this) {
            this.charstring = otherValue.charstring;
            if (this.charstring) {
                this.cstr = new StringBuilder(otherValue.cstr);
            } else {
                this.val_ptr = new ArrayList<TitanUniversalChar>();
                this.val_ptr.addAll(otherValue.val_ptr);
            }
        }
        return this;
    }

    public TitanUniversalCharString operator_assign(TitanUniversalCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound universal charstring element to a universal charstring.");
        if (otherValue.get_char().is_char()) {
            this.cstr = new StringBuilder();
            this.cstr.append(otherValue.get_char().getUc_cell());
            this.val_ptr = null;
            this.charstring = true;
        } else {
            this.val_ptr = new ArrayList<TitanUniversalChar>();
            this.val_ptr.add(otherValue.get_char());
            this.cstr = null;
            this.charstring = false;
        }
        return this;
    }

    public TitanUniversalCharString operator_assign(TitanCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring value.");
        if (!this.charstring) {
            this.clean_up();
            this.charstring = true;
        }
        this.cstr = new StringBuilder(otherValue.get_value());
        return this;
    }

    public TitanUniversalCharString operator_assign(TitanCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring element to a charstring.");
        if (!this.charstring) {
            this.clean_up();
            this.charstring = true;
        }
        this.cstr = new StringBuilder();
        this.cstr.append(otherValue.get_char());
        return this;
    }

    @Override
    public TitanUniversalCharString operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanUniversalCharString) {
            return this.operator_assign((TitanUniversalCharString)otherValue);
        }
        if (otherValue instanceof TitanCharString) {
            return this.operator_assign((TitanCharString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to universal charstring", otherValue));
    }

    public TitanUniversalCharString operator_assign(TitanUniversalChar otherValue) {
        this.clean_up();
        if (otherValue.is_char()) {
            this.charstring = true;
            this.cstr = new StringBuilder();
            this.cstr.append(otherValue.getUc_cell());
        } else {
            this.charstring = false;
            this.val_ptr = new ArrayList<TitanUniversalChar>();
            this.val_ptr.add(otherValue);
        }
        return this;
    }

    public TitanUniversalCharString operator_assign(char[] otherValue) {
        this.charstring = true;
        this.cstr = new StringBuilder();
        for (int i = 0; i < otherValue.length; ++i) {
            this.cstr.append(otherValue[i]);
        }
        return this;
    }

    public TitanUniversalCharString operator_assign(String otherValue) {
        this.charstring = true;
        this.cstr = new StringBuilder();
        for (int i = 0; i < otherValue.length(); ++i) {
            this.cstr.append(otherValue.charAt(i));
        }
        return this;
    }

    @Override
    public boolean is_bound() {
        return this.charstring ? this.cstr != null : this.val_ptr != null;
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_value() {
        return this.is_bound();
    }

    public TitanInteger lengthof() {
        this.must_bound("Performing lengthof operation on an unbound universal charstring value.");
        if (this.charstring) {
            return new TitanInteger(this.cstr.length());
        }
        return new TitanInteger(this.val_ptr.size());
    }

    public boolean operator_equals(TitanUniversalCharString otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring value.");
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring value.");
        if (this.charstring) {
            if (otherValue.charstring) {
                return this.cstr.toString().equals(otherValue.cstr.toString());
            }
            if (this.cstr.length() != otherValue.val_ptr.size()) {
                return false;
            }
            for (int i = 0; i < otherValue.val_ptr.size(); ++i) {
                TitanUniversalChar temp = otherValue.val_ptr.get(i);
                if (temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && temp.getUc_group() == '\u0000' && temp.getUc_cell() == this.cstr.charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (otherValue.charstring) {
            if (this.val_ptr.size() != otherValue.cstr.length()) {
                return false;
            }
            for (int i = 0; i < this.val_ptr.size(); ++i) {
                TitanUniversalChar temp = this.val_ptr.get(i);
                if (temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && temp.getUc_group() == '\u0000' && temp.getUc_cell() == otherValue.cstr.charAt(i)) continue;
                return false;
            }
        } else {
            if (this.val_ptr.size() != otherValue.val_ptr.size()) {
                return false;
            }
            for (int i = 0; i < this.val_ptr.size(); ++i) {
                if (this.val_ptr.get(i).operator_equals(otherValue.val_ptr.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean operator_equals(TitanUniversalCharString_Element otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring value.");
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring element.");
        if (this.charstring) {
            return otherValue.get_char().is_char() && otherValue.get_char().getUc_cell() == this.cstr.charAt(0);
        }
        if (this.val_ptr.size() != 1) {
            return false;
        }
        return this.val_ptr.get(0).operator_equals(otherValue.get_char());
    }

    public boolean operator_equals(TitanCharString otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring value.");
        otherValue.must_bound("The right operand of comparison is an unbound charstring value.");
        if (this.charstring) {
            return otherValue.get_value().toString().equals(this.cstr.toString());
        }
        if (this.val_ptr.size() != otherValue.lengthof().get_int()) {
            return false;
        }
        for (int i = 0; i < this.val_ptr.size(); ++i) {
            TitanUniversalChar temp = this.val_ptr.get(i);
            if (temp.getUc_group() == '\u0000' && temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && temp.getUc_cell() == otherValue.get_value().charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean operator_equals(TitanCharString_Element otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring value.");
        otherValue.must_bound("The right operand of comparison is an unbound charstring element.");
        if (this.charstring) {
            return this.cstr.charAt(0) == otherValue.get_char();
        }
        if (this.val_ptr.size() != 1) {
            return false;
        }
        TitanUniversalChar temp = this.val_ptr.get(0);
        return temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && temp.getUc_group() == '\u0000' && temp.getUc_cell() == otherValue.get_char();
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanUniversalCharString) {
            return this.operator_equals((TitanUniversalCharString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to universal charstring", otherValue));
    }

    public boolean operator_equals(TitanUniversalChar otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring value.");
        if (this.charstring) {
            return this.cstr.length() == 1 && otherValue.getUc_group() == '\u0000' && otherValue.getUc_plane() == '\u0000' && otherValue.getUc_row() == '\u0000' && this.cstr.charAt(0) == otherValue.getUc_cell();
        }
        if (this.val_ptr.size() != 1) {
            return false;
        }
        return this.val_ptr.get(0).operator_equals(otherValue);
    }

    public boolean operator_equals(String otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring value.");
        if (this.charstring) {
            return this.cstr.toString().equals(otherValue);
        }
        if (this.val_ptr.size() != otherValue.length()) {
            return false;
        }
        for (int i = 0; i < this.val_ptr.size(); ++i) {
            TitanUniversalChar temp = this.val_ptr.get(i);
            if (temp.getUc_group() == '\u0000' && temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && temp.getUc_cell() == otherValue.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean operator_not_equals(TitanUniversalCharString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanUniversalCharString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanCharString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanCharString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(Base_Type otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanUniversalChar otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(String otherValue) {
        return !this.operator_equals(otherValue);
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalChar other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring value.");
        if (this.charstring) {
            if (other_value.is_char()) {
                return new TitanUniversalCharString(new StringBuilder(this.cstr).append(other_value.getUc_cell()));
            }
            ArrayList<TitanUniversalChar> ulist = new ArrayList<TitanUniversalChar>();
            for (int i = 0; i < this.cstr.length(); ++i) {
                TitanUniversalChar uc = new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.cstr.charAt(i));
                ulist.add(uc);
            }
            ulist.add(other_value);
            TitanUniversalCharString ret_val = new TitanUniversalCharString();
            ret_val.set_value(ulist);
            return ret_val;
        }
        TitanUniversalCharString ret_val = new TitanUniversalCharString(this.val_ptr);
        ret_val.val_ptr.add(other_value);
        return ret_val;
    }

    public TitanUniversalCharString operator_concatenate(String other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring value.");
        int other_len = other_value == null ? 0 : other_value.length();
        if (other_len == 0) {
            return new TitanUniversalCharString(this);
        }
        if (this.charstring) {
            return new TitanUniversalCharString(new StringBuilder(this.cstr).append(other_value));
        }
        TitanUniversalCharString ret_val = new TitanUniversalCharString(this.val_ptr);
        for (int i = 0; i < other_len; ++i) {
            TitanUniversalChar uc = new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.charAt(i));
            ret_val.val_ptr.add(uc);
        }
        return ret_val;
    }

    public TitanUniversalCharString operator_concatenate(TitanCharString other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring value.");
        other_value.must_bound("The right operand of concatenation is an unbound charstring value.");
        return this.operator_concatenate(other_value.get_value().toString());
    }

    public TitanUniversalCharString operator_concatenate(TitanCharString_Element other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring value.");
        other_value.must_bound("The right operand of concatenation is an unbound charstring element.");
        if (this.charstring) {
            return new TitanUniversalCharString(new StringBuilder(this.cstr).append(other_value.get_char()));
        }
        TitanUniversalCharString ret_val = new TitanUniversalCharString(this.val_ptr);
        TitanUniversalChar uc = new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.get_char());
        ret_val.val_ptr.add(uc);
        return ret_val;
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalCharString other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring value.");
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring value.");
        if (this.charstring) {
            if (this.cstr.length() == 0) {
                return new TitanUniversalCharString(other_value);
            }
            if (other_value.charstring) {
                if (other_value.cstr.length() == 0) {
                    return new TitanUniversalCharString(this);
                }
                return new TitanUniversalCharString(new StringBuilder(this.cstr).append((CharSequence)other_value.cstr));
            }
            if (other_value.val_ptr.isEmpty()) {
                return new TitanUniversalCharString(this);
            }
            ArrayList<TitanUniversalChar> ulist = new ArrayList<TitanUniversalChar>();
            for (int i = 0; i < this.cstr.length(); ++i) {
                TitanUniversalChar uc = new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.cstr.charAt(i));
                ulist.add(uc);
            }
            ulist.addAll(other_value.val_ptr);
            TitanUniversalCharString ret_val = new TitanUniversalCharString();
            ret_val.set_value(ulist);
            return ret_val;
        }
        if (other_value.charstring) {
            TitanUniversalCharString ret_val = new TitanUniversalCharString(this.val_ptr);
            StringBuilder cs = other_value.cstr;
            int cslen = cs.length();
            for (int i = 0; i < cslen; ++i) {
                TitanUniversalChar uc = new TitanUniversalChar('\u0000', '\u0000', '\u0000', cs.charAt(i));
                ret_val.get_value().add(uc);
            }
            return ret_val;
        }
        if (this.val_ptr.isEmpty()) {
            return new TitanUniversalCharString(other_value);
        }
        if (other_value.val_ptr.isEmpty()) {
            return new TitanUniversalCharString(this);
        }
        TitanUniversalCharString ret_val = new TitanUniversalCharString(this.val_ptr);
        ret_val.get_value().addAll(other_value.val_ptr);
        return ret_val;
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalCharString_Element other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring value.");
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring element.");
        if (this.charstring) {
            return new TitanUniversalCharString(new StringBuilder(this.cstr).append(other_value.get_char().getUc_cell()));
        }
        TitanUniversalCharString ret_val = new TitanUniversalCharString(this.val_ptr);
        ret_val.val_ptr.add(other_value.get_char());
        return ret_val;
    }

    @Override
    public void clean_up() {
        this.val_ptr = null;
        this.cstr = null;
    }

    private int size() {
        return this.charstring ? this.cstr.length() : this.val_ptr.size();
    }

    public TitanUniversalCharString_Element get_at(int index_value) {
        if (!this.is_bound() && index_value == 0) {
            if (this.charstring) {
                this.cstr = new StringBuilder();
            } else {
                this.val_ptr = new ArrayList<TitanUniversalChar>();
            }
            return new TitanUniversalCharString_Element(false, this, 0);
        }
        this.must_bound("Accessing an element of an unbound universal charstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an universal charstring element using a negative index (" + index_value + ").");
        }
        int n_nibbles = this.size();
        if (index_value > n_nibbles) {
            throw new TtcnError("Index overflow when accessing a universal charstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " characters.");
        }
        if (index_value == n_nibbles) {
            if (this.charstring) {
                this.cstr.append('\u0000');
            } else {
                this.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\u0000'));
            }
            return new TitanUniversalCharString_Element(false, this, index_value);
        }
        return new TitanUniversalCharString_Element(true, this, index_value);
    }

    public TitanUniversalCharString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a universal charstring value with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public TitanUniversalCharString_Element constGet_at(int index_value) {
        int n_nibbles;
        this.must_bound("Accessing an element of an unbound universal charstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an universal charstring element using a negative index (" + index_value + ").");
        }
        int n = n_nibbles = this.charstring ? this.cstr.length() : this.val_ptr.size();
        if (index_value >= n_nibbles) {
            throw new TtcnError("Index overflow when accessing a universal charstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " characters.");
        }
        return new TitanUniversalCharString_Element(true, this, index_value);
    }

    public TitanUniversalCharString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a universal charstring value with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    public static boolean is_printable(TitanUniversalChar uchar) {
        return uchar.getUc_group() == '\u0000' && uchar.getUc_plane() == '\u0000' && uchar.getUc_row() == '\u0000' && TTCN_Logger.is_printable(uchar.getUc_cell());
    }

    @Override
    public void log() {
        if (this.charstring) {
            new TitanCharString(this.cstr).log();
            return;
        }
        if (this.val_ptr != null) {
            States state = States.INIT;
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.val_ptr.size(); ++i) {
                TitanUniversalChar uchar = this.val_ptr.get(i);
                if (TitanUniversalCharString.is_printable(uchar)) {
                    switch (state) {
                        case UCHAR: {
                            buffer.append(" & ");
                        }
                        case INIT: {
                            buffer.append('\"');
                        }
                        case PCHAR: {
                            TTCN_Logger.log_char_escaped(uchar.getUc_cell(), buffer);
                        }
                    }
                    state = States.PCHAR;
                    continue;
                }
                switch (state) {
                    case PCHAR: {
                        buffer.append('\"');
                    }
                    case UCHAR: {
                        buffer.append(" & ");
                    }
                    case INIT: {
                        buffer.append(MessageFormat.format("char({0}, {1}, {2}, {3})", uchar.getUc_group(), uchar.getUc_plane(), uchar.getUc_row(), uchar.getUc_cell()));
                    }
                }
                state = States.UCHAR;
            }
            switch (state) {
                case INIT: {
                    buffer.append("\"\"");
                    break;
                }
                case PCHAR: {
                    buffer.append('\"');
                    break;
                }
            }
            TTCN_Logger.log_event_str(buffer.toString());
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    protected static TitanUniversalCharString from_UTF8_buffer(TTCN_Buffer p_buff) {
        TitanOctetString os = new TitanOctetString();
        p_buff.get_string(os);
        if (new TitanCharString("UTF-8").operator_equals(AdditionalFunctions.get_stringencoding(os))) {
            TitanUniversalCharString ret = new TitanUniversalCharString();
            ret.decode_utf8(p_buff.get_data(), TitanCharString.CharCoding.UTF_8, false);
            return ret;
        }
        if (p_buff.get_data() != null) {
            return new TitanUniversalCharString(new String(p_buff.get_data()));
        }
        return new TitanUniversalCharString("");
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        this.set_param_internal(param, false);
    }

    public boolean set_param_internal(Param_Types.Module_Parameter param, boolean allow_pattern) {
        return this.set_param_internal(param, allow_pattern, false);
    }

    public boolean set_param_internal(Param_Types.Module_Parameter param, boolean allow_pattern, boolean is_nocase_pattern) {
        boolean is_pattern = false;
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "universal charstring value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Charstring: {
                switch (param.get_operation_type()) {
                    case OT_ASSIGN: {
                        this.clean_up();
                    }
                    case OT_CONCAT: {
                        if (this.is_bound()) {
                            this.operator_assign(this.operator_concatenate(param.get_charstring()));
                            break block0;
                        }
                        this.operator_assign(param.get_charstring());
                        break block0;
                    }
                }
                throw new TtcnError("Internal error: TitanUniversalCharString.set_param()");
            }
            case MP_Universal_Charstring: {
                switch (param.get_operation_type()) {
                    case OT_ASSIGN: {
                        this.clean_up();
                    }
                    case OT_CONCAT: {
                        if (this.is_bound()) {
                            this.operator_assign(this.operator_concatenate((TitanUniversalCharString)param.get_string_data()));
                            break block0;
                        }
                        this.operator_assign((TitanUniversalCharString)param.get_string_data());
                        break block0;
                    }
                }
                throw new TtcnError("Internal error: TitanUniversalCharString.set_param()");
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanUniversalCharString operand1 = new TitanUniversalCharString();
                    TitanUniversalCharString operand2 = new TitanUniversalCharString();
                    is_pattern = operand1.set_param_internal(param.get_operand1(), allow_pattern, is_nocase_pattern);
                    operand2.set_param(param.get_operand2());
                    if (param.get_operation_type() == Param_Types.Module_Parameter.operation_type_t.OT_CONCAT) {
                        this.operator_assign(this.operator_concatenate(operand1).operator_concatenate(operand2));
                        break;
                    }
                    this.operator_assign(operand1.operator_concatenate(operand2));
                    break;
                }
                param.expr_type_error("a universal charstring");
                break;
            }
            case MP_Pattern: {
                if (allow_pattern) {
                    this.operator_assign(new TitanCharString(param.get_pattern()));
                    is_pattern = true;
                    if (param.parent.get_type() != Param_Types.Module_Parameter.type_t.MP_Expression) break;
                    ((Param_Types.Module_Param_Expression)param.parent).set_nocase(param.get_nocase());
                    break;
                }
            }
            default: {
                param.type_error("universal charstring value");
            }
        }
        return is_pattern;
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Universal_Charstring(this);
    }

    public String toString() {
        if (!this.is_bound()) {
            return "<unbound>";
        }
        if (this.charstring) {
            return this.cstr.toString();
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.val_ptr.size(); ++i) {
            str.append(this.val_ptr.get(i).toString());
        }
        return str.toString();
    }

    public String to_utf() {
        this.must_bound("Accessing an element of an unbound universal charstring value.");
        if (this.charstring) {
            return this.cstr.toString();
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.val_ptr.size(); ++i) {
            str.append(this.val_ptr.get(i).to_utf(this.val_ptr.size() == 1));
        }
        return str.toString();
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound universal charstring value.");
        if (this.charstring) {
            this.convert_cstr_to_uni();
        }
        int n_chars = this.val_ptr.size();
        text_buf.push_int(n_chars);
        for (int i = 0; i < n_chars; ++i) {
            TitanUniversalChar tempChar = this.val_ptr.get(i);
            byte[] buf = new byte[]{(byte)tempChar.getUc_group(), (byte)tempChar.getUc_plane(), (byte)tempChar.getUc_row(), (byte)tempChar.getUc_cell()};
            text_buf.push_raw(buf);
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        int n_uchars = text_buf.pull_int().get_int();
        if (n_uchars < 0) {
            throw new TtcnError("Text decoder: Invalid length was received for an universal charstring.");
        }
        this.charstring = false;
        this.val_ptr = new ArrayList<TitanUniversalChar>(n_uchars);
        if (n_uchars > 0) {
            for (int i = 0; i < n_uchars; ++i) {
                byte[] buf = new byte[4];
                text_buf.pull_raw(4, buf);
                TitanUniversalChar temp = new TitanUniversalChar((char)buf[0], (char)buf[1], (char)buf[2], (char)buf[3]);
                this.val_ptr.add(temp);
            }
        }
    }

    final TitanUniversalChar char_at(int i) {
        if (this.charstring) {
            return new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.cstr.charAt(i));
        }
        return this.val_ptr.get(i);
    }

    final void set_char_at(int i, TitanUniversalChar c) {
        if (this.charstring) {
            this.convert_cstr_to_uni();
        }
        this.val_ptr.set(i, c);
    }

    final void set_char_at(int i, char c) {
        if (this.charstring) {
            this.cstr.setCharAt(i, c);
        } else {
            this.val_ptr.set(i, new TitanUniversalChar('\u0000', '\u0000', '\u0000', c));
        }
    }

    public TitanUniversalCharString rotate_left(int rotate_count) {
        this.must_bound("The left operand of rotate left operator is an unbound universal charstring value.");
        if (this.charstring) {
            return new TitanUniversalCharString(new TitanCharString(this.cstr).rotate_left(rotate_count));
        }
        if (this.val_ptr.isEmpty()) {
            return new TitanUniversalCharString(this);
        }
        if (rotate_count >= 0) {
            int i;
            if ((rotate_count %= this.val_ptr.size()) == 0) {
                return new TitanUniversalCharString(this);
            }
            TitanUniversalCharString result = new TitanUniversalCharString();
            result.val_ptr = new ArrayList<TitanUniversalChar>();
            for (i = 0; i < this.val_ptr.size() - rotate_count; ++i) {
                result.val_ptr.add(i, this.val_ptr.get(i + rotate_count));
            }
            for (i = this.val_ptr.size() - rotate_count; i < this.val_ptr.size(); ++i) {
                result.val_ptr.add(i, this.val_ptr.get(i + rotate_count - this.val_ptr.size()));
            }
            return result;
        }
        return this.rotate_right(-rotate_count);
    }

    public TitanUniversalCharString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("The right operand of rotate left operator is an unbound integer value.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanUniversalCharString rotate_right(int rotate_count) {
        this.must_bound("The left operand of rotate right operator is an unbound universal charstring value.");
        if (this.charstring) {
            return new TitanUniversalCharString(new TitanCharString(this.cstr).rotate_right(rotate_count));
        }
        if (this.val_ptr.isEmpty()) {
            return new TitanUniversalCharString(this);
        }
        if (rotate_count >= 0) {
            int i;
            if ((rotate_count %= this.val_ptr.size()) == 0) {
                return new TitanUniversalCharString(this);
            }
            TitanUniversalCharString result = new TitanUniversalCharString();
            result.val_ptr = new ArrayList<TitanUniversalChar>();
            if (rotate_count > this.val_ptr.size()) {
                rotate_count = this.val_ptr.size();
            }
            for (i = 0; i < rotate_count; ++i) {
                result.val_ptr.add(i, this.val_ptr.get(i - rotate_count + this.val_ptr.size()));
            }
            for (i = rotate_count; i < this.val_ptr.size(); ++i) {
                result.val_ptr.add(i, this.val_ptr.get(i - rotate_count));
            }
            return result;
        }
        return this.rotate_left(-rotate_count);
    }

    public TitanUniversalCharString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("The right operand of rotate right operator is an unbound integer value.");
        return this.rotate_right(rotate_count.get_int());
    }

    public TitanCharString get_stringRepr_for_pattern() {
        this.must_bound("Performing pattern conversion operation on an unbound universal charstring value.");
        StringBuilder ret_val = new StringBuilder();
        if (this.charstring) {
            for (int i = 0; i < this.cstr.length(); ++i) {
                char chr = this.cstr.charAt(i);
                if (TTCN_Logger.is_printable(chr)) {
                    ret_val.append(chr);
                    continue;
                }
                ret_val.append("\\q{0,0,0,");
                ret_val.append((int)chr);
                ret_val.append('}');
            }
        } else {
            for (int i = 0; i < this.val_ptr.size(); ++i) {
                TitanUniversalChar uchar = this.val_ptr.get(i);
                if (uchar.is_char()) {
                    ret_val.append(uchar.getUc_cell());
                    continue;
                }
                ret_val.append("\\q{");
                ret_val.append((int)uchar.getUc_group());
                ret_val.append(',');
                ret_val.append((int)uchar.getUc_plane());
                ret_val.append(',');
                ret_val.append((int)uchar.getUc_row());
                ret_val.append(',');
                ret_val.append((int)uchar.getUc_cell());
                ret_val.append('}');
            }
        }
        return new TitanCharString(ret_val.toString());
    }

    public void convert_cstr_to_uni() {
        this.val_ptr = new ArrayList<TitanUniversalChar>(this.cstr.length());
        for (int i = 0; i < this.cstr.length(); ++i) {
            this.val_ptr.add(i, new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.cstr.charAt(i)));
        }
        this.charstring = false;
        this.cstr = null;
    }

    public static boolean operator_equals(TitanUniversalChar left_value, TitanUniversalChar right_value) {
        return left_value.getUc_group() == right_value.getUc_group() && left_value.getUc_plane() == right_value.getUc_plane() && left_value.getUc_row() == right_value.getUc_row() && left_value.getUc_cell() == right_value.getUc_cell();
    }

    public static boolean operator_equals(TitanUniversalChar ucharValue, TitanUniversalCharString otherValue) {
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring value.");
        if (otherValue.charstring) {
            if (otherValue.cstr.length() != 1) {
                return false;
            }
            return ucharValue.is_char() && ucharValue.getUc_cell() == otherValue.cstr.charAt(0);
        }
        if (otherValue.val_ptr.size() != 1) {
            return false;
        }
        return ucharValue.operator_equals(otherValue.val_ptr.get(0));
    }

    public static boolean operator_equals(String otherValue, TitanUniversalCharString rightValue) {
        rightValue.must_bound("The left operand of comparison is an unbound universal charstring value.");
        if (rightValue.charstring) {
            return rightValue.cstr.toString().equals(otherValue);
        }
        if (rightValue.val_ptr.size() != otherValue.length()) {
            return false;
        }
        for (int i = 0; i < rightValue.val_ptr.size(); ++i) {
            TitanUniversalChar temp = rightValue.val_ptr.get(i);
            if (temp.getUc_group() == '\u0000' && temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && temp.getUc_cell() == otherValue.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean operator_not_equals(TitanUniversalChar left_value, TitanUniversalChar right_value) {
        return !TitanUniversalCharString.operator_equals(left_value, right_value);
    }

    public static boolean operator_not_equals(TitanUniversalChar ucharValue, TitanUniversalCharString otherValue) {
        return !TitanUniversalCharString.operator_equals(ucharValue, otherValue);
    }

    public static boolean operator_not_equals(String otherValue, TitanUniversalCharString rightValue) {
        return !TitanUniversalCharString.operator_equals(otherValue, rightValue);
    }

    public static TitanUniversalCharString operator_concatenate(TitanUniversalChar ucharValue, TitanUniversalCharString other_value) {
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring value.");
        if (other_value.charstring) {
            if (ucharValue.is_char()) {
                return new TitanUniversalCharString(new StringBuilder(ucharValue.getUc_cell()).append((CharSequence)other_value.cstr));
            }
            ArrayList<TitanUniversalChar> ulist = new ArrayList<TitanUniversalChar>();
            ulist.add(ucharValue);
            for (int i = 0; i < other_value.cstr.length(); ++i) {
                TitanUniversalChar uc = new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.cstr.charAt(i));
                ulist.add(uc);
            }
            TitanUniversalCharString ret_val = new TitanUniversalCharString();
            ret_val.set_value(ulist);
            return ret_val;
        }
        TitanUniversalCharString ret_val = new TitanUniversalCharString(ucharValue);
        ret_val.val_ptr.addAll(other_value.val_ptr);
        return ret_val;
    }

    public static TitanUniversalCharString operator_concatenate(String stringValue, TitanUniversalCharString other_value) {
        other_value.must_bound("The left operand of concatenation is an unbound universal charstring value.");
        int other_len = stringValue == null ? 0 : stringValue.length();
        if (other_len == 0) {
            return new TitanUniversalCharString(other_value);
        }
        if (other_value.charstring) {
            return new TitanUniversalCharString(new StringBuilder(stringValue).append((CharSequence)other_value.cstr));
        }
        TitanUniversalCharString ret_val = new TitanUniversalCharString();
        ret_val.val_ptr = new ArrayList<TitanUniversalChar>();
        for (int i = 0; i < other_len; ++i) {
            TitanUniversalChar uc = new TitanUniversalChar('\u0000', '\u0000', '\u0000', stringValue.charAt(i));
            ret_val.val_ptr.add(uc);
        }
        ret_val.val_ptr.addAll(other_value.val_ptr);
        return ret_val;
    }

    public void decode_utf8(byte[] valueStr, TitanCharString.CharCoding code, boolean checkBOM) {
        int start;
        int i;
        int lenghtOctets = valueStr.length;
        int lenghtUnichars = 0;
        for (i = 0; i < lenghtOctets; ++i) {
            if ((valueStr[i] & 0xC0) == 128) continue;
            ++lenghtUnichars;
        }
        this.clean_up();
        this.charstring = false;
        this.val_ptr = new ArrayList<TitanUniversalChar>(lenghtUnichars);
        for (i = 0; i < lenghtUnichars; ++i) {
            this.val_ptr.add(new TitanUniversalChar());
        }
        lenghtUnichars = 0;
        int i2 = start = checkBOM ? this.check_BOM(TitanCharString.CharCoding.UTF_8, valueStr) : 0;
        while (i2 < lenghtOctets) {
            char[] octets;
            int tempValue = valueStr[i2] & 0xFF;
            if (tempValue <= 127) {
                this.val_ptr.add(lenghtUnichars, new TitanUniversalChar('\u0000', '\u0000', '\u0000', (char)(valueStr[i2] & 0xFF)));
                ++i2;
                ++lenghtUnichars;
                continue;
            }
            if (tempValue <= 191) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Malformed: At character position {0}, octet position {1}: continuing octet {0} without leading octet.", lenghtUnichars, i2, tempValue), new Object[0]);
                ++i2;
                continue;
            }
            if (tempValue <= 223) {
                octets = new char[2];
                octets[0] = (char)(tempValue & 0x1F);
                TitanUniversalCharString.fill_continuing_octets(1, octets, lenghtOctets, valueStr, i2 + 1, lenghtUnichars);
                this.val_ptr.set(lenghtUnichars, new TitanUniversalChar('\u0000', '\u0000', (char)(octets[0] >> 2), (char)(octets[0] << 6 & 0xFF | octets[1])));
                if (this.val_ptr.get(lenghtUnichars).getUc_row() == '\u0000' && this.val_ptr.get(lenghtUnichars).getUc_cell() < '\u0080') {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Overlong: At character position {0}, octet position {1}: 2-octet encoding for quadruple (0, 0, 0, {2}).", lenghtUnichars, i2, Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_cell())), new Object[0]);
                }
                i2 += 2;
                ++lenghtUnichars;
                continue;
            }
            if (tempValue <= 239) {
                octets = new char[3];
                octets[0] = (char)(tempValue & 0xF);
                TitanUniversalCharString.fill_continuing_octets(2, octets, lenghtOctets, valueStr, i2 + 1, lenghtUnichars);
                this.val_ptr.set(lenghtUnichars, new TitanUniversalChar('\u0000', '\u0000', (char)(octets[0] << 4 & 0xFF | octets[1] >> 2), (char)(octets[1] << 6 & 0xFF | octets[2])));
                if (this.val_ptr.get(lenghtUnichars).getUc_row() < '\b') {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Overlong: At character position {0}, octet position {1}: 3-octet encoding for quadruple (0, 0, {2}, {3}).", lenghtUnichars, i2, Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_row()), Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_cell())), new Object[0]);
                }
                i2 += 3;
                ++lenghtUnichars;
                continue;
            }
            if (tempValue <= 247) {
                octets = new char[4];
                octets[0] = (char)(tempValue & 7);
                TitanUniversalCharString.fill_continuing_octets(3, octets, lenghtOctets, valueStr, i2 + 1, lenghtUnichars);
                this.val_ptr.set(lenghtUnichars, new TitanUniversalChar('\u0000', (char)(octets[0] << 2 & 0xFF | octets[1] >> 4), (char)(octets[1] << 4 & 0xFF | octets[2] >> 2), (char)(octets[2] << 6 & 0xFF | octets[3])));
                if (this.val_ptr.get(lenghtUnichars).getUc_plane() == '\u0000') {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Overlong: At character position {0}, octet position {1}: 4-octet encoding for quadruple (0, 0, {2}, {3}).", lenghtUnichars, i2, Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_row()), Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_cell())), new Object[0]);
                }
                i2 += 4;
                ++lenghtUnichars;
                continue;
            }
            if (tempValue <= 251) {
                octets = new char[5];
                octets[0] = (char)(tempValue & 3);
                TitanUniversalCharString.fill_continuing_octets(4, octets, lenghtOctets, valueStr, i2 + 1, lenghtUnichars);
                this.val_ptr.set(lenghtUnichars, new TitanUniversalChar(octets[0], (char)(octets[1] << 2 & 0xFF | octets[2] >> 4), (char)(octets[2] << 4 & 0xFF | octets[3] >> 2), (char)(octets[3] << 6 & 0xFF | octets[4])));
                if (this.val_ptr.get(lenghtUnichars).getUc_group() == '\u0000' && this.val_ptr.get(lenghtUnichars).getUc_plane() < ' ') {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Overlong: At character position {0}, octet position {1}: 5-octet encoding for quadruple (0, {4}, {2}, {3}).", lenghtUnichars, i2, Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_row()), Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_cell()), Character.valueOf(this.val_ptr.get(lenghtUnichars).getUc_plane())), new Object[0]);
                }
                i2 += 5;
                ++lenghtUnichars;
                continue;
            }
            if (tempValue <= 253) {
                octets = new char[6];
                octets[0] = (char)(tempValue & 1);
                TitanUniversalCharString.fill_continuing_octets(5, octets, lenghtOctets, valueStr, i2 + 1, lenghtUnichars);
                this.val_ptr.set(lenghtUnichars, new TitanUniversalChar((char)(octets[0] << 6 & 0xFF | octets[1]), (char)(octets[2] << 2 & 0xFF | octets[3] >> 4), (char)(octets[3] << 4 & 0xFF | octets[4] >> 2), (char)(octets[4] << 6 & 0xFF | octets[5])));
                if (this.val_ptr.get(lenghtUnichars).getUc_group() < '\u0004') {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Overlong: At character position {0}, octet position {1}: 6-octet encoding for quadruple {2}.", lenghtUnichars, i2, this.val_ptr.get(lenghtUnichars).toString()), new Object[0]);
                }
                i2 += 6;
                ++lenghtUnichars;
                continue;
            }
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, String.format("Malformed: At character position %d, octet position %d: unused/reserved octet %02X.", lenghtUnichars, i2, valueStr[i2] & 0xFF), new Object[0]);
            ++i2;
        }
        if (this.val_ptr.size() != lenghtUnichars) {
            if (lenghtUnichars > 0) {
                ArrayList<TitanUniversalChar> helper = new ArrayList<TitanUniversalChar>(lenghtUnichars);
                for (int i3 = 0; i3 < lenghtUnichars && i3 < this.val_ptr.size(); ++i3) {
                    helper.add(this.val_ptr.get(i3));
                }
                this.val_ptr = helper;
            } else {
                this.clean_up();
            }
        }
    }

    public void decode_utf16(int n_octets, byte[] octets_ptr, TitanCharString.CharCoding expected_coding) {
        if (n_octets % 2 != 0 || 0 > n_octets) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Wrong UTF-16 string. The number of bytes (%d) in octetstring shall be non negative and divisible by 2", n_octets);
        }
        int start = this.check_BOM(expected_coding, octets_ptr);
        int n_uchars = n_octets / 2;
        this.clean_up();
        this.val_ptr = new ArrayList<TitanUniversalChar>(n_uchars);
        n_uchars = 0;
        boolean isBig = true;
        switch (expected_coding) {
            case UTF16: 
            case UTF16BE: {
                isBig = true;
                break;
            }
            case UTF16LE: {
                isBig = false;
                break;
            }
            default: {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Unexpected coding type for UTF-16 encoding", new Object[0]);
            }
        }
        for (int i = start; i < n_octets; i += 2) {
            int W2;
            int first = isBig ? i : i + 1;
            int second = isBig ? i + 1 : i;
            int third = isBig ? i + 2 : i + 3;
            int fourth = isBig ? i + 3 : i + 2;
            int W1 = (octets_ptr[first] & 0xFF) << 8 | octets_ptr[second] & 0xFF;
            int n = W2 = i + 3 < n_octets ? (octets_ptr[third] & 0xFF) << 8 | octets_ptr[fourth] & 0xFF : 0;
            if (55296 > W1 || 57343 < W1) {
                this.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', (char)(octets_ptr[first] & 0xFF), (char)(octets_ptr[second] & 0xFF)));
                ++n_uchars;
                continue;
            }
            if (55296 > W1 || 56319 < W1) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "The word (0x%04X) shall be between 0xD800 and 0xDBFF", W1);
                continue;
            }
            if (0 == W2 || 56320 > W2 || 57343 < W2) {
                if (W2 != 0) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Wrong UTF-16 string. The word (0x%04X) shall be between 0xDC00 and 0xDFFF", W2);
                    continue;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Wrong UTF-16 string. The decoding algorithm does not expect 0x00 or EOL", new Object[0]);
                continue;
            }
            int mask10bitlow = 1023;
            int DW = (W1 & 0x3FF) << 10;
            DW |= W2 & 0x3FF;
            this.val_ptr.add(new TitanUniversalChar('\u0000', (char)((DW += 65536) >> 16 & 0xFF), (char)(DW >> 8 & 0xFF), (char)(DW & 0xFF)));
            ++n_uchars;
            i += 2;
        }
        if (this.val_ptr.size() != n_uchars) {
            if (n_uchars > 0) {
                this.val_ptr = new ArrayList<TitanUniversalChar>(n_uchars);
            } else {
                this.clean_up();
            }
        }
    }

    public void decode_utf32(int n_octets, byte[] octets_ptr, TitanCharString.CharCoding expected_coding) {
        if (n_octets % 4 != 0 || 0 > n_octets) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Wrong UTF-32 string. The number of bytes (%d) in octetstring shall be non negative and divisible by 4", n_octets);
        }
        int start = this.check_BOM(expected_coding, octets_ptr);
        int n_uchars = n_octets / 4;
        this.val_ptr = new ArrayList<TitanUniversalChar>(n_uchars);
        n_uchars = 0;
        boolean isBig = true;
        switch (expected_coding) {
            case UTF32: 
            case UTF32BE: {
                isBig = true;
                break;
            }
            case UTF32LE: {
                isBig = false;
                break;
            }
            default: {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Unexpected coding type for UTF-32 encoding", new Object[0]);
            }
        }
        for (int i = start; i < n_octets; i += 4) {
            int first = isBig ? i : i + 3;
            int second = isBig ? i + 1 : i + 2;
            int third = isBig ? i + 2 : i + 1;
            int fourth = isBig ? i + 3 : i;
            long DW = (octets_ptr[first] & 0xFF) << 8 | octets_ptr[second] & 0xFF;
            DW <<= 8;
            DW |= (long)(octets_ptr[third] & 0xFF);
            DW <<= 8;
            if (55296L <= (DW |= (long)(octets_ptr[fourth] & 0xFF)) && 57343L >= DW) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Any UTF-32 code (0x%08X) between 0x0000D800 and 0x0000DFFF is ill-formed", DW);
                continue;
            }
            if (0x10FFFFL < DW) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Any UTF-32 code (0x%08X) greater than 0x0010FFFF is ill-formed", DW);
                continue;
            }
            this.val_ptr.add(new TitanUniversalChar((char)(octets_ptr[first] & 0xFF), (char)(octets_ptr[second] & 0xFF), (char)(octets_ptr[third] & 0xFF), (char)(octets_ptr[fourth] & 0xFF)));
            ++n_uchars;
        }
        if (this.val_ptr.size() != n_uchars) {
            if (n_uchars > 0) {
                this.val_ptr = new ArrayList<TitanUniversalChar>(n_uchars);
            } else {
                this.clean_up();
            }
        }
    }

    public int check_BOM(TitanCharString.CharCoding code, byte[] ostr) {
        String coding_str;
        int length = ostr.length;
        switch (code) {
            case UTF32: 
            case UTF32BE: {
                if (4 <= length && 0 == ostr[0] && 0 == ostr[1] && -2 == ostr[2] && -1 == ostr[3]) {
                    return 4;
                }
                coding_str = "UTF-32BE";
                break;
            }
            case UTF32LE: {
                if (4 <= length && -1 == ostr[0] && -2 == ostr[1] && 0 == ostr[2] && 0 == ostr[3]) {
                    return 4;
                }
                coding_str = "UTF-32LE";
                break;
            }
            case UTF16: 
            case UTF16BE: {
                if (2 <= length && -2 == ostr[0] && -1 == ostr[1]) {
                    return 2;
                }
                coding_str = "UTF-16BE";
                break;
            }
            case UTF16LE: {
                if (2 <= length && -1 == ostr[0] && -2 == ostr[1]) {
                    return 2;
                }
                coding_str = "UTF-16LE";
                break;
            }
            case UTF_8: {
                if (3 <= ostr.length && -17 == ostr[0] && -69 == ostr[1] && -65 == ostr[2]) {
                    return 3;
                }
                coding_str = "UTF-8";
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Internal error: invalid expected coding ({0})", new Object[]{code}));
            }
        }
        if (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_UNQUALIFIED)) {
            TTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_UNQUALIFIED);
            TTCN_Logger.log_event_str("Warning: No ");
            TTCN_Logger.log_event_str(coding_str);
            TTCN_Logger.log_event_str(" Byte Order Mark(BOM) detected. It may result decoding errors");
            TTCN_Logger.end_event();
        }
        return 0;
    }

    public static void fill_continuing_octets(int n_continuing, char[] continuing_ptr, int n_octets, byte[] octets_ptr, int start_pos, int uchar_pos) {
        for (int i = 0; i < n_continuing; ++i) {
            if (start_pos + i < n_octets) {
                byte octet = octets_ptr[start_pos + i];
                if ((octet & 0xC0) != 128) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Malformed: At character position {0}, octet position {1}: {2} is not a valid continuing octet.", uchar_pos, start_pos + i, octet), new Object[0]);
                }
                continuing_ptr[i + 1] = (char)(octet & 0x3F);
                continue;
            }
            if (start_pos + i == n_octets) {
                if (i > 0) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Incomplete: At character position {0}, octet position {1}: {2} out of {3} continuing octets {4} missing from the end of the stream.", uchar_pos, start_pos + i, n_continuing - i, n_continuing, n_continuing - i > 1 ? "are" : "is"), new Object[0]);
                } else {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, MessageFormat.format("Incomplete: At character position {0}, octet position {1}: {2} continuing octet{3} missing from the end of the stream.", uchar_pos, start_pos, n_continuing, n_continuing > 1 ? "s are" : " is"), new Object[0]);
                }
            }
            continuing_ptr[i + 1] = '\u0000';
        }
    }

    public void encode_utf8(TTCN_Buffer text_buf) {
        this.encode_utf8(text_buf, false);
    }

    public void encode_utf8(TTCN_Buffer buf, boolean addBOM) {
        if (addBOM) {
            buf.put_c((byte)-17);
            buf.put_c((byte)-69);
            buf.put_c((byte)-65);
        }
        if (this.charstring) {
            char[] bstr = new char[this.cstr.length()];
            for (int i = 0; i < this.cstr.length(); ++i) {
                bstr[i] = this.cstr.charAt(i);
            }
            buf.put_s(bstr);
        } else {
            for (int i = 0; i < this.val_ptr.size(); ++i) {
                TitanUniversalChar temp = this.val_ptr.get(i);
                int g = temp.getUc_group() & 0xFF;
                int p = temp.getUc_plane() & 0xFF;
                int r = temp.getUc_row() & 0xFF;
                int c = temp.getUc_cell() & 0xFF;
                if (g == 0 && p <= 31) {
                    if (p == 0) {
                        if (r == 0 && c <= 127) {
                            buf.put_c((byte)c);
                            continue;
                        }
                        if (r <= 7) {
                            buf.put_c((byte)(0xC0 | r << 2 | c >> 6));
                            buf.put_c((byte)(0x80 | c & 0x3F));
                            continue;
                        }
                        buf.put_c((byte)(0xE0 | r >> 4));
                        buf.put_c((byte)(0x80 | r << 2 & 0x3C | c >> 6));
                        buf.put_c((byte)(0x80 | c & 0x3F));
                        continue;
                    }
                    buf.put_c((byte)(0xF0 | p >> 2));
                    buf.put_c((byte)(0x80 | p << 4 & 0x30 | r >> 4));
                    buf.put_c((byte)(0x80 | r << 2 & 0x3C | c >> 6));
                    buf.put_c((byte)(0x80 | c & 0x3F));
                    continue;
                }
                if (g <= 3) {
                    buf.put_c((byte)(0xF8 | g));
                    buf.put_c((byte)(0x80 | p >> 2));
                    buf.put_c((byte)(0x80 | p << 4 & 0x30 | r >> 4));
                    buf.put_c((byte)(0x80 | r << 2 & 0x3C | c >> 6));
                    buf.put_c((byte)(0x80 | c & 0x3F));
                    continue;
                }
                buf.put_c((byte)(0xFC | g >> 6));
                buf.put_c((byte)(0x80 | g & 0x3F));
                buf.put_c((byte)(0x80 | p >> 2));
                buf.put_c((byte)(0x80 | p << 4 & 0x30 | r >> 4));
                buf.put_c((byte)(0x80 | r << 2 & 0x3C | c >> 6));
                buf.put_c((byte)(0x80 | c & 0x3F));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode_utf16(TTCN_Buffer buf, TitanCharString.CharCoding expected_coding) {
        boolean isBig = true;
        TTCN_EncDec_ErrorContext error = new TTCN_EncDec_ErrorContext();
        try {
            switch (expected_coding) {
                case UTF16: 
                case UTF16BE: {
                    isBig = true;
                    break;
                }
                case UTF16LE: {
                    isBig = false;
                    break;
                }
                default: {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Unexpected coding type for UTF-16 encoding", new Object[0]);
                }
            }
            buf.put_c((byte)(isBig ? 254 : 255));
            buf.put_c((byte)(isBig ? 255 : 254));
            if (this.charstring) {
                for (int i = 0; i < this.cstr.length(); ++i) {
                    buf.put_c((byte)(isBig ? (char)'\u0000' : this.cstr.charAt(i)));
                    buf.put_c((byte)(isBig ? this.cstr.charAt(i) : (char)'\u0000'));
                }
            } else {
                for (int i = 0; i < this.val_ptr.size(); ++i) {
                    TitanUniversalChar temp_char = this.val_ptr.get(i);
                    int g = temp_char.getUc_group();
                    int p = temp_char.getUc_plane();
                    char r = temp_char.getUc_row();
                    char c = temp_char.getUc_cell();
                    if (g != 0 || 16 < p) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Any UCS code (0x%02X%02X%02X%02X) to be encoded into UTF-16 shall not be greater than 0x10FFFF", Character.valueOf((char)g), Character.valueOf((char)p), Character.valueOf(r), Character.valueOf(c));
                        continue;
                    }
                    if (0 == g && 0 == p && '\u00d8' <= r && '\u00df' >= r) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Any UCS code (0x%02X%02X) between 0xD800 and 0xDFFF is ill-formed", Character.valueOf(r), Character.valueOf(c));
                        continue;
                    }
                    if (0 == g && 0 == p) {
                        buf.put_c((byte)((isBig ? r : c) & 0xFF));
                        buf.put_c((byte)((isBig ? c : r) & 0xFF));
                        continue;
                    }
                    if (g == 0 && p == 0) continue;
                    int univc = g;
                    univc <<= 24;
                    int temp = p;
                    univc |= (temp <<= 16);
                    temp = r;
                    univc |= (temp <<= 8);
                    int W1 = 55296;
                    int W2 = 56320;
                    int univcmod = (univc |= c) - 65536;
                    int WH = univcmod >> 10;
                    int WL = univcmod & 0x3FF;
                    char uc = (char)(isBig ? W1 >> 8 : (W1 |= WH));
                    buf.put_c((byte)(uc & 0xFF));
                    uc = (char)(isBig ? W1 : W1 >> 8);
                    buf.put_c((byte)(uc & 0xFF));
                    uc = (char)(isBig ? W2 >> 8 : (W2 |= WL));
                    buf.put_c((byte)(uc & 0xFF));
                    uc = (char)(isBig ? W2 : W2 >> 8);
                    buf.put_c((byte)(uc & 0xFF));
                }
            }
        }
        finally {
            error.leave_context();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode_utf32(TTCN_Buffer buf, TitanCharString.CharCoding expected_coding) {
        boolean isBig = true;
        TTCN_EncDec_ErrorContext error = new TTCN_EncDec_ErrorContext();
        try {
            switch (expected_coding) {
                case UTF32: 
                case UTF32BE: {
                    isBig = true;
                    break;
                }
                case UTF32LE: {
                    isBig = false;
                    break;
                }
                default: {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Unexpected coding type for UTF-32 encoding", new Object[0]);
                }
            }
            buf.put_c((byte)(isBig ? 0 : 255));
            buf.put_c((byte)(isBig ? 0 : 254));
            buf.put_c((byte)(isBig ? 254 : 0));
            buf.put_c((byte)(isBig ? 255 : 0));
            if (this.charstring) {
                for (int i = 0; i < this.cstr.length(); ++i) {
                    buf.put_c((byte)(isBig ? (char)'\u0000' : this.cstr.charAt(i)));
                    buf.put_c((byte)0);
                    buf.put_c((byte)0);
                    buf.put_c((byte)(isBig ? this.cstr.charAt(i) : (char)'\u0000'));
                }
            } else {
                for (int i = 0; i < this.val_ptr.size(); ++i) {
                    TitanUniversalChar temp = this.val_ptr.get(i);
                    char g = temp.getUc_group();
                    char p = temp.getUc_plane();
                    char r = temp.getUc_row();
                    char c = temp.getUc_cell();
                    int DW = g << 8 | p;
                    DW <<= 8;
                    DW |= r;
                    DW <<= 8;
                    if (55296 <= (DW |= c) && 57343 >= DW) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Any UCS code (0x%08X) between 0x0000D800 and 0x0000DFFF is ill-formed", DW);
                        continue;
                    }
                    if (0x10FFFF < DW) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_DEC_UCSTR, "Any UCS code (0x%08X) greater than 0x0010FFFF is ill-formed", DW);
                        continue;
                    }
                    buf.put_c((byte)(isBig ? g : c));
                    buf.put_c((byte)(isBig ? p : r));
                    buf.put_c((byte)(isBig ? r : p));
                    buf.put_c((byte)(isBig ? c : g));
                }
            }
        }
        finally {
            error.leave_context();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        int align_length;
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
        }
        if (this.charstring) {
            return new TitanCharString(this.cstr).RAW_encode(p_td, myleaf);
        }
        TTCN_Buffer buf = new TTCN_Buffer();
        switch (p_td.raw.stringformat) {
            case UTF_8: 
            case UNKNOWN: {
                this.encode_utf8(buf);
                break;
            }
            case UTF16: {
                this.encode_utf16(buf, TitanCharString.CharCoding.UTF16);
                break;
            }
            default: {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INTERNAL, "Invalid string serialization type.", new Object[0]);
            }
        }
        if (p_td.raw.fieldlength < 0) {
            buf.put_c((byte)0);
        }
        int buff_len = buf.get_len();
        int bl = buff_len * 8;
        int n = align_length = p_td.raw.fieldlength > 0 ? p_td.raw.fieldlength - bl : 0;
        if (align_length < 0) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There are insufficient bits to encode '%s': ", p_td.name);
            bl = p_td.raw.fieldlength;
            align_length = 0;
        }
        myleaf.data_array = new byte[buff_len];
        System.arraycopy(buf.get_data(), 0, myleaf.data_array, 0, buff_len);
        myleaf.align = p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB ? -align_length : align_length;
        myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
        myleaf.length = bl + align_length;
        return myleaf.length;
    }

    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord) {
        return this.RAW_decode(p_td, buff, limit, top_bit_ord, false, -1, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        TitanCharString buff_str = new TitanCharString();
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            int dec_len = buff_str.RAW_decode(p_td, buff, limit, top_bit_ord);
            byte[] tmp_val_ptr = AdditionalFunctions.char2oct(buff_str).get_value();
            if (buff_str.is_bound()) {
                this.charstring = true;
                for (int i = 0; i < buff_str.lengthof().get_int(); ++i) {
                    if (buff_str.get_value().charAt(i) <= '\u007f') continue;
                    this.charstring = false;
                    break;
                }
                switch (p_td.raw.stringformat) {
                    case UTF_8: 
                    case UNKNOWN: {
                        if (this.charstring) {
                            this.cstr = buff_str.get_value();
                            break;
                        }
                        this.decode_utf8(tmp_val_ptr, TitanCharString.CharCoding.UTF_8, false);
                        break;
                    }
                    case UTF16: {
                        if (!this.charstring) {
                            this.decode_utf16(tmp_val_ptr.length, tmp_val_ptr, TitanCharString.CharCoding.UTF16);
                            break;
                        }
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid string format. Buffer contains only ASCII characters.", new Object[0]);
                        break;
                    }
                    default: {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INTERNAL, "Invalid string serialization type.", new Object[0]);
                    }
                }
            }
            int n = dec_len;
            return n;
        }
        finally {
            errorcontext.leave_context();
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        String tmp_str;
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound universal charstring value.", new Object[0]);
            return -1;
        }
        if (this.charstring) {
            tmp_str = TitanCharString.to_JSON_string(this.cstr, p_td.json.getEscaping());
        } else {
            TTCN_Buffer tmp_buf = new TTCN_Buffer();
            this.encode_utf8(tmp_buf);
            tmp_str = TitanUniversalCharString.to_JSON_string(tmp_buf, p_td.json.getEscaping());
        }
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str);
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        int dec_len = p_tok.get_next_token(token, value, value_len);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get()) {
            StringBuilder out = new StringBuilder();
            if (TitanCharString.from_JSON_string(value.toString(), true, out)) {
                this.charstring = true;
                this.cstr = out;
            } else {
                this.charstring = false;
                byte[] temp = new byte[value.length()];
                for (int i = 0; i < value.length(); ++i) {
                    temp[i] = (byte)value.charAt(i);
                }
                this.decode_utf8(temp, TitanCharString.CharCoding.UTF_8, false);
                if (!this.from_JSON_string(true)) {
                    if (!p_silent) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", "universal charstring");
                    }
                    if (p_silent) {
                        this.clean_up();
                    }
                    return -2;
                }
            }
        } else {
            return -1;
        }
        return dec_len;
    }

    private static String to_JSON_string(TTCN_Buffer p_buf, JSON.json_string_escaping mode) {
        byte[] ustr = p_buf.get_data();
        int ustr_len = p_buf.get_len();
        StringBuilder json_str = new StringBuilder();
        json_str.append('\"');
        for (int i = 0; i < ustr_len; ++i) {
            int temp = ustr[i] & 0xFF;
            if (mode != JSON.json_string_escaping.ESCAPE_AS_USI) {
                switch (temp) {
                    case 10: {
                        json_str.append("\\n");
                        break;
                    }
                    case 9: {
                        json_str.append("\\t");
                        break;
                    }
                    case 13: {
                        json_str.append("\\r");
                        break;
                    }
                    case 12: {
                        json_str.append("\\f");
                        break;
                    }
                    case 8: {
                        json_str.append("\\b");
                        break;
                    }
                    case 34: {
                        json_str.append("\\\"");
                        break;
                    }
                    case 92: {
                        if (mode == JSON.json_string_escaping.ESCAPE_AS_SHORT) {
                            json_str.append("\\\\");
                            break;
                        }
                    }
                    case 47: {
                        if (mode == JSON.json_string_escaping.ESCAPE_AS_SHORT) {
                            json_str.append("\\/");
                            break;
                        }
                    }
                    default: {
                        if (temp <= 31 || temp == 127) {
                            json_str.append("\\u00");
                            json_str.append(Integer.toHexString(temp / 16).toUpperCase());
                            json_str.append(Integer.toHexString(temp % 16).toUpperCase());
                            break;
                        }
                        json_str.append((char)temp);
                        break;
                    }
                }
                continue;
            }
            if (temp <= 32 || temp == 34 || temp == 92 || temp == 127) {
                json_str.append("\\u00");
                json_str.append(Integer.toHexString(temp / 16).toUpperCase());
                json_str.append(Integer.toHexString(temp % 16).toUpperCase());
                continue;
            }
            json_str.append((char)temp);
        }
        json_str.append('\"');
        return json_str.toString();
    }

    private boolean from_JSON_string(boolean check_quotes) {
        int json_len = this.val_ptr.size();
        List<TitanUniversalChar> json_str = this.val_ptr;
        int start = 0;
        int end = json_len;
        if (check_quotes) {
            start = 1;
            end = json_len - 1;
            if (!json_str.get(0).is_char() || json_str.get(0).getUc_cell() != '\"' || !json_str.get(json_len - 1).is_char() || json_str.get(json_len - 1).getUc_cell() != '\"') {
                return false;
            }
        }
        ArrayList<TitanUniversalChar> ustr = new ArrayList<TitanUniversalChar>();
        boolean error = false;
        for (int i = start; i < end; ++i) {
            if (json_str.get(i).is_char() && '\\' == json_str.get(i).getUc_cell()) {
                if (i == end - 1 || !json_str.get(i + 1).is_char()) {
                    error = true;
                    break;
                }
                switch (json_str.get(i + 1).getUc_cell()) {
                    case 'n': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\n'));
                        break;
                    }
                    case 't': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\t'));
                        break;
                    }
                    case 'r': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\r'));
                        break;
                    }
                    case 'f': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\f'));
                        break;
                    }
                    case 'b': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\b'));
                        break;
                    }
                    case '\\': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\\'));
                        break;
                    }
                    case '\"': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '\"'));
                        break;
                    }
                    case '/': {
                        ustr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', '/'));
                        break;
                    }
                    case 'u': {
                        if (end - i >= 6 && json_str.get(i + 2).is_char() && json_str.get(i + 3).is_char() && json_str.get(i + 4).is_char() && json_str.get(i + 5).is_char()) {
                            byte row_upper_nibble = AdditionalFunctions.char_to_hexdigit(json_str.get(i + 2).getUc_cell());
                            byte row_lower_nibble = AdditionalFunctions.char_to_hexdigit(json_str.get(i + 3).getUc_cell());
                            byte cell_upper_nibble = AdditionalFunctions.char_to_hexdigit(json_str.get(i + 4).getUc_cell());
                            byte cell_lower_nibble = AdditionalFunctions.char_to_hexdigit(json_str.get(i + 5).getUc_cell());
                            if (row_upper_nibble <= 15 && row_lower_nibble <= 15 && cell_upper_nibble <= 15 && cell_lower_nibble <= 15) {
                                ustr.add(new TitanUniversalChar('\u0000', '\u0000', (char)(row_upper_nibble << 4 | row_lower_nibble), (char)(cell_upper_nibble << 4 | cell_lower_nibble)));
                                i += 4;
                                break;
                            }
                            i = end;
                            error = true;
                            break;
                        }
                        i = end;
                        error = true;
                        break;
                    }
                    default: {
                        i = end;
                        error = true;
                    }
                }
                ++i;
            } else {
                ustr.add(new TitanUniversalChar(json_str.get(i)));
            }
            if (!check_quotes || i != json_len - 1) continue;
            error = true;
        }
        if (!error) {
            this.clean_up();
            this.val_ptr = ustr;
        }
        return !error;
    }

    public static TitanCharString.CharCoding get_character_coding(String codingString, String contextString) {
        TitanCharString.CharCoding newCoding = TitanCharString.CharCoding.UTF_8;
        if (codingString != null && !codingString.equals("UTF-8")) {
            if ("UTF-16".equals(codingString)) {
                newCoding = TitanCharString.CharCoding.UTF16;
            } else if ("UTF-16LE".equals(codingString)) {
                newCoding = TitanCharString.CharCoding.UTF16LE;
            } else if ("UTF-16BE".equals(codingString)) {
                newCoding = TitanCharString.CharCoding.UTF16BE;
            } else if ("UTF-32".equals(codingString)) {
                newCoding = TitanCharString.CharCoding.UTF32;
            } else if ("UTF-32LE".equals(codingString)) {
                newCoding = TitanCharString.CharCoding.UTF32LE;
            } else if ("UTF-32BE".equals(codingString)) {
                newCoding = TitanCharString.CharCoding.UTF32BE;
            } else {
                throw new TtcnError(MessageFormat.format("Invalid string serialization for {0}.", contextString));
            }
        }
        return newCoding;
    }

    public static TitanUniversalCharString convert_to_UniversalCharString(TitanUniversalCharString otherValue) {
        return otherValue;
    }

    public static TitanUniversalCharString convert_to_UniversalCharString(TitanUniversalCharString_Element otherValue) {
        return new TitanUniversalCharString(otherValue);
    }

    public static TitanUniversalCharString convert_to_UniversalCharString(TitanCharString otherValue) {
        return new TitanUniversalCharString(otherValue);
    }

    public static TitanUniversalCharString convert_to_UniversalCharString(TitanCharString_Element otherValue) {
        return new TitanUniversalCharString(new TitanCharString(otherValue));
    }

    private static enum States {
        INIT,
        PCHAR,
        UCHAR;

    }
}

