/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanVerdictType
extends Base_Type {
    public static final JSON.TTCN_JSONdescriptor TitanVerdictType_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanVerdictType_descr_ = new Base_Type.TTCN_Typedescriptor("verdicttype", null, null, TitanVerdictType_json_, null);
    public static final String[] verdict_name = new String[]{"none", "pass", "inconc", "fail", "error"};
    private VerdictTypeEnum verdict_value;

    public TitanVerdictType() {
        this.verdict_value = VerdictTypeEnum.UNBOUND;
    }

    public TitanVerdictType(VerdictTypeEnum otherValue) {
        if (!TitanVerdictType.is_valid(otherValue)) {
            throw new TtcnError("Initializing a verdict variable with an invalid value (" + (Object)((Object)otherValue) + ").");
        }
        this.verdict_value = otherValue;
    }

    public TitanVerdictType(TitanVerdictType otherValue) {
        otherValue.must_bound("Copying an unbound verdict value.");
        this.verdict_value = otherValue.verdict_value;
    }

    @Override
    public void clean_up() {
        this.verdict_value = VerdictTypeEnum.UNBOUND;
    }

    public static boolean is_valid(VerdictTypeEnum aVerdictValue) {
        return aVerdictValue != VerdictTypeEnum.UNBOUND;
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_bound() {
        return this.verdict_value != VerdictTypeEnum.UNBOUND;
    }

    public boolean operator_equals(VerdictTypeEnum otherValue) {
        this.must_bound("The left operand of comparison is an unbound verdict value.");
        if (!TitanVerdictType.is_valid(otherValue)) {
            throw new TtcnError("The right operand of comparison is an invalid verdict value (" + (Object)((Object)otherValue) + ").");
        }
        return this.verdict_value == otherValue;
    }

    public boolean operator_equals(TitanVerdictType otherValue) {
        this.must_bound("The left operand of comparison is an unbound verdict value.");
        otherValue.must_bound("The right operand of comparison is an unbound verdict value.");
        return this.verdict_value.equals((Object)otherValue.verdict_value);
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanVerdictType) {
            return this.operator_equals((TitanVerdictType)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to verdict type", otherValue));
    }

    public boolean operator_not_equals(VerdictTypeEnum otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanVerdictType otherValue) {
        return !this.operator_equals(otherValue);
    }

    public TitanVerdictType operator_assign(VerdictTypeEnum otherValue) {
        if (!TitanVerdictType.is_valid(otherValue)) {
            throw new TtcnError("Assignment of an invalid verdict value (" + (Object)((Object)otherValue) + ").");
        }
        this.verdict_value = otherValue;
        return this;
    }

    public TitanVerdictType operator_assign(TitanVerdictType otherValue) {
        otherValue.must_bound("Assignment of an unbound verdict value.");
        if (otherValue != this) {
            this.verdict_value = otherValue.verdict_value;
        }
        return this;
    }

    @Override
    public TitanVerdictType operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanVerdictType) {
            return this.operator_assign((TitanVerdictType)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to verdict type", otherValue));
    }

    public VerdictTypeEnum get_value() {
        return this.verdict_value;
    }

    @Override
    public void log() {
        if (TitanVerdictType.is_valid(this.verdict_value)) {
            TTCN_Logger.log_event_str(verdict_name[this.verdict_value.ordinal()]);
        } else if (this.verdict_value == VerdictTypeEnum.UNBOUND) {
            TTCN_Logger.log_event_unbound();
        } else {
            TTCN_Logger.log_event(MessageFormat.format("<invalid verdict value: {0}>", new Object[]{this.verdict_value}), new Object[0]);
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "verdict value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        if (param.get_type() != Param_Types.Module_Parameter.type_t.MP_Verdict) {
            param.type_error("verdict value");
        }
        TitanVerdictType verdict = param.get_verdict();
        if (!TitanVerdictType.is_valid(verdict.verdict_value)) {
            param.error("Internal error: invalid verdict value (%d).", verdict);
        }
        this.verdict_value = verdict.verdict_value;
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Verdict(this);
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound verdict value.");
        text_buf.push_int(this.verdict_value.getValue());
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        int received_value = text_buf.pull_int().get_int();
        if (received_value < 0 || received_value > 5) {
            throw new TtcnError(MessageFormat.format("Text decoder: Invalid verdict value ({0}) was received.", received_value));
        }
        this.verdict_value = VerdictTypeEnum.values()[received_value];
    }

    public static boolean operator_equals(VerdictTypeEnum par_value, TitanVerdictType other_value) {
        if (!TitanVerdictType.is_valid(par_value)) {
            throw new TtcnError("The left operand of comparison is an invalid verdict value (" + (Object)((Object)par_value) + ").");
        }
        other_value.must_bound("The right operand of comparison is an unbound verdict value.");
        return par_value == other_value.get_value();
    }

    public static boolean operator_not_equals(VerdictTypeEnum par_value, TitanVerdictType other_value) {
        return !TitanVerdictType.operator_equals(par_value, other_value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound verdicttype value.", new Object[0]);
            return -1;
        }
        String tmp_str = "\"" + this.verdict_value.getName() + "\"";
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str);
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        int dec_len = p_tok.get_next_token(token, value, value_len);
        boolean error = true;
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get()) {
            if (value.charAt(0) == '\"' && value.charAt(value_len.get() - 1) == '\"') {
                String valueWithoutQuotes = value.substring(1, value.length() - 1);
                value.setLength(0);
                value.append(valueWithoutQuotes);
                value_len.set(value.length());
                for (VerdictTypeEnum v : VerdictTypeEnum.values()) {
                    if (!v.getName().equals(value.toString())) continue;
                    this.verdict_value = v;
                    error = false;
                    break;
                }
            }
        } else {
            this.verdict_value = VerdictTypeEnum.UNBOUND;
            return -1;
        }
        if (error) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", "verdicttype");
            }
            this.verdict_value = VerdictTypeEnum.UNBOUND;
            return -2;
        }
        return dec_len;
    }

    public VerdictTypeEnum str_to_verdict(String v, boolean silent) {
        for (VerdictTypeEnum i : VerdictTypeEnum.values()) {
            if (!verdict_name[i.ordinal()].equals(v)) continue;
            return i;
        }
        if (!silent) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid value for verdicttype: '%s'", v);
        }
        return VerdictTypeEnum.UNBOUND;
    }

    public static enum VerdictTypeEnum {
        NONE(0, "none"),
        PASS(1, "pass"),
        INCONC(2, "inconc"),
        FAIL(3, "fail"),
        ERROR(4, "error"),
        UNBOUND(5, "unbound");

        private int index;
        private String name;

        private VerdictTypeEnum(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getValue() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

