/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.search.LogSearchQuery;
import org.eclipse.titan.log.viewer.search.SearchPattern;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.utils.SelectionUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class LogSearchPage
extends DialogPage
implements ISearchPage {
    private static final int ALL_NONE_BUTTONS = 2;
    private static final String WILDCARDS_TEXT = " * = any string, ? = any character, \\ = escape for literals: *?\\ ";
    private static final Image INFORMATION_ICON = Activator.getDefault().getIcon("icons/tree_text_obj.gif");
    private static final Image INVALID_DATA_ICON = Activator.getDefault().getIcon("icons/testerr.gif");
    private Combo searchString;
    private Button caseSensitive;
    private Button regularExpression;
    private CLabel wildcards;
    private Button[] searchFor;
    private Button[] limitTo;
    private IDialogSettings dialogSettings = null;
    private boolean firstTime = true;
    private static final int HISTORY_SIZE = 12;
    private final List<SearchPattern> previousSearchPatterns = new ArrayList<SearchPattern>();
    private ISearchPageContainer container;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expression = this.createExpression(result);
        expression.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Control limitTo = this.createLimitTo(result);
        limitTo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.setControl((Control)result);
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText("Search String");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.searchString = new Combo(result, 2052);
        this.searchString.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogSearchPage.this.getContainer().setPerformActionEnabled(LogSearchPage.this.isValidSearchPattern());
            }
        });
        this.searchString.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogSearchPage.this.handlePatternSelected();
                LogSearchPage.this.getContainer().setPerformActionEnabled(LogSearchPage.this.isValidSearchPattern());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LogSearchPage.this.handlePatternSelected();
                LogSearchPage.this.getContainer().setPerformActionEnabled(LogSearchPage.this.isValidSearchPattern());
            }
        });
        this.caseSensitive = new Button(result, 32);
        this.caseSensitive.setText("Case sensitive");
        this.wildcards = new CLabel(result, 16384);
        this.wildcards.setText(WILDCARDS_TEXT);
        this.wildcards.setImage(INFORMATION_ICON);
        this.regularExpression = new Button(result, 32);
        this.regularExpression.setText("Regular expression");
        this.regularExpression.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LogSearchPage.this.getContainer().setPerformActionEnabled(LogSearchPage.this.isValidSearchPattern());
            }
        });
        return result;
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText("Search For");
        result.setLayout((Layout)new GridLayout(5, true));
        this.searchFor = new Button[Constants.EVENT_CATEGORIES.size() + 2];
        int i = 0;
        Iterator<String> it = Constants.EVENT_CATEGORIES.keySet().iterator();
        while (it.hasNext()) {
            Button tmp = new Button((Composite)result, 32);
            String currentEvent = it.next();
            tmp.setText(currentEvent);
            tmp.setData((Object)currentEvent);
            tmp.setSelection(true);
            tmp.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LogSearchPage.this.getContainer().setPerformActionEnabled(LogSearchPage.this.isValidSearchPattern());
                    LogSearchPage.this.searchFor[LogSearchPage.this.searchFor.length - 1].setSelection(false);
                    LogSearchPage.this.searchFor[LogSearchPage.this.searchFor.length - 2].setSelection(false);
                }
            });
            this.searchFor[i] = tmp;
            ++i;
        }
        Button all = new Button((Composite)result, 8);
        all.setText("Select all");
        all.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (int i = 0; i < LogSearchPage.this.searchFor.length - 2; ++i) {
                    LogSearchPage.this.searchFor[i].setSelection(true);
                }
                LogSearchPage.this.getContainer().setPerformActionEnabled(LogSearchPage.this.isValidSearchPattern());
            }
        });
        all.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.searchFor[i] = all;
        Button none = new Button((Composite)result, 8);
        none.setText("Deselect all");
        none.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (int i = 0; i < LogSearchPage.this.searchFor.length - 2; ++i) {
                    LogSearchPage.this.searchFor[i].setSelection(false);
                }
                LogSearchPage.this.getContainer().setPerformActionEnabled(LogSearchPage.this.isValidSearchPattern());
            }
        });
        none.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.searchFor[i + 1] = none;
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText("Limit To");
        result.setLayout((Layout)new GridLayout(1, false));
        Button sourceInfo = new Button((Composite)result, 32);
        sourceInfo.setText("Source Info");
        sourceInfo.setData((Object)FilterPattern.Field.SOURCE_INFO);
        sourceInfo.setSelection(true);
        Button message = new Button((Composite)result, 32);
        message.setText("Message");
        message.setData((Object)FilterPattern.Field.MESSAGE);
        message.setSelection(true);
        this.limitTo = new Button[2];
        this.limitTo[0] = sourceInfo;
        this.limitTo[1] = message;
        return result;
    }

    private List<IFile> collectFilesForSearch() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                IProject[] projects;
                for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                    this.getLogFilesFromResource((IResource)project, files);
                }
                break;
            }
            case 1: {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                ISelection selection = activePage.getSelection();
                if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) break;
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object o : structuredSelection) {
                    if (!(o instanceof IResource)) continue;
                    this.getLogFilesFromResource((IResource)o, files);
                }
                break;
            }
            case 3: {
                String[] projectNames;
                for (String name : projectNames = this.getContainer().getSelectedProjectNames()) {
                    IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                    this.getLogFilesFromResource((IResource)currentProject, files);
                }
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) break;
                for (IWorkingSet workingSet : workingSets) {
                    for (IAdaptable element : workingSet.getElements()) {
                        this.getLogFilesFromResource((IResource)element, files);
                    }
                }
                break;
            }
        }
        return files;
    }

    private void getLogFilesFromResource(IResource resource, List<IFile> files) {
        if (resource == null || files == null) {
            return;
        }
        if (resource instanceof IFile) {
            IFile myFile = (IFile)resource;
            if (this.isValidLogFile(myFile) && !files.contains(myFile)) {
                files.add((IFile)resource);
            }
        } else if (resource instanceof IContainer) {
            try {
                IResource[] project;
                if (resource instanceof IProject && (!(project = (IResource[])resource).isOpen() || project.getNature("org.eclipse.titan.log.viewer.TitanLogProject") == null)) {
                    return;
                }
                for (IResource r : ((IContainer)resource).members()) {
                    this.getLogFilesFromResource(r, files);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("Could not collect the log files. Reason: ") + e.getMessage()));
            }
        }
    }

    public boolean performAction() {
        List<IFile> files = this.collectFilesForSearch();
        LogSearchQuery query = new LogSearchQuery(files, this.getPattern());
        for (ISearchQuery runningQuery : NewSearchUI.getQueries()) {
            NewSearchUI.cancelQuery((ISearchQuery)runningQuery);
        }
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    private boolean isValidLogFile(IFile file) {
        return SelectionUtils.hasLogFileExtension(file);
    }

    public ISearchPageContainer getContainer() {
        return this.container;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private SearchPattern getPattern() {
        String string = this.searchString.getText();
        SearchPattern match = this.findInPrevious(string);
        if (match != null) {
            this.previousSearchPatterns.remove(match);
        }
        TreeMap<String, Boolean> events = new TreeMap<String, Boolean>();
        for (int i = 0; i < this.searchFor.length - 2; ++i) {
            events.put(this.searchFor[i].getData().toString(), this.searchFor[i].getSelection());
        }
        HashMap<FilterPattern.Field, Boolean> limitToMap = new HashMap<FilterPattern.Field, Boolean>();
        for (Button aLimitTo : this.limitTo) {
            limitToMap.put(FilterPattern.Field.valueOf(aLimitTo.getData().toString()), aLimitTo.getSelection());
        }
        match = new SearchPattern(string, this.caseSensitive.getSelection(), this.regularExpression.getSelection(), events, limitToMap, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.previousSearchPatterns.add(0, match);
        return match;
    }

    private SearchPattern findInPrevious(String pattern) {
        for (SearchPattern element : this.previousSearchPatterns) {
            if (!pattern.equals(element.getSearchString())) continue;
            return element;
        }
        return null;
    }

    private void readConfiguration() {
        int historySize;
        IDialogSettings settings = this.getDialogSettings();
        try {
            historySize = settings.getInt("historySize");
        }
        catch (NumberFormatException e) {
            historySize = 12;
        }
        try {
            for (int i = 0; i < historySize; ++i) {
                SearchPattern data;
                IDialogSettings histSettings = settings.getSection("history" + i);
                if (histSettings == null || (data = SearchPattern.create(histSettings)) == null) continue;
                this.previousSearchPatterns.add(data);
            }
        }
        catch (NumberFormatException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("Could not read the configuration of the page. Reason: ") + e.getMessage()));
        }
    }

    private void writeConfiguration() {
        IDialogSettings settings = this.getDialogSettings();
        int historySize = Math.min(this.previousSearchPatterns.size(), 12);
        settings.put("historySize", historySize);
        for (int i = 0; i < historySize; ++i) {
            IDialogSettings histSettings = settings.addNewSection("history" + i);
            SearchPattern pattern = this.previousSearchPatterns.get(i);
            pattern.store(histSettings);
        }
    }

    private IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = Activator.getDefault().getDialogSettingsSection("search");
        }
        return this.dialogSettings;
    }

    public void setVisible(boolean visible) {
        if (visible && this.searchString != null) {
            if (this.firstTime) {
                this.firstTime = false;
                String[] searchStrings = new String[this.previousSearchPatterns.size()];
                for (int i = 0; i < searchStrings.length; ++i) {
                    searchStrings[i] = this.previousSearchPatterns.get(i).getSearchString();
                }
                this.searchString.setItems(searchStrings);
            }
            this.searchString.setFocus();
        }
        this.getContainer().setPerformActionEnabled(this.isValidSearchPattern());
        super.setVisible(visible);
    }

    private boolean isValidSearchPattern() {
        if (this.searchString.getText().length() == 0) {
            this.wildcards.setText(WILDCARDS_TEXT);
            this.wildcards.setForeground(null);
            this.wildcards.setImage(INFORMATION_ICON);
            return false;
        }
        if (this.regularExpression.getSelection()) {
            try {
                Pattern.compile(this.searchString.getText());
            }
            catch (PatternSyntaxException e) {
                this.wildcards.setText("Invalid regular expression");
                this.wildcards.setForeground(this.getShell().getDisplay().getSystemColor(3));
                this.wildcards.setImage(INVALID_DATA_ICON);
                return false;
            }
        }
        this.wildcards.setText(WILDCARDS_TEXT);
        this.wildcards.setForeground(null);
        this.wildcards.setImage(INFORMATION_ICON);
        for (int i = 0; i < this.searchFor.length - 2; ++i) {
            if (!this.searchFor[i].getSelection()) continue;
            return true;
        }
        return false;
    }

    private void handlePatternSelected() {
        int selectionIndex = this.searchString.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.previousSearchPatterns.size()) {
            return;
        }
        SearchPattern pattern = this.previousSearchPatterns.get(selectionIndex);
        SortedMap<String, Boolean> events = pattern.getEvents();
        for (int i = 0; i < this.searchFor.length - 2; ++i) {
            this.searchFor[i].setSelection(((Boolean)events.get(this.searchFor[i].getData().toString())).booleanValue());
        }
        Map<FilterPattern.Field, Boolean> limitToMap = pattern.getLimitTo();
        for (Button button : this.limitTo) {
            button.setSelection(limitToMap.get(button.getData()).booleanValue());
        }
        this.searchString.setText(pattern.getSearchString());
        this.caseSensitive.setSelection(pattern.isCaseSensitive());
        this.regularExpression.setSelection(pattern.isRegularExpression());
        if (pattern.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(pattern.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(pattern.getScope());
        }
    }
}

