/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.actions.OpenMSCViewAction;
import org.eclipse.titan.log.viewer.actions.OpenTextTableStatisticalViewMenuAction;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.extractors.TestCaseExtractor;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.readers.CachedLogReader;
import org.eclipse.titan.log.viewer.readers.LogFileReader;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.ILogViewerView;
import org.eclipse.titan.log.viewer.views.details.StatisticalData;
import org.eclipse.titan.log.viewer.views.navigator.ProjectsViewerMenuListener;
import org.eclipse.titan.log.viewer.views.navigator.ProjectsViewerMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.ViewPart;

public class StatisticalView
extends ViewPart
implements ISelectionProvider,
ILogViewerView {
    private IMemento memento = null;
    private LogFileMetaData logFileMetaData;
    private Table amountTable = null;
    private Table errorTestCasesTable = null;
    private Table failTestCasesTable = null;
    private Table testCasesTable = null;
    private CachedLogReader reader = null;
    private static final int DEFAULT_COLUMN_WIDTH = 55;
    private static final int DEFAULT_AMOUNT_COLUMN_WIDTH = 75;
    private OpenMSCViewAction openMSCViewAction;
    private OpenTextTableStatisticalViewMenuAction openTextTableStatisticalViewMenuAction;
    private final List<ISelectionChangedListener> registeredListeners = new ArrayList<ISelectionChangedListener>();
    private TestCase testcaseSelection = null;
    private ISelection eventSelection;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private ExpandableComposite ecError;
    private ExpandableComposite ecFail;
    private ExpandableComposite ecTestCases;
    private final Map<String, Section> cachedSections = new HashMap<String, Section>();
    private List<StatisticalData> statisticalDataVector = new Vector<StatisticalData>();

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.reader == null) {
            return;
        }
        IMemento tempMemento = memento.createChild("selection");
        try {
            IMemento[] viewAttributes = new IMemento[this.statisticalDataVector.size()];
            for (int i = 0; i < this.statisticalDataVector.size(); ++i) {
                IMemento viewAttribute = tempMemento.createChild("viewAttributes");
                StatisticalData statisticData = this.statisticalDataVector.get(i);
                LogFileMetaData logFileMetaData = statisticData.getLogFileMetaData();
                viewAttribute.putString("projectName", logFileMetaData.getProjectName());
                Path filePath = new Path(logFileMetaData.getProjectRelativePath());
                IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
                if (logFile != null && logFile.exists()) {
                    viewAttribute.putString("propertyFile", LogFileCacheHandler.getPropertyFileForLogFile(logFile).getAbsolutePath());
                    File aLogFile = logFile.getLocation().toFile();
                    viewAttribute.putString("fileSize", String.valueOf(aLogFile.length()));
                    viewAttribute.putString("fileModification", String.valueOf(aLogFile.lastModified()));
                }
                viewAttributes[i] = viewAttribute;
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    public void setData(List<StatisticalData> statisticalDataVector) {
        this.statisticalDataVector = statisticalDataVector;
        if (this.statisticalDataVector.size() > 1) {
            Set<String> keys = this.cachedSections.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String currentKey = (String)iterator.next();
                Section tmpSection = this.cachedSections.get(currentKey);
                if (tmpSection == null || tmpSection.isDisposed()) continue;
                tmpSection.dispose();
            }
            this.cachedSections.clear();
        }
        for (StatisticalData statisticalData : this.statisticalDataVector) {
            this.logFileMetaData = statisticalData.getLogFileMetaData();
            List<TestCase> tmpTestCases = statisticalData.getTestCaseVector();
            this.reader = statisticalData.getCachedLogFileReader();
            String projectRelativePath = this.logFileMetaData.getProjectRelativePath();
            Section tmpSection = this.cachedSections.get(projectRelativePath);
            if (tmpSection == null) {
                this.createSection();
            }
            this.amountTable.removeAll();
            this.errorTestCasesTable.removeAll();
            this.failTestCasesTable.removeAll();
            this.testCasesTable.removeAll();
            int noOfPass = 0;
            int noOfFail = 0;
            int noOfInconc = 0;
            int noOfNone = 0;
            int noOfError = 0;
            int noOfCrash = 0;
            if (tmpTestCases == null) continue;
            int noTotal = tmpTestCases.size();
            for (TestCase tc : tmpTestCases) {
                Image image;
                TableItem tcItem = new TableItem(this.testCasesTable, 2048);
                LogRecord record = this.getLogRecordAtRow(tc.getStartRecordNumber());
                String start = record.getTimestamp();
                record = this.getLogRecordAtRow(tc.getEndRecordNumber());
                String stop = record.getTimestamp();
                switch (tc.getVerdict()) {
                    case 0: {
                        image = Activator.getDefault().getIcon("icons/testpass.gif");
                        ++noOfPass;
                        break;
                    }
                    case 4: {
                        image = Activator.getDefault().getIcon("icons/testerr.gif");
                        TableItem tcErrorItem = new TableItem(this.errorTestCasesTable, 2048);
                        tcErrorItem.setImage(1, image);
                        tcErrorItem.setText(2, tc.getTestCaseName());
                        tcErrorItem.setText(3, start);
                        tcErrorItem.setText(4, stop);
                        tcErrorItem.setData((Object)tc);
                        ++noOfError;
                        break;
                    }
                    case 3: {
                        image = Activator.getDefault().getIcon("icons/testfail.gif");
                        TableItem tcFailItem = new TableItem(this.failTestCasesTable, 2048);
                        tcFailItem.setImage(1, image);
                        tcFailItem.setText(2, tc.getTestCaseName());
                        tcFailItem.setText(3, start);
                        tcFailItem.setText(4, stop);
                        tcFailItem.setData((Object)tc);
                        ++noOfFail;
                        break;
                    }
                    case 2: {
                        image = Activator.getDefault().getIcon("icons/testincon.gif");
                        ++noOfInconc;
                        break;
                    }
                    case 1: {
                        image = Activator.getDefault().getIcon("icons/testnone.gif");
                        ++noOfNone;
                        break;
                    }
                    case 5: {
                        image = Activator.getDefault().getIcon("icons/crashed.gif");
                        ++noOfCrash;
                        break;
                    }
                    default: {
                        image = null;
                    }
                }
                tcItem.setImage(1, image);
                tcItem.setText(2, tc.getTestCaseName());
                tcItem.setText(3, start);
                tcItem.setText(4, stop);
                tcItem.setData((Object)tc);
            }
            if (this.errorTestCasesTable.getItems().length < 1) {
                this.errorTestCasesTable.setLinesVisible(false);
            } else {
                this.errorTestCasesTable.redraw();
                this.ecError.setExpanded(true);
            }
            if (this.failTestCasesTable.getItems().length < 1) {
                this.failTestCasesTable.setLinesVisible(false);
            } else {
                this.failTestCasesTable.redraw();
                this.ecFail.setExpanded(true);
            }
            if (this.testCasesTable.getItems().length < 1) {
                this.testCasesTable.setLinesVisible(false);
            } else {
                this.testCasesTable.redraw();
                this.ecTestCases.setExpanded(true);
            }
            TableItem item = new TableItem(this.amountTable, 2048);
            item.setText(0, String.valueOf(noTotal));
            item.setText(1, String.valueOf(noOfPass + this.getPercent(noOfPass, noTotal)));
            item.setText(2, String.valueOf(noOfFail + this.getPercent(noOfFail, noTotal)));
            item.setText(3, String.valueOf(noOfInconc + this.getPercent(noOfInconc, noTotal)));
            item.setText(4, String.valueOf(noOfNone + this.getPercent(noOfNone, noTotal)));
            item.setText(5, String.valueOf(noOfError + this.getPercent(noOfError, noTotal)));
            item.setText(6, String.valueOf(noOfCrash + this.getPercent(noOfCrash, noTotal)));
        }
        if (statisticalDataVector.size() > 1) {
            this.setPartName("Statistics");
            this.setContentDescription("");
        } else if (this.logFileMetaData != null) {
            File file = new File(this.logFileMetaData.getFilePath());
            String fileName = file.getName();
            this.setPartName(fileName);
            this.setContentDescription(this.logFileMetaData.getProjectRelativePath());
        }
        this.form.reflow(true);
        this.form.setRedraw(true);
    }

    public void dispose() {
        IOUtils.closeQuietly((Closeable)this.reader);
        this.toolkit.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StatisticalData> restoreState() {
        if (this.memento == null) {
            return new ArrayList<StatisticalData>();
        }
        this.memento = this.memento.getChild("selection");
        if (this.memento == null) {
            return new ArrayList<StatisticalData>();
        }
        ArrayList<StatisticalData> tmpStatisticalDataVector = new ArrayList<StatisticalData>();
        try {
            IMemento[] viewAttributes;
            for (IMemento viewAttribute : viewAttributes = this.memento.getChildren("viewAttributes")) {
                String projectName = viewAttribute.getString("projectName");
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null || !project.exists() || !project.isOpen()) {
                    ArrayList<StatisticalData> arrayList = new ArrayList<StatisticalData>();
                    return arrayList;
                }
                String propertyFilePath = viewAttribute.getString("propertyFile");
                if (propertyFilePath == null) {
                    ArrayList<StatisticalData> arrayList = new ArrayList<StatisticalData>();
                    return arrayList;
                }
                File propertyFile = new File(propertyFilePath);
                if (!propertyFile.exists()) {
                    ArrayList<StatisticalData> arrayList = new ArrayList<StatisticalData>();
                    return arrayList;
                }
                LogFileMetaData tmpLogFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
                Path path = new Path(tmpLogFileMetaData.getProjectRelativePath());
                IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (logFile == null || !logFile.exists() || !logFile.getProject().getName().equals(project.getName())) {
                    ArrayList<StatisticalData> arrayList = new ArrayList<StatisticalData>();
                    return arrayList;
                }
                File file = logFile.getLocation().toFile();
                String fileSizeString = viewAttribute.getString("fileSize");
                long fileSize = 0L;
                if (fileSizeString != null) {
                    fileSize = Long.parseLong(fileSizeString);
                }
                String fileModificationString = viewAttribute.getString("fileModification");
                long fileModification = 0L;
                if (fileModificationString != null) {
                    fileModification = Long.valueOf(fileModificationString);
                }
                if (file.lastModified() != fileModification || file.length() != fileSize || LogFileCacheHandler.hasLogFileChanged(logFile)) {
                    ArrayList<StatisticalData> arrayList = new ArrayList<StatisticalData>();
                    return arrayList;
                }
                this.reader = new CachedLogReader(LogFileReader.getReaderForLogFile(logFile));
                TestCaseExtractor extractor = new TestCaseExtractor();
                extractor.extractTestCasesFromIndexedLogFile(logFile);
                StatisticalData statisticalData = new StatisticalData(tmpLogFileMetaData, extractor.getTestCases(), this.reader);
                tmpStatisticalDataVector.add(statisticalData);
            }
            ArrayList<StatisticalData> arrayList = tmpStatisticalDataVector;
            return arrayList;
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        finally {
            this.memento = null;
        }
        return new ArrayList<StatisticalData>();
    }

    public void setLogFileMetaData(LogFileMetaData logFileMetaData) {
        this.logFileMetaData = logFileMetaData;
    }

    private String getPercent(int noOf, int noTotal) {
        int result = 0;
        if (noTotal > 0) {
            float percent = (float)noOf / (float)noTotal * 100.0f;
            result = Math.round(percent);
        }
        if (result > 0) {
            return Messages.getString("StatisticalView.23") + String.valueOf(result) + Messages.getString("StatisticalView.24");
        }
        return Messages.getString("StatisticalView.25");
    }

    private LogRecord getLogRecordAtRow(int row) {
        LogRecord logRecord = null;
        try {
            logRecord = this.reader.getRecord(row);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.6") + e.getMessage()));
        }
        catch (ParseException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.7") + e.getMessage()));
        }
        return logRecord;
    }

    private void createStatisticalViewContextMenuActions() {
        this.openMSCViewAction = new OpenMSCViewAction();
        this.openMSCViewAction.setEnabled(false);
        this.openMSCViewAction.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/msc.gif"));
        this.addSelectionChangedListener(this.openMSCViewAction);
        this.openTextTableStatisticalViewMenuAction = new OpenTextTableStatisticalViewMenuAction(this);
        this.openTextTableStatisticalViewMenuAction.setEnabled(false);
        this.openTextTableStatisticalViewMenuAction.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/table_view.gif"));
    }

    private Menu hookStatisticalViewTableContextMenu(Control control) {
        ProjectsViewerMenuManager menuMgr = new ProjectsViewerMenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new ProjectsViewerMenuListener(){

            @Override
            public void menuAboutToShow(IMenuManager menuManager) {
                StatisticalView.this.fillStatisticalViewContextMenu(menuManager);
            }
        });
        return menuMgr.createContextMenu(control);
    }

    protected void fillStatisticalViewContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IAction)this.openMSCViewAction);
        menuManager.add((IAction)this.openTextTableStatisticalViewMenuAction);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.registeredListeners.contains(listener)) {
            this.registeredListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.eventSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.registeredListeners.contains(listener)) {
            this.registeredListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.eventSelection = selection;
    }

    private void fireSelectionChangeEvent() {
        for (ISelectionChangedListener listener : this.registeredListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection((Object)this.testcaseSelection)));
        }
    }

    private void createToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager mgr = actionBars.getToolBarManager();
        Action closeAllAction = new Action(){

            public void run() {
                IViewReference[] viewReferences;
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                for (IViewReference reference : viewReferences = activePage.getViewReferences()) {
                    IViewPart view = reference.getView(false);
                    if (view == null) {
                        activePage.hideView(reference);
                        continue;
                    }
                    if (!(view instanceof StatisticalView)) continue;
                    activePage.hideView(reference);
                }
            }
        };
        closeAllAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon("icons/delete.gif")));
        closeAllAction.setId(Messages.getString("StatisticalView.27"));
        closeAllAction.setToolTipText(Messages.getString("StatisticalView.26"));
        closeAllAction.setEnabled(true);
        mgr.add((IAction)closeAllAction);
        actionBars.updateActionBars();
    }

    public void createPartControl(Composite parent) {
        List<StatisticalData> statisticalData = this.restoreState();
        this.createToolbar();
        this.createStatisticalViewContextMenuActions();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText("Statistics");
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        layout.numColumns = 2;
        this.toolkit.paintBordersFor(this.form.getBody());
        if (statisticalData != null) {
            this.setData(statisticalData);
        }
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private Section createSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(128);
        td.colspan = 2;
        section.setLayoutData((Object)td);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                StatisticalView.this.form.reflow(true);
            }
        });
        File file = new File(this.logFileMetaData.getFilePath());
        Date date = new Date(file.lastModified());
        section.setText(file.getName());
        section.setData((Object)this.logFileMetaData.getProjectRelativePath());
        section.setDescription(this.logFileMetaData.getProjectRelativePath() + " " + date.toString());
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout());
        this.createAmountTable(sectionClient);
        this.ecError = this.toolkit.createExpandableComposite(sectionClient, 20);
        this.ecError.setText("Error test cases");
        this.errorTestCasesTable = this.createTestCaseTable((Composite)this.ecError);
        this.ecError.setClient((Control)this.errorTestCasesTable);
        this.ecError.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                StatisticalView.this.form.reflow(true);
            }
        });
        this.ecFail = this.toolkit.createExpandableComposite(sectionClient, 20);
        this.ecFail.setText("Fail test cases");
        this.failTestCasesTable = this.createTestCaseTable((Composite)this.ecFail);
        this.ecFail.setClient((Control)this.failTestCasesTable);
        this.ecFail.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                StatisticalView.this.form.reflow(true);
            }
        });
        this.ecTestCases = this.toolkit.createExpandableComposite(sectionClient, 20);
        this.ecTestCases.setText("Test cases");
        this.testCasesTable = this.createTestCaseTable((Composite)this.ecTestCases);
        this.ecTestCases.setClient((Control)this.testCasesTable);
        this.ecTestCases.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                StatisticalView.this.form.reflow(true);
            }
        });
        section.setClient((Control)sectionClient);
        this.cachedSections.put(this.logFileMetaData.getProjectRelativePath(), section);
        return section;
    }

    private Table createAmountTable(Composite composite) {
        this.amountTable = this.toolkit.createTable(composite, 0);
        this.amountTable.setBackgroundMode(1);
        this.amountTable.setHeaderVisible(true);
        this.amountTable.setLinesVisible(true);
        this.createAmountColumn(Messages.getString("StatisticalView.1"));
        this.createAmountColumn(Messages.getString("StatisticalView.2"));
        this.createAmountColumn(Messages.getString("StatisticalView.3"));
        this.createAmountColumn(Messages.getString("StatisticalView.4"));
        this.createAmountColumn(Messages.getString("StatisticalView.5"));
        this.createAmountColumn(Messages.getString("StatisticalView.6"));
        this.createAmountColumn(Messages.getString("StatisticalView.7"));
        return this.amountTable;
    }

    private void createAmountColumn(String title) {
        TableColumn column = new TableColumn(this.amountTable, 2048);
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        column.setWidth(75);
    }

    private Table createTestCaseTable(Composite composite) {
        Table testCasesTable = this.toolkit.createTable(composite, 0x10010300);
        testCasesTable.setHeaderVisible(true);
        testCasesTable.setLinesVisible(true);
        testCasesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Table) {
                    Table table = (Table)e.getSource();
                    TableItem tableItem = table.getItem(table.getSelectionIndex());
                    Object data = tableItem.getData();
                    if (data instanceof TestCase) {
                        StatisticalView.this.testcaseSelection = (TestCase)data;
                    } else {
                        StatisticalView.this.testcaseSelection = null;
                    }
                    StatisticalView.this.fireSelectionChangeEvent();
                }
            }
        });
        testCasesTable.setMenu(this.hookStatisticalViewTableContextMenu((Control)testCasesTable));
        new TableColumn(testCasesTable, 2048);
        this.createTestCasesColumn(testCasesTable, Messages.getString("StatisticalView.9"), 55);
        this.createTestCasesColumn(testCasesTable, Messages.getString("StatisticalView.10"), 275);
        this.createTestCasesColumn(testCasesTable, Messages.getString("StatisticalView.11"), 220);
        this.createTestCasesColumn(testCasesTable, Messages.getString("StatisticalView.12"), 220);
        testCasesTable.redraw();
        return testCasesTable;
    }

    private void createTestCasesColumn(Table testCasesTable, String title, int width) {
        TableColumn column = new TableColumn(testCasesTable, 2048);
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        column.setWidth(width);
    }

    @Override
    public LogFileMetaData getLogFileMetaData() {
        return this.logFileMetaData;
    }

    @Override
    public String getName() {
        return "Statistical View";
    }
}

