/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.executormonitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.executor.executors.ITreeBranch;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeLeaf;
import org.eclipse.titan.executor.views.executormonitor.InformationElement;

public final class ComponentElement
extends TreeLeaf
implements ITreeBranch {
    private InformationElement referenceInfo;
    private InformationElement typeInfo;
    private InformationElement stateInfo;
    private InformationElement executedInfo;
    private InformationElement localVerdictInfo;

    public ComponentElement(String name) {
        super(name);
    }

    public ComponentElement(String name, InformationElement referenceInfo) {
        super(name);
        this.referenceInfo = referenceInfo;
        referenceInfo.parent(this);
    }

    public void setTypeInfo(InformationElement typeInfo) {
        this.typeInfo = typeInfo;
        typeInfo.parent(this);
    }

    public void setStateInfo(InformationElement stateInfo) {
        this.stateInfo = stateInfo;
        stateInfo.parent(this);
    }

    public void setExecutedInfo(InformationElement executedInfo) {
        this.executedInfo = executedInfo;
        executedInfo.parent(this);
    }

    public void setLocalVerdictInfo(InformationElement localVerdictInfo) {
        this.localVerdictInfo = localVerdictInfo;
        localVerdictInfo.parent(this);
    }

    @Override
    public List<ITreeLeaf> children() {
        ArrayList<ITreeLeaf> result = new ArrayList<ITreeLeaf>();
        if (null != this.referenceInfo) {
            result.add(this.referenceInfo);
        }
        if (null != this.typeInfo) {
            result.add(this.typeInfo);
        }
        if (null != this.stateInfo) {
            result.add(this.stateInfo);
        }
        if (null != this.executedInfo) {
            result.add(this.executedInfo);
        }
        if (null != this.localVerdictInfo) {
            result.add(this.localVerdictInfo);
        }
        return result;
    }

    public boolean isSame(ComponentElement other) {
        if (null != this.referenceInfo && null != other.referenceInfo && this.referenceInfo.name().equals(other.referenceInfo.name())) {
            return true;
        }
        return null != this.name() && null != other.name() && this.name().equals(other.name());
    }

    public void transferData(ComponentElement other) {
        this.referenceInfo = other.referenceInfo;
        if (null != this.referenceInfo) {
            this.referenceInfo.parent(this);
        }
        this.typeInfo = other.typeInfo;
        if (null != this.typeInfo) {
            this.typeInfo.parent(this);
        }
        this.stateInfo = other.stateInfo;
        if (null != this.stateInfo) {
            this.stateInfo.parent(this);
        }
        this.executedInfo = other.executedInfo;
        if (null != this.executedInfo) {
            this.executedInfo.parent(this);
        }
        this.localVerdictInfo = other.localVerdictInfo;
        if (null != this.localVerdictInfo) {
            this.localVerdictInfo.parent(this);
        }
    }
}

