/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.export;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.markers.export.BaseProblemExporter;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.markers.types.TaskType;
import org.eclipse.titanium.markers.utils.AnalyzerCache;

public class CsvProblemExporter
extends BaseProblemExporter {
    protected static final String SEPARATOR = ";";

    public CsvProblemExporter(IProject proj) {
        super(proj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportMarkers(IProgressMonitor monitor, String filenamePrefix, Date date) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        PrintWriter summaryFile = new PrintWriter(new FileWriter(filenamePrefix + "_summary.csv"));
        PrintWriter timesFile = new PrintWriter(new FileWriter(filenamePrefix + "_times.csv"));
        try {
            summaryFile.println("Smell name;Amount");
            timesFile.println("Smell name;Minimal repair time;Average repair time;Maximal repair time");
            PrintWriter actualSmellFile = null;
            Map<TaskType, List<IMarker>> markers = this.collectMarkers();
            for (TaskType actSmell : TaskType.values()) {
                int row = 0;
                if (!markers.get(actSmell).isEmpty()) {
                    actualSmellFile = new PrintWriter(new FileWriter(filenamePrefix + "_" + actSmell.getHumanReadableName() + ".csv"));
                    actualSmellFile.println("Message;Smell name;Line number");
                    for (IMarker m : markers.get(actSmell)) {
                        actualSmellFile.println(m.getAttribute("message").toString() + SEPARATOR + m.getResource().getName() + SEPARATOR + m.getAttribute("lineNumber"));
                        ++row;
                    }
                    actualSmellFile.close();
                    actualSmellFile = null;
                }
                summaryFile.println(actSmell.getHumanReadableName() + SEPARATOR + row);
                timesFile.println(actSmell.getHumanReadableName() + SEPARATOR + (double)row * actSmell.getMinRepairTime() + SEPARATOR + (double)row * actSmell.getAvgRepairTime() + SEPARATOR + (double)row * actSmell.getMaxRepairTime());
            }
            progress.worked(20);
            MarkerHandler mh = AnalyzerCache.withAll().analyzeProject((IProgressMonitor)progress.newChild(30), this.project);
            progress.setWorkRemaining(CodeSmellType.values().length);
            for (CodeSmellType actSmell : CodeSmellType.values()) {
                int row = 0;
                if (!mh.get(actSmell).isEmpty()) {
                    actualSmellFile = new PrintWriter(new FileWriter(filenamePrefix + "_" + actSmell.name() + ".csv"));
                    actualSmellFile.println("Description; Resurce; Location");
                    for (Marker m : mh.get(actSmell)) {
                        if (m.getLine() == -1 || m.getResource() == null) continue;
                        actualSmellFile.println(m.getMessage() + SEPARATOR + m.getResource().getName() + SEPARATOR + m.getLine());
                        ++row;
                    }
                    actualSmellFile.close();
                    actualSmellFile = null;
                }
                summaryFile.println(actSmell.getHumanReadableName() + SEPARATOR + row + SEPARATOR + (double)row * actSmell.getMinRepairTime() + SEPARATOR + (double)row * actSmell.getAvgRepairTime() + SEPARATOR + (double)row * actSmell.getMaxRepairTime());
                timesFile.println(actSmell.getHumanReadableName() + SEPARATOR + (double)row * actSmell.getMinRepairTime() + SEPARATOR + (double)row * actSmell.getAvgRepairTime() + SEPARATOR + (double)row * actSmell.getMaxRepairTime());
                progress.worked(1);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while exporting to csv", (Throwable)e);
        }
        finally {
            summaryFile.close();
            timesFile.close();
        }
    }
}

