/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clauses;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class LogicInversion
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "Negation is not necessary in this condition";

    public LogicInversion() {
        super(CodeSmellType.LOGIC_INVERSION);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (node instanceof If_Statement) {
            If_Statement s = (If_Statement)node;
            if (s.getStatementBlock() == null) {
                return;
            }
            If_Clauses ifClauses = s.getIfClauses();
            if (ifClauses == null) {
                return;
            }
            List clauses = ifClauses.getClauses();
            if (clauses.size() != 1) {
                return;
            }
            Value expression = ((If_Clause)clauses.get(0)).getExpression();
            if (expression != null && IValue.Value_type.EXPRESSION_VALUE.equals((Object)expression.getValuetype()) && Expression_Value.Operation_type.NOT_OPERATION.equals((Object)((Expression_Value)expression).getOperationType())) {
                problems.report(s.getLocation(), ERROR_MESSAGE);
            }
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(If_Statement.class);
        return ret;
    }
}

