/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Value_Assignment
extends ASN1Assignment {
    private static final String UNKNOWNASSIGNMENT = "unknown value assignment";
    private final IASN1Type type;
    private final Value value;

    public Value_Assignment(Identifier id, Ass_pard assPard, IASN1Type type, Value value) {
        super(id, assPard);
        this.type = type;
        this.value = value;
        if (null != type) {
            type.setOwnertype(IType.TypeOwner_type.OT_VAR_ASS, this);
            type.setFullNameParent(this);
        }
        if (null != value) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_CONST;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(".<type>");
        }
        if (this.value == child) {
            return builder;
        }
        return builder;
    }

    @Override
    protected ASN1Assignment internalNewInstance(Identifier identifier) {
        return new Value_Assignment(identifier, null, this.type.newInstance(), this.value);
    }

    @Override
    public void setRightScope(Scope rightScope) {
        if (null != this.value) {
            this.value.setMyScope(rightScope);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.type) {
            this.type.setMyScope(scope);
        }
        if (null != this.value) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public IType getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    public IValue getValue() {
        if (null != this.assPard) {
            this.location.reportSemanticError(MessageFormat.format("`{0}'' is a parameterized value assignment", this.getFullName()));
            this.isErroneous = true;
            return null;
        }
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.value;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            return;
        }
        this.checkTTCNIdentifier();
        if (null == this.type) {
            return;
        }
        this.type.setGenName("_T_", this.getGenName());
        this.type.check(timestamp);
        if (null == this.value) {
            return;
        }
        this.value.setMyGovernor(this.type);
        IValue tempValue = this.type.checkThisValueRef(timestamp, this.value);
        this.type.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, true, false));
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        tempValue.checkRecursions(timestamp, chain);
        chain.release();
        this.value.setGenNameRecursive(this.getGenName());
        this.value.setCodeSection(GovernedSimple.CodeSectionType.CS_PRE_INIT);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() >= index + 1 && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && null != this.type) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this.identifier.getDisplayName(), this.identifier.getLocation(), this);
            }
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            String proposalKind = UNKNOWNASSIGNMENT;
            propCollector.addProposal(this.identifier, " - unknown value assignment", ImageCache.getImage(this.getOutlineIcon()), UNKNOWNASSIGNMENT);
        } else if (subrefs.size() > index + 1 && null != this.type && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public String getAssignmentName() {
        return "value";
    }

    @Override
    public String getOutlineIcon() {
        return "constant.gif";
    }

    @Override
    public Location getLikelyLocation() {
        if (this.value != null) {
            return Location.interval(super.getLikelyLocation(), this.value.getLocation());
        }
        return super.getLikelyLocation();
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.assPard != null) {
            return true;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.value == null || this.value.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        if (null != this.assPard || this.dontGenerate) {
            return;
        }
        if (this.value == null) {
            return;
        }
        String genName = this.getGenName();
        this.value.setGenNameRecursive(genName);
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        String typeGeneratedName = this.type.getGenNameValue(aData, source);
        if (this.value.canGenerateSingleExpression()) {
            if (this.value.returnsNative()) {
                source.append(MessageFormat.format("\tpublic static final {0} {1} = new {0}({2});\n", typeGeneratedName, genName, this.value.generateSingleExpression(aData)));
            } else {
                source.append(MessageFormat.format("\tpublic static final {0} {1} = {2};\n", typeGeneratedName, genName, this.value.generateSingleExpression(aData)));
            }
        } else {
            source.append(MessageFormat.format("\tpublic static final {0} {1} = new {0}();\n", typeGeneratedName, genName));
            this.value.generateCodeInit(aData, aData.getPreInit(), genName);
        }
        sb.append((CharSequence)source);
    }
}

