/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class Definitions
extends Assignments
implements ILocateableNode {
    private final List<Definition> definitions = new CopyOnWriteArrayList<Definition>();
    private Location location;
    private HashMap<String, Definition> definitionMap;
    private List<Definition> doubleDefinitions;
    private CompilationTimeStamp lastCompilationTimeStamp;
    private CompilationTimeStamp lastUniquenessCheckTimeStamp;
    private final List<Group> groups = new ArrayList<Group>();

    public Definitions() {
        this.scopeName = "definitions";
        this.location = NULL_Location.INSTANCE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (Definition definition : this.definitions) {
            if (definition != child) continue;
            Identifier identifier = definition.getIdentifier();
            return builder.append(".").append(identifier.getDisplayName());
        }
        for (Group group : this.groups) {
            if (group != child) continue;
            Identifier identifier = group.getIdentifier();
            return builder.append(".").append(identifier.getDisplayName());
        }
        return builder;
    }

    @Override
    public int getNofAssignments() {
        return this.definitions.size();
    }

    @Override
    public Definition getAssignmentByIndex(int i) {
        return this.definitions.get(i);
    }

    public CompilationTimeStamp getLastCompilationTimeStamp() {
        return this.lastCompilationTimeStamp;
    }

    protected void removeGroups() {
    }

    @Override
    public Object[] getOutlineChildren() {
        ArrayList<ASTNode> outlineDefinitions = new ArrayList<ASTNode>();
        outlineDefinitions.addAll(this.definitions);
        outlineDefinitions.addAll(this.groups);
        Collections.sort(outlineDefinitions, new Comparator<IOutlineElement>(){

            @Override
            public int compare(IOutlineElement o1, IOutlineElement o2) {
                Location l1 = o1.getIdentifier().getLocation();
                Location l2 = o2.getIdentifier().getLocation();
                if (l1.getOffset() < l2.getOffset()) {
                    return -1;
                }
                if (l1.getOffset() > l2.getOffset()) {
                    return 1;
                }
                return 0;
            }
        });
        return outlineDefinitions.toArray();
    }

    @Override
    public String getOutlineIcon() {
        return "ttcn.gif";
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public synchronized void addDefinitions(List<Definition> definitionList) {
        this.lastUniquenessCheckTimeStamp = null;
        if (definitionList != null) {
            ArrayList<Definition> safeToAdd = new ArrayList<Definition>(definitionList.size());
            for (Definition definition : definitionList) {
                if (definition == null || definition.getIdentifier() == null || definition.getIdentifier().getLocation() == null) continue;
                definition.setMyScope(this);
                safeToAdd.add(definition);
                definition.setFullNameParent(this);
            }
            this.definitions.addAll(safeToAdd);
        }
    }

    public void addGroup(Group group) {
        if (group != null && group.getIdentifier() != null && group.getIdentifier().getLocation() != null) {
            group.setMyScope(this);
            this.groups.add(group);
            group.setFullNameParent(this);
        }
    }

    protected void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheckTimeStamp != null && !this.lastUniquenessCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.createDefinitionMap(timestamp);
        this.reportDoubleDefinitions();
        this.checkSimilarTypeNames();
    }

    private void createDefinitionMap(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheckTimeStamp != null && !this.lastUniquenessCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastUniquenessCheckTimeStamp = timestamp;
        if (this.doubleDefinitions != null) {
            this.doubleDefinitions.clear();
        }
        this.definitionMap = new HashMap(this.definitions.size());
        for (Definition definition : this.definitions) {
            String definitionName = definition.getIdentifier().getName();
            if (this.definitionMap.containsKey(definitionName)) {
                if (this.doubleDefinitions == null) {
                    this.doubleDefinitions = new ArrayList<Definition>();
                }
                this.doubleDefinitions.add(definition);
                continue;
            }
            this.definitionMap.put(definitionName, definition);
        }
    }

    private void reportDoubleDefinitions() {
        if (this.doubleDefinitions != null && !this.doubleDefinitions.isEmpty()) {
            for (Definition definition : this.doubleDefinitions) {
                Identifier identifier = definition.getIdentifier();
                String definitionName = identifier.getName();
                try {
                    Location otherLocation = this.definitionMap.get(definitionName).getIdentifier().getLocation();
                    otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                    identifier.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
                }
                catch (NullPointerException e) {
                    ErrorReporter.logError((String)("Nullpointer was detected when reporting duplication error for definition: " + definitionName));
                    throw e;
                }
            }
        }
    }

    private void checkSimilarTypeNames() {
        HashMap<String, Def_Type> similarityMap = new HashMap<String, Def_Type>(this.definitions.size());
        for (Definition definition : this.definitions) {
            if (!(definition instanceof Def_Type)) continue;
            ((Def_Type)definition).setHasSimilarName(false);
        }
        for (Definition definition : this.definitions) {
            if (!(definition instanceof Def_Type)) continue;
            String definitionName = definition.getIdentifier().getName();
            String lowerCaseName = definitionName.toLowerCase(Locale.ENGLISH);
            if (similarityMap.containsKey(lowerCaseName)) {
                Def_Type similarDef = (Def_Type)similarityMap.get(lowerCaseName);
                similarDef.setHasSimilarName(true);
                ((Def_Type)definition).setHasSimilarName(true);
            } else {
                similarityMap.put(lowerCaseName, (Def_Type)definition);
            }
            if (!"anytype".equals(lowerCaseName)) continue;
            ((Def_Type)definition).setHasSimilarName(true);
        }
    }

    private void checkGroups(CompilationTimeStamp timestamp) {
        if (this.groups.isEmpty()) {
            return;
        }
        HashMap<String, Group> groupMap = new HashMap<String, Group>(this.groups.size());
        HashMap<String, Definition> defs = new HashMap<String, Definition>(this.definitions.size());
        for (Definition definition : this.definitions) {
            String defName;
            if (definition.getParentGroup() != null || defs.containsKey(defName = definition.getIdentifier().getName())) continue;
            defs.put(defName, definition);
        }
        for (Group group : this.groups) {
            if (group == null) continue;
            String groupName = group.getIdentifier().getName();
            if (defs.containsKey(groupName)) {
                group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Group name `{0}'' clashes with a definition", groupName));
                ((Definition)defs.get(groupName)).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Definition of `{0}'' is here", groupName));
            }
            if (groupMap.containsKey(groupName)) {
                ((Group)groupMap.get(groupName)).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate group definition with name `{0}'' was first defined here", groupName));
                group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Duplicate group definition with name `{0}'' was defined here again", groupName));
                continue;
            }
            groupMap.put(groupName, group);
        }
        for (Group temp : this.groups) {
            temp.check(timestamp);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        Module module = this.getModuleScope();
        if (module != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        int maxEndOffset = this.getLocation().getOffset();
        int lastEndOffset = 0;
        for (Definition definition : this.definitions) {
            if (definition.getLastTimeChecked() == null || definition.getLastTimeChecked().isLess(timestamp)) {
                MarkerHandler.markAllSemanticMarkersForRemoval(definition);
            }
            if ((lastEndOffset = definition.getLocation().getEndOffset()) <= maxEndOffset) continue;
            maxEndOffset = lastEndOffset;
        }
        for (Group group : this.groups) {
            group.markMarkersForRemoval(timestamp);
        }
        int defsEndOffset = this.getLocation().getEndOffset();
        if (maxEndOffset < defsEndOffset) {
            Location loc = new Location(this.getLocation().getFile(), 0, maxEndOffset, defsEndOffset);
            MarkerHandler.markAllSemanticMarkersForRemoval(loc);
        }
        this.checkUniqueness(timestamp);
        this.checkGroups(timestamp);
        for (Definition definition : this.definitions) {
            definition.check(timestamp);
        }
        this.reportDoubleDefinitions();
    }

    public void checkWithDefinitions(CompilationTimeStamp timestamp, List<Assignment> assignments) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        if (this.lastCompilationTimeStamp == null) {
            this.check(timestamp);
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        for (Assignment assignment : assignments) {
            if (assignment.getLastTimeChecked() != null && !assignment.getLastTimeChecked().isLess(timestamp)) continue;
            MarkerHandler.markAllSemanticMarkersForRemoval(assignment);
        }
        int maxEndOffset = this.getLocation().getOffset();
        int lastEndOffset = 0;
        for (Definition definition : this.definitions) {
            lastEndOffset = definition.getLocation().getEndOffset();
            if (lastEndOffset <= maxEndOffset) continue;
            maxEndOffset = lastEndOffset;
        }
        for (Group group : this.groups) {
            group.markMarkersForRemoval(timestamp);
        }
        int defsEndOffset = this.getLocation().getEndOffset();
        if (maxEndOffset < defsEndOffset) {
            Location loc = new Location(this.getLocation().getFile(), 0, maxEndOffset, defsEndOffset);
            MarkerHandler.markAllSemanticMarkersForRemoval(loc);
        }
        this.checkUniqueness(timestamp);
        this.checkGroups(timestamp);
        for (Assignment assignmentFrom : assignments) {
            assignmentFrom.check(timestamp);
            LoadBalancingUtilities.astNodeChecked();
        }
        this.reportDoubleDefinitions();
    }

    @Override
    public void postCheck() {
        Module module = this.getModuleScope();
        if (module != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        for (Definition temp : this.definitions) {
            temp.postCheck();
        }
        for (Group group : this.groups) {
            group.postCheck();
        }
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        Definition result;
        if (reference.getModuleIdentifier() != null) {
            return this.getModuleScope().getAssBySRef(timestamp, reference);
        }
        Identifier identifier = reference.getId();
        if (identifier == null) {
            return this.getModuleScope().getAssBySRef(timestamp, reference);
        }
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.createDefinitionMap(timestamp);
        }
        if ((result = this.definitionMap.get(identifier.getName())) != null) {
            return result;
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    @Override
    public Definition getLocalAssignmentByID(CompilationTimeStamp timestamp, Identifier id) {
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        return this.definitionMap.get(id.getName());
    }

    @Override
    public boolean hasLocalAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        return this.definitionMap.containsKey(identifier.getName());
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        if (propCollector.getReference().getModuleIdentifier() == null) {
            for (Definition temp : this.definitions) {
                temp.addProposal(propCollector, 0);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.MODULE_LEVEL_SKELETON_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.MODULE_SCOPE, null, "keyword");
        propCollector.addProposal(TTCN3Keywords.GENERALLY_USABLE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        if (!this.groups.isEmpty()) {
            for (Group item : this.groups) {
                item.addDeclaration(declarationCollector);
            }
        }
        if (declarationCollector.getReference().getModuleIdentifier() == null) {
            for (Definition temp : this.definitions) {
                temp.addDeclaration(declarationCollector, 0);
            }
        }
        super.addDeclaration(declarationCollector);
    }

    public void updateSyntax(TTCN3ReparseUpdater reparser, List<ImportModule> importedModules, List<FriendModule> friendModules, ControlPart controlpart) throws ReParseException {
        boolean tempIsControlPossible;
        Location tempLocation;
        int i;
        Location tempLocation2;
        int i2;
        int result = 0;
        boolean enveloped = false;
        int nofDamaged = 0;
        int leftBoundary = this.location.getOffset();
        int rightBoundary = this.location.getEndOffset();
        int damageOffset = reparser.getDamageStart();
        int damageEndOffset = reparser.getDamageEnd();
        IVisitableNode lastAppendableBeforeChange = null;
        IVisitableNode lastPrependableBeforeChange = null;
        if (controlpart != null) {
            Location tempLocation3 = controlpart.getLocation();
            if (reparser.envelopsDamage(tempLocation3)) {
                enveloped = true;
            } else if (!reparser.isDamaged(tempLocation3)) {
                if (tempLocation3.getEndOffset() < damageOffset && tempLocation3.getEndOffset() > leftBoundary) {
                    leftBoundary = tempLocation3.getEndOffset();
                    lastAppendableBeforeChange = controlpart;
                }
                if (tempLocation3.getOffset() > damageEndOffset && tempLocation3.getOffset() < rightBoundary) {
                    rightBoundary = tempLocation3.getOffset();
                    lastPrependableBeforeChange = controlpart;
                }
            }
        }
        int lastOffset = 0;
        int size = this.groups.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            Group tempGroup = this.groups.get(i2);
            tempLocation2 = tempGroup.getLocation();
            if (reparser.envelopsDamage(tempLocation2)) {
                enveloped = true;
                leftBoundary = tempLocation2.getOffset();
                rightBoundary = tempLocation2.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation2)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation2.getEndOffset() < damageOffset && tempLocation2.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation2.getEndOffset();
                lastAppendableBeforeChange = tempGroup;
            }
            if (tempLocation2.getOffset() > damageEndOffset && tempLocation2.getOffset() < rightBoundary) {
                rightBoundary = tempLocation2.getOffset();
                lastPrependableBeforeChange = tempGroup;
            }
            if (lastOffset >= tempLocation2.getEndOffset()) continue;
            lastOffset = tempLocation2.getEndOffset();
        }
        size = importedModules.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            ImportModule tempImport = importedModules.get(i2);
            if (tempImport.getParentGroup() != null) continue;
            tempLocation2 = tempImport.getLocation();
            if (reparser.envelopsDamage(tempLocation2)) {
                enveloped = true;
                leftBoundary = tempLocation2.getOffset();
                rightBoundary = tempLocation2.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation2)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation2.getEndOffset() < damageOffset && tempLocation2.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation2.getEndOffset();
                lastAppendableBeforeChange = tempImport;
            }
            if (tempLocation2.getOffset() > damageEndOffset && tempLocation2.getOffset() < rightBoundary) {
                rightBoundary = tempLocation2.getOffset();
                lastPrependableBeforeChange = tempImport;
            }
            if (lastOffset >= tempLocation2.getEndOffset()) continue;
            lastOffset = tempLocation2.getEndOffset();
        }
        size = friendModules.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            FriendModule tempFriend = friendModules.get(i2);
            if (tempFriend.getParentGroup() != null) continue;
            tempLocation2 = tempFriend.getLocation();
            if (reparser.envelopsDamage(tempLocation2)) {
                enveloped = true;
                leftBoundary = tempLocation2.getOffset();
                rightBoundary = tempLocation2.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation2)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation2.getEndOffset() < damageOffset && tempLocation2.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation2.getEndOffset();
                lastAppendableBeforeChange = tempFriend;
            }
            if (tempLocation2.getOffset() > damageEndOffset && tempLocation2.getOffset() < rightBoundary) {
                rightBoundary = tempLocation2.getOffset();
                lastPrependableBeforeChange = tempFriend;
            }
            if (lastOffset >= tempLocation2.getEndOffset()) continue;
            lastOffset = tempLocation2.getEndOffset();
        }
        size = this.definitions.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            Location tempCommentLocation;
            Definition temp = this.definitions.get(i2);
            if (temp.getParentGroup() != null) continue;
            tempLocation2 = temp.getLocation();
            Location cumulativeLocation = temp.getCumulativeDefinitionLocation();
            if (temp.hasDocumentComment()) {
                int offset = temp.getDocumentComment().getLocation().getOffset();
                if (tempLocation2.getOffset() > offset) {
                    tempLocation2.setOffset(offset);
                }
                if (cumulativeLocation.getOffset() > offset) {
                    cumulativeLocation.setOffset(offset);
                }
            }
            if (tempLocation2.equals(cumulativeLocation) && reparser.envelopsDamage(cumulativeLocation)) {
                enveloped = true;
                leftBoundary = cumulativeLocation.getOffset();
                rightBoundary = cumulativeLocation.getEndOffset();
            } else if (reparser.isDamaged(cumulativeLocation)) {
                ++nofDamaged;
                if (reparser.getDamageStart() == cumulativeLocation.getEndOffset()) {
                    lastAppendableBeforeChange = temp;
                } else if (reparser.getDamageEnd() == cumulativeLocation.getOffset()) {
                    lastPrependableBeforeChange = temp;
                }
            } else {
                if (cumulativeLocation.getEndOffset() < damageOffset && cumulativeLocation.getEndOffset() > leftBoundary) {
                    leftBoundary = cumulativeLocation.getEndOffset();
                    lastAppendableBeforeChange = temp;
                }
                if (cumulativeLocation.getOffset() > damageEndOffset && cumulativeLocation.getOffset() < rightBoundary) {
                    rightBoundary = cumulativeLocation.getOffset();
                    lastPrependableBeforeChange = temp;
                }
                if (lastOffset < tempLocation2.getEndOffset()) {
                    lastOffset = tempLocation2.getEndOffset();
                }
            }
            if (!temp.hasDocumentComment() || (tempCommentLocation = temp.getDocumentComment().getLocation()) == null || !reparser.isDamaged(tempCommentLocation)) continue;
            ++nofDamaged;
            rightBoundary = tempLocation2.getEndOffset();
        }
        if (!enveloped && reparser.isDamaged(this.location)) {
            List<Integer> temp;
            boolean isBeingExtended;
            if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
                leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (lastPrependableBeforeChange != null && (temp = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp)) {
                rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (nofDamaged != 0) {
                this.removeStuffInRange(reparser, importedModules, friendModules);
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                this.lastCompilationTimeStamp = null;
            }
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        for (i = 0; i < this.groups.size(); ++i) {
            Group temp = this.groups.get(i);
            tempLocation = temp.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp.updateSyntax(reparser, importedModules, this.definitions, friendModules);
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.groups.remove(i);
                    --i;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        for (i = 0; i < importedModules.size(); ++i) {
            ImportModule temp = importedModules.get(i);
            if (temp.getParentGroup() != null || !reparser.isAffected(tempLocation = temp.getLocation())) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                if (!isDamaged) continue;
                ((TTCN3Module)this.parentScope).checkRoot();
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    importedModules.remove(i);
                    --i;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        for (i = 0; i < friendModules.size(); ++i) {
            FriendModule temp = friendModules.get(i);
            if (temp.getParentGroup() != null || !reparser.isAffected(tempLocation = temp.getLocation())) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                if (!isDamaged) continue;
                ((TTCN3Module)this.parentScope).checkRoot();
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    friendModules.remove(i);
                    --i;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        for (Definition temp : this.definitions) {
            if (temp.getParentGroup() != null) continue;
            tempLocation = temp.getLocation();
            Location cumulativeLocation = temp.getCumulativeDefinitionLocation();
            if (!reparser.isAffected(cumulativeLocation)) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp.updateSyntax(reparser, isDamaged);
                if (reparser.getNameChanged()) {
                    if (this.doubleDefinitions != null) {
                        this.doubleDefinitions.clear();
                    }
                    this.lastUniquenessCheckTimeStamp = null;
                    this.lastCompilationTimeStamp = null;
                    reparser.setNameChanged(false);
                }
                if (!isDamaged) continue;
                temp.checkRoot();
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.definitions.remove(temp);
                    reparser.extendDamagedRegion(cumulativeLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        if (result == 1) {
            this.removeStuffInRange(reparser, importedModules, friendModules);
            if (this.doubleDefinitions != null) {
                this.doubleDefinitions.clear();
            }
            this.lastUniquenessCheckTimeStamp = null;
            this.lastCompilationTimeStamp = null;
        }
        for (Group temp : this.groups) {
            tempLocation = temp.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        for (ImportModule temp : importedModules) {
            if (temp.getParentGroup() != null || !reparser.isAffected(tempLocation = temp.getLocation())) continue;
            reparser.updateLocation(tempLocation);
        }
        for (FriendModule temp : friendModules) {
            if (temp.getParentGroup() != null || !reparser.isAffected(tempLocation = temp.getLocation())) continue;
            reparser.updateLocation(tempLocation);
        }
        for (Definition temp : this.definitions) {
            if (temp.getParentGroup() != null) continue;
            tempLocation = temp.getLocation();
            Location cumulativeLocation = temp.getCumulativeDefinitionLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            if (tempLocation != cumulativeLocation) {
                reparser.updateLocation(cumulativeLocation);
            }
            reparser.updateLocation(tempLocation);
        }
        boolean bl = tempIsControlPossible = controlpart == null && lastOffset < leftBoundary;
        if (!enveloped) {
            if (reparser.envelopsDamage(this.location)) {
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
                result = this.reparse(reparser, tempIsControlPossible);
                result = Math.max(result - 1, 0);
                this.lastCompilationTimeStamp = null;
            } else {
                result = Math.max(result, 1);
            }
        }
        if (result != 0) {
            if (this.doubleDefinitions != null) {
                this.doubleDefinitions.clear();
            }
            this.lastUniquenessCheckTimeStamp = null;
            throw new ReParseException(result);
        }
        this.lastUniquenessCheckTimeStamp = null;
    }

    private int reparse(TTCN3ReparseUpdater aReparser, final boolean aTempIsControlPossible) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                ArrayList<Definition> allDefinitions = new ArrayList<Definition>();
                ArrayList<Definition> localDefinitions = new ArrayList<Definition>();
                ArrayList<Group> localGroups = new ArrayList<Group>();
                ArrayList<ImportModule> allImports = new ArrayList<ImportModule>();
                ArrayList<ImportModule> localImports = new ArrayList<ImportModule>();
                ArrayList<FriendModule> allFriends = new ArrayList<FriendModule>();
                ArrayList<FriendModule> localFriends = new ArrayList<FriendModule>();
                ArrayList<ControlPart> controlParts = null;
                if (aTempIsControlPossible) {
                    controlParts = new ArrayList<ControlPart>();
                }
                TTCN3Module module = (TTCN3Module)Definitions.this.parentScope;
                parser.setModule((TTCN3Module)Definitions.this.parentScope);
                Ttcn3Reparser.Pr_reparse_ModuleDefinitionsListContext root = parser.pr_reparse_ModuleDefinitionsList(null, allDefinitions, localDefinitions, localGroups, allImports, localImports, allFriends, localFriends, controlParts);
                ParserUtilities.logParseTree((ParseTree)root, parser);
                if (parser.isErrorListEmpty()) {
                    Definitions.this.addDefinitions(allDefinitions);
                    if (Definitions.this.doubleDefinitions != null) {
                        Definitions.this.doubleDefinitions.clear();
                    }
                    Definitions.this.lastUniquenessCheckTimeStamp = null;
                    for (ImportModule impmod : allImports) {
                        module.addImportedModule(impmod);
                    }
                    for (Group group : localGroups) {
                        Definitions.this.addGroup(group);
                    }
                    module.addFriendModules(allFriends);
                    if (controlParts != null && controlParts.size() == 1) {
                        ((TTCN3Module)Definitions.this.parentScope).addControlpart((ControlPart)controlParts.get(0));
                    }
                }
            }
        });
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser, List<ImportModule> importedModules, List<FriendModule> friendModules) {
        for (int i = this.groups.size() - 1; i >= 0; --i) {
            Group temp = this.groups.get(i);
            if (!reparser.isDamaged(temp.getLocation())) continue;
            reparser.extendDamagedRegion(temp.getLocation());
            this.groups.remove(i);
        }
        ArrayList<ImportModule> importsToBeRemoved = new ArrayList<ImportModule>();
        for (ImportModule importModule : importedModules) {
            if (!reparser.isDamaged(importModule.getLocation())) continue;
            reparser.extendDamagedRegion(importModule.getLocation());
            importsToBeRemoved.add(importModule);
        }
        importedModules.removeAll(importsToBeRemoved);
        ArrayList<FriendModule> frendsToBeRemoved = new ArrayList<FriendModule>();
        for (FriendModule temp : friendModules) {
            if (!reparser.isDamaged(temp.getLocation())) continue;
            reparser.extendDamagedRegion(temp.getLocation());
            frendsToBeRemoved.add(temp);
        }
        friendModules.removeAll(frendsToBeRemoved);
        ArrayList<Definition> arrayList = new ArrayList<Definition>();
        for (Definition temp : this.definitions) {
            if (!reparser.isDamaged(temp.getCumulativeDefinitionLocation())) continue;
            reparser.extendDamagedRegion(temp.getCumulativeDefinitionLocation());
            arrayList.add(temp);
        }
        this.definitions.removeAll(arrayList);
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitions == null) {
            return null;
        }
        for (Definition definition : this.definitions) {
            if (!definition.getLocation().containsOffset(offset)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        ArrayList<Definition> tempList = new ArrayList<Definition>(this.definitions);
        for (Definition definition : tempList) {
            definition.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        for (Definition definition : this.definitions) {
            if (definition.accept(v)) continue;
            return false;
        }
        for (Group g : this.groups) {
            if (g.accept(v)) continue;
            return false;
        }
        return v.leave(this) != 2;
    }

    @Override
    public Iterator<Assignment> iterator() {
        return new Iterator<Assignment>(){
            Iterator<Definition> it;
            {
                this.it = Definitions.this.definitions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Assignment next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setGenName() {
        for (Definition definition : this.definitions) {
            definition.setGenName(definition.getIdentifier().getName());
        }
    }

    public void generateCode(JavaGenData aData) {
        if (this.definitions != null) {
            for (Definition definition : this.definitions) {
                definition.generateCode(aData, false);
            }
        }
    }

    public Map<String, Definition> getDefinitionMap() {
        return this.definitionMap;
    }

    @Override
    public boolean isClassScope() {
        return this.parentScope.isClassScope();
    }
}

