/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportation;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class ImportModule
extends ModuleImportation
implements ILocateableNode,
IAppendableSyntax,
IIncrementallyUpdateable,
IReferencingElement {
    public static final String MISSINGMODULE = "There is no module with name `{0}''";
    private WithAttributesPath withAttributesPath = null;
    private Identifier myModuleIdentifier;
    private TTCN3Module myModule;
    private Group parentGroup = null;
    private Location location;
    private VisibilityModifier visibilityModifier = VisibilityModifier.Private;
    private boolean hasNormalImport = false;
    private boolean hasImportOfImport = false;

    public ImportModule(Identifier identifier) {
        super(identifier);
    }

    public void setHasNormalImports() {
        this.hasNormalImport = true;
    }

    public void setHasImportOfImports() {
        this.hasImportOfImport = true;
    }

    public void setVisibility(VisibilityModifier modifier) {
        this.visibilityModifier = modifier;
    }

    public VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }

    public String getName() {
        return this.identifier != null ? this.identifier.getName() : null;
    }

    @Override
    public String chainedDescription() {
        if (this.myModuleIdentifier != null) {
            return this.myModuleIdentifier.getDisplayName();
        }
        return this.identifier != null ? this.identifier.getDisplayName() : null;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public void setMyModule(Identifier module) {
        this.myModuleIdentifier = module;
    }

    public void setMyModule(TTCN3Module myModule) {
        this.myModule = myModule;
    }

    public TTCN3Module getMyModule() {
        return this.myModule;
    }

    public void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    public Def_Type getAnytype() {
        return this.referredModule == null ? null : this.referredModule.getAnytype();
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
        }
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    @Override
    public void checkImports(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, List<Module> moduleStack) {
        if (this.lastImportCheckTimeStamp != null && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(this.project);
        if (parser == null || this.identifier == null) {
            this.lastImportCheckTimeStamp = timestamp;
            this.referredModule = null;
            return;
        }
        Module temp = this.referredModule;
        this.referredModule = parser.getModuleByName(this.identifier.getName());
        if (temp != this.referredModule) {
            this.setUnhandledChange(true);
        }
        if (this.referredModule == null) {
            this.identifier.getLocation().reportSemanticError(MessageFormat.format(MISSINGMODULE, this.identifier.getDisplayName()));
            this.lastImportCheckTimeStamp = timestamp;
            return;
        }
        moduleStack.add(this.referredModule);
        if (referenceChain.add(this)) {
            if (this.hasImportOfImport) {
                if (this.referredModule instanceof TTCN3Module) {
                    TTCN3Module ttcnmodule = (TTCN3Module)this.referredModule;
                    List<ImportModule> imports = ttcnmodule.getImports();
                    for (ImportModule importation : imports) {
                        referenceChain.markState();
                        importation.checkImports(timestamp, referenceChain, moduleStack);
                        referenceChain.previousState();
                    }
                } else {
                    this.location.reportSemanticError("import of imports can only be used on TTCN-3 modules");
                }
            }
            if (this.hasNormalImport) {
                this.referredModule.checkImports(timestamp, referenceChain, moduleStack);
            }
        }
        moduleStack.remove(moduleStack.size() - 1);
        this.lastImportCheckTimeStamp = timestamp;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.setUnhandledChange(false);
        if (this.lastImportCheckTimeStamp != null && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastImportCheckTimeStamp = timestamp;
        if (this.referredModule != null) {
            this.referredModule.check(timestamp);
        }
        if (this.withAttributesPath != null) {
            MarkerHandler.markAllSemanticMarkersForRemoval(this.withAttributesPath);
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.usedForImportation = false;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            result.add(175);
            return result;
        }
        return null;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>(2);
            result.add(124);
            result.add(126);
            return result;
        }
        return new ArrayList<Integer>(0);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parse();
                this.identifier = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    reparser.extendDamagedRegion(this.withAttributesPath.getLocation());
                    int result = this.reparse(reparser);
                    if (result != 0) {
                        throw new ReParseException();
                    }
                    enveloped = true;
                }
            }
            if (!enveloped) {
                throw new ReParseException(1);
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private int reparse(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_reparser_optionalWithStatementContext root = parser.pr_reparser_optionalWithStatement();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                MultipleWithAttributes attributes = root.attributes;
                Ttcn3Reparser.Pr_EndOfFileContext rootEof = parser.pr_EndOfFile();
                ParserUtilities.logParseTree((ParseTree)rootEof, parser);
                if (parser.isErrorListEmpty()) {
                    ImportModule.this.withAttributesPath.setWithAttributes(attributes);
                    if (attributes != null) {
                        ImportModule.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                    }
                }
            }
        });
    }

    @Override
    public boolean hasImportedAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        Assignments assignments;
        if (this.referredModule == null) {
            return false;
        }
        if (this.hasImportOfImport && this.referredModule instanceof TTCN3Module) {
            TTCN3Module ttcnmodule = (TTCN3Module)this.referredModule;
            List<ImportModule> imports = ttcnmodule.getImports();
            for (ImportModule importation : imports) {
                if (!importation.hasImportedAssignmentWithID(timestamp, identifier)) continue;
                return true;
            }
        }
        return this.hasNormalImport && (assignments = this.referredModule.getAssignments()) != null && assignments.hasLocalAssignmentWithID(timestamp, identifier);
    }

    @Override
    public Assignment importAssignment(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, Identifier moduleId, Reference reference, List<ModuleImportation> usedImports) {
        if (referenceChain.contains(this)) {
            return null;
        }
        if (this.referredModule == null) {
            return null;
        }
        Assignment result = null;
        if (this.hasImportOfImport && this.referredModule instanceof TTCN3Module) {
            TTCN3Module ttcnmodule = (TTCN3Module)this.referredModule;
            Assignment tempResult = null;
            List<ImportModule> imports = ttcnmodule.getImports();
            for (ImportModule importation : imports) {
                ArrayList<ModuleImportation> tempUsedImports = new ArrayList<ModuleImportation>();
                referenceChain.markState();
                if (importation.getVisibilityModifier() == VisibilityModifier.Public) {
                    tempResult = importation.importAssignment(timestamp, referenceChain, moduleId, reference, tempUsedImports);
                } else if (importation.getVisibilityModifier() == VisibilityModifier.Friend && (tempResult = importation.importAssignment(timestamp, referenceChain, moduleId, reference, tempUsedImports)) != null) {
                    tempUsedImports.add(importation);
                }
                referenceChain.previousState();
                if (tempResult == null) continue;
                boolean visible = true;
                for (ModuleImportation usedImportation : tempUsedImports) {
                    ImportModule ttcnImport;
                    if (!(usedImportation instanceof ImportModule) || (ttcnImport = (ImportModule)usedImportation).getMyModule().isVisible(timestamp, this.myModuleIdentifier, ttcnImport)) continue;
                    visible = false;
                }
                if (visible) {
                    usedImports.addAll(tempUsedImports);
                    if (result == null) {
                        result = tempResult;
                    } else if (result != tempResult) {
                        reference.getLocation().reportSemanticError("It is not possible to resolve this reference unambigously, as  it can be resolved to `" + result.getFullName() + "' and to `" + tempResult.getFullName() + "'");
                        return null;
                    }
                }
                tempResult = null;
            }
        }
        if (this.hasNormalImport) {
            result = this.referredModule.importAssignment(timestamp, moduleId, reference);
        }
        if (result != null) {
            usedImports.add(this);
            this.setUsedForImportation();
        }
        return result;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, Identifier targetModuleId) {
        Module savedReferredModule;
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (propCollector.getReference().getModuleIdentifier() == null && subrefs.size() == 1) {
            propCollector.addProposal(this.identifier, ImageCache.getImage(this.getOutlineIcon()), "imported module");
        }
        if ((savedReferredModule = this.referredModule) != null) {
            Assignments assignments = savedReferredModule.getAssignments();
            int size = assignments.getNofAssignments();
            for (int i = 0; i < size; ++i) {
                Assignment temporalAssignment = assignments.getAssignmentByIndex(i);
                if (!savedReferredModule.isVisible(CompilationTimeStamp.getBaseTimestamp(), targetModuleId, temporalAssignment)) continue;
                temporalAssignment.addProposal(propCollector, 0);
            }
            if (savedReferredModule instanceof TTCN3Module) {
                TTCN3Module ttcnmodule = (TTCN3Module)savedReferredModule;
                List<ImportModule> imports = ttcnmodule.getImports();
                for (ImportModule importation : imports) {
                    if (importation.getVisibilityModifier() == VisibilityModifier.Public) {
                        importation.addProposal(propCollector, targetModuleId);
                        continue;
                    }
                    if (importation.getVisibilityModifier() != VisibilityModifier.Friend || !ttcnmodule.isVisible(CompilationTimeStamp.getBaseTimestamp(), targetModuleId, importation)) continue;
                    importation.addProposal(propCollector, targetModuleId);
                }
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, Identifier targetModuleId) {
        Module savedReferredModule = this.referredModule;
        if (savedReferredModule != null) {
            Assignments assignments = savedReferredModule.getAssignments();
            for (int i = 0; i < assignments.getNofAssignments(); ++i) {
                Assignment temporalAssignment = assignments.getAssignmentByIndex(i);
                if (!savedReferredModule.isVisible(CompilationTimeStamp.getBaseTimestamp(), targetModuleId, temporalAssignment)) continue;
                temporalAssignment.addDeclaration(declarationCollector, 0);
            }
            if (savedReferredModule instanceof TTCN3Module) {
                TTCN3Module ttcnmodule = (TTCN3Module)savedReferredModule;
                List<ImportModule> imports = ttcnmodule.getImports();
                for (ImportModule importation : imports) {
                    if (importation.getVisibilityModifier() == VisibilityModifier.Public) {
                        importation.addDeclaration(declarationCollector, targetModuleId);
                        continue;
                    }
                    if (importation.getVisibilityModifier() != VisibilityModifier.Friend || !ttcnmodule.isVisible(CompilationTimeStamp.getBaseTimestamp(), targetModuleId, importation)) continue;
                    importation.addDeclaration(declarationCollector, targetModuleId);
                }
            }
            Identifier moduleId = declarationCollector.getReference().getModuleIdentifier();
            List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
            if (moduleId == null && subrefs.size() == 1 && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
                declarationCollector.addDeclaration(savedReferredModule.getIdentifier().getDisplayName(), savedReferredModule.getIdentifier().getLocation(), (ASTNode)null);
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        if (this.withAttributesPath != null && !this.withAttributesPath.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }

    @Override
    public Declaration getDeclaration() {
        return Declaration.createInstance(this.getReferredModule());
    }
}

