/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TTCN3Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class PortScope
extends TTCN3Scope {
    private final Port_Type portType;
    private final Definitions variableDefinitions;

    public PortScope(Port_Type portType, Scope parentScope) {
        this.portType = portType;
        if (portType == null) {
            this.variableDefinitions = null;
        } else {
            portType.setOwnertype(IType.TypeOwner_type.OT_PORT_SCOPE, this);
            this.variableDefinitions = portType.getPortBody().getVariableDefinitions();
        }
        this.setParentScope(parentScope);
    }

    @Override
    public PortScope getScopePort() {
        return this;
    }

    public Port_Type getPortType() {
        return this.portType;
    }

    @Override
    public boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.variableDefinitions != null && this.variableDefinitions.hasAssignmentWithId(timestamp, identifier)) {
            return true;
        }
        return super.hasAssignmentWithId(timestamp, identifier);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        if (this.variableDefinitions != null && this.variableDefinitions.hasLocalAssignmentWithID(timestamp, reference.getId())) {
            return this.variableDefinitions.getLocalAssignmentByID(timestamp, reference.getId());
        }
        if (this.parentScope != null) {
            return this.parentScope.getAssBySRef(timestamp, reference);
        }
        return null;
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        if (propCollector.getReference().getModuleIdentifier() == null && this.variableDefinitions != null) {
            this.variableDefinitions.addProposal(propCollector);
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        if (declarationCollector.getReference().getModuleIdentifier() == null && this.variableDefinitions != null && this.variableDefinitions.hasLocalAssignmentWithID(CompilationTimeStamp.getBaseTimestamp(), declarationCollector.getReference().getId())) {
            Definition def = this.variableDefinitions.getLocalAssignmentByID(CompilationTimeStamp.getBaseTimestamp(), declarationCollector.getReference().getId());
            declarationCollector.addDeclaration(def);
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portType != null) {
            this.portType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.variableDefinitions != null) {
            this.variableDefinitions.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.portType != null && !this.portType.accept(v)) {
            return false;
        }
        if (this.variableDefinitions != null && !this.variableDefinitions.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

