/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectCase
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART1 = ".templateinstances";
    private static final String FULLNAMEPART2 = ".block";
    private final TemplateInstances templateInstances;
    private final StatementBlock statementBlock;
    private Location location = NULL_Location.INSTANCE;

    public SelectCase(TemplateInstances templateInstances, StatementBlock statementblock) {
        this.templateInstances = templateInstances;
        this.statementBlock = statementblock;
        if (templateInstances != null) {
            templateInstances.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstances == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.statementBlock == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public StatementBlock getStatementBlock() {
        return this.statementBlock;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstances != null) {
            this.templateInstances.setMyScope(scope);
        }
        if (this.statementBlock != null) {
            this.statementBlock.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.templateInstances != null) {
            this.templateInstances.setCodeSection(codeSection);
        }
        if (this.statementBlock != null) {
            this.statementBlock.setCodeSection(codeSection);
        }
    }

    public void setMyStatementBlock(StatementBlock parStatementBlock, int index) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyStatementBlock(parStatementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyAltguards(altGuards);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean hasElse() {
        return this.templateInstances == null;
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementBlock != null) {
            return this.statementBlock.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    public boolean hasReceivingStatement() {
        if (this.statementBlock != null) {
            return this.statementBlock.hasReceivingStatement(0);
        }
        return false;
    }

    public boolean check(CompilationTimeStamp timestamp, IType governor, boolean unreachable) {
        boolean unreachable2 = unreachable;
        if (this.templateInstances != null) {
            for (int i = 0; i < this.templateInstances.getNofTis(); ++i) {
                this.templateInstances.getInstanceByIndex(i).check(timestamp, governor);
            }
        } else {
            unreachable2 = true;
        }
        this.statementBlock.check(timestamp);
        return unreachable2;
    }

    public void checkAllowedInterleave() {
        if (this.statementBlock != null) {
            this.statementBlock.checkAllowedInterleave();
        }
    }

    public void postCheck() {
        if (this.statementBlock != null) {
            this.statementBlock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstances != null) {
            this.templateInstances.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstances.getLocation());
        }
        if (this.statementBlock != null) {
            this.statementBlock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementBlock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstances != null) {
            this.templateInstances.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementBlock != null) {
            this.statementBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstances != null && !this.templateInstances.accept(v)) {
            return false;
        }
        return this.statementBlock == null || this.statementBlock.accept(v);
    }

    public void generateCode(JavaGenData aData, StringBuilder source, String name, AtomicBoolean unreach) {
        ExpressionStruct expression = new ExpressionStruct();
        StringBuilder condition = new StringBuilder();
        if (this.templateInstances != null) {
            for (int i = 0; i < this.templateInstances.getNofTis(); ++i) {
                String genName;
                String tmp = aData.getTemporaryVariableName();
                TemplateInstance templateInstance = this.templateInstances.getInstanceByIndex(i);
                TTCN3Template templateBody = templateInstance.getTemplateBody();
                boolean isValue = templateInstance.getDerivedReference() == null && templateBody.isValue(CompilationTimeStamp.getBaseTimestamp());
                IType last = templateInstance.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (i > 0) {
                    condition.append(" || ");
                }
                if (isValue) {
                    genName = last.getGenNameValue(aData, expression.expression);
                    expression.expression.append(MessageFormat.format("final {0} {1} = new {0} (", genName, tmp));
                    IValue value = templateBody.getValue();
                    value.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                    value.generateCodeExpressionMandatory(aData, expression, true);
                    expression.expression.append(");\n");
                    condition.append(MessageFormat.format("{0}.operator_equals({1})", tmp, name));
                    continue;
                }
                genName = last.getGenNameTemplate(aData, expression.expression);
                expression.expression.append(MessageFormat.format("final {0} {1} = new {0} (", genName, tmp));
                templateInstance.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
                expression.expression.append(");\n");
                condition.append(MessageFormat.format("{0}.match({1})", tmp, name));
            }
            source.append((CharSequence)expression.preamble);
            source.append((CharSequence)expression.expression);
            source.append((CharSequence)expression.postamble);
            this.getLocation().update_location_object(aData, source);
            source.append("if (").append((CharSequence)condition).append(") {\n");
            this.statementBlock.generateCode(aData, source);
            source.append("}\n");
        } else {
            this.statementBlock.generateCode(aData, source);
            unreach.set(true);
        }
    }
}

