/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectClassCases;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class SelectClass_Statement
extends Statement {
    private static final String CLASSEXPECTED = "Reference to a class object was expected";
    private static final String STATEMENT_NAME = "select-class";
    private final SelectClassCases selectClassCases;
    private final Reference reference;

    public SelectClass_Statement(Reference reference, SelectClassCases selectClassCases) {
        this.selectClassCases = selectClassCases;
        this.reference = reference;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
        selectClassCases.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
        this.selectClassCases.setMyScope(scope);
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SELECT_CLASS;
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        this.selectClassCases.setMyStatementBlock(statementBlock, index);
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        IType refType = this.reference.checkVariableReference(timestamp);
        Class_Type refClass = null;
        if (refType != null) {
            IType refTypeLast = refType.getTypeRefdLast(timestamp);
            if (!(refTypeLast instanceof Class_Type)) {
                this.reference.getLocation().reportSemanticError(CLASSEXPECTED);
            } else {
                refClass = refTypeLast.getClassType();
            }
        }
        this.selectClassCases.check(timestamp, refClass);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
        if (this.selectClassCases != null) {
            this.selectClassCases.updateSyntax(reparser, false);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.reference != null && !this.reference.accept(v)) {
            return false;
        }
        return this.selectClassCases == null || this.selectClassCases.accept(v);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.selectClassCases != null) {
            this.selectClassCases.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
    }
}

